/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.util.Arrays;
import java.util.function.BiFunction;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.fingerprint.Fingerprint;
import org.signal.libsignal.protocol.fingerprint.FingerprintParsingException;
import org.signal.libsignal.protocol.fingerprint.FingerprintVersionMismatchException;
import org.signal.libsignal.protocol.fingerprint.ScannableFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.push.ServiceId;

public class IdentityHelper {
    private static final Logger logger = LoggerFactory.getLogger(IdentityHelper.class);
    private final SignalAccount account;
    private final Context context;

    public IdentityHelper(Context context) {
        this.account = context.getAccount();
        this.context = context;
    }

    public boolean trustIdentityVerified(RecipientId recipientId, byte[] fingerprint) {
        return this.trustIdentity(recipientId, (serviceId, identityKey) -> Arrays.equals(identityKey.serialize(), fingerprint), TrustLevel.TRUSTED_VERIFIED);
    }

    public boolean trustIdentityVerifiedSafetyNumber(RecipientId recipientId, String safetyNumber) {
        return this.trustIdentity(recipientId, (serviceId, identityKey) -> safetyNumber.equals(this.computeSafetyNumber((ServiceId)serviceId, (IdentityKey)identityKey)), TrustLevel.TRUSTED_VERIFIED);
    }

    public boolean trustIdentityVerifiedSafetyNumber(RecipientId recipientId, byte[] safetyNumber) {
        return this.trustIdentity(recipientId, (serviceId, identityKey) -> {
            ScannableFingerprint fingerprint = this.computeSafetyNumberForScanning((ServiceId)serviceId, (IdentityKey)identityKey);
            try {
                return fingerprint != null && fingerprint.compareTo(safetyNumber);
            }
            catch (FingerprintParsingException | FingerprintVersionMismatchException e) {
                return false;
            }
        }, TrustLevel.TRUSTED_VERIFIED);
    }

    public boolean trustIdentityAllKeys(RecipientId recipientId) {
        return this.trustIdentity(recipientId, (serviceId, identityKey) -> true, TrustLevel.TRUSTED_UNVERIFIED);
    }

    public String computeSafetyNumber(ServiceId serviceId, IdentityKey theirIdentityKey) {
        Fingerprint fingerprint = this.computeSafetyNumberFingerprint(serviceId, theirIdentityKey);
        return fingerprint == null ? null : fingerprint.getDisplayableFingerprint().getDisplayText();
    }

    public ScannableFingerprint computeSafetyNumberForScanning(ServiceId serviceId, IdentityKey theirIdentityKey) {
        Fingerprint fingerprint = this.computeSafetyNumberFingerprint(serviceId, theirIdentityKey);
        return fingerprint == null ? null : fingerprint.getScannableFingerprint();
    }

    private Fingerprint computeSafetyNumberFingerprint(ServiceId serviceId, IdentityKey theirIdentityKey) {
        if (!serviceId.isUnknown()) {
            return Utils.computeSafetyNumberForUuid((ServiceId)this.account.getAci(), this.account.getAciIdentityKeyPair().getPublicKey(), serviceId, theirIdentityKey);
        }
        RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(serviceId);
        RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
        if (address.number().isEmpty()) {
            return null;
        }
        return Utils.computeSafetyNumberForNumber(this.account.getNumber(), this.account.getAciIdentityKeyPair().getPublicKey(), address.number().get(), theirIdentityKey);
    }

    private boolean trustIdentity(RecipientId recipientId, BiFunction<ServiceId, IdentityKey, Boolean> verifier, TrustLevel trustLevel) {
        RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
        ServiceId serviceId = address.serviceId().orElse(null);
        if (serviceId == null) {
            return false;
        }
        IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(serviceId);
        if (identity == null) {
            return false;
        }
        if (!verifier.apply(serviceId, identity.getIdentityKey()).booleanValue()) {
            return false;
        }
        this.account.getIdentityKeyStore().setIdentityTrustLevel(serviceId, identity.getIdentityKey(), trustLevel);
        this.context.getSyncHelper().sendVerifiedMessage(address.toSignalServiceAddress(), identity.getIdentityKey(), trustLevel);
        return true;
    }

    public void handleIdentityFailure(RecipientId recipientId, ServiceId serviceId, SendMessageResult.IdentityFailure identityFailure) {
        IdentityKey identityKey = identityFailure.getIdentityKey();
        if (identityKey != null) {
            this.account.getIdentityKeyStore().saveIdentity(serviceId, identityKey);
        } else {
            this.context.getProfileHelper().refreshRecipientProfile(recipientId);
        }
    }
}

