/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.message;

import io.reactivex.rxjava3.core.Single;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.message.MessageApi;
import org.whispersystems.signalservice.api.message.SpamTokenMessage;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.internal.push.SendGroupMessageResponse;
import org.whispersystems.signalservice.internal.push.SendMessageResponse;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\f\u0010 \u001a\u00020\u001e*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/whispersystems/signalservice/api/message/MessageApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "sendMessage", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/internal/push/SendMessageResponse;", "messageList", "Lorg/whispersystems/signalservice/internal/push/OutgoingPushMessageList;", "sealedSenderAccess", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "story", "", "sendGroupMessage", "Lorg/whispersystems/signalservice/internal/push/SendGroupMessageResponse;", "body", "", "timestamp", "", "online", "urgent", "reportSpam", "", "serviceId", "Lorg/whispersystems/signalservice/api/push/ServiceId;", "serverGuid", "", "reportingToken", "toQueryParam", "Companion", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nMessageApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageApi.kt\norg/whispersystems/signalservice/api/message/MessageApi\n+ 2 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult$Companion\n*L\n1#1,106:1\n71#2:107\n*S KotlinDebug\n*F\n+ 1 MessageApi.kt\norg/whispersystems/signalservice/api/message/MessageApi\n*L\n90#1:107\n*E\n"})
public final class MessageApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;
    @NotNull
    private static final Companion.sendMessageResponseConverter.1 sendMessageResponseConverter = new NetworkResult.WebSocketResponseConverter<SendMessageResponse>(){

        public NetworkResult<SendMessageResponse> convert(WebsocketResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return response.getStatus() == 200 ? this.toSuccess(response, Reflection.getOrCreateKotlinClass(SendMessageResponse.class)).map(arg_0 -> Companion.sendMessageResponseConverter.1.convert$lambda$1(response, arg_0)) : this.toStatusCodeError(response);
        }

        private static final SendMessageResponse convert$lambda$1(WebsocketResponse $response, SendMessageResponse it) {
            SendMessageResponse sendMessageResponse;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SendMessageResponse $this$convert_u24lambda_u241_u24lambda_u240 = sendMessageResponse = it;
            boolean bl = false;
            $this$convert_u24lambda_u241_u24lambda_u240.setSentUnidentfied($response.isUnidentified());
            return sendMessageResponse;
        }
    };

    public MessageApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final NetworkResult<SendMessageResponse> sendMessage(@NotNull OutgoingPushMessageList messageList, @Nullable SealedSenderAccess sealedSenderAccess, boolean story) {
        Intrinsics.checkNotNullParameter((Object)messageList, (String)"messageList");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/messages/" + messageList.getDestination() + "?story=" + this.toQueryParam(story), messageList, null, 4, null);
        return sealedSenderAccess == null ? NetworkResult.Companion.fromWebSocket(sendMessageResponseConverter, () -> MessageApi.sendMessage$lambda$0(this, request2)) : NetworkResult.Companion.fromWebSocket(sendMessageResponseConverter, () -> MessageApi.sendMessage$lambda$1(this, request2, sealedSenderAccess)).fallback(MessageApi::sendMessage$lambda$2, () -> MessageApi.sendMessage$lambda$4(this, request2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkResult<SendGroupMessageResponse> sendGroupMessage(@NotNull byte[] body, @NotNull SealedSenderAccess sealedSenderAccess, long timestamp, boolean online, boolean urgent, boolean story) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)sealedSenderAccess, (String)"sealedSenderAccess");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.putCustom(WebSocketRequestMessage.Companion, "/v1/messages/multi_recipient?ts=" + timestamp + "&online=" + this.toQueryParam(online) + "&urgent=" + this.toQueryParam(urgent) + "&story=" + this.toQueryParam(story), body, MapsKt.mapOf((Pair)TuplesKt.to((Object)"content-type", (Object)"application/vnd.signal-messenger.mrm")));
        NetworkResult.Companion companion = NetworkResult.Companion;
        NetworkResult.Fetcher<Single<WebsocketResponse>> fetcher$iv = () -> MessageApi.sendGroupMessage$lambda$5(this, request2, sealedSenderAccess);
        boolean $i$f$fromWebSocket = false;
        return this_$iv.fromWebSocket(new NetworkResult.DefaultWebSocketConverter(Reflection.getOrCreateKotlinClass(SendGroupMessageResponse.class)), fetcher$iv);
    }

    @NotNull
    public final NetworkResult<Unit> reportSpam(@NotNull ServiceId serviceId, @NotNull String serverGuid, @Nullable String reportingToken) {
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)serverGuid, (String)"serverGuid");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/messages/report/" + serviceId + "/" + serverGuid, new SpamTokenMessage(reportingToken), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    private final String toQueryParam(boolean $this$toQueryParam) {
        return $this$toQueryParam ? "true" : "false";
    }

    private static final Single sendMessage$lambda$0(MessageApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final Single sendMessage$lambda$1(MessageApi this$0, WebSocketRequestMessage $request, SealedSenderAccess $sealedSenderAccess) {
        return this$0.unauthWebSocket.request($request, $sealedSenderAccess);
    }

    private static final boolean sendMessage$lambda$2(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)it).getCode() == 401;
    }

    private static final Single sendMessage$lambda$4$lambda$3(MessageApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final NetworkResult sendMessage$lambda$4(MessageApi this$0, WebSocketRequestMessage $request) {
        return NetworkResult.Companion.fromWebSocket(sendMessageResponseConverter, () -> MessageApi.sendMessage$lambda$4$lambda$3(this$0, $request));
    }

    private static final Single sendGroupMessage$lambda$5(MessageApi this$0, WebSocketRequestMessage $request, SealedSenderAccess $sealedSenderAccess) {
        return this$0.unauthWebSocket.request($request, $sealedSenderAccess);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003*\u0001\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/message/MessageApi$Companion;", "", "<init>", "()V", "sendMessageResponseConverter", "org/whispersystems/signalservice/api/message/MessageApi$Companion$sendMessageResponseConverter$1", "Lorg/whispersystems/signalservice/api/message/MessageApi$Companion$sendMessageResponseConverter$1;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

