/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.remoteconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.remoteconfig.RemoteConfigResponse;
import org.whispersystems.signalservice.api.remoteconfig.RemoteConfigResult;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "getAuthWebSocket", "()Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "getPushServiceSocket", "()Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "getRemoteConfig", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/remoteconfig/RemoteConfigResult;", "eTag", "", "RemoteConfigResultWebSocketResponseConverter", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigApi.kt\norg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n126#2:72\n153#2,3:73\n*S KotlinDebug\n*F\n+ 1 RemoteConfigApi.kt\norg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi\n*L\n39#1:72\n39#1:73,3\n*E\n"})
public final class RemoteConfigApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public RemoteConfigApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.authWebSocket = authWebSocket;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final SignalWebSocket.AuthenticatedWebSocket getAuthWebSocket() {
        return this.authWebSocket;
    }

    @NotNull
    public final PushServiceSocket getPushServiceSocket() {
        return this.pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<RemoteConfigResult> getRemoteConfig(@NotNull String eTag) {
        Intrinsics.checkNotNullParameter((Object)eTag, (String)"eTag");
        Map headers = ((CharSequence)eTag).length() > 0 ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"If-None-Match", (Object)eTag)) : MapsKt.emptyMap();
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v2/config", headers);
        return NetworkResult.Companion.fromWebSocketRequest-exY8QGI$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, new RemoteConfigResultWebSocketResponseConverter(), 4, null).fallback(RemoteConfigApi::getRemoteConfig$lambda$0, () -> RemoteConfigApi.getRemoteConfig$lambda$3(this));
    }

    public static /* synthetic */ NetworkResult getRemoteConfig$default(RemoteConfigApi remoteConfigApi, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return remoteConfigApi.getRemoteConfig(string);
    }

    private static final boolean getRemoteConfig$lambda$0(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)it).getCode() != 304;
    }

    /*
     * WARNING - void declaration
     */
    private static final RemoteConfigResult getRemoteConfig$lambda$3$lambda$2(RemoteConfigApi this$0) {
        void $this$mapTo$iv$iv;
        RemoteConfigResponse response = this$0.pushServiceSocket.getRemoteConfig();
        Map<String, String> $this$map$iv = response.getConfig();
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            String string = (String)it.getValue();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Boolean bl2 = StringsKt.toBooleanStrictOrNull((String)string2);
            if (bl2 == null) {
                bl2 = it.getValue();
            }
            collection.add(TuplesKt.to(k, (Object)bl2));
        }
        Map transformed = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return new RemoteConfigResult(transformed, response.getServerEpochTime(), null, 4, null);
    }

    private static final NetworkResult getRemoteConfig$lambda$3(RemoteConfigApi this$0) {
        return NetworkResult.Companion.fromFetch(() -> RemoteConfigApi.getRemoteConfig$lambda$3$lambda$2(this$0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi$RemoteConfigResultWebSocketResponseConverter;", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "Lorg/whispersystems/signalservice/api/remoteconfig/RemoteConfigResult;", "<init>", "()V", "convert", "Lorg/whispersystems/signalservice/api/NetworkResult;", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nRemoteConfigApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigApi.kt\norg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi$RemoteConfigResultWebSocketResponseConverter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n126#2:72\n153#2,3:73\n*S KotlinDebug\n*F\n+ 1 RemoteConfigApi.kt\norg/whispersystems/signalservice/api/remoteconfig/RemoteConfigApi$RemoteConfigResultWebSocketResponseConverter\n*L\n58#1:72\n58#1:73,3\n*E\n"})
    private static final class RemoteConfigResultWebSocketResponseConverter
    implements NetworkResult.WebSocketResponseConverter<RemoteConfigResult> {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public NetworkResult<RemoteConfigResult> convert(@NotNull WebsocketResponse response) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response.getStatus() < 200 || response.getStatus() > 299) {
                networkResult = this.toStatusCodeError(response);
            } else {
                void $this$mapTo$iv$iv;
                RemoteConfigResponse remoteConfigResponse = JsonUtil.fromJson(response.getBody(), RemoteConfigResponse.class);
                Map<String, String> $this$map$iv = remoteConfigResponse.getConfig();
                boolean $i$f$map = false;
                Map<String, String> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object k = it.getKey();
                    String string = (String)it.getValue();
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = string.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    Boolean bl2 = StringsKt.toBooleanStrictOrNull((String)string2);
                    if (bl2 == null) {
                        bl2 = it.getValue();
                    }
                    collection.add(TuplesKt.to(k, (Object)bl2));
                }
                Map transformed = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                String string = response.getHeader("X-Signal-Timestamp");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHeader(...)");
                Long l = StringsKt.toLongOrNull((String)string);
                networkResult = new NetworkResult.Success<RemoteConfigResult>(new RemoteConfigResult(transformed, l != null ? l : System.currentTimeMillis(), response.getHeaders().get("etag")));
            }
            return networkResult;
        }
    }
}

