//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// The main menu system.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimainmenusystem?language=objc)
    #[unsafe(super(UIMenuSystem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIMenuSystem")]
    pub struct UIMainMenuSystem;
);

#[cfg(feature = "UIMenuSystem")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIMainMenuSystem {}
);

#[cfg(feature = "UIMenuSystem")]
impl UIMainMenuSystem {
    extern_methods!(
        /// The shared main menu system.
        #[unsafe(method(sharedSystem))]
        #[unsafe(method_family = none)]
        pub fn sharedSystem(mtm: MainThreadMarker) -> Retained<UIMainMenuSystem>;

        #[cfg(all(feature = "UIMenuBuilder", feature = "block2"))]
        /// Specifies that the main menu system should be built using the specified configuration.
        /// A build handler can be optionally provided, which the main menu system will use instead of calling `-buildMenuWithBuilder:`.
        /// Setting this will invalidate and rebuild the main menu system. Ideally it should be set once, and as early as possible, preferably in `-application:didFinishLaunchingWithOptions:`.
        /// Subsequent rebuilds of the main menu system will continue to use this `configuration` and `buildHandler`.
        /// It is a developer error to set the `configuration` while the main menu system is building. Doing so will assert.
        #[unsafe(method(setBuildConfiguration:buildHandler:))]
        #[unsafe(method_family = none)]
        pub fn setBuildConfiguration_buildHandler(
            &self,
            configuration: &UIMainMenuSystemConfiguration,
            build_handler: Option<
                &block2::DynBlock<dyn Fn(NonNull<ProtocolObject<dyn UIMenuBuilder>>)>,
            >,
        );

        #[unsafe(method(mainSystem))]
        #[unsafe(method_family = none)]
        pub unsafe fn mainSystem(mtm: MainThreadMarker) -> Retained<UIMenuSystem>;

        #[unsafe(method(contextSystem))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextSystem(mtm: MainThreadMarker) -> Retained<UIMenuSystem>;
    );
}

/// Methods declared on superclass `UIMenuSystem`.
#[cfg(feature = "UIMenuSystem")]
impl UIMainMenuSystem {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

extern_class!(
    /// A configuration for the main menu system.
    /// You can specify whether or not certain elements are present in the initial main menu, as well as a block to build the menu using a UIMenuBuilder.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimainmenusystemconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIMainMenuSystemConfiguration;
);

extern_conformance!(
    unsafe impl NSCopying for UIMainMenuSystemConfiguration {}
);

unsafe impl CopyingHelper for UIMainMenuSystemConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIMainMenuSystemConfiguration {}
);

impl UIMainMenuSystemConfiguration {
    extern_methods!(
        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for new scene elements in the main menu.
        #[unsafe(method(newScenePreference))]
        #[unsafe(method_family = none)]
        pub fn newScenePreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`newScenePreference`][Self::newScenePreference].
        #[unsafe(method(setNewScenePreference:))]
        #[unsafe(method_family = none)]
        pub fn setNewScenePreference(
            &self,
            new_scene_preference: UIMenuSystemElementGroupPreference,
        );

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for document elements in the main menu.
        #[unsafe(method(documentPreference))]
        #[unsafe(method_family = none)]
        pub fn documentPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`documentPreference`][Self::documentPreference].
        #[unsafe(method(setDocumentPreference:))]
        #[unsafe(method_family = none)]
        pub fn setDocumentPreference(
            &self,
            document_preference: UIMenuSystemElementGroupPreference,
        );

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for printing elements in the main menu.
        #[unsafe(method(printingPreference))]
        #[unsafe(method_family = none)]
        pub fn printingPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`printingPreference`][Self::printingPreference].
        #[unsafe(method(setPrintingPreference:))]
        #[unsafe(method_family = none)]
        pub fn setPrintingPreference(
            &self,
            printing_preference: UIMenuSystemElementGroupPreference,
        );

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for finding elements in the main menu.
        #[unsafe(method(findingPreference))]
        #[unsafe(method_family = none)]
        pub fn findingPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`findingPreference`][Self::findingPreference].
        #[unsafe(method(setFindingPreference:))]
        #[unsafe(method_family = none)]
        pub fn setFindingPreference(&self, finding_preference: UIMenuSystemElementGroupPreference);

        #[cfg(feature = "UIMenuSystem")]
        /// Configuration for the find elements should they be present in the main menu.
        #[unsafe(method(findingConfiguration))]
        #[unsafe(method_family = none)]
        pub fn findingConfiguration(&self) -> Retained<UIMenuSystemFindElementGroupConfiguration>;

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for toolbar elements in the main menu.
        #[unsafe(method(toolbarPreference))]
        #[unsafe(method_family = none)]
        pub fn toolbarPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`toolbarPreference`][Self::toolbarPreference].
        #[unsafe(method(setToolbarPreference:))]
        #[unsafe(method_family = none)]
        pub fn setToolbarPreference(&self, toolbar_preference: UIMenuSystemElementGroupPreference);

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for sidebar elements in the main menu.
        #[unsafe(method(sidebarPreference))]
        #[unsafe(method_family = none)]
        pub fn sidebarPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`sidebarPreference`][Self::sidebarPreference].
        #[unsafe(method(setSidebarPreference:))]
        #[unsafe(method_family = none)]
        pub fn setSidebarPreference(&self, sidebar_preference: UIMenuSystemElementGroupPreference);

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for inspector elements in the main menu.
        #[unsafe(method(inspectorPreference))]
        #[unsafe(method_family = none)]
        pub fn inspectorPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`inspectorPreference`][Self::inspectorPreference].
        #[unsafe(method(setInspectorPreference:))]
        #[unsafe(method_family = none)]
        pub fn setInspectorPreference(
            &self,
            inspector_preference: UIMenuSystemElementGroupPreference,
        );

        #[cfg(feature = "UIMenuSystem")]
        /// Specifies a preference for text formatting elements in the main menu.
        #[unsafe(method(textFormattingPreference))]
        #[unsafe(method_family = none)]
        pub fn textFormattingPreference(&self) -> UIMenuSystemElementGroupPreference;

        #[cfg(feature = "UIMenuSystem")]
        /// Setter for [`textFormattingPreference`][Self::textFormattingPreference].
        #[unsafe(method(setTextFormattingPreference:))]
        #[unsafe(method_family = none)]
        pub fn setTextFormattingPreference(
            &self,
            text_formatting_preference: UIMenuSystemElementGroupPreference,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UIMainMenuSystemConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
