#ifndef GFXARCBALL_INCLUDED // -*- C++ -*-
#define GFXARCBALL_INCLUDED
#if !defined(__GNUC__)
#  pragma once
#endif

/************************************************************************

  Arcball rotation control.
  
  $Id: arcball.h,v 1.6 2002/03/12 17:52:14 garland Exp $

 ************************************************************************/

#include "baseball.h"

class Arcball : public Baseball
{
private:
    Vec2 ball_ctr;
    double ball_radius;

    Quat q_now, q_down, q_drag;	// Quaternions describing rotation
    Vec3 v_from, v_to;		//

    bool is_dragging;

protected:
    Vec3 proj_to_sphere(const Vec2&);
    void update();


public:
    Arcball();

    virtual void update_animation();
    virtual bool mouse_down(int *where, int which);
    virtual bool mouse_up(int *where, int which);
    virtual bool mouse_drag(int *where, int *last, int which);

    virtual void apply_transform();
    virtual void get_transform(Vec3 & c, Vec3 &t, Quat & q);
    virtual void set_transform(const Vec3 & c, const Vec3 & t, const Quat & q); 
};



// GFXARCBALL_INCLUDED
#endif
