/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.function.BooleanConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanConsumerTest
extends AbstractLangTest {
    private BooleanConsumer accept(BooleanConsumer consumer, boolean expected) {
        consumer.accept(expected);
        return consumer;
    }

    @Test
    public void testAccept() {
        AtomicBoolean aBool = new AtomicBoolean();
        this.accept(aBool::lazySet, true);
        Assertions.assertTrue((boolean)aBool.get());
        this.accept(aBool::lazySet, false);
        Assertions.assertFalse((boolean)aBool.get());
    }

    @Test
    public void testAndThen() throws Throwable {
        BooleanConsumer nop = BooleanConsumer.nop();
        nop.andThen(nop);
        Assertions.assertThrows(NullPointerException.class, () -> nop.andThen(null));
        AtomicBoolean aBool1 = new AtomicBoolean();
        AtomicBoolean aBool2 = new AtomicBoolean();
        BooleanConsumer bc = aBool1::lazySet;
        BooleanConsumer composite = bc.andThen(aBool2::lazySet);
        composite.accept(true);
        Assertions.assertTrue((boolean)aBool1.get());
        Assertions.assertTrue((boolean)aBool2.get());
        composite.accept(false);
        Assertions.assertFalse((boolean)aBool1.get());
        Assertions.assertFalse((boolean)aBool2.get());
        BooleanConsumer bad = value -> {
            throw new IllegalStateException();
        };
        BooleanConsumer badComposite = bad.andThen(aBool2::lazySet);
        Assertions.assertThrows(IllegalStateException.class, () -> badComposite.accept(true));
        Assertions.assertFalse((boolean)aBool2.get(), (String)"Second consumer should not be invoked");
    }
}

