/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.function.TriFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TriFunctionTest
extends AbstractLangTest {
    @Test
    public void testAccept() throws Throwable {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        TriFunction tri = (t, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
            return "ABC";
        };
        Assertions.assertEquals((Object)"ABC", (Object)tri.apply(ref1, ref2, ref3));
        Assertions.assertEquals((Character)Character.valueOf('a'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)1, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"z", ref3.get());
    }

    @Test
    public void testAndThen() throws Throwable {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        TriFunction tri = (t, u, v) -> {
            ref1.set(Character.valueOf('a'));
            ref2.set((short)1);
            ref3.set("z");
            return "9";
        };
        Function<String, BigInteger> after = t -> {
            ref1.set(Character.valueOf('b'));
            ref2.set((short)2);
            ref3.set("zz");
            return BigInteger.valueOf(Long.parseLong(t)).add(BigInteger.ONE);
        };
        Assertions.assertEquals((Object)BigInteger.TEN, (Object)tri.andThen(after).apply(ref1, ref2, ref3));
        Assertions.assertEquals((Character)Character.valueOf('b'), (Character)((Character)ref1.get()));
        Assertions.assertEquals((Short)2, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"zz", ref3.get());
    }
}

