---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, syntaxe,  
              noms d'auteurs dans les bibliographies initiales et bibtex
---

# Comment gérer des initiales multi-lettres avec BibTeX ?

Si votre style bibliographique utilise une convention "initiales des prénom +
nom de famille", vous pouvez rencontrer un problème avec certains noms 
transcrits (par exemple, les noms russes). Prenons l'exemple suivant, 
tiré du monde réel :

```bibtex
@article{epifanov1997,
   author = {Epifanov, S. Yu. and Vigasin, A. A.},
   title  = ...
}
```

Notez que le "Yu" est l'initiale, et non un nom complet.
Cependant, les algorithmes de BibTeX vous laisseront avec une citation
--- légèrement dépendante du style bibliographique ---
qui se lit : "S. Y. Epifanov et A. A. Vigasin" au lieu de "S. Yu. Epifanov 
et A. A. Vigasin".

Une solution consiste à remplacer chaque initiale affectée par une commande
qui imprime la combinaison correcte. Pour que votre bibliographie reste 
utilisable par d'autres, vous devez ajouter cette commande 
à votre bibliographie avec la commande `@preamble` :

```bibtex
@preamble{ {\providecommand{\BIBYu}{Yu} } }

@article{epifanov1997,
   author   = {Epifanov, S. {\BIBYu}. and Vigasin, A. A.},
   title    = ...
}
```

Si vous avez beaucoup de commandes de ce type, vous pouvez les mettre 
dans un fichier séparé et appeler ce dernier avec la commande `\input` 
placée elle-même dans la commande `@preamble`.

Une alternative est de faire en sorte que la transcription ressemble 
à un accent, du point de vue de BibTeX. Pour cela, nous avons besoin 
d'une séquence de contrôle qui ne fait rien :

```bibtex
@article{epifanov1997,
   author   = {Epifanov, S. {\relax Yu}. and Vigasin, A. A.},
   title    = ...
}
```

Tout comme la solution consistant à générer des commandes supplémentaires,
elle implique une saisie supplémentaire fastidieuse. Celle des deux techniques
qui est préférable pour une bibliographie donnée sera déterminée par les noms
qu'elle contient. Il convient de noter qu'un préambule qui introduit 
un grand nombre de commandes bizarres n'est généralement pas souhaitable 
si la bibliographie est partagée.

Les initiales "composées" (pour les noms composés de deux mots ou plus)
peuvent être traitées de la même manière, de sorte que l'on peut entrer 
le nom plutôt compliqué de Forster sous la forme :

```bibtex
@article{forster2006,
  author   = {Forster, P.M. {\relax de F.} and Collins, M.},
  title    = ...
```

La même astuce peut être utilisée si vous saisissez des noms entiers :

```text
  author   = {Epifanov, Sasha {\relax Yu}ri and Vigasin, A. A.},
```

Si vous tapez les noms de manière "naturelle" (occidentale), en commençant 
par les prénoms, l'astuce suivante ne fonctionnera pas :

```text
  author   = {P.M. {\relax de F.} Forster and Collins, M.},
```

En effet, "de F. Forster" sera traité comme un nom de famille composé.


:::{sources}
[Multi-letter initials in BibTeX](faquk:FAQ-bibtranscinit)
:::