---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, itemize, enumerate, description, liste de choses, 
              environnement de liste, liste à puce, bullet point, tiret
---

# Comment composer des listes ?

## Les listes simples

LaTeX fournit trois environnements de liste différents :

- `itemize` ;
- `description` ;
- et `enumerate`.

Ils partagent une logique commune : chaque élément de ces listes est introduit 
par la commande `\item`. Mais cette commande affiche un élément différent 
pour chaque environnement. Dans le cas particulier de l'environnement `description`, 
l'argument optionnel de la commande `\item` devient le nom de l'élément 
introduisant l'élément de la liste (en gras).

Voici un exemple de chacun de ces environnements :

```
\documentclass{article}
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Parmi les merveilles du monde antique, on peut distinguer plusieurs
catégories de monunents. Deux sont des statues : 
\begin{itemize}
   \item la statue chryséléphantine de Zeus à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom.
\end{itemize}

Deux autres merveilles ont été remarquées par le prestige politique 
qu'elles ont apporté aux villes les hébergeant.
\begin{description}
   \item[Les jardins suspendus de Babylone] : en Mésopotamie.
   \item[Le phare d'Alexandrie] : en Égypte.
\end{description}

Trois autres restent connues pour leur rôle religieux ou funéraire et leurs
dimensions remarquables. Les voici, de la plus ancienne à la plus récente :
\begin{enumerate}
   \item la grande pyramide de Gizeh : tombeau présumé de Khéops, en Égypte ;
   \item l'Artémision : temple d'Artémis, à Éphèse, en Ionie ;
   \item le mausolée d'Halicarnasse : tombeau de Mausole, en Carie.
\end{enumerate}
\end{document}
```

L'environnement `itemize` a une particularité. 
Son format est modifié par l'extension <ctanpkg:babel> pour correspondre aux normes de chaque langue. 
L'exemple ci-dessus et l'exemple ci-dessous illustrent les modifications que cela génère : 
en français, le symbole pour les éléments de la liste devient un tiret cadratin 
et l'espacement entre les éléments de la liste est réduit :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Parmi les merveilles du monde antique, on peut distinguer plusieurs
catégories de monunents. Deux sont des statues : 
\begin{itemize}
   \item la statue chryséléphantine de Zeus à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom.
\end{itemize}

Deux autres merveilles ont été remarquées par le prestige (...)
\end{document}
```

Pour être tout à fait complet, il existe en fait un quatrième environnement 
de liste fourni par LaTeX : l'environnement `list`.

Il n'est jamais utilisé directement lorsque l'on écrit un document, 
car c'est un environnement générique, qui sert à 
[construire des listes plus spécialisées](/3_composition/texte/listes/modifier_les_environnements_de_liste). 
Les environnements `itemize`, `description` et `enumerate` font appel à lui en interne, 
par exemple, ainsi que `quote` et les commandes qui produisent les bibliographies.


## Les listes imbriquées

Les environnements de liste vus ci-dessus peuvent être imbriqués pour obtenir 
différents niveaux de liste. Rien n'empêche d'ailleurs d'imbriquer 
des environnements différents les uns dans les autres. 

L'exemple suivant se limite à l'imbrication d'environnements `itemize` 
mais il illustre également les 
[règles de ponctuation](https://www.typographie.images-en-france.fr/lexique-des-regles/enumerations/) 
associées aux listes.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Parmi les merveilles du monde antique, on peut distinguer plusieurs
catégories de monunents : 
\begin{itemize} 
   \item deux sont des statues : 
   \begin{itemize}
      \item la statue chryséléphantine de Zeus à Olympie,
      \item le colosse de Rhodes, sur l'île du même nom ;
   \end{itemize}
   \item deux autres ont été remarquées par le prestige 
   politique qu'elles ont apporté aux villes les hébergeant :
   \begin{itemize}
      \item les jardins suspendus de Babylone, en Mésopotamie,
      \item le phare d'Alexandrie, en Égypte ;
   \end{itemize}
   \item trois autres restent connues pour leur rôle religieux ou funéraire 
   et leurs dimensions remarquables :
   \begin{itemize}
      \item la grande pyramide de Gizeh, tombeau présumé de Khéops, en Égypte,
      \item l'Artémision, temple d'Artémis à Éphèse, en Ionie,
      \item le mausolée d'Halicarnasse, tombeau de Mausole, en Carie.
   \end{itemize}
\end{itemize}
\end{document}
```

Notez que LaTeX limite par défaut la profondeur maximale des listes. 
Pour changer cette profondeur, vous pouvez vous tourner vers la question 
"[](augmenter_la_profondeur_des_listes)".


:::{sources}
- [Latex – Customisation de listes à puces](https://borntocode.fr/latex-customisation-de-listes-a-puces/) ;
- [How can I define bullet style for itemize with french option babel?](https://tex.stackexchange.com/q/123668), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/) ;
- [Manuel de référence officieux de LaTeXe : « list »](https://tug.ctan.org/info/latex2e-help-texinfo-fr/latex2e-fr.html#list).
:::