//
//Copyright 2018 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run hack/update-generated-runtime.sh

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: github.com/containerd/containerd/third_party/k8s.io/cri-api/pkg/apis/runtime/v1alpha2/api.proto

package v1alpha2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Protocol int32

const (
	Protocol_TCP  Protocol = 0
	Protocol_UDP  Protocol = 1
	Protocol_SCTP Protocol = 2
)

// Enum value maps for Protocol.
var (
	Protocol_name = map[int32]string{
		0: "TCP",
		1: "UDP",
		2: "SCTP",
	}
	Protocol_value = map[string]int32{
		"TCP":  0,
		"UDP":  1,
		"SCTP": 2,
	}
)

func (x Protocol) Enum() *Protocol {
	p := new(Protocol)
	*p = x
	return p
}

func (x Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[0].Descriptor()
}

func (Protocol) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[0]
}

func (x Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Protocol.Descriptor instead.
func (Protocol) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{0}
}

type MountPropagation int32

const (
	// No mount propagation ("private" in Linux terminology).
	MountPropagation_PROPAGATION_PRIVATE MountPropagation = 0
	// Mounts get propagated from the host to the container ("rslave" in Linux).
	MountPropagation_PROPAGATION_HOST_TO_CONTAINER MountPropagation = 1
	// Mounts get propagated from the host to the container and from the
	// container to the host ("rshared" in Linux).
	MountPropagation_PROPAGATION_BIDIRECTIONAL MountPropagation = 2
)

// Enum value maps for MountPropagation.
var (
	MountPropagation_name = map[int32]string{
		0: "PROPAGATION_PRIVATE",
		1: "PROPAGATION_HOST_TO_CONTAINER",
		2: "PROPAGATION_BIDIRECTIONAL",
	}
	MountPropagation_value = map[string]int32{
		"PROPAGATION_PRIVATE":           0,
		"PROPAGATION_HOST_TO_CONTAINER": 1,
		"PROPAGATION_BIDIRECTIONAL":     2,
	}
)

func (x MountPropagation) Enum() *MountPropagation {
	p := new(MountPropagation)
	*p = x
	return p
}

func (x MountPropagation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MountPropagation) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[1].Descriptor()
}

func (MountPropagation) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[1]
}

func (x MountPropagation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MountPropagation.Descriptor instead.
func (MountPropagation) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{1}
}

// A NamespaceMode describes the intended namespace configuration for each
// of the namespaces (Network, PID, IPC) in NamespaceOption. Runtimes should
// map these modes as appropriate for the technology underlying the runtime.
type NamespaceMode int32

const (
	// A POD namespace is common to all containers in a pod.
	// For example, a container with a PID namespace of POD expects to view
	// all of the processes in all of the containers in the pod.
	NamespaceMode_POD NamespaceMode = 0
	// A CONTAINER namespace is restricted to a single container.
	// For example, a container with a PID namespace of CONTAINER expects to
	// view only the processes in that container.
	NamespaceMode_CONTAINER NamespaceMode = 1
	// A NODE namespace is the namespace of the Kubernetes node.
	// For example, a container with a PID namespace of NODE expects to view
	// all of the processes on the host running the kubelet.
	NamespaceMode_NODE NamespaceMode = 2
	// TARGET targets the namespace of another container. When this is specified,
	// a target_id must be specified in NamespaceOption and refer to a container
	// previously created with NamespaceMode CONTAINER. This containers namespace
	// will be made to match that of container target_id.
	// For example, a container with a PID namespace of TARGET expects to view
	// all of the processes that container target_id can view.
	NamespaceMode_TARGET NamespaceMode = 3
)

// Enum value maps for NamespaceMode.
var (
	NamespaceMode_name = map[int32]string{
		0: "POD",
		1: "CONTAINER",
		2: "NODE",
		3: "TARGET",
	}
	NamespaceMode_value = map[string]int32{
		"POD":       0,
		"CONTAINER": 1,
		"NODE":      2,
		"TARGET":    3,
	}
)

func (x NamespaceMode) Enum() *NamespaceMode {
	p := new(NamespaceMode)
	*p = x
	return p
}

func (x NamespaceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NamespaceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[2].Descriptor()
}

func (NamespaceMode) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[2]
}

func (x NamespaceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NamespaceMode.Descriptor instead.
func (NamespaceMode) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{2}
}

type PodSandboxState int32

const (
	PodSandboxState_SANDBOX_READY    PodSandboxState = 0
	PodSandboxState_SANDBOX_NOTREADY PodSandboxState = 1
)

// Enum value maps for PodSandboxState.
var (
	PodSandboxState_name = map[int32]string{
		0: "SANDBOX_READY",
		1: "SANDBOX_NOTREADY",
	}
	PodSandboxState_value = map[string]int32{
		"SANDBOX_READY":    0,
		"SANDBOX_NOTREADY": 1,
	}
)

func (x PodSandboxState) Enum() *PodSandboxState {
	p := new(PodSandboxState)
	*p = x
	return p
}

func (x PodSandboxState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PodSandboxState) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[3].Descriptor()
}

func (PodSandboxState) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[3]
}

func (x PodSandboxState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PodSandboxState.Descriptor instead.
func (PodSandboxState) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{3}
}

type ContainerState int32

const (
	ContainerState_CONTAINER_CREATED ContainerState = 0
	ContainerState_CONTAINER_RUNNING ContainerState = 1
	ContainerState_CONTAINER_EXITED  ContainerState = 2
	ContainerState_CONTAINER_UNKNOWN ContainerState = 3
)

// Enum value maps for ContainerState.
var (
	ContainerState_name = map[int32]string{
		0: "CONTAINER_CREATED",
		1: "CONTAINER_RUNNING",
		2: "CONTAINER_EXITED",
		3: "CONTAINER_UNKNOWN",
	}
	ContainerState_value = map[string]int32{
		"CONTAINER_CREATED": 0,
		"CONTAINER_RUNNING": 1,
		"CONTAINER_EXITED":  2,
		"CONTAINER_UNKNOWN": 3,
	}
)

func (x ContainerState) Enum() *ContainerState {
	p := new(ContainerState)
	*p = x
	return p
}

func (x ContainerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContainerState) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[4].Descriptor()
}

func (ContainerState) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[4]
}

func (x ContainerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContainerState.Descriptor instead.
func (ContainerState) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{4}
}

// Available profile types.
type SecurityProfile_ProfileType int32

const (
	// The container runtime default profile should be used.
	SecurityProfile_RuntimeDefault SecurityProfile_ProfileType = 0
	// Disable the feature for the sandbox or the container.
	SecurityProfile_Unconfined SecurityProfile_ProfileType = 1
	// A pre-defined profile on the node should be used.
	SecurityProfile_Localhost SecurityProfile_ProfileType = 2
)

// Enum value maps for SecurityProfile_ProfileType.
var (
	SecurityProfile_ProfileType_name = map[int32]string{
		0: "RuntimeDefault",
		1: "Unconfined",
		2: "Localhost",
	}
	SecurityProfile_ProfileType_value = map[string]int32{
		"RuntimeDefault": 0,
		"Unconfined":     1,
		"Localhost":      2,
	}
)

func (x SecurityProfile_ProfileType) Enum() *SecurityProfile_ProfileType {
	p := new(SecurityProfile_ProfileType)
	*p = x
	return p
}

func (x SecurityProfile_ProfileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityProfile_ProfileType) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[5].Descriptor()
}

func (SecurityProfile_ProfileType) Type() protoreflect.EnumType {
	return &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes[5]
}

func (x SecurityProfile_ProfileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityProfile_ProfileType.Descriptor instead.
func (SecurityProfile_ProfileType) EnumDescriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{10, 0}
}

type VersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the kubelet runtime API.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *VersionRequest) Reset() {
	*x = VersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionRequest) ProtoMessage() {}

func (x *VersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionRequest.ProtoReflect.Descriptor instead.
func (*VersionRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{0}
}

func (x *VersionRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type VersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the kubelet runtime API.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Name of the container runtime.
	RuntimeName string `protobuf:"bytes,2,opt,name=runtime_name,json=runtimeName,proto3" json:"runtime_name,omitempty"`
	// Version of the container runtime. The string must be
	// semver-compatible.
	RuntimeVersion string `protobuf:"bytes,3,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	// API version of the container runtime. The string must be
	// semver-compatible.
	RuntimeApiVersion string `protobuf:"bytes,4,opt,name=runtime_api_version,json=runtimeApiVersion,proto3" json:"runtime_api_version,omitempty"`
}

func (x *VersionResponse) Reset() {
	*x = VersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponse) ProtoMessage() {}

func (x *VersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponse.ProtoReflect.Descriptor instead.
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{1}
}

func (x *VersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionResponse) GetRuntimeName() string {
	if x != nil {
		return x.RuntimeName
	}
	return ""
}

func (x *VersionResponse) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

func (x *VersionResponse) GetRuntimeApiVersion() string {
	if x != nil {
		return x.RuntimeApiVersion
	}
	return ""
}

// DNSConfig specifies the DNS servers and search domains of a sandbox.
type DNSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DNS servers of the cluster.
	Servers []string `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// List of DNS search domains of the cluster.
	Searches []string `protobuf:"bytes,2,rep,name=searches,proto3" json:"searches,omitempty"`
	// List of DNS options. See https://linux.die.net/man/5/resolv.conf
	// for all available options.
	Options []string `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *DNSConfig) Reset() {
	*x = DNSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DNSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNSConfig) ProtoMessage() {}

func (x *DNSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNSConfig.ProtoReflect.Descriptor instead.
func (*DNSConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{2}
}

func (x *DNSConfig) GetServers() []string {
	if x != nil {
		return x.Servers
	}
	return nil
}

func (x *DNSConfig) GetSearches() []string {
	if x != nil {
		return x.Searches
	}
	return nil
}

func (x *DNSConfig) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

// PortMapping specifies the port mapping configurations of a sandbox.
type PortMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Protocol of the port mapping.
	Protocol Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=runtime.v1alpha2.Protocol" json:"protocol,omitempty"`
	// Port number within the container. Default: 0 (not specified).
	ContainerPort int32 `protobuf:"varint,2,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
	// Port number on the host. Default: 0 (not specified).
	HostPort int32 `protobuf:"varint,3,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// Host IP.
	HostIp string `protobuf:"bytes,4,opt,name=host_ip,json=hostIp,proto3" json:"host_ip,omitempty"`
}

func (x *PortMapping) Reset() {
	*x = PortMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortMapping) ProtoMessage() {}

func (x *PortMapping) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortMapping.ProtoReflect.Descriptor instead.
func (*PortMapping) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{3}
}

func (x *PortMapping) GetProtocol() Protocol {
	if x != nil {
		return x.Protocol
	}
	return Protocol_TCP
}

func (x *PortMapping) GetContainerPort() int32 {
	if x != nil {
		return x.ContainerPort
	}
	return 0
}

func (x *PortMapping) GetHostPort() int32 {
	if x != nil {
		return x.HostPort
	}
	return 0
}

func (x *PortMapping) GetHostIp() string {
	if x != nil {
		return x.HostIp
	}
	return ""
}

// Mount specifies a host volume to mount into a container.
type Mount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path of the mount within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the mount on the host. If the hostPath doesn't exist, then runtimes
	// should report error. If the hostpath is a symbolic link, runtimes should
	// follow the symlink and mount the real destination to container.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	Readonly bool `protobuf:"varint,3,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// If set, the mount needs SELinux relabeling.
	SelinuxRelabel bool `protobuf:"varint,4,opt,name=selinux_relabel,json=selinuxRelabel,proto3" json:"selinux_relabel,omitempty"`
	// Requested propagation mode.
	Propagation MountPropagation `protobuf:"varint,5,opt,name=propagation,proto3,enum=runtime.v1alpha2.MountPropagation" json:"propagation,omitempty"`
}

func (x *Mount) Reset() {
	*x = Mount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{4}
}

func (x *Mount) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Mount) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Mount) GetReadonly() bool {
	if x != nil {
		return x.Readonly
	}
	return false
}

func (x *Mount) GetSelinuxRelabel() bool {
	if x != nil {
		return x.SelinuxRelabel
	}
	return false
}

func (x *Mount) GetPropagation() MountPropagation {
	if x != nil {
		return x.Propagation
	}
	return MountPropagation_PROPAGATION_PRIVATE
}

// IDMapping describes host to container ID mappings for a pod sandbox.
type IDMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// HostId is the id on the host.
	HostId uint32 `protobuf:"varint,1,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
	// ContainerId is the id in the container.
	ContainerId uint32 `protobuf:"varint,2,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Length is the size of the range to map.
	Length uint32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *IDMapping) Reset() {
	*x = IDMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IDMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IDMapping) ProtoMessage() {}

func (x *IDMapping) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IDMapping.ProtoReflect.Descriptor instead.
func (*IDMapping) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{5}
}

func (x *IDMapping) GetHostId() uint32 {
	if x != nil {
		return x.HostId
	}
	return 0
}

func (x *IDMapping) GetContainerId() uint32 {
	if x != nil {
		return x.ContainerId
	}
	return 0
}

func (x *IDMapping) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

// UserNamespace describes the intended user namespace configuration for a pod sandbox.
type UserNamespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode is the NamespaceMode for this UserNamespace.
	// Note: NamespaceMode for UserNamespace currently supports only POD and NODE, not CONTAINER OR TARGET.
	Mode NamespaceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=runtime.v1alpha2.NamespaceMode" json:"mode,omitempty"`
	// Uids specifies the UID mappings for the user namespace.
	Uids []*IDMapping `protobuf:"bytes,2,rep,name=uids,proto3" json:"uids,omitempty"`
	// Gids specifies the GID mappings for the user namespace.
	Gids []*IDMapping `protobuf:"bytes,3,rep,name=gids,proto3" json:"gids,omitempty"`
}

func (x *UserNamespace) Reset() {
	*x = UserNamespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserNamespace) ProtoMessage() {}

func (x *UserNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserNamespace.ProtoReflect.Descriptor instead.
func (*UserNamespace) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{6}
}

func (x *UserNamespace) GetMode() NamespaceMode {
	if x != nil {
		return x.Mode
	}
	return NamespaceMode_POD
}

func (x *UserNamespace) GetUids() []*IDMapping {
	if x != nil {
		return x.Uids
	}
	return nil
}

func (x *UserNamespace) GetGids() []*IDMapping {
	if x != nil {
		return x.Gids
	}
	return nil
}

// NamespaceOption provides options for Linux namespaces.
type NamespaceOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped network in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Network NamespaceMode `protobuf:"varint,1,opt,name=network,proto3,enum=runtime.v1alpha2.NamespaceMode" json:"network,omitempty"`
	// PID namespace for this container/sandbox.
	// Note: The CRI default is POD, but the v1.PodSpec default is CONTAINER.
	// The kubelet's runtime manager will set this to CONTAINER explicitly for v1 pods.
	// Namespaces currently set by the kubelet: POD, CONTAINER, NODE, TARGET
	Pid NamespaceMode `protobuf:"varint,2,opt,name=pid,proto3,enum=runtime.v1alpha2.NamespaceMode" json:"pid,omitempty"`
	// IPC namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped IPC in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Ipc NamespaceMode `protobuf:"varint,3,opt,name=ipc,proto3,enum=runtime.v1alpha2.NamespaceMode" json:"ipc,omitempty"`
	// Target Container ID for NamespaceMode of TARGET. This container must have been
	// previously created in the same pod. It is not possible to specify different targets
	// for each namespace.
	TargetId string `protobuf:"bytes,4,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// UsernsOptions for this pod sandbox.
	// The Kubelet picks the user namespace configuration to use for the pod sandbox.  The mappings
	// are specified as part of the UserNamespace struct.  If the struct is nil, then the POD mode
	// must be assumed.  This is done for backward compatibility with older Kubelet versions that
	// do not set a user namespace.
	UsernsOptions *UserNamespace `protobuf:"bytes,5,opt,name=userns_options,json=usernsOptions,proto3" json:"userns_options,omitempty"`
}

func (x *NamespaceOption) Reset() {
	*x = NamespaceOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceOption) ProtoMessage() {}

func (x *NamespaceOption) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceOption.ProtoReflect.Descriptor instead.
func (*NamespaceOption) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{7}
}

func (x *NamespaceOption) GetNetwork() NamespaceMode {
	if x != nil {
		return x.Network
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetPid() NamespaceMode {
	if x != nil {
		return x.Pid
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetIpc() NamespaceMode {
	if x != nil {
		return x.Ipc
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *NamespaceOption) GetUsernsOptions() *UserNamespace {
	if x != nil {
		return x.UsernsOptions
	}
	return nil
}

// Int64Value is the wrapper of int64.
type Int64Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value.
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Int64Value) Reset() {
	*x = Int64Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Int64Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int64Value) ProtoMessage() {}

func (x *Int64Value) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Int64Value.ProtoReflect.Descriptor instead.
func (*Int64Value) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{8}
}

func (x *Int64Value) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// LinuxSandboxSecurityContext holds linux security configuration that will be
// applied to a sandbox. Note that:
//  1. It does not apply to containers in the pods.
//  2. It may not be applicable to a PodSandbox which does not contain any running
//     process.
type LinuxSandboxSecurityContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configurations for the sandbox's namespaces.
	// This will be used only if the PodSandbox uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,1,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// Optional SELinux context to be applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,2,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run sandbox processes as, when applicable.
	RunAsUser *Int64Value `protobuf:"bytes,3,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run sandbox processes as, when applicable. run_as_group should only
	// be specified when run_as_user is specified; otherwise, the runtime MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,8,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// If set, the root filesystem of the sandbox is read-only.
	ReadonlyRootfs bool `protobuf:"varint,4,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in the sandbox, in
	// addition to the sandbox's primary GID.
	SupplementalGroups []int64 `protobuf:"varint,5,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// Indicates whether the sandbox will be asked to run a privileged
	// container. If a privileged container is to be executed within it, this
	// MUST be true.
	// This allows a sandbox to take additional security precautions if no
	// privileged containers are expected to be run.
	Privileged bool `protobuf:"varint,6,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Seccomp profile for the sandbox.
	Seccomp *SecurityProfile `protobuf:"bytes,9,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the sandbox.
	Apparmor *SecurityProfile `protobuf:"bytes,10,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// Seccomp profile for the sandbox, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	//
	// Deprecated: Do not use.
	SeccompProfilePath string `protobuf:"bytes,7,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"`
}

func (x *LinuxSandboxSecurityContext) Reset() {
	*x = LinuxSandboxSecurityContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxSandboxSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxSandboxSecurityContext) ProtoMessage() {}

func (x *LinuxSandboxSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxSandboxSecurityContext.ProtoReflect.Descriptor instead.
func (*LinuxSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{9}
}

func (x *LinuxSandboxSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if x != nil {
		return x.NamespaceOptions
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if x != nil {
		return x.SelinuxOptions
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetRunAsUser() *Int64Value {
	if x != nil {
		return x.RunAsUser
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetRunAsGroup() *Int64Value {
	if x != nil {
		return x.RunAsGroup
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetReadonlyRootfs() bool {
	if x != nil {
		return x.ReadonlyRootfs
	}
	return false
}

func (x *LinuxSandboxSecurityContext) GetSupplementalGroups() []int64 {
	if x != nil {
		return x.SupplementalGroups
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetPrivileged() bool {
	if x != nil {
		return x.Privileged
	}
	return false
}

func (x *LinuxSandboxSecurityContext) GetSeccomp() *SecurityProfile {
	if x != nil {
		return x.Seccomp
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetApparmor() *SecurityProfile {
	if x != nil {
		return x.Apparmor
	}
	return nil
}

// Deprecated: Do not use.
func (x *LinuxSandboxSecurityContext) GetSeccompProfilePath() string {
	if x != nil {
		return x.SeccompProfilePath
	}
	return ""
}

// A security profile which can be used for sandboxes and containers.
type SecurityProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicator which `ProfileType` should be applied.
	ProfileType SecurityProfile_ProfileType `protobuf:"varint,1,opt,name=profile_type,json=profileType,proto3,enum=runtime.v1alpha2.SecurityProfile_ProfileType" json:"profile_type,omitempty"`
	// Indicates that a pre-defined profile on the node should be used.
	// Must only be set if `ProfileType` is `Localhost`.
	// For seccomp, it must be an absolute path to the seccomp profile.
	// For AppArmor, this field is the AppArmor `<profile name>/`
	LocalhostRef string `protobuf:"bytes,2,opt,name=localhost_ref,json=localhostRef,proto3" json:"localhost_ref,omitempty"`
}

func (x *SecurityProfile) Reset() {
	*x = SecurityProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityProfile) ProtoMessage() {}

func (x *SecurityProfile) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityProfile.ProtoReflect.Descriptor instead.
func (*SecurityProfile) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{10}
}

func (x *SecurityProfile) GetProfileType() SecurityProfile_ProfileType {
	if x != nil {
		return x.ProfileType
	}
	return SecurityProfile_RuntimeDefault
}

func (x *SecurityProfile) GetLocalhostRef() string {
	if x != nil {
		return x.LocalhostRef
	}
	return ""
}

// LinuxPodSandboxConfig holds platform-specific configurations for Linux
// host platforms and Linux-based containers.
type LinuxPodSandboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent cgroup of the PodSandbox.
	// The cgroupfs style syntax will be used, but the container runtime can
	// convert it to systemd semantics if needed.
	CgroupParent string `protobuf:"bytes,1,opt,name=cgroup_parent,json=cgroupParent,proto3" json:"cgroup_parent,omitempty"`
	// LinuxSandboxSecurityContext holds sandbox security attributes.
	SecurityContext *LinuxSandboxSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	// Sysctls holds linux sysctls config for the sandbox.
	Sysctls map[string]string `protobuf:"bytes,3,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional overhead represents the overheads associated with this sandbox
	Overhead *LinuxContainerResources `protobuf:"bytes,4,opt,name=overhead,proto3" json:"overhead,omitempty"`
	// Optional resources represents the sum of container resources for this sandbox
	Resources *LinuxContainerResources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *LinuxPodSandboxConfig) Reset() {
	*x = LinuxPodSandboxConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxPodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxConfig) ProtoMessage() {}

func (x *LinuxPodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxConfig.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{11}
}

func (x *LinuxPodSandboxConfig) GetCgroupParent() string {
	if x != nil {
		return x.CgroupParent
	}
	return ""
}

func (x *LinuxPodSandboxConfig) GetSecurityContext() *LinuxSandboxSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetSysctls() map[string]string {
	if x != nil {
		return x.Sysctls
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetOverhead() *LinuxContainerResources {
	if x != nil {
		return x.Overhead
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetResources() *LinuxContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// PodSandboxMetadata holds all necessary information for building the sandbox name.
// The container runtime is encouraged to expose the metadata associated with the
// PodSandbox in its user interface for better user experience. For example,
// the runtime can construct a unique PodSandboxName based on the metadata.
type PodSandboxMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pod name of the sandbox. Same as the pod name in the Pod ObjectMeta.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Pod UID of the sandbox. Same as the pod UID in the Pod ObjectMeta.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Pod namespace of the sandbox. Same as the pod namespace in the Pod ObjectMeta.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Attempt number of creating the sandbox. Default: 0.
	Attempt uint32 `protobuf:"varint,4,opt,name=attempt,proto3" json:"attempt,omitempty"`
}

func (x *PodSandboxMetadata) Reset() {
	*x = PodSandboxMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxMetadata) ProtoMessage() {}

func (x *PodSandboxMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxMetadata.ProtoReflect.Descriptor instead.
func (*PodSandboxMetadata) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{12}
}

func (x *PodSandboxMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PodSandboxMetadata) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PodSandboxMetadata) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *PodSandboxMetadata) GetAttempt() uint32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

// PodSandboxConfig holds all the required and optional fields for creating a
// sandbox.
type PodSandboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata of the sandbox. This information will uniquely identify the
	// sandbox, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *PodSandboxMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Hostname of the sandbox. Hostname could only be empty when the pod
	// network namespace is NODE.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Path to the directory on the host in which container log files are
	// stored.
	// By default the log of a container going into the LogDirectory will be
	// hooked up to STDOUT and STDERR. However, the LogDirectory may contain
	// binary log files with structured logging data from the individual
	// containers. For example, the files might be newline separated JSON
	// structured logs, systemd-journald journal files, gRPC trace files, etc.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	LogDirectory string `protobuf:"bytes,3,opt,name=log_directory,json=logDirectory,proto3" json:"log_directory,omitempty"`
	// DNS config for the sandbox.
	DnsConfig *DNSConfig `protobuf:"bytes,4,opt,name=dns_config,json=dnsConfig,proto3" json:"dns_config,omitempty"`
	// Port mappings for the sandbox.
	PortMappings []*PortMapping `protobuf:"bytes,5,rep,name=port_mappings,json=portMappings,proto3" json:"port_mappings,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map that may be set by the kubelet to store and
	// retrieve arbitrary metadata. This will include any annotations set on a
	// pod through the Kubernetes API.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the PodSandboxStatus associated with the pod
	// this PodSandboxConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	//
	// Annotations can also be useful for runtime authors to experiment with
	// new features that are opaque to the Kubernetes APIs (both user-facing
	// and the CRI). Whenever possible, however, runtime authors SHOULD
	// consider proposing new typed fields for any new features instead.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional configurations specific to Linux hosts.
	Linux *LinuxPodSandboxConfig `protobuf:"bytes,8,opt,name=linux,proto3" json:"linux,omitempty"`
	// Optional configurations specific to Windows hosts.
	Windows *WindowsPodSandboxConfig `protobuf:"bytes,9,opt,name=windows,proto3" json:"windows,omitempty"`
}

func (x *PodSandboxConfig) Reset() {
	*x = PodSandboxConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxConfig) ProtoMessage() {}

func (x *PodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxConfig.ProtoReflect.Descriptor instead.
func (*PodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{13}
}

func (x *PodSandboxConfig) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxConfig) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *PodSandboxConfig) GetLogDirectory() string {
	if x != nil {
		return x.LogDirectory
	}
	return ""
}

func (x *PodSandboxConfig) GetDnsConfig() *DNSConfig {
	if x != nil {
		return x.DnsConfig
	}
	return nil
}

func (x *PodSandboxConfig) GetPortMappings() []*PortMapping {
	if x != nil {
		return x.PortMappings
	}
	return nil
}

func (x *PodSandboxConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandboxConfig) GetLinux() *LinuxPodSandboxConfig {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxConfig) GetWindows() *WindowsPodSandboxConfig {
	if x != nil {
		return x.Windows
	}
	return nil
}

type RunPodSandboxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for creating a PodSandbox.
	Config *PodSandboxConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Named runtime configuration to use for this PodSandbox.
	// If the runtime handler is unknown, this request should be rejected.  An
	// empty string should select the default handler, equivalent to the
	// behavior before this feature was added.
	// See https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
	RuntimeHandler string `protobuf:"bytes,2,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
}

func (x *RunPodSandboxRequest) Reset() {
	*x = RunPodSandboxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPodSandboxRequest) ProtoMessage() {}

func (x *RunPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*RunPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{14}
}

func (x *RunPodSandboxRequest) GetConfig() *PodSandboxConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *RunPodSandboxRequest) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type RunPodSandboxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox to run.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
}

func (x *RunPodSandboxResponse) Reset() {
	*x = RunPodSandboxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPodSandboxResponse) ProtoMessage() {}

func (x *RunPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*RunPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{15}
}

func (x *RunPodSandboxResponse) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type StopPodSandboxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox to stop.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
}

func (x *StopPodSandboxRequest) Reset() {
	*x = StopPodSandboxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopPodSandboxRequest) ProtoMessage() {}

func (x *StopPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*StopPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{16}
}

func (x *StopPodSandboxRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type StopPodSandboxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StopPodSandboxResponse) Reset() {
	*x = StopPodSandboxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopPodSandboxResponse) ProtoMessage() {}

func (x *StopPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*StopPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{17}
}

type RemovePodSandboxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox to remove.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
}

func (x *RemovePodSandboxRequest) Reset() {
	*x = RemovePodSandboxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemovePodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePodSandboxRequest) ProtoMessage() {}

func (x *RemovePodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePodSandboxRequest.ProtoReflect.Descriptor instead.
func (*RemovePodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{18}
}

func (x *RemovePodSandboxRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type RemovePodSandboxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemovePodSandboxResponse) Reset() {
	*x = RemovePodSandboxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemovePodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePodSandboxResponse) ProtoMessage() {}

func (x *RemovePodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePodSandboxResponse.ProtoReflect.Descriptor instead.
func (*RemovePodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{19}
}

type PodSandboxStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox for which to retrieve status.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Verbose indicates whether to return extra information about the pod sandbox.
	Verbose bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
}

func (x *PodSandboxStatusRequest) Reset() {
	*x = PodSandboxStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatusRequest) ProtoMessage() {}

func (x *PodSandboxStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatusRequest.ProtoReflect.Descriptor instead.
func (*PodSandboxStatusRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{20}
}

func (x *PodSandboxStatusRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *PodSandboxStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

// PodIP represents an ip of a Pod
type PodIP struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// an ip is a string representation of an IPv4 or an IPv6
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
}

func (x *PodIP) Reset() {
	*x = PodIP{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodIP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodIP) ProtoMessage() {}

func (x *PodIP) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodIP.ProtoReflect.Descriptor instead.
func (*PodIP) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{21}
}

func (x *PodIP) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

// PodSandboxNetworkStatus is the status of the network for a PodSandbox.
// Currently ignored for pods sharing the host networking namespace.
type PodSandboxNetworkStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IP address of the PodSandbox.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// list of additional ips (not inclusive of PodSandboxNetworkStatus.Ip) of the PodSandBoxNetworkStatus
	AdditionalIps []*PodIP `protobuf:"bytes,2,rep,name=additional_ips,json=additionalIps,proto3" json:"additional_ips,omitempty"`
}

func (x *PodSandboxNetworkStatus) Reset() {
	*x = PodSandboxNetworkStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxNetworkStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxNetworkStatus) ProtoMessage() {}

func (x *PodSandboxNetworkStatus) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxNetworkStatus.ProtoReflect.Descriptor instead.
func (*PodSandboxNetworkStatus) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{22}
}

func (x *PodSandboxNetworkStatus) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *PodSandboxNetworkStatus) GetAdditionalIps() []*PodIP {
	if x != nil {
		return x.AdditionalIps
	}
	return nil
}

// Namespace contains paths to the namespaces.
type Namespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Namespace options for Linux namespaces.
	Options *NamespaceOption `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *Namespace) Reset() {
	*x = Namespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Namespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespace) ProtoMessage() {}

func (x *Namespace) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespace.ProtoReflect.Descriptor instead.
func (*Namespace) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{23}
}

func (x *Namespace) GetOptions() *NamespaceOption {
	if x != nil {
		return x.Options
	}
	return nil
}

// LinuxSandboxStatus contains status specific to Linux sandboxes.
type LinuxPodSandboxStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Paths to the sandbox's namespaces.
	Namespaces *Namespace `protobuf:"bytes,1,opt,name=namespaces,proto3" json:"namespaces,omitempty"`
}

func (x *LinuxPodSandboxStatus) Reset() {
	*x = LinuxPodSandboxStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxPodSandboxStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxStatus) ProtoMessage() {}

func (x *LinuxPodSandboxStatus) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxStatus.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxStatus) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{24}
}

func (x *LinuxPodSandboxStatus) GetNamespaces() *Namespace {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

// PodSandboxStatus contains the status of the PodSandbox.
type PodSandboxStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the sandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1alpha2.PodSandboxState" json:"state,omitempty"`
	// Creation timestamp of the sandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Network contains network status if network is handled by the runtime.
	Network *PodSandboxNetworkStatus `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Linux-specific status to a pod sandbox.
	Linux *LinuxPodSandboxStatus `protobuf:"bytes,6,opt,name=linux,proto3" json:"linux,omitempty"`
	// Labels are key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate the pod sandbox this status represents.
	Annotations map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler string `protobuf:"bytes,9,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
}

func (x *PodSandboxStatus) Reset() {
	*x = PodSandboxStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatus) ProtoMessage() {}

func (x *PodSandboxStatus) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatus.ProtoReflect.Descriptor instead.
func (*PodSandboxStatus) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{25}
}

func (x *PodSandboxStatus) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxStatus) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxStatus) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (x *PodSandboxStatus) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *PodSandboxStatus) GetNetwork() *PodSandboxNetworkStatus {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *PodSandboxStatus) GetLinux() *LinuxPodSandboxStatus {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxStatus) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxStatus) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandboxStatus) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type PodSandboxStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of the PodSandbox.
	Status *PodSandboxStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the PodSandbox. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. network namespace for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PodSandboxStatusResponse) Reset() {
	*x = PodSandboxStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatusResponse) ProtoMessage() {}

func (x *PodSandboxStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatusResponse.ProtoReflect.Descriptor instead.
func (*PodSandboxStatusResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{26}
}

func (x *PodSandboxStatusResponse) GetStatus() *PodSandboxStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *PodSandboxStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// PodSandboxStateValue is the wrapper of PodSandboxState.
type PodSandboxStateValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State of the sandbox.
	State PodSandboxState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1alpha2.PodSandboxState" json:"state,omitempty"`
}

func (x *PodSandboxStateValue) Reset() {
	*x = PodSandboxStateValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStateValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStateValue) ProtoMessage() {}

func (x *PodSandboxStateValue) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStateValue.ProtoReflect.Descriptor instead.
func (*PodSandboxStateValue) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{27}
}

func (x *PodSandboxStateValue) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

// PodSandboxFilter is used to filter a list of PodSandboxes.
// All those fields are combined with 'AND'
type PodSandboxFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the sandbox.
	State *PodSandboxStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PodSandboxFilter) Reset() {
	*x = PodSandboxFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxFilter) ProtoMessage() {}

func (x *PodSandboxFilter) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxFilter.ProtoReflect.Descriptor instead.
func (*PodSandboxFilter) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{28}
}

func (x *PodSandboxFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxFilter) GetState() *PodSandboxStateValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *PodSandboxFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListPodSandboxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PodSandboxFilter to filter a list of PodSandboxes.
	Filter *PodSandboxFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPodSandboxRequest) Reset() {
	*x = ListPodSandboxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxRequest) ProtoMessage() {}

func (x *ListPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*ListPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{29}
}

func (x *ListPodSandboxRequest) GetFilter() *PodSandboxFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// PodSandbox contains minimal information about a sandbox.
type PodSandbox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the PodSandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the PodSandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1alpha2.PodSandboxState" json:"state,omitempty"`
	// Creation timestamps of the PodSandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Labels of the PodSandbox.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate this PodSandbox.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler string `protobuf:"bytes,7,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
}

func (x *PodSandbox) Reset() {
	*x = PodSandbox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandbox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandbox) ProtoMessage() {}

func (x *PodSandbox) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandbox.ProtoReflect.Descriptor instead.
func (*PodSandbox) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{30}
}

func (x *PodSandbox) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandbox) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandbox) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (x *PodSandbox) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *PodSandbox) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandbox) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandbox) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type ListPodSandboxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of PodSandboxes.
	Items []*PodSandbox `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListPodSandboxResponse) Reset() {
	*x = ListPodSandboxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxResponse) ProtoMessage() {}

func (x *ListPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*ListPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{31}
}

func (x *ListPodSandboxResponse) GetItems() []*PodSandbox {
	if x != nil {
		return x.Items
	}
	return nil
}

type PodSandboxStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the pod sandbox for which to retrieve stats.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
}

func (x *PodSandboxStatsRequest) Reset() {
	*x = PodSandboxStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsRequest) ProtoMessage() {}

func (x *PodSandboxStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsRequest.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{32}
}

func (x *PodSandboxStatsRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type PodSandboxStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stats *PodSandboxStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *PodSandboxStatsResponse) Reset() {
	*x = PodSandboxStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsResponse) ProtoMessage() {}

func (x *PodSandboxStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsResponse.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{33}
}

func (x *PodSandboxStatsResponse) GetStats() *PodSandboxStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// PodSandboxStatsFilter is used to filter the list of pod sandboxes to retrieve stats for.
// All those fields are combined with 'AND'.
type PodSandboxStatsFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,2,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PodSandboxStatsFilter) Reset() {
	*x = PodSandboxStatsFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsFilter) ProtoMessage() {}

func (x *PodSandboxStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsFilter.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsFilter) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{34}
}

func (x *PodSandboxStatsFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxStatsFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListPodSandboxStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Filter for the list request.
	Filter *PodSandboxStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPodSandboxStatsRequest) Reset() {
	*x = ListPodSandboxStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPodSandboxStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxStatsRequest) ProtoMessage() {}

func (x *ListPodSandboxStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxStatsRequest.ProtoReflect.Descriptor instead.
func (*ListPodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{35}
}

func (x *ListPodSandboxStatsRequest) GetFilter() *PodSandboxStatsFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

type ListPodSandboxStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stats of the pod sandbox.
	Stats []*PodSandboxStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
}

func (x *ListPodSandboxStatsResponse) Reset() {
	*x = ListPodSandboxStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPodSandboxStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxStatsResponse) ProtoMessage() {}

func (x *ListPodSandboxStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxStatsResponse.ProtoReflect.Descriptor instead.
func (*ListPodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{36}
}

func (x *ListPodSandboxStatsResponse) GetStats() []*PodSandboxStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// PodSandboxAttributes provides basic information of the pod sandbox.
type PodSandboxAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the pod sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxStatus used to
	// instantiate the PodSandbox this status represents.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PodSandboxAttributes) Reset() {
	*x = PodSandboxAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxAttributes) ProtoMessage() {}

func (x *PodSandboxAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxAttributes.ProtoReflect.Descriptor instead.
func (*PodSandboxAttributes) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{37}
}

func (x *PodSandboxAttributes) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxAttributes) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxAttributes) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxAttributes) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// PodSandboxStats provides the resource usage statistics for a pod.
// The linux or windows field will be populated depending on the platform.
type PodSandboxStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information of the pod.
	Attributes *PodSandboxAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Stats from linux.
	Linux *LinuxPodSandboxStats `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Stats from windows.
	Windows *WindowsPodSandboxStats `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
}

func (x *PodSandboxStats) Reset() {
	*x = PodSandboxStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStats) ProtoMessage() {}

func (x *PodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStats.ProtoReflect.Descriptor instead.
func (*PodSandboxStats) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{38}
}

func (x *PodSandboxStats) GetAttributes() *PodSandboxAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *PodSandboxStats) GetLinux() *LinuxPodSandboxStats {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxStats) GetWindows() *WindowsPodSandboxStats {
	if x != nil {
		return x.Windows
	}
	return nil
}

// LinuxPodSandboxStats provides the resource usage statistics for a pod sandbox on linux.
type LinuxPodSandboxStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU usage gathered for the pod sandbox.
	Cpu *CpuUsage `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered for the pod sandbox.
	Memory *MemoryUsage `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage gathered for the pod sandbox
	Network *NetworkUsage `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Stats pertaining to processes in the pod sandbox.
	Process *ProcessUsage `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	// Stats of containers in the measured pod sandbox.
	Containers []*ContainerStats `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
}

func (x *LinuxPodSandboxStats) Reset() {
	*x = LinuxPodSandboxStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxPodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxStats) ProtoMessage() {}

func (x *LinuxPodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxStats.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxStats) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{39}
}

func (x *LinuxPodSandboxStats) GetCpu() *CpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetMemory() *MemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetNetwork() *NetworkUsage {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetProcess() *ProcessUsage {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetContainers() []*ContainerStats {
	if x != nil {
		return x.Containers
	}
	return nil
}

// WindowsPodSandboxStats provides the resource usage statistics for a pod sandbox on windows
type WindowsPodSandboxStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WindowsPodSandboxStats) Reset() {
	*x = WindowsPodSandboxStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsPodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsPodSandboxStats) ProtoMessage() {}

func (x *WindowsPodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsPodSandboxStats.ProtoReflect.Descriptor instead.
func (*WindowsPodSandboxStats) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{40}
}

// NetworkUsage contains data about network resources.
type NetworkUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which these stats were updated.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Stats for the default network interface.
	DefaultInterface *NetworkInterfaceUsage `protobuf:"bytes,2,opt,name=default_interface,json=defaultInterface,proto3" json:"default_interface,omitempty"`
	// Stats for all found network interfaces, excluding the default.
	Interfaces []*NetworkInterfaceUsage `protobuf:"bytes,3,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
}

func (x *NetworkUsage) Reset() {
	*x = NetworkUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkUsage) ProtoMessage() {}

func (x *NetworkUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkUsage.ProtoReflect.Descriptor instead.
func (*NetworkUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{41}
}

func (x *NetworkUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *NetworkUsage) GetDefaultInterface() *NetworkInterfaceUsage {
	if x != nil {
		return x.DefaultInterface
	}
	return nil
}

func (x *NetworkUsage) GetInterfaces() []*NetworkInterfaceUsage {
	if x != nil {
		return x.Interfaces
	}
	return nil
}

// NetworkInterfaceUsage contains resource value data about a network interface.
type NetworkInterfaceUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the network interface.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cumulative count of bytes received.
	RxBytes *UInt64Value `protobuf:"bytes,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	// Cumulative count of receive errors encountered.
	RxErrors *UInt64Value `protobuf:"bytes,3,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	// Cumulative count of bytes transmitted.
	TxBytes *UInt64Value `protobuf:"bytes,4,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	// Cumulative count of transmit errors encountered.
	TxErrors *UInt64Value `protobuf:"bytes,5,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
}

func (x *NetworkInterfaceUsage) Reset() {
	*x = NetworkInterfaceUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkInterfaceUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterfaceUsage) ProtoMessage() {}

func (x *NetworkInterfaceUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterfaceUsage.ProtoReflect.Descriptor instead.
func (*NetworkInterfaceUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{42}
}

func (x *NetworkInterfaceUsage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkInterfaceUsage) GetRxBytes() *UInt64Value {
	if x != nil {
		return x.RxBytes
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetRxErrors() *UInt64Value {
	if x != nil {
		return x.RxErrors
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetTxBytes() *UInt64Value {
	if x != nil {
		return x.TxBytes
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetTxErrors() *UInt64Value {
	if x != nil {
		return x.TxErrors
	}
	return nil
}

// ProcessUsage are stats pertaining to processes.
type ProcessUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which these stats were updated.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Number of processes.
	ProcessCount *UInt64Value `protobuf:"bytes,2,opt,name=process_count,json=processCount,proto3" json:"process_count,omitempty"`
}

func (x *ProcessUsage) Reset() {
	*x = ProcessUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessUsage) ProtoMessage() {}

func (x *ProcessUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessUsage.ProtoReflect.Descriptor instead.
func (*ProcessUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{43}
}

func (x *ProcessUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *ProcessUsage) GetProcessCount() *UInt64Value {
	if x != nil {
		return x.ProcessCount
	}
	return nil
}

// ImageSpec is an internal representation of an image.
type ImageSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container's Image field (e.g. imageID or imageDigest).
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Unstructured key-value map holding arbitrary metadata.
	// ImageSpec Annotations can be used to help the runtime target specific
	// images in multi-arch images.
	Annotations map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ImageSpec) Reset() {
	*x = ImageSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSpec) ProtoMessage() {}

func (x *ImageSpec) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSpec.ProtoReflect.Descriptor instead.
func (*ImageSpec) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{44}
}

func (x *ImageSpec) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ImageSpec) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *KeyValue) Reset() {
	*x = KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValue) ProtoMessage() {}

func (x *KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValue.ProtoReflect.Descriptor instead.
func (*KeyValue) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{45}
}

func (x *KeyValue) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// LinuxContainerResources specifies Linux specific configuration for
// resources.
type LinuxContainerResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU CFS (Completely Fair Scheduler) period. Default: 0 (not specified).
	CpuPeriod int64 `protobuf:"varint,1,opt,name=cpu_period,json=cpuPeriod,proto3" json:"cpu_period,omitempty"`
	// CPU CFS (Completely Fair Scheduler) quota. Default: 0 (not specified).
	CpuQuota int64 `protobuf:"varint,2,opt,name=cpu_quota,json=cpuQuota,proto3" json:"cpu_quota,omitempty"`
	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,3,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// OOMScoreAdj adjusts the oom-killer score. Default: 0 (not specified).
	OomScoreAdj int64 `protobuf:"varint,5,opt,name=oom_score_adj,json=oomScoreAdj,proto3" json:"oom_score_adj,omitempty"`
	// CpusetCpus constrains the allowed set of logical CPUs. Default: "" (not specified).
	CpusetCpus string `protobuf:"bytes,6,opt,name=cpuset_cpus,json=cpusetCpus,proto3" json:"cpuset_cpus,omitempty"`
	// CpusetMems constrains the allowed set of memory nodes. Default: "" (not specified).
	CpusetMems string `protobuf:"bytes,7,opt,name=cpuset_mems,json=cpusetMems,proto3" json:"cpuset_mems,omitempty"`
	// List of HugepageLimits to limit the HugeTLB usage of container per page size. Default: nil (not specified).
	HugepageLimits []*HugepageLimit `protobuf:"bytes,8,rep,name=hugepage_limits,json=hugepageLimits,proto3" json:"hugepage_limits,omitempty"`
	// Unified resources for cgroup v2. Default: nil (not specified).
	// Each key/value in the map refers to the cgroup v2.
	// e.g. "memory.max": "6937202688" or "io.weight": "default 100".
	Unified map[string]string `protobuf:"bytes,9,rep,name=unified,proto3" json:"unified,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Memory swap limit in bytes. Default 0 (not specified).
	MemorySwapLimitInBytes int64 `protobuf:"varint,10,opt,name=memory_swap_limit_in_bytes,json=memorySwapLimitInBytes,proto3" json:"memory_swap_limit_in_bytes,omitempty"`
}

func (x *LinuxContainerResources) Reset() {
	*x = LinuxContainerResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerResources) ProtoMessage() {}

func (x *LinuxContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerResources.ProtoReflect.Descriptor instead.
func (*LinuxContainerResources) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{46}
}

func (x *LinuxContainerResources) GetCpuPeriod() int64 {
	if x != nil {
		return x.CpuPeriod
	}
	return 0
}

func (x *LinuxContainerResources) GetCpuQuota() int64 {
	if x != nil {
		return x.CpuQuota
	}
	return 0
}

func (x *LinuxContainerResources) GetCpuShares() int64 {
	if x != nil {
		return x.CpuShares
	}
	return 0
}

func (x *LinuxContainerResources) GetMemoryLimitInBytes() int64 {
	if x != nil {
		return x.MemoryLimitInBytes
	}
	return 0
}

func (x *LinuxContainerResources) GetOomScoreAdj() int64 {
	if x != nil {
		return x.OomScoreAdj
	}
	return 0
}

func (x *LinuxContainerResources) GetCpusetCpus() string {
	if x != nil {
		return x.CpusetCpus
	}
	return ""
}

func (x *LinuxContainerResources) GetCpusetMems() string {
	if x != nil {
		return x.CpusetMems
	}
	return ""
}

func (x *LinuxContainerResources) GetHugepageLimits() []*HugepageLimit {
	if x != nil {
		return x.HugepageLimits
	}
	return nil
}

func (x *LinuxContainerResources) GetUnified() map[string]string {
	if x != nil {
		return x.Unified
	}
	return nil
}

func (x *LinuxContainerResources) GetMemorySwapLimitInBytes() int64 {
	if x != nil {
		return x.MemorySwapLimitInBytes
	}
	return 0
}

// HugepageLimit corresponds to the file`hugetlb.<hugepagesize>.limit_in_byte` in container level cgroup.
// For example, `PageSize=1GB`, `Limit=1073741824` means setting `1073741824` bytes to hugetlb.1GB.limit_in_bytes.
type HugepageLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of PageSize has the format <size><unit-prefix>B (2MB, 1GB),
	// and must match the <hugepagesize> of the corresponding control file found in `hugetlb.<hugepagesize>.limit_in_bytes`.
	// The values of <unit-prefix> are intended to be parsed using base 1024("1KB" = 1024, "1MB" = 1048576, etc).
	PageSize string `protobuf:"bytes,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// limit in bytes of hugepagesize HugeTLB usage.
	Limit uint64 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (x *HugepageLimit) Reset() {
	*x = HugepageLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HugepageLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HugepageLimit) ProtoMessage() {}

func (x *HugepageLimit) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HugepageLimit.ProtoReflect.Descriptor instead.
func (*HugepageLimit) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{47}
}

func (x *HugepageLimit) GetPageSize() string {
	if x != nil {
		return x.PageSize
	}
	return ""
}

func (x *HugepageLimit) GetLimit() uint64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

// SELinuxOption are the labels to be applied to the container.
type SELinuxOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	User  string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Role  string `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	Type  string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Level string `protobuf:"bytes,4,opt,name=level,proto3" json:"level,omitempty"`
}

func (x *SELinuxOption) Reset() {
	*x = SELinuxOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SELinuxOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SELinuxOption) ProtoMessage() {}

func (x *SELinuxOption) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SELinuxOption.ProtoReflect.Descriptor instead.
func (*SELinuxOption) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{48}
}

func (x *SELinuxOption) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *SELinuxOption) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *SELinuxOption) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SELinuxOption) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

// Capability contains the container capabilities to add or drop
// Dropping a capability will drop it from all sets.
// If a capability is added to only the add_capabilities list then it gets added to permitted,
// inheritable, effective and bounding sets, i.e. all sets except the ambient set.
// If a capability is added to only the add_ambient_capabilities list then it gets added to all sets, i.e permitted
// inheritable, effective, bounding and ambient sets.
// If a capability is added to add_capabilities and add_ambient_capabilities lists then it gets added to all sets, i.e.
// permitted, inheritable, effective, bounding and ambient sets.
type Capability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of capabilities to add.
	AddCapabilities []string `protobuf:"bytes,1,rep,name=add_capabilities,json=addCapabilities,proto3" json:"add_capabilities,omitempty"`
	// List of capabilities to drop.
	DropCapabilities []string `protobuf:"bytes,2,rep,name=drop_capabilities,json=dropCapabilities,proto3" json:"drop_capabilities,omitempty"`
	// List of ambient capabilities to add.
	AddAmbientCapabilities []string `protobuf:"bytes,3,rep,name=add_ambient_capabilities,json=addAmbientCapabilities,proto3" json:"add_ambient_capabilities,omitempty"`
}

func (x *Capability) Reset() {
	*x = Capability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Capability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Capability) ProtoMessage() {}

func (x *Capability) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Capability.ProtoReflect.Descriptor instead.
func (*Capability) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{49}
}

func (x *Capability) GetAddCapabilities() []string {
	if x != nil {
		return x.AddCapabilities
	}
	return nil
}

func (x *Capability) GetDropCapabilities() []string {
	if x != nil {
		return x.DropCapabilities
	}
	return nil
}

func (x *Capability) GetAddAmbientCapabilities() []string {
	if x != nil {
		return x.AddAmbientCapabilities
	}
	return nil
}

// LinuxContainerSecurityContext holds linux security configuration that will be applied to a container.
type LinuxContainerSecurityContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Capabilities to add or drop.
	Capabilities *Capability `protobuf:"bytes,1,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	// If set, run container in privileged mode.
	// Privileged mode is incompatible with the following options. If
	// privileged is set, the following features MAY have no effect:
	// 1. capabilities
	// 2. selinux_options
	// 4. seccomp
	// 5. apparmor
	//
	// Privileged mode implies the following specific options are applied:
	// 1. All capabilities are added.
	// 2. Sensitive paths, such as kernel module paths within sysfs, are not masked.
	// 3. Any sysfs and procfs mounts are mounted RW.
	// 4. AppArmor confinement is not applied.
	// 5. Seccomp restrictions are not applied.
	// 6. The device cgroup does not restrict access to any devices.
	// 7. All devices from the host's /dev are available within the container.
	// 8. SELinux restrictions are not applied (e.g. label=disabled).
	Privileged bool `protobuf:"varint,2,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Configurations for the container's namespaces.
	// Only used if the container uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,3,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// SELinux context to be optionally applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,4,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run the container process as. Only one of run_as_user and
	// run_as_username can be specified at a time.
	RunAsUser *Int64Value `protobuf:"bytes,5,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run the container process as. run_as_group should only be specified
	// when run_as_user or run_as_username is specified; otherwise, the runtime
	// MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,12,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image (i.e. in the /etc/passwd inside the image),
	// and be resolved there by the runtime; otherwise, the runtime MUST error.
	RunAsUsername string `protobuf:"bytes,6,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// If set, the root filesystem of the container is read-only.
	ReadonlyRootfs bool `protobuf:"varint,7,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in the container, in
	// addition to the container's primary GID.
	SupplementalGroups []int64 `protobuf:"varint,8,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// no_new_privs defines if the flag for no_new_privs should be set on the
	// container.
	NoNewPrivs bool `protobuf:"varint,11,opt,name=no_new_privs,json=noNewPrivs,proto3" json:"no_new_privs,omitempty"`
	// masked_paths is a slice of paths that should be masked by the container
	// runtime, this can be passed directly to the OCI spec.
	MaskedPaths []string `protobuf:"bytes,13,rep,name=masked_paths,json=maskedPaths,proto3" json:"masked_paths,omitempty"`
	// readonly_paths is a slice of paths that should be set as readonly by the
	// container runtime, this can be passed directly to the OCI spec.
	ReadonlyPaths []string `protobuf:"bytes,14,rep,name=readonly_paths,json=readonlyPaths,proto3" json:"readonly_paths,omitempty"`
	// Seccomp profile for the container.
	Seccomp *SecurityProfile `protobuf:"bytes,15,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the container.
	Apparmor *SecurityProfile `protobuf:"bytes,16,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// AppArmor profile for the container, candidate values are:
	//   - runtime/default: equivalent to not specifying a profile.
	//   - unconfined: no profiles are loaded
	//   - localhost/<profile_name>: profile loaded on the node
	//     (localhost) by name. The possible profile names are detailed at
	//     https://gitlab.com/apparmor/apparmor/-/wikis/AppArmor_Core_Policy_Reference
	//
	// Deprecated: Do not use.
	ApparmorProfile string `protobuf:"bytes,9,opt,name=apparmor_profile,json=apparmorProfile,proto3" json:"apparmor_profile,omitempty"`
	// Seccomp profile for the container, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	//
	// Deprecated: Do not use.
	SeccompProfilePath string `protobuf:"bytes,10,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"`
}

func (x *LinuxContainerSecurityContext) Reset() {
	*x = LinuxContainerSecurityContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxContainerSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerSecurityContext) ProtoMessage() {}

func (x *LinuxContainerSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerSecurityContext.ProtoReflect.Descriptor instead.
func (*LinuxContainerSecurityContext) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{50}
}

func (x *LinuxContainerSecurityContext) GetCapabilities() *Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetPrivileged() bool {
	if x != nil {
		return x.Privileged
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if x != nil {
		return x.NamespaceOptions
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if x != nil {
		return x.SelinuxOptions
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsUser() *Int64Value {
	if x != nil {
		return x.RunAsUser
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsGroup() *Int64Value {
	if x != nil {
		return x.RunAsGroup
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *LinuxContainerSecurityContext) GetReadonlyRootfs() bool {
	if x != nil {
		return x.ReadonlyRootfs
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetSupplementalGroups() []int64 {
	if x != nil {
		return x.SupplementalGroups
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetNoNewPrivs() bool {
	if x != nil {
		return x.NoNewPrivs
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetMaskedPaths() []string {
	if x != nil {
		return x.MaskedPaths
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetReadonlyPaths() []string {
	if x != nil {
		return x.ReadonlyPaths
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetSeccomp() *SecurityProfile {
	if x != nil {
		return x.Seccomp
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetApparmor() *SecurityProfile {
	if x != nil {
		return x.Apparmor
	}
	return nil
}

// Deprecated: Do not use.
func (x *LinuxContainerSecurityContext) GetApparmorProfile() string {
	if x != nil {
		return x.ApparmorProfile
	}
	return ""
}

// Deprecated: Do not use.
func (x *LinuxContainerSecurityContext) GetSeccompProfilePath() string {
	if x != nil {
		return x.SeccompProfilePath
	}
	return ""
}

// LinuxContainerConfig contains platform-specific configuration for
// Linux-based containers.
type LinuxContainerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resources specification for the container.
	Resources *LinuxContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// LinuxContainerSecurityContext configuration for the container.
	SecurityContext *LinuxContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
}

func (x *LinuxContainerConfig) Reset() {
	*x = LinuxContainerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerConfig) ProtoMessage() {}

func (x *LinuxContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerConfig.ProtoReflect.Descriptor instead.
func (*LinuxContainerConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{51}
}

func (x *LinuxContainerConfig) GetResources() *LinuxContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *LinuxContainerConfig) GetSecurityContext() *LinuxContainerSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// WindowsSandboxSecurityContext holds platform-specific configurations that will be
// applied to a sandbox.
// These settings will only apply to the sandbox container.
type WindowsSandboxSecurityContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether the container requested to run as a HostProcess container.
	HostProcess bool `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
}

func (x *WindowsSandboxSecurityContext) Reset() {
	*x = WindowsSandboxSecurityContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsSandboxSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsSandboxSecurityContext) ProtoMessage() {}

func (x *WindowsSandboxSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsSandboxSecurityContext.ProtoReflect.Descriptor instead.
func (*WindowsSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{52}
}

func (x *WindowsSandboxSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *WindowsSandboxSecurityContext) GetCredentialSpec() string {
	if x != nil {
		return x.CredentialSpec
	}
	return ""
}

func (x *WindowsSandboxSecurityContext) GetHostProcess() bool {
	if x != nil {
		return x.HostProcess
	}
	return false
}

// WindowsPodSandboxConfig holds platform-specific configurations for Windows
// host platforms and Windows-based containers.
type WindowsPodSandboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// WindowsSandboxSecurityContext holds sandbox security attributes.
	SecurityContext *WindowsSandboxSecurityContext `protobuf:"bytes,1,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
}

func (x *WindowsPodSandboxConfig) Reset() {
	*x = WindowsPodSandboxConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsPodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsPodSandboxConfig) ProtoMessage() {}

func (x *WindowsPodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsPodSandboxConfig.ProtoReflect.Descriptor instead.
func (*WindowsPodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{53}
}

func (x *WindowsPodSandboxConfig) GetSecurityContext() *WindowsSandboxSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// WindowsContainerSecurityContext holds windows security configuration that will be applied to a container.
type WindowsContainerSecurityContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether a container is to be run as a HostProcess container.
	HostProcess bool `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
}

func (x *WindowsContainerSecurityContext) Reset() {
	*x = WindowsContainerSecurityContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsContainerSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerSecurityContext) ProtoMessage() {}

func (x *WindowsContainerSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerSecurityContext.ProtoReflect.Descriptor instead.
func (*WindowsContainerSecurityContext) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{54}
}

func (x *WindowsContainerSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *WindowsContainerSecurityContext) GetCredentialSpec() string {
	if x != nil {
		return x.CredentialSpec
	}
	return ""
}

func (x *WindowsContainerSecurityContext) GetHostProcess() bool {
	if x != nil {
		return x.HostProcess
	}
	return false
}

// WindowsContainerConfig contains platform-specific configuration for
// Windows-based containers.
type WindowsContainerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resources specification for the container.
	Resources *WindowsContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// WindowsContainerSecurityContext configuration for the container.
	SecurityContext *WindowsContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
}

func (x *WindowsContainerConfig) Reset() {
	*x = WindowsContainerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerConfig) ProtoMessage() {}

func (x *WindowsContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerConfig.ProtoReflect.Descriptor instead.
func (*WindowsContainerConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{55}
}

func (x *WindowsContainerConfig) GetResources() *WindowsContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *WindowsContainerConfig) GetSecurityContext() *WindowsContainerSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// WindowsContainerResources specifies Windows specific configuration for
// resources.
type WindowsContainerResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,1,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Number of CPUs available to the container. Default: 0 (not specified).
	CpuCount int64 `protobuf:"varint,2,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// Specifies the portion of processor cycles that this container can use as a percentage times 100.
	CpuMaximum int64 `protobuf:"varint,3,opt,name=cpu_maximum,json=cpuMaximum,proto3" json:"cpu_maximum,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// Specifies the size of the rootfs / scratch space in bytes to be configured for this container. Default: 0 (not specified).
	RootfsSizeInBytes int64 `protobuf:"varint,5,opt,name=rootfs_size_in_bytes,json=rootfsSizeInBytes,proto3" json:"rootfs_size_in_bytes,omitempty"`
}

func (x *WindowsContainerResources) Reset() {
	*x = WindowsContainerResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerResources) ProtoMessage() {}

func (x *WindowsContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerResources.ProtoReflect.Descriptor instead.
func (*WindowsContainerResources) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{56}
}

func (x *WindowsContainerResources) GetCpuShares() int64 {
	if x != nil {
		return x.CpuShares
	}
	return 0
}

func (x *WindowsContainerResources) GetCpuCount() int64 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *WindowsContainerResources) GetCpuMaximum() int64 {
	if x != nil {
		return x.CpuMaximum
	}
	return 0
}

func (x *WindowsContainerResources) GetMemoryLimitInBytes() int64 {
	if x != nil {
		return x.MemoryLimitInBytes
	}
	return 0
}

func (x *WindowsContainerResources) GetRootfsSizeInBytes() int64 {
	if x != nil {
		return x.RootfsSizeInBytes
	}
	return 0
}

// ContainerMetadata holds all necessary information for building the container
// name. The container runtime is encouraged to expose the metadata in its user
// interface for better user experience. E.g., runtime can construct a unique
// container name based on the metadata. Note that (name, attempt) is unique
// within a sandbox for the entire lifetime of the sandbox.
type ContainerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the container. Same as the container name in the PodSpec.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Attempt number of creating the container. Default: 0.
	Attempt uint32 `protobuf:"varint,2,opt,name=attempt,proto3" json:"attempt,omitempty"`
}

func (x *ContainerMetadata) Reset() {
	*x = ContainerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerMetadata) ProtoMessage() {}

func (x *ContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerMetadata.ProtoReflect.Descriptor instead.
func (*ContainerMetadata) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{57}
}

func (x *ContainerMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ContainerMetadata) GetAttempt() uint32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

// Device specifies a host device to mount into a container.
type Device struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path of the device within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *Device) Reset() {
	*x = Device{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{58}
}

func (x *Device) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Device) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Device) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

// ContainerConfig holds all the required and optional fields for creating a
// container.
type ContainerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata of the container. This information will uniquely identify the
	// container, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *ContainerMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Image to use.
	Image *ImageSpec `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	// Command to execute (i.e., entrypoint for docker)
	Command []string `protobuf:"bytes,3,rep,name=command,proto3" json:"command,omitempty"`
	// Args for the Command (i.e., command for docker)
	Args []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Current working directory of the command.
	WorkingDir string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	// List of environment variable to set in the container.
	Envs []*KeyValue `protobuf:"bytes,6,rep,name=envs,proto3" json:"envs,omitempty"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,7,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*Device `protobuf:"bytes,8,rep,name=devices,proto3" json:"devices,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	// Label keys are of the form:
	//
	//	label-key ::= prefixed-name | name
	//	prefixed-name ::= prefix '/' name
	//	prefix ::= DNS_SUBDOMAIN
	//	name ::= DNS_LABEL
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map that may be used by the kubelet to store and
	// retrieve arbitrary metadata.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the ContainerStatus associated with the container
	// this ContainerConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Path relative to PodSandboxConfig.LogDirectory for container to store
	// the log (STDOUT and STDERR) on the host.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	//
	// WARNING: Log management and how kubelet should interface with the
	// container logs are under active discussion in
	// https://issues.k8s.io/24677. There *may* be future change of direction
	// for logging as the discussion carries on.
	LogPath string `protobuf:"bytes,11,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Variables for interactive containers, these have very specialized
	// use-cases (e.g. debugging).
	Stdin     bool `protobuf:"varint,12,opt,name=stdin,proto3" json:"stdin,omitempty"`
	StdinOnce bool `protobuf:"varint,13,opt,name=stdin_once,json=stdinOnce,proto3" json:"stdin_once,omitempty"`
	Tty       bool `protobuf:"varint,14,opt,name=tty,proto3" json:"tty,omitempty"`
	// Configuration specific to Linux containers.
	Linux *LinuxContainerConfig `protobuf:"bytes,15,opt,name=linux,proto3" json:"linux,omitempty"`
	// Configuration specific to Windows containers.
	Windows *WindowsContainerConfig `protobuf:"bytes,16,opt,name=windows,proto3" json:"windows,omitempty"`
}

func (x *ContainerConfig) Reset() {
	*x = ContainerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerConfig) ProtoMessage() {}

func (x *ContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerConfig.ProtoReflect.Descriptor instead.
func (*ContainerConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{59}
}

func (x *ContainerConfig) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerConfig) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ContainerConfig) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *ContainerConfig) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ContainerConfig) GetWorkingDir() string {
	if x != nil {
		return x.WorkingDir
	}
	return ""
}

func (x *ContainerConfig) GetEnvs() []*KeyValue {
	if x != nil {
		return x.Envs
	}
	return nil
}

func (x *ContainerConfig) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ContainerConfig) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *ContainerConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ContainerConfig) GetLogPath() string {
	if x != nil {
		return x.LogPath
	}
	return ""
}

func (x *ContainerConfig) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *ContainerConfig) GetStdinOnce() bool {
	if x != nil {
		return x.StdinOnce
	}
	return false
}

func (x *ContainerConfig) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *ContainerConfig) GetLinux() *LinuxContainerConfig {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *ContainerConfig) GetWindows() *WindowsContainerConfig {
	if x != nil {
		return x.Windows
	}
	return nil
}

type CreateContainerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the PodSandbox in which the container should be created.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Config of the container.
	Config *ContainerConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Config of the PodSandbox. This is the same config that was passed
	// to RunPodSandboxRequest to create the PodSandbox. It is passed again
	// here just for easy reference. The PodSandboxConfig is immutable and
	// remains the same throughout the lifetime of the pod.
	SandboxConfig *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
}

func (x *CreateContainerRequest) Reset() {
	*x = CreateContainerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContainerRequest) ProtoMessage() {}

func (x *CreateContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContainerRequest.ProtoReflect.Descriptor instead.
func (*CreateContainerRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{60}
}

func (x *CreateContainerRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *CreateContainerRequest) GetConfig() *ContainerConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateContainerRequest) GetSandboxConfig() *PodSandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

type CreateContainerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the created container.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (x *CreateContainerResponse) Reset() {
	*x = CreateContainerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContainerResponse) ProtoMessage() {}

func (x *CreateContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContainerResponse.ProtoReflect.Descriptor instead.
func (*CreateContainerResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{61}
}

func (x *CreateContainerResponse) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type StartContainerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to start.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (x *StartContainerRequest) Reset() {
	*x = StartContainerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartContainerRequest) ProtoMessage() {}

func (x *StartContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartContainerRequest.ProtoReflect.Descriptor instead.
func (*StartContainerRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{62}
}

func (x *StartContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type StartContainerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StartContainerResponse) Reset() {
	*x = StartContainerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartContainerResponse) ProtoMessage() {}

func (x *StartContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartContainerResponse.ProtoReflect.Descriptor instead.
func (*StartContainerResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{63}
}

type StopContainerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to stop.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Timeout in seconds to wait for the container to stop before forcibly
	// terminating it. Default: 0 (forcibly terminate the container immediately)
	Timeout int64 `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *StopContainerRequest) Reset() {
	*x = StopContainerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopContainerRequest) ProtoMessage() {}

func (x *StopContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopContainerRequest.ProtoReflect.Descriptor instead.
func (*StopContainerRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{64}
}

func (x *StopContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *StopContainerRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type StopContainerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StopContainerResponse) Reset() {
	*x = StopContainerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopContainerResponse) ProtoMessage() {}

func (x *StopContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopContainerResponse.ProtoReflect.Descriptor instead.
func (*StopContainerResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{65}
}

type RemoveContainerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to remove.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (x *RemoveContainerRequest) Reset() {
	*x = RemoveContainerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContainerRequest) ProtoMessage() {}

func (x *RemoveContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContainerRequest.ProtoReflect.Descriptor instead.
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{66}
}

func (x *RemoveContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type RemoveContainerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveContainerResponse) Reset() {
	*x = RemoveContainerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContainerResponse) ProtoMessage() {}

func (x *RemoveContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContainerResponse.ProtoReflect.Descriptor instead.
func (*RemoveContainerResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{67}
}

// ContainerStateValue is the wrapper of ContainerState.
type ContainerStateValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State of the container.
	State ContainerState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1alpha2.ContainerState" json:"state,omitempty"`
}

func (x *ContainerStateValue) Reset() {
	*x = ContainerStateValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStateValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStateValue) ProtoMessage() {}

func (x *ContainerStateValue) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStateValue.ProtoReflect.Descriptor instead.
func (*ContainerStateValue) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{68}
}

func (x *ContainerStateValue) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

// ContainerFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the container.
	State *ContainerStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,3,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,4,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ContainerFilter) Reset() {
	*x = ContainerFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerFilter) ProtoMessage() {}

func (x *ContainerFilter) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerFilter.ProtoReflect.Descriptor instead.
func (*ContainerFilter) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{69}
}

func (x *ContainerFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerFilter) GetState() *ContainerStateValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ContainerFilter) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *ContainerFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListContainersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filter *ContainerFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListContainersRequest) Reset() {
	*x = ListContainersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListContainersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainersRequest) ProtoMessage() {}

func (x *ListContainersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainersRequest.ProtoReflect.Descriptor instead.
func (*ListContainersRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{70}
}

func (x *ListContainersRequest) GetFilter() *ContainerFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Container provides the runtime information for a container, such as ID, hash,
// state of the container.
type Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container, used by the container runtime to identify
	// a container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the sandbox to which this container belongs.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID.
	ImageRef string `protobuf:"bytes,5,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// State of the container.
	State ContainerState `protobuf:"varint,6,opt,name=state,proto3,enum=runtime.v1alpha2.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate this Container.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Container) Reset() {
	*x = Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{71}
}

func (x *Container) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Container) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *Container) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Container) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Container) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

func (x *Container) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (x *Container) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *Container) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Container) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type ListContainersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of containers.
	Containers []*Container `protobuf:"bytes,1,rep,name=containers,proto3" json:"containers,omitempty"`
}

func (x *ListContainersResponse) Reset() {
	*x = ListContainersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListContainersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainersResponse) ProtoMessage() {}

func (x *ListContainersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainersResponse.ProtoReflect.Descriptor instead.
func (*ListContainersResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{72}
}

func (x *ListContainersResponse) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

type ContainerStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container for which to retrieve status.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Verbose indicates whether to return extra information about the container.
	Verbose bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
}

func (x *ContainerStatusRequest) Reset() {
	*x = ContainerStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatusRequest) ProtoMessage() {}

func (x *ContainerStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatusRequest.ProtoReflect.Descriptor instead.
func (*ContainerStatusRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{73}
}

func (x *ContainerStatusRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ContainerStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

// ContainerStatus represents the status of a container.
type ContainerStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Status of the container.
	State ContainerState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1alpha2.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Start time of the container in nanoseconds. Default: 0 (not specified).
	StartedAt int64 `protobuf:"varint,5,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// Finish time of the container in nanoseconds. Default: 0 (not specified).
	FinishedAt int64 `protobuf:"varint,6,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Exit code of the container. Only required when finished_at != 0. Default: 0.
	ExitCode int32 `protobuf:"varint,7,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,8,opt,name=image,proto3" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID
	ImageRef string `protobuf:"bytes,9,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// Brief CamelCase string explaining why container is in its current state.
	Reason string `protobuf:"bytes,10,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about why container is in its
	// current state.
	Message string `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,14,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Log path of container.
	LogPath string `protobuf:"bytes,15,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Resource limits configuration of the container.
	Resources *ContainerResources `protobuf:"bytes,16,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ContainerStatus) Reset() {
	*x = ContainerStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatus) ProtoMessage() {}

func (x *ContainerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatus.ProtoReflect.Descriptor instead.
func (*ContainerStatus) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{74}
}

func (x *ContainerStatus) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerStatus) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerStatus) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (x *ContainerStatus) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *ContainerStatus) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *ContainerStatus) GetFinishedAt() int64 {
	if x != nil {
		return x.FinishedAt
	}
	return 0
}

func (x *ContainerStatus) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *ContainerStatus) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ContainerStatus) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

func (x *ContainerStatus) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *ContainerStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ContainerStatus) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerStatus) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ContainerStatus) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ContainerStatus) GetLogPath() string {
	if x != nil {
		return x.LogPath
	}
	return ""
}

func (x *ContainerStatus) GetResources() *ContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type ContainerStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of the container.
	Status *ContainerStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Container. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. pid for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ContainerStatusResponse) Reset() {
	*x = ContainerStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatusResponse) ProtoMessage() {}

func (x *ContainerStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatusResponse.ProtoReflect.Descriptor instead.
func (*ContainerStatusResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{75}
}

func (x *ContainerStatusResponse) GetStatus() *ContainerStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ContainerStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// ContainerResources holds resource limits configuration for a container.
type ContainerResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource limits configuration specific to Linux container.
	Linux *LinuxContainerResources `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource limits configuration specific to Windows container.
	Windows *WindowsContainerResources `protobuf:"bytes,2,opt,name=windows,proto3" json:"windows,omitempty"`
}

func (x *ContainerResources) Reset() {
	*x = ContainerResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerResources) ProtoMessage() {}

func (x *ContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerResources.ProtoReflect.Descriptor instead.
func (*ContainerResources) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{76}
}

func (x *ContainerResources) GetLinux() *LinuxContainerResources {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *ContainerResources) GetWindows() *WindowsContainerResources {
	if x != nil {
		return x.Windows
	}
	return nil
}

type UpdateContainerResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to update.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Resource configuration specific to Linux containers.
	Linux *LinuxContainerResources `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource configuration specific to Windows containers.
	Windows *WindowsContainerResources `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
	// Unstructured key-value map holding arbitrary additional information for
	// container resources updating. This can be used for specifying experimental
	// resources to update or other options to use when updating the container.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *UpdateContainerResourcesRequest) Reset() {
	*x = UpdateContainerResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateContainerResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContainerResourcesRequest) ProtoMessage() {}

func (x *UpdateContainerResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContainerResourcesRequest.ProtoReflect.Descriptor instead.
func (*UpdateContainerResourcesRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{77}
}

func (x *UpdateContainerResourcesRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *UpdateContainerResourcesRequest) GetLinux() *LinuxContainerResources {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *UpdateContainerResourcesRequest) GetWindows() *WindowsContainerResources {
	if x != nil {
		return x.Windows
	}
	return nil
}

func (x *UpdateContainerResourcesRequest) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type UpdateContainerResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateContainerResourcesResponse) Reset() {
	*x = UpdateContainerResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateContainerResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContainerResourcesResponse) ProtoMessage() {}

func (x *UpdateContainerResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContainerResourcesResponse.ProtoReflect.Descriptor instead.
func (*UpdateContainerResourcesResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{78}
}

type ExecSyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Timeout in seconds to stop the command. Default: 0 (run forever).
	Timeout int64 `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *ExecSyncRequest) Reset() {
	*x = ExecSyncRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecSyncRequest) ProtoMessage() {}

func (x *ExecSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecSyncRequest.ProtoReflect.Descriptor instead.
func (*ExecSyncRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{79}
}

func (x *ExecSyncRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ExecSyncRequest) GetCmd() []string {
	if x != nil {
		return x.Cmd
	}
	return nil
}

func (x *ExecSyncRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type ExecSyncResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Captured command stdout output.
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Captured command stderr output.
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// Exit code the command finished with. Default: 0 (success).
	ExitCode int32 `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (x *ExecSyncResponse) Reset() {
	*x = ExecSyncResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecSyncResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecSyncResponse) ProtoMessage() {}

func (x *ExecSyncResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecSyncResponse.ProtoReflect.Descriptor instead.
func (*ExecSyncResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{80}
}

func (x *ExecSyncResponse) GetStdout() []byte {
	if x != nil {
		return x.Stdout
	}
	return nil
}

func (x *ExecSyncResponse) GetStderr() []byte {
	if x != nil {
		return x.Stderr
	}
	return nil
}

func (x *ExecSyncResponse) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

type ExecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container in which to execute the command.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Whether to exec the command in a TTY.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,4,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,5,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr bool `protobuf:"varint,6,opt,name=stderr,proto3" json:"stderr,omitempty"`
}

func (x *ExecRequest) Reset() {
	*x = ExecRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecRequest) ProtoMessage() {}

func (x *ExecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecRequest.ProtoReflect.Descriptor instead.
func (*ExecRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{81}
}

func (x *ExecRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ExecRequest) GetCmd() []string {
	if x != nil {
		return x.Cmd
	}
	return nil
}

func (x *ExecRequest) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *ExecRequest) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *ExecRequest) GetStdout() bool {
	if x != nil {
		return x.Stdout
	}
	return false
}

func (x *ExecRequest) GetStderr() bool {
	if x != nil {
		return x.Stderr
	}
	return false
}

type ExecResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully qualified URL of the exec streaming server.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *ExecResponse) Reset() {
	*x = ExecResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecResponse) ProtoMessage() {}

func (x *ExecResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecResponse.ProtoReflect.Descriptor instead.
func (*ExecResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{82}
}

func (x *ExecResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type AttachRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to which to attach.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether the process being attached is running in a TTY.
	// This must match the TTY setting in the ContainerConfig.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,4,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr bool `protobuf:"varint,5,opt,name=stderr,proto3" json:"stderr,omitempty"`
}

func (x *AttachRequest) Reset() {
	*x = AttachRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachRequest) ProtoMessage() {}

func (x *AttachRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachRequest.ProtoReflect.Descriptor instead.
func (*AttachRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{83}
}

func (x *AttachRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *AttachRequest) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *AttachRequest) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *AttachRequest) GetStdout() bool {
	if x != nil {
		return x.Stdout
	}
	return false
}

func (x *AttachRequest) GetStderr() bool {
	if x != nil {
		return x.Stderr
	}
	return false
}

type AttachResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully qualified URL of the attach streaming server.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *AttachResponse) Reset() {
	*x = AttachResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachResponse) ProtoMessage() {}

func (x *AttachResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachResponse.ProtoReflect.Descriptor instead.
func (*AttachResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{84}
}

func (x *AttachResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type PortForwardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container to which to forward the port.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Port to forward.
	Port []int32 `protobuf:"varint,2,rep,packed,name=port,proto3" json:"port,omitempty"`
}

func (x *PortForwardRequest) Reset() {
	*x = PortForwardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortForwardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortForwardRequest) ProtoMessage() {}

func (x *PortForwardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortForwardRequest.ProtoReflect.Descriptor instead.
func (*PortForwardRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{85}
}

func (x *PortForwardRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *PortForwardRequest) GetPort() []int32 {
	if x != nil {
		return x.Port
	}
	return nil
}

type PortForwardResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully qualified URL of the port-forward streaming server.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *PortForwardResponse) Reset() {
	*x = PortForwardResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortForwardResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortForwardResponse) ProtoMessage() {}

func (x *PortForwardResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortForwardResponse.ProtoReflect.Descriptor instead.
func (*PortForwardResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{86}
}

func (x *PortForwardResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type ImageFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
}

func (x *ImageFilter) Reset() {
	*x = ImageFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFilter) ProtoMessage() {}

func (x *ImageFilter) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFilter.ProtoReflect.Descriptor instead.
func (*ImageFilter) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{87}
}

func (x *ImageFilter) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

type ListImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Filter to list images.
	Filter *ImageFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListImagesRequest) Reset() {
	*x = ListImagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesRequest) ProtoMessage() {}

func (x *ListImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesRequest.ProtoReflect.Descriptor instead.
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{88}
}

func (x *ListImagesRequest) GetFilter() *ImageFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Basic information about a container image.
type Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the image.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Other names by which this image is known.
	RepoTags []string `protobuf:"bytes,2,rep,name=repo_tags,json=repoTags,proto3" json:"repo_tags,omitempty"`
	// Digests by which this image is known.
	RepoDigests []string `protobuf:"bytes,3,rep,name=repo_digests,json=repoDigests,proto3" json:"repo_digests,omitempty"`
	// Size of the image in bytes. Must be > 0.
	Size uint64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// UID that will run the command(s). This is used as a default if no user is
	// specified when creating the container. UID and the following user name
	// are mutually exclusive.
	Uid *Int64Value `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// User name that will run the command(s). This is used if UID is not set
	// and no user is specified when creating container.
	Username string `protobuf:"bytes,6,opt,name=username,proto3" json:"username,omitempty"`
	// ImageSpec for image which includes annotations
	Spec *ImageSpec `protobuf:"bytes,7,opt,name=spec,proto3" json:"spec,omitempty"`
	// Recommendation on whether this image should be exempt from garbage collection.
	// It must only be treated as a recommendation -- the client can still request that the image be deleted,
	// and the runtime must oblige.
	Pinned bool `protobuf:"varint,8,opt,name=pinned,proto3" json:"pinned,omitempty"`
}

func (x *Image) Reset() {
	*x = Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{89}
}

func (x *Image) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Image) GetRepoTags() []string {
	if x != nil {
		return x.RepoTags
	}
	return nil
}

func (x *Image) GetRepoDigests() []string {
	if x != nil {
		return x.RepoDigests
	}
	return nil
}

func (x *Image) GetSize() uint64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Image) GetUid() *Int64Value {
	if x != nil {
		return x.Uid
	}
	return nil
}

func (x *Image) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Image) GetSpec() *ImageSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Image) GetPinned() bool {
	if x != nil {
		return x.Pinned
	}
	return false
}

type ListImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of images.
	Images []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
}

func (x *ListImagesResponse) Reset() {
	*x = ListImagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesResponse) ProtoMessage() {}

func (x *ListImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesResponse.ProtoReflect.Descriptor instead.
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{90}
}

func (x *ListImagesResponse) GetImages() []*Image {
	if x != nil {
		return x.Images
	}
	return nil
}

type ImageStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Verbose indicates whether to return extra information about the image.
	Verbose bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
}

func (x *ImageStatusRequest) Reset() {
	*x = ImageStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageStatusRequest) ProtoMessage() {}

func (x *ImageStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageStatusRequest.ProtoReflect.Descriptor instead.
func (*ImageStatusRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{91}
}

func (x *ImageStatusRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ImageStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

type ImageStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of the image.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Info is extra information of the Image. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful
	// for debug, e.g. image config for oci image based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ImageStatusResponse) Reset() {
	*x = ImageStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageStatusResponse) ProtoMessage() {}

func (x *ImageStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageStatusResponse.ProtoReflect.Descriptor instead.
func (*ImageStatusResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{92}
}

func (x *ImageStatusResponse) GetImage() *Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ImageStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// AuthConfig contains authorization information for connecting to a registry.
type AuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username      string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password      string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	Auth          string `protobuf:"bytes,3,opt,name=auth,proto3" json:"auth,omitempty"`
	ServerAddress string `protobuf:"bytes,4,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// IdentityToken is used to authenticate the user and get
	// an access token for the registry.
	IdentityToken string `protobuf:"bytes,5,opt,name=identity_token,json=identityToken,proto3" json:"identity_token,omitempty"`
	// RegistryToken is a bearer token to be sent to a registry
	RegistryToken string `protobuf:"bytes,6,opt,name=registry_token,json=registryToken,proto3" json:"registry_token,omitempty"`
}

func (x *AuthConfig) Reset() {
	*x = AuthConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig) ProtoMessage() {}

func (x *AuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{93}
}

func (x *AuthConfig) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *AuthConfig) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *AuthConfig) GetAuth() string {
	if x != nil {
		return x.Auth
	}
	return ""
}

func (x *AuthConfig) GetServerAddress() string {
	if x != nil {
		return x.ServerAddress
	}
	return ""
}

func (x *AuthConfig) GetIdentityToken() string {
	if x != nil {
		return x.IdentityToken
	}
	return ""
}

func (x *AuthConfig) GetRegistryToken() string {
	if x != nil {
		return x.RegistryToken
	}
	return ""
}

type PullImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Authentication configuration for pulling the image.
	Auth *AuthConfig `protobuf:"bytes,2,opt,name=auth,proto3" json:"auth,omitempty"`
	// Config of the PodSandbox, which is used to pull image in PodSandbox context.
	SandboxConfig *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
}

func (x *PullImageRequest) Reset() {
	*x = PullImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullImageRequest) ProtoMessage() {}

func (x *PullImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullImageRequest.ProtoReflect.Descriptor instead.
func (*PullImageRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{94}
}

func (x *PullImageRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *PullImageRequest) GetAuth() *AuthConfig {
	if x != nil {
		return x.Auth
	}
	return nil
}

func (x *PullImageRequest) GetSandboxConfig() *PodSandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

type PullImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference to the image in use. For most runtimes, this should be an
	// image ID or digest.
	ImageRef string `protobuf:"bytes,1,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
}

func (x *PullImageResponse) Reset() {
	*x = PullImageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullImageResponse) ProtoMessage() {}

func (x *PullImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullImageResponse.ProtoReflect.Descriptor instead.
func (*PullImageResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{95}
}

func (x *PullImageResponse) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

type RemoveImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Spec of the image to remove.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
}

func (x *RemoveImageRequest) Reset() {
	*x = RemoveImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveImageRequest) ProtoMessage() {}

func (x *RemoveImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveImageRequest.ProtoReflect.Descriptor instead.
func (*RemoveImageRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{96}
}

func (x *RemoveImageRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

type RemoveImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveImageResponse) Reset() {
	*x = RemoveImageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveImageResponse) ProtoMessage() {}

func (x *RemoveImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveImageResponse.ProtoReflect.Descriptor instead.
func (*RemoveImageResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{97}
}

type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CIDR to use for pod IP addresses. If the CIDR is empty, runtimes
	// should omit it.
	PodCidr string `protobuf:"bytes,1,opt,name=pod_cidr,json=podCidr,proto3" json:"pod_cidr,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{98}
}

func (x *NetworkConfig) GetPodCidr() string {
	if x != nil {
		return x.PodCidr
	}
	return ""
}

type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkConfig *NetworkConfig `protobuf:"bytes,1,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{99}
}

func (x *RuntimeConfig) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

type UpdateRuntimeConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RuntimeConfig *RuntimeConfig `protobuf:"bytes,1,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
}

func (x *UpdateRuntimeConfigRequest) Reset() {
	*x = UpdateRuntimeConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRuntimeConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRuntimeConfigRequest) ProtoMessage() {}

func (x *UpdateRuntimeConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRuntimeConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateRuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{100}
}

func (x *UpdateRuntimeConfigRequest) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

type UpdateRuntimeConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateRuntimeConfigResponse) Reset() {
	*x = UpdateRuntimeConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRuntimeConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRuntimeConfigResponse) ProtoMessage() {}

func (x *UpdateRuntimeConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRuntimeConfigResponse.ProtoReflect.Descriptor instead.
func (*UpdateRuntimeConfigResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{101}
}

// RuntimeCondition contains condition information for the runtime.
// There are 2 kinds of runtime conditions:
// 1. Required conditions: Conditions are required for kubelet to work
// properly. If any required condition is unmet, the node will be not ready.
// The required conditions include:
//   - RuntimeReady: RuntimeReady means the runtime is up and ready to accept
//     basic containers e.g. container only needs host network.
//   - NetworkReady: NetworkReady means the runtime network is up and ready to
//     accept containers which require container network.
//
// 2. Optional conditions: Conditions are informative to the user, but kubelet
// will not rely on. Since condition type is an arbitrary string, all conditions
// not required are optional. These conditions will be exposed to users to help
// them understand the status of the system.
type RuntimeCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of runtime condition.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Status of the condition, one of true/false. Default: false.
	Status bool `protobuf:"varint,2,opt,name=status,proto3" json:"status,omitempty"`
	// Brief CamelCase string containing reason for the condition's last transition.
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *RuntimeCondition) Reset() {
	*x = RuntimeCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeCondition) ProtoMessage() {}

func (x *RuntimeCondition) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeCondition.ProtoReflect.Descriptor instead.
func (*RuntimeCondition) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{102}
}

func (x *RuntimeCondition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *RuntimeCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *RuntimeCondition) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *RuntimeCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// RuntimeStatus is information about the current status of the runtime.
type RuntimeStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of current observed runtime conditions.
	Conditions []*RuntimeCondition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *RuntimeStatus) Reset() {
	*x = RuntimeStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeStatus) ProtoMessage() {}

func (x *RuntimeStatus) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeStatus.ProtoReflect.Descriptor instead.
func (*RuntimeStatus) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{103}
}

func (x *RuntimeStatus) GetConditions() []*RuntimeCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

type StatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Verbose indicates whether to return extra information about the runtime.
	Verbose bool `protobuf:"varint,1,opt,name=verbose,proto3" json:"verbose,omitempty"`
}

func (x *StatusRequest) Reset() {
	*x = StatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusRequest) ProtoMessage() {}

func (x *StatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusRequest.ProtoReflect.Descriptor instead.
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{104}
}

func (x *StatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

type StatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status of the Runtime.
	Status *RuntimeStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Runtime. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. plugins used by the container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *StatusResponse) Reset() {
	*x = StatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusResponse) ProtoMessage() {}

func (x *StatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusResponse.ProtoReflect.Descriptor instead.
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{105}
}

func (x *StatusResponse) GetStatus() *RuntimeStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *StatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

type ImageFsInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImageFsInfoRequest) Reset() {
	*x = ImageFsInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageFsInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFsInfoRequest) ProtoMessage() {}

func (x *ImageFsInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFsInfoRequest.ProtoReflect.Descriptor instead.
func (*ImageFsInfoRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{106}
}

// UInt64Value is the wrapper of uint64.
type UInt64Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value.
	Value uint64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *UInt64Value) Reset() {
	*x = UInt64Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UInt64Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt64Value) ProtoMessage() {}

func (x *UInt64Value) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UInt64Value.ProtoReflect.Descriptor instead.
func (*UInt64Value) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{107}
}

func (x *UInt64Value) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// FilesystemIdentifier uniquely identify the filesystem.
type FilesystemIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mountpoint of a filesystem.
	Mountpoint string `protobuf:"bytes,1,opt,name=mountpoint,proto3" json:"mountpoint,omitempty"`
}

func (x *FilesystemIdentifier) Reset() {
	*x = FilesystemIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilesystemIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilesystemIdentifier) ProtoMessage() {}

func (x *FilesystemIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilesystemIdentifier.ProtoReflect.Descriptor instead.
func (*FilesystemIdentifier) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{108}
}

func (x *FilesystemIdentifier) GetMountpoint() string {
	if x != nil {
		return x.Mountpoint
	}
	return ""
}

// FilesystemUsage provides the filesystem usage information.
type FilesystemUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The unique identifier of the filesystem.
	FsId *FilesystemIdentifier `protobuf:"bytes,2,opt,name=fs_id,json=fsId,proto3" json:"fs_id,omitempty"`
	// UsedBytes represents the bytes used for images on the filesystem.
	// This may differ from the total bytes used on the filesystem and may not
	// equal CapacityBytes - AvailableBytes.
	UsedBytes *UInt64Value `protobuf:"bytes,3,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	// InodesUsed represents the inodes used by the images.
	// This may not equal InodesCapacity - InodesAvailable because the underlying
	// filesystem may also be used for purposes other than storing images.
	InodesUsed *UInt64Value `protobuf:"bytes,4,opt,name=inodes_used,json=inodesUsed,proto3" json:"inodes_used,omitempty"`
}

func (x *FilesystemUsage) Reset() {
	*x = FilesystemUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilesystemUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilesystemUsage) ProtoMessage() {}

func (x *FilesystemUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilesystemUsage.ProtoReflect.Descriptor instead.
func (*FilesystemUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{109}
}

func (x *FilesystemUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *FilesystemUsage) GetFsId() *FilesystemIdentifier {
	if x != nil {
		return x.FsId
	}
	return nil
}

func (x *FilesystemUsage) GetUsedBytes() *UInt64Value {
	if x != nil {
		return x.UsedBytes
	}
	return nil
}

func (x *FilesystemUsage) GetInodesUsed() *UInt64Value {
	if x != nil {
		return x.InodesUsed
	}
	return nil
}

type ImageFsInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information of image filesystem(s).
	ImageFilesystems []*FilesystemUsage `protobuf:"bytes,1,rep,name=image_filesystems,json=imageFilesystems,proto3" json:"image_filesystems,omitempty"`
}

func (x *ImageFsInfoResponse) Reset() {
	*x = ImageFsInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageFsInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFsInfoResponse) ProtoMessage() {}

func (x *ImageFsInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFsInfoResponse.ProtoReflect.Descriptor instead.
func (*ImageFsInfoResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{110}
}

func (x *ImageFsInfoResponse) GetImageFilesystems() []*FilesystemUsage {
	if x != nil {
		return x.ImageFilesystems
	}
	return nil
}

type ContainerStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container for which to retrieve stats.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (x *ContainerStatsRequest) Reset() {
	*x = ContainerStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsRequest) ProtoMessage() {}

func (x *ContainerStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsRequest.ProtoReflect.Descriptor instead.
func (*ContainerStatsRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{111}
}

func (x *ContainerStatsRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type ContainerStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stats of the container.
	Stats *ContainerStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *ContainerStatsResponse) Reset() {
	*x = ContainerStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsResponse) ProtoMessage() {}

func (x *ContainerStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsResponse.ProtoReflect.Descriptor instead.
func (*ContainerStatsResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{112}
}

func (x *ContainerStatsResponse) GetStats() *ContainerStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

type ListContainerStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Filter for the list request.
	Filter *ContainerStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListContainerStatsRequest) Reset() {
	*x = ListContainerStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListContainerStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainerStatsRequest) ProtoMessage() {}

func (x *ListContainerStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainerStatsRequest.ProtoReflect.Descriptor instead.
func (*ListContainerStatsRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{113}
}

func (x *ListContainerStatsRequest) GetFilter() *ContainerStatsFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// ContainerStatsFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerStatsFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ContainerStatsFilter) Reset() {
	*x = ContainerStatsFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsFilter) ProtoMessage() {}

func (x *ContainerStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsFilter.ProtoReflect.Descriptor instead.
func (*ContainerStatsFilter) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{114}
}

func (x *ContainerStatsFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerStatsFilter) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *ContainerStatsFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListContainerStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stats of the container.
	Stats []*ContainerStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
}

func (x *ListContainerStatsResponse) Reset() {
	*x = ListContainerStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListContainerStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainerStatsResponse) ProtoMessage() {}

func (x *ListContainerStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainerStatsResponse.ProtoReflect.Descriptor instead.
func (*ListContainerStatsResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{115}
}

func (x *ListContainerStatsResponse) GetStats() []*ContainerStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// ContainerAttributes provides basic information of the container.
type ContainerAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ContainerAttributes) Reset() {
	*x = ContainerAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerAttributes) ProtoMessage() {}

func (x *ContainerAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerAttributes.ProtoReflect.Descriptor instead.
func (*ContainerAttributes) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{116}
}

func (x *ContainerAttributes) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerAttributes) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerAttributes) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerAttributes) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// ContainerStats provides the resource usage statistics for a container.
type ContainerStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information of the container.
	Attributes *ContainerAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// CPU usage gathered from the container.
	Cpu *CpuUsage `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered from the container.
	Memory *MemoryUsage `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Usage of the writable layer.
	WritableLayer *FilesystemUsage `protobuf:"bytes,4,opt,name=writable_layer,json=writableLayer,proto3" json:"writable_layer,omitempty"`
}

func (x *ContainerStats) Reset() {
	*x = ContainerStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStats) ProtoMessage() {}

func (x *ContainerStats) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStats.ProtoReflect.Descriptor instead.
func (*ContainerStats) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{117}
}

func (x *ContainerStats) GetAttributes() *ContainerAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ContainerStats) GetCpu() *CpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *ContainerStats) GetMemory() *MemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *ContainerStats) GetWritableLayer() *FilesystemUsage {
	if x != nil {
		return x.WritableLayer
	}
	return nil
}

// CpuUsage provides the CPU usage information.
type CpuUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Cumulative CPU usage (sum across all cores) since object creation.
	UsageCoreNanoSeconds *UInt64Value `protobuf:"bytes,2,opt,name=usage_core_nano_seconds,json=usageCoreNanoSeconds,proto3" json:"usage_core_nano_seconds,omitempty"`
	// Total CPU usage (sum of all cores) averaged over the sample window.
	// The "core" unit can be interpreted as CPU core-nanoseconds per second.
	UsageNanoCores *UInt64Value `protobuf:"bytes,3,opt,name=usage_nano_cores,json=usageNanoCores,proto3" json:"usage_nano_cores,omitempty"`
}

func (x *CpuUsage) Reset() {
	*x = CpuUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpuUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpuUsage) ProtoMessage() {}

func (x *CpuUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpuUsage.ProtoReflect.Descriptor instead.
func (*CpuUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{118}
}

func (x *CpuUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *CpuUsage) GetUsageCoreNanoSeconds() *UInt64Value {
	if x != nil {
		return x.UsageCoreNanoSeconds
	}
	return nil
}

func (x *CpuUsage) GetUsageNanoCores() *UInt64Value {
	if x != nil {
		return x.UsageNanoCores
	}
	return nil
}

// MemoryUsage provides the memory usage information.
type MemoryUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of working set memory in bytes.
	WorkingSetBytes *UInt64Value `protobuf:"bytes,2,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	// Available memory for use. This is defined as the memory limit - workingSetBytes.
	AvailableBytes *UInt64Value `protobuf:"bytes,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// Total memory in use. This includes all memory regardless of when it was accessed.
	UsageBytes *UInt64Value `protobuf:"bytes,4,opt,name=usage_bytes,json=usageBytes,proto3" json:"usage_bytes,omitempty"`
	// The amount of anonymous and swap cache memory (includes transparent hugepages).
	RssBytes *UInt64Value `protobuf:"bytes,5,opt,name=rss_bytes,json=rssBytes,proto3" json:"rss_bytes,omitempty"`
	// Cumulative number of minor page faults.
	PageFaults *UInt64Value `protobuf:"bytes,6,opt,name=page_faults,json=pageFaults,proto3" json:"page_faults,omitempty"`
	// Cumulative number of major page faults.
	MajorPageFaults *UInt64Value `protobuf:"bytes,7,opt,name=major_page_faults,json=majorPageFaults,proto3" json:"major_page_faults,omitempty"`
}

func (x *MemoryUsage) Reset() {
	*x = MemoryUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MemoryUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemoryUsage) ProtoMessage() {}

func (x *MemoryUsage) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemoryUsage.ProtoReflect.Descriptor instead.
func (*MemoryUsage) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{119}
}

func (x *MemoryUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *MemoryUsage) GetWorkingSetBytes() *UInt64Value {
	if x != nil {
		return x.WorkingSetBytes
	}
	return nil
}

func (x *MemoryUsage) GetAvailableBytes() *UInt64Value {
	if x != nil {
		return x.AvailableBytes
	}
	return nil
}

func (x *MemoryUsage) GetUsageBytes() *UInt64Value {
	if x != nil {
		return x.UsageBytes
	}
	return nil
}

func (x *MemoryUsage) GetRssBytes() *UInt64Value {
	if x != nil {
		return x.RssBytes
	}
	return nil
}

func (x *MemoryUsage) GetPageFaults() *UInt64Value {
	if x != nil {
		return x.PageFaults
	}
	return nil
}

func (x *MemoryUsage) GetMajorPageFaults() *UInt64Value {
	if x != nil {
		return x.MajorPageFaults
	}
	return nil
}

type ReopenContainerLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the container for which to reopen the log.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (x *ReopenContainerLogRequest) Reset() {
	*x = ReopenContainerLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReopenContainerLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReopenContainerLogRequest) ProtoMessage() {}

func (x *ReopenContainerLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReopenContainerLogRequest.ProtoReflect.Descriptor instead.
func (*ReopenContainerLogRequest) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{120}
}

func (x *ReopenContainerLogRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type ReopenContainerLogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReopenContainerLogResponse) Reset() {
	*x = ReopenContainerLogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReopenContainerLogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReopenContainerLogResponse) ProtoMessage() {}

func (x *ReopenContainerLogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReopenContainerLogResponse.ProtoReflect.Descriptor instead.
func (*ReopenContainerLogResponse) Descriptor() ([]byte, []int) {
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP(), []int{121}
}

var File_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto protoreflect.FileDescriptor

var file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDesc = []byte{
	0x0a, 0x5f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x64, 0x2f, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x6b,
	0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x63, 0x72, 0x69, 0x2d, 0x61, 0x70, 0x69, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x22, 0x2a, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xa7, 0x01, 0x0a, 0x0f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a,
	0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41,
	0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0x0a, 0x09, 0x44, 0x4e, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa2, 0x01, 0x0a, 0x0b, 0x50, 0x6f, 0x72, 0x74, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x36, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x6f, 0x73, 0x74, 0x49, 0x70, 0x22, 0xd6, 0x01, 0x0a, 0x05,
	0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78,
	0x5f, 0x72, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x52, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x44,
	0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70,
	0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5f, 0x0a, 0x09, 0x49, 0x44, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x06, 0x68, 0x6f, 0x73, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0xa6, 0x01, 0x0a, 0x0d, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x04,
	0x75, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x44,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x75, 0x69, 0x64, 0x73, 0x12, 0x2f, 0x0a,
	0x04, 0x67, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x44, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x67, 0x69, 0x64, 0x73, 0x22, 0x97,
	0x02, 0x0a, 0x0f, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x31, 0x0a,
	0x03, 0x70, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x03, 0x70, 0x69, 0x64,
	0x12, 0x31, 0x0a, 0x03, 0x69, 0x70, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x03,
	0x69, 0x70, 0x63, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64,
	0x12, 0x46, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x22, 0x0a, 0x0a, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe1, 0x04, 0x0a,
	0x1b, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4e, 0x0a, 0x11,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x0f,
	0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x45, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x41, 0x73,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79,
	0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x52, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x12, 0x2f, 0x0a,
	0x13, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x73, 0x75, 0x70, 0x70,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x3b,
	0x0a, 0x07, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x07, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x12, 0x3d, 0x0a, 0x08, 0x61,
	0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x14, 0x73, 0x65,
	0x63, 0x63, 0x6f, 0x6d, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x73, 0x65,
	0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x22, 0xca, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x66, 0x22, 0x40, 0x0a, 0x0b, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x55, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74, 0x10, 0x02, 0x22, 0xb2, 0x03,
	0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x10,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4e, 0x0a, 0x07, 0x73, 0x79, 0x73, 0x63, 0x74, 0x6c,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x73,
	0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65,
	0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x12, 0x47, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x53, 0x79, 0x73, 0x63, 0x74, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x72, 0x0a, 0x12, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1c,
	0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x61,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0xb3, 0x05, 0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x67,
	0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x6f, 0x67, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3a,
	0x0a, 0x0a, 0x64, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x4e, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x64, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x0d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x46,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a,
	0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x43, 0x0a, 0x07,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a, 0x14,
	0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x22, 0x3d, 0x0a, 0x15, 0x52, 0x75, 0x6e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x3d, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x70,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x53, 0x74, 0x6f, 0x70, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3f, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e,
	0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x49, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59,
	0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64,
	0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0x17, 0x0a, 0x05, 0x50, 0x6f, 0x64,
	0x49, 0x50, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x70, 0x22, 0x69, 0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x3e, 0x0a,
	0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x49, 0x50, 0x52, 0x0d,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x73, 0x22, 0x48, 0x0a,
	0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x54, 0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x3b, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22, 0x83, 0x05,
	0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x3d, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78,
	0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xd9, 0x01, 0x0a, 0x18, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x48, 0x0a, 0x04,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4f, 0x0a, 0x14, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x22, 0x80, 0x02, 0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x5c, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x1a, 0x40, 0x0a, 0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x53, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xed, 0x03, 0x0a, 0x0a, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4c, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x3e, 0x0a, 0x16, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x52, 0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0xcc, 0x01, 0x0a, 0x15, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x61, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a, 0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5d, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x56, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x22, 0x8a, 0x03, 0x0a, 0x14, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x59, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a,
	0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xdb, 0x01,
	0x0a, 0x0f, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x46, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x05, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x42, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x22, 0xb1, 0x02, 0x0a, 0x14,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x03, 0x63,
	0x70, 0x75, 0x12, 0x35, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x38, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x38, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x40, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x22,
	0x18, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0xcb, 0x01, 0x0a, 0x0c, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x54, 0x0a, 0x11, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x47,
	0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x22, 0x97, 0x02, 0x0a, 0x15, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x72, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x72, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x3a, 0x0a, 0x09, 0x72, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x08, 0x72, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x38, 0x0a, 0x08, 0x74,
	0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x74, 0x78,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x74, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x74, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x22, 0x70, 0x0a, 0x0c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x42, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0xb1, 0x01, 0x0a, 0x09, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x32, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa1, 0x04, 0x0a, 0x17,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x70, 0x75,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x63, 0x70, 0x75, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x70, 0x75, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x73, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x6f, 0x6d, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x5f, 0x61, 0x64, 0x6a, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6f, 0x6f,
	0x6d, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6a, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x70, 0x75,
	0x73, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x43, 0x70, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x70,
	0x75, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x73, 0x12, 0x48, 0x0a, 0x0f, 0x68,
	0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x48, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x0e, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x1a, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x5f, 0x73, 0x77, 0x61, 0x70, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x53, 0x77, 0x61, 0x70, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x55, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x42, 0x0a, 0x0d, 0x48, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x22, 0x61, 0x0a, 0x0d, 0x53, 0x45, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x9e, 0x01, 0x0a, 0x0a, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x64, 0x64, 0x5f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x61, 0x64, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x64, 0x72, 0x6f,
	0x70, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x18, 0x61, 0x64, 0x64, 0x5f, 0x61, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x16, 0x61, 0x64, 0x64, 0x41, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xe8, 0x06, 0x0a, 0x1d, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x40, 0x0a, 0x0c, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x4e, 0x0a, 0x11, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x0f, 0x73,
	0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x45, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x55,
	0x73, 0x65, 0x72, 0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x26, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75,
	0x6e, 0x41, 0x73, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x52, 0x6f,
	0x6f, 0x74, 0x66, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x03, 0x52, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x20, 0x0a, 0x0c, 0x6e, 0x6f, 0x5f, 0x6e, 0x65, 0x77, 0x5f,
	0x70, 0x72, 0x69, 0x76, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x6e, 0x6f, 0x4e,
	0x65, 0x77, 0x50, 0x72, 0x69, 0x76, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x73, 0x6b, 0x65,
	0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6d,
	0x61, 0x73, 0x6b, 0x65, 0x64, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0e, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x68,
	0x73, 0x12, 0x3b, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x07, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x12, 0x3d,
	0x0a, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x52, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x12, 0x2d, 0x0a,
	0x10, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x61, 0x70, 0x70,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x34, 0x0a, 0x14,
	0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12,
	0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x22, 0xbb, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x22, 0x93, 0x01, 0x0a, 0x1d, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6e,
	0x41, 0x73, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x75, 0x0a, 0x17, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5a, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x95, 0x01,
	0x0a, 0x1f, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x26, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x41,
	0x73, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x49, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x10, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xdc, 0x01, 0x0a, 0x19, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x70, 0x75,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d,
	0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x70, 0x75, 0x4d, 0x61, 0x78,
	0x69, 0x6d, 0x75, 0x6d, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x72, 0x6f, 0x6f, 0x74, 0x66,
	0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x53, 0x69, 0x7a,
	0x65, 0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x41, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0x6e, 0x0a, 0x06, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe5, 0x06, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44,
	0x69, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x65, 0x6e,
	0x76, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x12, 0x32, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x54,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x14, 0x0a, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x73, 0x74, 0x64, 0x69, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x5f, 0x6f,
	0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x74, 0x64, 0x69, 0x6e,
	0x4f, 0x6e, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x03, 0x74, 0x74, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x6c,
	0x69, 0x6e, 0x75, 0x78, 0x12, 0x42, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xc4, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24,
	0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x49, 0x0a, 0x0e, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x3c, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x3a, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53,
	0x0a, 0x14, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x22, 0x17, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x0a, 0x16,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x36, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0xa3, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x0e, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a, 0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb5, 0x04,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70,
	0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49,
	0x64, 0x12, 0x3f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72,
	0x65, 0x66, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x66, 0x12, 0x36, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x55, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x22, 0x55, 0x0a, 0x16,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x62, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62,
	0x6f, 0x73, 0x65, 0x22, 0xc0, 0x06, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x31, 0x0a, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x45,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x54, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08,
	0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6c, 0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd6, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x9c, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x45, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x22, 0xf2,
	0x02, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x45, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x12, 0x64, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x22, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x53,
	0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a,
	0x03, 0x63, 0x6d, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x5f, 0x0a, 0x10, 0x45, 0x78, 0x65,
	0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73,
	0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x0b, 0x45,
	0x78, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a,
	0x03, 0x63, 0x6d, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x12,
	0x10, 0x0a, 0x03, 0x74, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x74, 0x74,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x22, 0x20, 0x0a, 0x0c, 0x45, 0x78, 0x65, 0x63, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x8a, 0x01, 0x0a, 0x0d, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x73,
	0x74, 0x64, 0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x03, 0x74, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x22, 0x22, 0x0a, 0x0e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x4e, 0x0a, 0x12, 0x50, 0x6f,
	0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x27, 0x0a, 0x13, 0x50, 0x6f,
	0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x22, 0x40, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x4a, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x80, 0x02, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x70, 0x6f, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x65, 0x70, 0x6f, 0x54, 0x61, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x70, 0x6f, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12,
	0x2e, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x04, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x70, 0x69,
	0x6e, 0x6e, 0x65, 0x64, 0x22, 0x45, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x22, 0x61, 0x0a, 0x12, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0xc2,
	0x01, 0x0a, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x43, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e,
	0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xcd, 0x01, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x75,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xc2, 0x01, 0x0a, 0x10, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x61,
	0x75, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x49, 0x0a,
	0x0e, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x30, 0x0a, 0x11, 0x50, 0x75, 0x6c, 0x6c,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x22, 0x47, 0x0a, 0x12, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x31, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x22, 0x15, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2a, 0x0a, 0x0d, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x08, 0x70,
	0x6f, 0x64, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x6f, 0x64, 0x43, 0x69, 0x64, 0x72, 0x22, 0x57, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x64, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x1d, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x70, 0x0a, 0x10, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x53, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x29, 0x0a, 0x0d, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x3e, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e,
	0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x14, 0x0a, 0x12, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x23, 0x0a, 0x0b, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x36, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0xea,
	0x01, 0x0a, 0x0f, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x3b, 0x0a, 0x05, 0x66, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x04, 0x66, 0x73, 0x49, 0x64, 0x12, 0x3c, 0x0a,
	0x0a, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x0b, 0x69,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0a, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x55, 0x73, 0x65, 0x64, 0x22, 0x65, 0x0a, 0x13, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4e, 0x0a, 0x11, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x10, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x22, 0x3a, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x50,
	0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x22, 0x5b, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xf0, 0x01,
	0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x0e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40,
	0x0a, 0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x54, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x86, 0x03, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3f,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x58, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x86, 0x02, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x03, 0x63, 0x70, 0x75,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x35, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x48,
	0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x22, 0xc7, 0x01, 0x0a, 0x08, 0x43, 0x70, 0x75,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x54, 0x0a, 0x17, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x72,
	0x65, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x14, 0x75, 0x73, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4e, 0x61,
	0x6e, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x47, 0x0a, 0x10, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x43, 0x6f, 0x72,
	0x65, 0x73, 0x22, 0xc5, 0x03, 0x0a, 0x0b, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x49, 0x0a, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x0f, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x0b, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x75, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x72, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x3e, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x49, 0x0a, 0x11, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x6a, 0x6f, 0x72,
	0x50, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x3e, 0x0a, 0x19, 0x52, 0x65,
	0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65,
	0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x26, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10, 0x00, 0x12, 0x07, 0x0a,
	0x03, 0x55, 0x44, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x43, 0x54, 0x50, 0x10, 0x02,
	0x2a, 0x6d, 0x0a, 0x10, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x00, 0x12, 0x21, 0x0a,
	0x1d, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x4f, 0x53,
	0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x01,
	0x12, 0x1d, 0x0a, 0x19, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x42, 0x49, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x2a,
	0x3d, 0x0a, 0x0d, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x07, 0x0a, 0x03, 0x50, 0x4f, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e,
	0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x44, 0x45,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x10, 0x03, 0x2a, 0x3a,
	0x0a, 0x0f, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x41, 0x4e, 0x44, 0x42, 0x4f, 0x58, 0x5f, 0x52, 0x45, 0x41,
	0x44, 0x59, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x41, 0x4e, 0x44, 0x42, 0x4f, 0x58, 0x5f,
	0x4e, 0x4f, 0x54, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x2a, 0x6b, 0x0a, 0x0e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52,
	0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f,
	0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x03, 0x32, 0xa1, 0x13, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x07, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x62, 0x0a, 0x0d,
	0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x26, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x65, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x12, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53,
	0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6b, 0x0a, 0x10, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x29, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x6b, 0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x65, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x12, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x28, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x65, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x62, 0x0a, 0x0d, 0x53, 0x74, 0x6f,
	0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x26, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74,
	0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68, 0x0a,
	0x0f, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x12, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x65, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68,
	0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x83, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x71,
	0x0a, 0x12, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x4c, 0x6f, 0x67, 0x12, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x53, 0x0a, 0x08, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x21, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a, 0x04, 0x45, 0x78, 0x65, 0x63, 0x12, 0x1d,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x4d, 0x0a, 0x06, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x12, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c,
	0x0a, 0x0b, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x12, 0x24, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x65, 0x0a, 0x0e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x27,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x71, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x0f, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x74, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x06,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x32, 0xdb, 0x03, 0x0a, 0x0c,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x59, 0x0a, 0x0a,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x23, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x56, 0x0a, 0x09, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a,
	0x0b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x24, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x0b, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x57, 0x5a, 0x55, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x2f, 0x74, 0x68,
	0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f,
	0x2f, 0x63, 0x72, 0x69, 0x2d, 0x61, 0x70, 0x69, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescOnce sync.Once
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescData = file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDesc
)

func file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescGZIP() []byte {
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescOnce.Do(func() {
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescData)
	})
	return file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDescData
}

var file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes = make([]protoimpl.MessageInfo, 150)
var file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_goTypes = []interface{}{
	(Protocol)(0),                            // 0: runtime.v1alpha2.Protocol
	(MountPropagation)(0),                    // 1: runtime.v1alpha2.MountPropagation
	(NamespaceMode)(0),                       // 2: runtime.v1alpha2.NamespaceMode
	(PodSandboxState)(0),                     // 3: runtime.v1alpha2.PodSandboxState
	(ContainerState)(0),                      // 4: runtime.v1alpha2.ContainerState
	(SecurityProfile_ProfileType)(0),         // 5: runtime.v1alpha2.SecurityProfile.ProfileType
	(*VersionRequest)(nil),                   // 6: runtime.v1alpha2.VersionRequest
	(*VersionResponse)(nil),                  // 7: runtime.v1alpha2.VersionResponse
	(*DNSConfig)(nil),                        // 8: runtime.v1alpha2.DNSConfig
	(*PortMapping)(nil),                      // 9: runtime.v1alpha2.PortMapping
	(*Mount)(nil),                            // 10: runtime.v1alpha2.Mount
	(*IDMapping)(nil),                        // 11: runtime.v1alpha2.IDMapping
	(*UserNamespace)(nil),                    // 12: runtime.v1alpha2.UserNamespace
	(*NamespaceOption)(nil),                  // 13: runtime.v1alpha2.NamespaceOption
	(*Int64Value)(nil),                       // 14: runtime.v1alpha2.Int64Value
	(*LinuxSandboxSecurityContext)(nil),      // 15: runtime.v1alpha2.LinuxSandboxSecurityContext
	(*SecurityProfile)(nil),                  // 16: runtime.v1alpha2.SecurityProfile
	(*LinuxPodSandboxConfig)(nil),            // 17: runtime.v1alpha2.LinuxPodSandboxConfig
	(*PodSandboxMetadata)(nil),               // 18: runtime.v1alpha2.PodSandboxMetadata
	(*PodSandboxConfig)(nil),                 // 19: runtime.v1alpha2.PodSandboxConfig
	(*RunPodSandboxRequest)(nil),             // 20: runtime.v1alpha2.RunPodSandboxRequest
	(*RunPodSandboxResponse)(nil),            // 21: runtime.v1alpha2.RunPodSandboxResponse
	(*StopPodSandboxRequest)(nil),            // 22: runtime.v1alpha2.StopPodSandboxRequest
	(*StopPodSandboxResponse)(nil),           // 23: runtime.v1alpha2.StopPodSandboxResponse
	(*RemovePodSandboxRequest)(nil),          // 24: runtime.v1alpha2.RemovePodSandboxRequest
	(*RemovePodSandboxResponse)(nil),         // 25: runtime.v1alpha2.RemovePodSandboxResponse
	(*PodSandboxStatusRequest)(nil),          // 26: runtime.v1alpha2.PodSandboxStatusRequest
	(*PodIP)(nil),                            // 27: runtime.v1alpha2.PodIP
	(*PodSandboxNetworkStatus)(nil),          // 28: runtime.v1alpha2.PodSandboxNetworkStatus
	(*Namespace)(nil),                        // 29: runtime.v1alpha2.Namespace
	(*LinuxPodSandboxStatus)(nil),            // 30: runtime.v1alpha2.LinuxPodSandboxStatus
	(*PodSandboxStatus)(nil),                 // 31: runtime.v1alpha2.PodSandboxStatus
	(*PodSandboxStatusResponse)(nil),         // 32: runtime.v1alpha2.PodSandboxStatusResponse
	(*PodSandboxStateValue)(nil),             // 33: runtime.v1alpha2.PodSandboxStateValue
	(*PodSandboxFilter)(nil),                 // 34: runtime.v1alpha2.PodSandboxFilter
	(*ListPodSandboxRequest)(nil),            // 35: runtime.v1alpha2.ListPodSandboxRequest
	(*PodSandbox)(nil),                       // 36: runtime.v1alpha2.PodSandbox
	(*ListPodSandboxResponse)(nil),           // 37: runtime.v1alpha2.ListPodSandboxResponse
	(*PodSandboxStatsRequest)(nil),           // 38: runtime.v1alpha2.PodSandboxStatsRequest
	(*PodSandboxStatsResponse)(nil),          // 39: runtime.v1alpha2.PodSandboxStatsResponse
	(*PodSandboxStatsFilter)(nil),            // 40: runtime.v1alpha2.PodSandboxStatsFilter
	(*ListPodSandboxStatsRequest)(nil),       // 41: runtime.v1alpha2.ListPodSandboxStatsRequest
	(*ListPodSandboxStatsResponse)(nil),      // 42: runtime.v1alpha2.ListPodSandboxStatsResponse
	(*PodSandboxAttributes)(nil),             // 43: runtime.v1alpha2.PodSandboxAttributes
	(*PodSandboxStats)(nil),                  // 44: runtime.v1alpha2.PodSandboxStats
	(*LinuxPodSandboxStats)(nil),             // 45: runtime.v1alpha2.LinuxPodSandboxStats
	(*WindowsPodSandboxStats)(nil),           // 46: runtime.v1alpha2.WindowsPodSandboxStats
	(*NetworkUsage)(nil),                     // 47: runtime.v1alpha2.NetworkUsage
	(*NetworkInterfaceUsage)(nil),            // 48: runtime.v1alpha2.NetworkInterfaceUsage
	(*ProcessUsage)(nil),                     // 49: runtime.v1alpha2.ProcessUsage
	(*ImageSpec)(nil),                        // 50: runtime.v1alpha2.ImageSpec
	(*KeyValue)(nil),                         // 51: runtime.v1alpha2.KeyValue
	(*LinuxContainerResources)(nil),          // 52: runtime.v1alpha2.LinuxContainerResources
	(*HugepageLimit)(nil),                    // 53: runtime.v1alpha2.HugepageLimit
	(*SELinuxOption)(nil),                    // 54: runtime.v1alpha2.SELinuxOption
	(*Capability)(nil),                       // 55: runtime.v1alpha2.Capability
	(*LinuxContainerSecurityContext)(nil),    // 56: runtime.v1alpha2.LinuxContainerSecurityContext
	(*LinuxContainerConfig)(nil),             // 57: runtime.v1alpha2.LinuxContainerConfig
	(*WindowsSandboxSecurityContext)(nil),    // 58: runtime.v1alpha2.WindowsSandboxSecurityContext
	(*WindowsPodSandboxConfig)(nil),          // 59: runtime.v1alpha2.WindowsPodSandboxConfig
	(*WindowsContainerSecurityContext)(nil),  // 60: runtime.v1alpha2.WindowsContainerSecurityContext
	(*WindowsContainerConfig)(nil),           // 61: runtime.v1alpha2.WindowsContainerConfig
	(*WindowsContainerResources)(nil),        // 62: runtime.v1alpha2.WindowsContainerResources
	(*ContainerMetadata)(nil),                // 63: runtime.v1alpha2.ContainerMetadata
	(*Device)(nil),                           // 64: runtime.v1alpha2.Device
	(*ContainerConfig)(nil),                  // 65: runtime.v1alpha2.ContainerConfig
	(*CreateContainerRequest)(nil),           // 66: runtime.v1alpha2.CreateContainerRequest
	(*CreateContainerResponse)(nil),          // 67: runtime.v1alpha2.CreateContainerResponse
	(*StartContainerRequest)(nil),            // 68: runtime.v1alpha2.StartContainerRequest
	(*StartContainerResponse)(nil),           // 69: runtime.v1alpha2.StartContainerResponse
	(*StopContainerRequest)(nil),             // 70: runtime.v1alpha2.StopContainerRequest
	(*StopContainerResponse)(nil),            // 71: runtime.v1alpha2.StopContainerResponse
	(*RemoveContainerRequest)(nil),           // 72: runtime.v1alpha2.RemoveContainerRequest
	(*RemoveContainerResponse)(nil),          // 73: runtime.v1alpha2.RemoveContainerResponse
	(*ContainerStateValue)(nil),              // 74: runtime.v1alpha2.ContainerStateValue
	(*ContainerFilter)(nil),                  // 75: runtime.v1alpha2.ContainerFilter
	(*ListContainersRequest)(nil),            // 76: runtime.v1alpha2.ListContainersRequest
	(*Container)(nil),                        // 77: runtime.v1alpha2.Container
	(*ListContainersResponse)(nil),           // 78: runtime.v1alpha2.ListContainersResponse
	(*ContainerStatusRequest)(nil),           // 79: runtime.v1alpha2.ContainerStatusRequest
	(*ContainerStatus)(nil),                  // 80: runtime.v1alpha2.ContainerStatus
	(*ContainerStatusResponse)(nil),          // 81: runtime.v1alpha2.ContainerStatusResponse
	(*ContainerResources)(nil),               // 82: runtime.v1alpha2.ContainerResources
	(*UpdateContainerResourcesRequest)(nil),  // 83: runtime.v1alpha2.UpdateContainerResourcesRequest
	(*UpdateContainerResourcesResponse)(nil), // 84: runtime.v1alpha2.UpdateContainerResourcesResponse
	(*ExecSyncRequest)(nil),                  // 85: runtime.v1alpha2.ExecSyncRequest
	(*ExecSyncResponse)(nil),                 // 86: runtime.v1alpha2.ExecSyncResponse
	(*ExecRequest)(nil),                      // 87: runtime.v1alpha2.ExecRequest
	(*ExecResponse)(nil),                     // 88: runtime.v1alpha2.ExecResponse
	(*AttachRequest)(nil),                    // 89: runtime.v1alpha2.AttachRequest
	(*AttachResponse)(nil),                   // 90: runtime.v1alpha2.AttachResponse
	(*PortForwardRequest)(nil),               // 91: runtime.v1alpha2.PortForwardRequest
	(*PortForwardResponse)(nil),              // 92: runtime.v1alpha2.PortForwardResponse
	(*ImageFilter)(nil),                      // 93: runtime.v1alpha2.ImageFilter
	(*ListImagesRequest)(nil),                // 94: runtime.v1alpha2.ListImagesRequest
	(*Image)(nil),                            // 95: runtime.v1alpha2.Image
	(*ListImagesResponse)(nil),               // 96: runtime.v1alpha2.ListImagesResponse
	(*ImageStatusRequest)(nil),               // 97: runtime.v1alpha2.ImageStatusRequest
	(*ImageStatusResponse)(nil),              // 98: runtime.v1alpha2.ImageStatusResponse
	(*AuthConfig)(nil),                       // 99: runtime.v1alpha2.AuthConfig
	(*PullImageRequest)(nil),                 // 100: runtime.v1alpha2.PullImageRequest
	(*PullImageResponse)(nil),                // 101: runtime.v1alpha2.PullImageResponse
	(*RemoveImageRequest)(nil),               // 102: runtime.v1alpha2.RemoveImageRequest
	(*RemoveImageResponse)(nil),              // 103: runtime.v1alpha2.RemoveImageResponse
	(*NetworkConfig)(nil),                    // 104: runtime.v1alpha2.NetworkConfig
	(*RuntimeConfig)(nil),                    // 105: runtime.v1alpha2.RuntimeConfig
	(*UpdateRuntimeConfigRequest)(nil),       // 106: runtime.v1alpha2.UpdateRuntimeConfigRequest
	(*UpdateRuntimeConfigResponse)(nil),      // 107: runtime.v1alpha2.UpdateRuntimeConfigResponse
	(*RuntimeCondition)(nil),                 // 108: runtime.v1alpha2.RuntimeCondition
	(*RuntimeStatus)(nil),                    // 109: runtime.v1alpha2.RuntimeStatus
	(*StatusRequest)(nil),                    // 110: runtime.v1alpha2.StatusRequest
	(*StatusResponse)(nil),                   // 111: runtime.v1alpha2.StatusResponse
	(*ImageFsInfoRequest)(nil),               // 112: runtime.v1alpha2.ImageFsInfoRequest
	(*UInt64Value)(nil),                      // 113: runtime.v1alpha2.UInt64Value
	(*FilesystemIdentifier)(nil),             // 114: runtime.v1alpha2.FilesystemIdentifier
	(*FilesystemUsage)(nil),                  // 115: runtime.v1alpha2.FilesystemUsage
	(*ImageFsInfoResponse)(nil),              // 116: runtime.v1alpha2.ImageFsInfoResponse
	(*ContainerStatsRequest)(nil),            // 117: runtime.v1alpha2.ContainerStatsRequest
	(*ContainerStatsResponse)(nil),           // 118: runtime.v1alpha2.ContainerStatsResponse
	(*ListContainerStatsRequest)(nil),        // 119: runtime.v1alpha2.ListContainerStatsRequest
	(*ContainerStatsFilter)(nil),             // 120: runtime.v1alpha2.ContainerStatsFilter
	(*ListContainerStatsResponse)(nil),       // 121: runtime.v1alpha2.ListContainerStatsResponse
	(*ContainerAttributes)(nil),              // 122: runtime.v1alpha2.ContainerAttributes
	(*ContainerStats)(nil),                   // 123: runtime.v1alpha2.ContainerStats
	(*CpuUsage)(nil),                         // 124: runtime.v1alpha2.CpuUsage
	(*MemoryUsage)(nil),                      // 125: runtime.v1alpha2.MemoryUsage
	(*ReopenContainerLogRequest)(nil),        // 126: runtime.v1alpha2.ReopenContainerLogRequest
	(*ReopenContainerLogResponse)(nil),       // 127: runtime.v1alpha2.ReopenContainerLogResponse
	nil,                                      // 128: runtime.v1alpha2.LinuxPodSandboxConfig.SysctlsEntry
	nil,                                      // 129: runtime.v1alpha2.PodSandboxConfig.LabelsEntry
	nil,                                      // 130: runtime.v1alpha2.PodSandboxConfig.AnnotationsEntry
	nil,                                      // 131: runtime.v1alpha2.PodSandboxStatus.LabelsEntry
	nil,                                      // 132: runtime.v1alpha2.PodSandboxStatus.AnnotationsEntry
	nil,                                      // 133: runtime.v1alpha2.PodSandboxStatusResponse.InfoEntry
	nil,                                      // 134: runtime.v1alpha2.PodSandboxFilter.LabelSelectorEntry
	nil,                                      // 135: runtime.v1alpha2.PodSandbox.LabelsEntry
	nil,                                      // 136: runtime.v1alpha2.PodSandbox.AnnotationsEntry
	nil,                                      // 137: runtime.v1alpha2.PodSandboxStatsFilter.LabelSelectorEntry
	nil,                                      // 138: runtime.v1alpha2.PodSandboxAttributes.LabelsEntry
	nil,                                      // 139: runtime.v1alpha2.PodSandboxAttributes.AnnotationsEntry
	nil,                                      // 140: runtime.v1alpha2.ImageSpec.AnnotationsEntry
	nil,                                      // 141: runtime.v1alpha2.LinuxContainerResources.UnifiedEntry
	nil,                                      // 142: runtime.v1alpha2.ContainerConfig.LabelsEntry
	nil,                                      // 143: runtime.v1alpha2.ContainerConfig.AnnotationsEntry
	nil,                                      // 144: runtime.v1alpha2.ContainerFilter.LabelSelectorEntry
	nil,                                      // 145: runtime.v1alpha2.Container.LabelsEntry
	nil,                                      // 146: runtime.v1alpha2.Container.AnnotationsEntry
	nil,                                      // 147: runtime.v1alpha2.ContainerStatus.LabelsEntry
	nil,                                      // 148: runtime.v1alpha2.ContainerStatus.AnnotationsEntry
	nil,                                      // 149: runtime.v1alpha2.ContainerStatusResponse.InfoEntry
	nil,                                      // 150: runtime.v1alpha2.UpdateContainerResourcesRequest.AnnotationsEntry
	nil,                                      // 151: runtime.v1alpha2.ImageStatusResponse.InfoEntry
	nil,                                      // 152: runtime.v1alpha2.StatusResponse.InfoEntry
	nil,                                      // 153: runtime.v1alpha2.ContainerStatsFilter.LabelSelectorEntry
	nil,                                      // 154: runtime.v1alpha2.ContainerAttributes.LabelsEntry
	nil,                                      // 155: runtime.v1alpha2.ContainerAttributes.AnnotationsEntry
}
var file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_depIdxs = []int32{
	0,   // 0: runtime.v1alpha2.PortMapping.protocol:type_name -> runtime.v1alpha2.Protocol
	1,   // 1: runtime.v1alpha2.Mount.propagation:type_name -> runtime.v1alpha2.MountPropagation
	2,   // 2: runtime.v1alpha2.UserNamespace.mode:type_name -> runtime.v1alpha2.NamespaceMode
	11,  // 3: runtime.v1alpha2.UserNamespace.uids:type_name -> runtime.v1alpha2.IDMapping
	11,  // 4: runtime.v1alpha2.UserNamespace.gids:type_name -> runtime.v1alpha2.IDMapping
	2,   // 5: runtime.v1alpha2.NamespaceOption.network:type_name -> runtime.v1alpha2.NamespaceMode
	2,   // 6: runtime.v1alpha2.NamespaceOption.pid:type_name -> runtime.v1alpha2.NamespaceMode
	2,   // 7: runtime.v1alpha2.NamespaceOption.ipc:type_name -> runtime.v1alpha2.NamespaceMode
	12,  // 8: runtime.v1alpha2.NamespaceOption.userns_options:type_name -> runtime.v1alpha2.UserNamespace
	13,  // 9: runtime.v1alpha2.LinuxSandboxSecurityContext.namespace_options:type_name -> runtime.v1alpha2.NamespaceOption
	54,  // 10: runtime.v1alpha2.LinuxSandboxSecurityContext.selinux_options:type_name -> runtime.v1alpha2.SELinuxOption
	14,  // 11: runtime.v1alpha2.LinuxSandboxSecurityContext.run_as_user:type_name -> runtime.v1alpha2.Int64Value
	14,  // 12: runtime.v1alpha2.LinuxSandboxSecurityContext.run_as_group:type_name -> runtime.v1alpha2.Int64Value
	16,  // 13: runtime.v1alpha2.LinuxSandboxSecurityContext.seccomp:type_name -> runtime.v1alpha2.SecurityProfile
	16,  // 14: runtime.v1alpha2.LinuxSandboxSecurityContext.apparmor:type_name -> runtime.v1alpha2.SecurityProfile
	5,   // 15: runtime.v1alpha2.SecurityProfile.profile_type:type_name -> runtime.v1alpha2.SecurityProfile.ProfileType
	15,  // 16: runtime.v1alpha2.LinuxPodSandboxConfig.security_context:type_name -> runtime.v1alpha2.LinuxSandboxSecurityContext
	128, // 17: runtime.v1alpha2.LinuxPodSandboxConfig.sysctls:type_name -> runtime.v1alpha2.LinuxPodSandboxConfig.SysctlsEntry
	52,  // 18: runtime.v1alpha2.LinuxPodSandboxConfig.overhead:type_name -> runtime.v1alpha2.LinuxContainerResources
	52,  // 19: runtime.v1alpha2.LinuxPodSandboxConfig.resources:type_name -> runtime.v1alpha2.LinuxContainerResources
	18,  // 20: runtime.v1alpha2.PodSandboxConfig.metadata:type_name -> runtime.v1alpha2.PodSandboxMetadata
	8,   // 21: runtime.v1alpha2.PodSandboxConfig.dns_config:type_name -> runtime.v1alpha2.DNSConfig
	9,   // 22: runtime.v1alpha2.PodSandboxConfig.port_mappings:type_name -> runtime.v1alpha2.PortMapping
	129, // 23: runtime.v1alpha2.PodSandboxConfig.labels:type_name -> runtime.v1alpha2.PodSandboxConfig.LabelsEntry
	130, // 24: runtime.v1alpha2.PodSandboxConfig.annotations:type_name -> runtime.v1alpha2.PodSandboxConfig.AnnotationsEntry
	17,  // 25: runtime.v1alpha2.PodSandboxConfig.linux:type_name -> runtime.v1alpha2.LinuxPodSandboxConfig
	59,  // 26: runtime.v1alpha2.PodSandboxConfig.windows:type_name -> runtime.v1alpha2.WindowsPodSandboxConfig
	19,  // 27: runtime.v1alpha2.RunPodSandboxRequest.config:type_name -> runtime.v1alpha2.PodSandboxConfig
	27,  // 28: runtime.v1alpha2.PodSandboxNetworkStatus.additional_ips:type_name -> runtime.v1alpha2.PodIP
	13,  // 29: runtime.v1alpha2.Namespace.options:type_name -> runtime.v1alpha2.NamespaceOption
	29,  // 30: runtime.v1alpha2.LinuxPodSandboxStatus.namespaces:type_name -> runtime.v1alpha2.Namespace
	18,  // 31: runtime.v1alpha2.PodSandboxStatus.metadata:type_name -> runtime.v1alpha2.PodSandboxMetadata
	3,   // 32: runtime.v1alpha2.PodSandboxStatus.state:type_name -> runtime.v1alpha2.PodSandboxState
	28,  // 33: runtime.v1alpha2.PodSandboxStatus.network:type_name -> runtime.v1alpha2.PodSandboxNetworkStatus
	30,  // 34: runtime.v1alpha2.PodSandboxStatus.linux:type_name -> runtime.v1alpha2.LinuxPodSandboxStatus
	131, // 35: runtime.v1alpha2.PodSandboxStatus.labels:type_name -> runtime.v1alpha2.PodSandboxStatus.LabelsEntry
	132, // 36: runtime.v1alpha2.PodSandboxStatus.annotations:type_name -> runtime.v1alpha2.PodSandboxStatus.AnnotationsEntry
	31,  // 37: runtime.v1alpha2.PodSandboxStatusResponse.status:type_name -> runtime.v1alpha2.PodSandboxStatus
	133, // 38: runtime.v1alpha2.PodSandboxStatusResponse.info:type_name -> runtime.v1alpha2.PodSandboxStatusResponse.InfoEntry
	3,   // 39: runtime.v1alpha2.PodSandboxStateValue.state:type_name -> runtime.v1alpha2.PodSandboxState
	33,  // 40: runtime.v1alpha2.PodSandboxFilter.state:type_name -> runtime.v1alpha2.PodSandboxStateValue
	134, // 41: runtime.v1alpha2.PodSandboxFilter.label_selector:type_name -> runtime.v1alpha2.PodSandboxFilter.LabelSelectorEntry
	34,  // 42: runtime.v1alpha2.ListPodSandboxRequest.filter:type_name -> runtime.v1alpha2.PodSandboxFilter
	18,  // 43: runtime.v1alpha2.PodSandbox.metadata:type_name -> runtime.v1alpha2.PodSandboxMetadata
	3,   // 44: runtime.v1alpha2.PodSandbox.state:type_name -> runtime.v1alpha2.PodSandboxState
	135, // 45: runtime.v1alpha2.PodSandbox.labels:type_name -> runtime.v1alpha2.PodSandbox.LabelsEntry
	136, // 46: runtime.v1alpha2.PodSandbox.annotations:type_name -> runtime.v1alpha2.PodSandbox.AnnotationsEntry
	36,  // 47: runtime.v1alpha2.ListPodSandboxResponse.items:type_name -> runtime.v1alpha2.PodSandbox
	44,  // 48: runtime.v1alpha2.PodSandboxStatsResponse.stats:type_name -> runtime.v1alpha2.PodSandboxStats
	137, // 49: runtime.v1alpha2.PodSandboxStatsFilter.label_selector:type_name -> runtime.v1alpha2.PodSandboxStatsFilter.LabelSelectorEntry
	40,  // 50: runtime.v1alpha2.ListPodSandboxStatsRequest.filter:type_name -> runtime.v1alpha2.PodSandboxStatsFilter
	44,  // 51: runtime.v1alpha2.ListPodSandboxStatsResponse.stats:type_name -> runtime.v1alpha2.PodSandboxStats
	18,  // 52: runtime.v1alpha2.PodSandboxAttributes.metadata:type_name -> runtime.v1alpha2.PodSandboxMetadata
	138, // 53: runtime.v1alpha2.PodSandboxAttributes.labels:type_name -> runtime.v1alpha2.PodSandboxAttributes.LabelsEntry
	139, // 54: runtime.v1alpha2.PodSandboxAttributes.annotations:type_name -> runtime.v1alpha2.PodSandboxAttributes.AnnotationsEntry
	43,  // 55: runtime.v1alpha2.PodSandboxStats.attributes:type_name -> runtime.v1alpha2.PodSandboxAttributes
	45,  // 56: runtime.v1alpha2.PodSandboxStats.linux:type_name -> runtime.v1alpha2.LinuxPodSandboxStats
	46,  // 57: runtime.v1alpha2.PodSandboxStats.windows:type_name -> runtime.v1alpha2.WindowsPodSandboxStats
	124, // 58: runtime.v1alpha2.LinuxPodSandboxStats.cpu:type_name -> runtime.v1alpha2.CpuUsage
	125, // 59: runtime.v1alpha2.LinuxPodSandboxStats.memory:type_name -> runtime.v1alpha2.MemoryUsage
	47,  // 60: runtime.v1alpha2.LinuxPodSandboxStats.network:type_name -> runtime.v1alpha2.NetworkUsage
	49,  // 61: runtime.v1alpha2.LinuxPodSandboxStats.process:type_name -> runtime.v1alpha2.ProcessUsage
	123, // 62: runtime.v1alpha2.LinuxPodSandboxStats.containers:type_name -> runtime.v1alpha2.ContainerStats
	48,  // 63: runtime.v1alpha2.NetworkUsage.default_interface:type_name -> runtime.v1alpha2.NetworkInterfaceUsage
	48,  // 64: runtime.v1alpha2.NetworkUsage.interfaces:type_name -> runtime.v1alpha2.NetworkInterfaceUsage
	113, // 65: runtime.v1alpha2.NetworkInterfaceUsage.rx_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 66: runtime.v1alpha2.NetworkInterfaceUsage.rx_errors:type_name -> runtime.v1alpha2.UInt64Value
	113, // 67: runtime.v1alpha2.NetworkInterfaceUsage.tx_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 68: runtime.v1alpha2.NetworkInterfaceUsage.tx_errors:type_name -> runtime.v1alpha2.UInt64Value
	113, // 69: runtime.v1alpha2.ProcessUsage.process_count:type_name -> runtime.v1alpha2.UInt64Value
	140, // 70: runtime.v1alpha2.ImageSpec.annotations:type_name -> runtime.v1alpha2.ImageSpec.AnnotationsEntry
	53,  // 71: runtime.v1alpha2.LinuxContainerResources.hugepage_limits:type_name -> runtime.v1alpha2.HugepageLimit
	141, // 72: runtime.v1alpha2.LinuxContainerResources.unified:type_name -> runtime.v1alpha2.LinuxContainerResources.UnifiedEntry
	55,  // 73: runtime.v1alpha2.LinuxContainerSecurityContext.capabilities:type_name -> runtime.v1alpha2.Capability
	13,  // 74: runtime.v1alpha2.LinuxContainerSecurityContext.namespace_options:type_name -> runtime.v1alpha2.NamespaceOption
	54,  // 75: runtime.v1alpha2.LinuxContainerSecurityContext.selinux_options:type_name -> runtime.v1alpha2.SELinuxOption
	14,  // 76: runtime.v1alpha2.LinuxContainerSecurityContext.run_as_user:type_name -> runtime.v1alpha2.Int64Value
	14,  // 77: runtime.v1alpha2.LinuxContainerSecurityContext.run_as_group:type_name -> runtime.v1alpha2.Int64Value
	16,  // 78: runtime.v1alpha2.LinuxContainerSecurityContext.seccomp:type_name -> runtime.v1alpha2.SecurityProfile
	16,  // 79: runtime.v1alpha2.LinuxContainerSecurityContext.apparmor:type_name -> runtime.v1alpha2.SecurityProfile
	52,  // 80: runtime.v1alpha2.LinuxContainerConfig.resources:type_name -> runtime.v1alpha2.LinuxContainerResources
	56,  // 81: runtime.v1alpha2.LinuxContainerConfig.security_context:type_name -> runtime.v1alpha2.LinuxContainerSecurityContext
	58,  // 82: runtime.v1alpha2.WindowsPodSandboxConfig.security_context:type_name -> runtime.v1alpha2.WindowsSandboxSecurityContext
	62,  // 83: runtime.v1alpha2.WindowsContainerConfig.resources:type_name -> runtime.v1alpha2.WindowsContainerResources
	60,  // 84: runtime.v1alpha2.WindowsContainerConfig.security_context:type_name -> runtime.v1alpha2.WindowsContainerSecurityContext
	63,  // 85: runtime.v1alpha2.ContainerConfig.metadata:type_name -> runtime.v1alpha2.ContainerMetadata
	50,  // 86: runtime.v1alpha2.ContainerConfig.image:type_name -> runtime.v1alpha2.ImageSpec
	51,  // 87: runtime.v1alpha2.ContainerConfig.envs:type_name -> runtime.v1alpha2.KeyValue
	10,  // 88: runtime.v1alpha2.ContainerConfig.mounts:type_name -> runtime.v1alpha2.Mount
	64,  // 89: runtime.v1alpha2.ContainerConfig.devices:type_name -> runtime.v1alpha2.Device
	142, // 90: runtime.v1alpha2.ContainerConfig.labels:type_name -> runtime.v1alpha2.ContainerConfig.LabelsEntry
	143, // 91: runtime.v1alpha2.ContainerConfig.annotations:type_name -> runtime.v1alpha2.ContainerConfig.AnnotationsEntry
	57,  // 92: runtime.v1alpha2.ContainerConfig.linux:type_name -> runtime.v1alpha2.LinuxContainerConfig
	61,  // 93: runtime.v1alpha2.ContainerConfig.windows:type_name -> runtime.v1alpha2.WindowsContainerConfig
	65,  // 94: runtime.v1alpha2.CreateContainerRequest.config:type_name -> runtime.v1alpha2.ContainerConfig
	19,  // 95: runtime.v1alpha2.CreateContainerRequest.sandbox_config:type_name -> runtime.v1alpha2.PodSandboxConfig
	4,   // 96: runtime.v1alpha2.ContainerStateValue.state:type_name -> runtime.v1alpha2.ContainerState
	74,  // 97: runtime.v1alpha2.ContainerFilter.state:type_name -> runtime.v1alpha2.ContainerStateValue
	144, // 98: runtime.v1alpha2.ContainerFilter.label_selector:type_name -> runtime.v1alpha2.ContainerFilter.LabelSelectorEntry
	75,  // 99: runtime.v1alpha2.ListContainersRequest.filter:type_name -> runtime.v1alpha2.ContainerFilter
	63,  // 100: runtime.v1alpha2.Container.metadata:type_name -> runtime.v1alpha2.ContainerMetadata
	50,  // 101: runtime.v1alpha2.Container.image:type_name -> runtime.v1alpha2.ImageSpec
	4,   // 102: runtime.v1alpha2.Container.state:type_name -> runtime.v1alpha2.ContainerState
	145, // 103: runtime.v1alpha2.Container.labels:type_name -> runtime.v1alpha2.Container.LabelsEntry
	146, // 104: runtime.v1alpha2.Container.annotations:type_name -> runtime.v1alpha2.Container.AnnotationsEntry
	77,  // 105: runtime.v1alpha2.ListContainersResponse.containers:type_name -> runtime.v1alpha2.Container
	63,  // 106: runtime.v1alpha2.ContainerStatus.metadata:type_name -> runtime.v1alpha2.ContainerMetadata
	4,   // 107: runtime.v1alpha2.ContainerStatus.state:type_name -> runtime.v1alpha2.ContainerState
	50,  // 108: runtime.v1alpha2.ContainerStatus.image:type_name -> runtime.v1alpha2.ImageSpec
	147, // 109: runtime.v1alpha2.ContainerStatus.labels:type_name -> runtime.v1alpha2.ContainerStatus.LabelsEntry
	148, // 110: runtime.v1alpha2.ContainerStatus.annotations:type_name -> runtime.v1alpha2.ContainerStatus.AnnotationsEntry
	10,  // 111: runtime.v1alpha2.ContainerStatus.mounts:type_name -> runtime.v1alpha2.Mount
	82,  // 112: runtime.v1alpha2.ContainerStatus.resources:type_name -> runtime.v1alpha2.ContainerResources
	80,  // 113: runtime.v1alpha2.ContainerStatusResponse.status:type_name -> runtime.v1alpha2.ContainerStatus
	149, // 114: runtime.v1alpha2.ContainerStatusResponse.info:type_name -> runtime.v1alpha2.ContainerStatusResponse.InfoEntry
	52,  // 115: runtime.v1alpha2.ContainerResources.linux:type_name -> runtime.v1alpha2.LinuxContainerResources
	62,  // 116: runtime.v1alpha2.ContainerResources.windows:type_name -> runtime.v1alpha2.WindowsContainerResources
	52,  // 117: runtime.v1alpha2.UpdateContainerResourcesRequest.linux:type_name -> runtime.v1alpha2.LinuxContainerResources
	62,  // 118: runtime.v1alpha2.UpdateContainerResourcesRequest.windows:type_name -> runtime.v1alpha2.WindowsContainerResources
	150, // 119: runtime.v1alpha2.UpdateContainerResourcesRequest.annotations:type_name -> runtime.v1alpha2.UpdateContainerResourcesRequest.AnnotationsEntry
	50,  // 120: runtime.v1alpha2.ImageFilter.image:type_name -> runtime.v1alpha2.ImageSpec
	93,  // 121: runtime.v1alpha2.ListImagesRequest.filter:type_name -> runtime.v1alpha2.ImageFilter
	14,  // 122: runtime.v1alpha2.Image.uid:type_name -> runtime.v1alpha2.Int64Value
	50,  // 123: runtime.v1alpha2.Image.spec:type_name -> runtime.v1alpha2.ImageSpec
	95,  // 124: runtime.v1alpha2.ListImagesResponse.images:type_name -> runtime.v1alpha2.Image
	50,  // 125: runtime.v1alpha2.ImageStatusRequest.image:type_name -> runtime.v1alpha2.ImageSpec
	95,  // 126: runtime.v1alpha2.ImageStatusResponse.image:type_name -> runtime.v1alpha2.Image
	151, // 127: runtime.v1alpha2.ImageStatusResponse.info:type_name -> runtime.v1alpha2.ImageStatusResponse.InfoEntry
	50,  // 128: runtime.v1alpha2.PullImageRequest.image:type_name -> runtime.v1alpha2.ImageSpec
	99,  // 129: runtime.v1alpha2.PullImageRequest.auth:type_name -> runtime.v1alpha2.AuthConfig
	19,  // 130: runtime.v1alpha2.PullImageRequest.sandbox_config:type_name -> runtime.v1alpha2.PodSandboxConfig
	50,  // 131: runtime.v1alpha2.RemoveImageRequest.image:type_name -> runtime.v1alpha2.ImageSpec
	104, // 132: runtime.v1alpha2.RuntimeConfig.network_config:type_name -> runtime.v1alpha2.NetworkConfig
	105, // 133: runtime.v1alpha2.UpdateRuntimeConfigRequest.runtime_config:type_name -> runtime.v1alpha2.RuntimeConfig
	108, // 134: runtime.v1alpha2.RuntimeStatus.conditions:type_name -> runtime.v1alpha2.RuntimeCondition
	109, // 135: runtime.v1alpha2.StatusResponse.status:type_name -> runtime.v1alpha2.RuntimeStatus
	152, // 136: runtime.v1alpha2.StatusResponse.info:type_name -> runtime.v1alpha2.StatusResponse.InfoEntry
	114, // 137: runtime.v1alpha2.FilesystemUsage.fs_id:type_name -> runtime.v1alpha2.FilesystemIdentifier
	113, // 138: runtime.v1alpha2.FilesystemUsage.used_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 139: runtime.v1alpha2.FilesystemUsage.inodes_used:type_name -> runtime.v1alpha2.UInt64Value
	115, // 140: runtime.v1alpha2.ImageFsInfoResponse.image_filesystems:type_name -> runtime.v1alpha2.FilesystemUsage
	123, // 141: runtime.v1alpha2.ContainerStatsResponse.stats:type_name -> runtime.v1alpha2.ContainerStats
	120, // 142: runtime.v1alpha2.ListContainerStatsRequest.filter:type_name -> runtime.v1alpha2.ContainerStatsFilter
	153, // 143: runtime.v1alpha2.ContainerStatsFilter.label_selector:type_name -> runtime.v1alpha2.ContainerStatsFilter.LabelSelectorEntry
	123, // 144: runtime.v1alpha2.ListContainerStatsResponse.stats:type_name -> runtime.v1alpha2.ContainerStats
	63,  // 145: runtime.v1alpha2.ContainerAttributes.metadata:type_name -> runtime.v1alpha2.ContainerMetadata
	154, // 146: runtime.v1alpha2.ContainerAttributes.labels:type_name -> runtime.v1alpha2.ContainerAttributes.LabelsEntry
	155, // 147: runtime.v1alpha2.ContainerAttributes.annotations:type_name -> runtime.v1alpha2.ContainerAttributes.AnnotationsEntry
	122, // 148: runtime.v1alpha2.ContainerStats.attributes:type_name -> runtime.v1alpha2.ContainerAttributes
	124, // 149: runtime.v1alpha2.ContainerStats.cpu:type_name -> runtime.v1alpha2.CpuUsage
	125, // 150: runtime.v1alpha2.ContainerStats.memory:type_name -> runtime.v1alpha2.MemoryUsage
	115, // 151: runtime.v1alpha2.ContainerStats.writable_layer:type_name -> runtime.v1alpha2.FilesystemUsage
	113, // 152: runtime.v1alpha2.CpuUsage.usage_core_nano_seconds:type_name -> runtime.v1alpha2.UInt64Value
	113, // 153: runtime.v1alpha2.CpuUsage.usage_nano_cores:type_name -> runtime.v1alpha2.UInt64Value
	113, // 154: runtime.v1alpha2.MemoryUsage.working_set_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 155: runtime.v1alpha2.MemoryUsage.available_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 156: runtime.v1alpha2.MemoryUsage.usage_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 157: runtime.v1alpha2.MemoryUsage.rss_bytes:type_name -> runtime.v1alpha2.UInt64Value
	113, // 158: runtime.v1alpha2.MemoryUsage.page_faults:type_name -> runtime.v1alpha2.UInt64Value
	113, // 159: runtime.v1alpha2.MemoryUsage.major_page_faults:type_name -> runtime.v1alpha2.UInt64Value
	6,   // 160: runtime.v1alpha2.RuntimeService.Version:input_type -> runtime.v1alpha2.VersionRequest
	20,  // 161: runtime.v1alpha2.RuntimeService.RunPodSandbox:input_type -> runtime.v1alpha2.RunPodSandboxRequest
	22,  // 162: runtime.v1alpha2.RuntimeService.StopPodSandbox:input_type -> runtime.v1alpha2.StopPodSandboxRequest
	24,  // 163: runtime.v1alpha2.RuntimeService.RemovePodSandbox:input_type -> runtime.v1alpha2.RemovePodSandboxRequest
	26,  // 164: runtime.v1alpha2.RuntimeService.PodSandboxStatus:input_type -> runtime.v1alpha2.PodSandboxStatusRequest
	35,  // 165: runtime.v1alpha2.RuntimeService.ListPodSandbox:input_type -> runtime.v1alpha2.ListPodSandboxRequest
	66,  // 166: runtime.v1alpha2.RuntimeService.CreateContainer:input_type -> runtime.v1alpha2.CreateContainerRequest
	68,  // 167: runtime.v1alpha2.RuntimeService.StartContainer:input_type -> runtime.v1alpha2.StartContainerRequest
	70,  // 168: runtime.v1alpha2.RuntimeService.StopContainer:input_type -> runtime.v1alpha2.StopContainerRequest
	72,  // 169: runtime.v1alpha2.RuntimeService.RemoveContainer:input_type -> runtime.v1alpha2.RemoveContainerRequest
	76,  // 170: runtime.v1alpha2.RuntimeService.ListContainers:input_type -> runtime.v1alpha2.ListContainersRequest
	79,  // 171: runtime.v1alpha2.RuntimeService.ContainerStatus:input_type -> runtime.v1alpha2.ContainerStatusRequest
	83,  // 172: runtime.v1alpha2.RuntimeService.UpdateContainerResources:input_type -> runtime.v1alpha2.UpdateContainerResourcesRequest
	126, // 173: runtime.v1alpha2.RuntimeService.ReopenContainerLog:input_type -> runtime.v1alpha2.ReopenContainerLogRequest
	85,  // 174: runtime.v1alpha2.RuntimeService.ExecSync:input_type -> runtime.v1alpha2.ExecSyncRequest
	87,  // 175: runtime.v1alpha2.RuntimeService.Exec:input_type -> runtime.v1alpha2.ExecRequest
	89,  // 176: runtime.v1alpha2.RuntimeService.Attach:input_type -> runtime.v1alpha2.AttachRequest
	91,  // 177: runtime.v1alpha2.RuntimeService.PortForward:input_type -> runtime.v1alpha2.PortForwardRequest
	117, // 178: runtime.v1alpha2.RuntimeService.ContainerStats:input_type -> runtime.v1alpha2.ContainerStatsRequest
	119, // 179: runtime.v1alpha2.RuntimeService.ListContainerStats:input_type -> runtime.v1alpha2.ListContainerStatsRequest
	38,  // 180: runtime.v1alpha2.RuntimeService.PodSandboxStats:input_type -> runtime.v1alpha2.PodSandboxStatsRequest
	41,  // 181: runtime.v1alpha2.RuntimeService.ListPodSandboxStats:input_type -> runtime.v1alpha2.ListPodSandboxStatsRequest
	106, // 182: runtime.v1alpha2.RuntimeService.UpdateRuntimeConfig:input_type -> runtime.v1alpha2.UpdateRuntimeConfigRequest
	110, // 183: runtime.v1alpha2.RuntimeService.Status:input_type -> runtime.v1alpha2.StatusRequest
	94,  // 184: runtime.v1alpha2.ImageService.ListImages:input_type -> runtime.v1alpha2.ListImagesRequest
	97,  // 185: runtime.v1alpha2.ImageService.ImageStatus:input_type -> runtime.v1alpha2.ImageStatusRequest
	100, // 186: runtime.v1alpha2.ImageService.PullImage:input_type -> runtime.v1alpha2.PullImageRequest
	102, // 187: runtime.v1alpha2.ImageService.RemoveImage:input_type -> runtime.v1alpha2.RemoveImageRequest
	112, // 188: runtime.v1alpha2.ImageService.ImageFsInfo:input_type -> runtime.v1alpha2.ImageFsInfoRequest
	7,   // 189: runtime.v1alpha2.RuntimeService.Version:output_type -> runtime.v1alpha2.VersionResponse
	21,  // 190: runtime.v1alpha2.RuntimeService.RunPodSandbox:output_type -> runtime.v1alpha2.RunPodSandboxResponse
	23,  // 191: runtime.v1alpha2.RuntimeService.StopPodSandbox:output_type -> runtime.v1alpha2.StopPodSandboxResponse
	25,  // 192: runtime.v1alpha2.RuntimeService.RemovePodSandbox:output_type -> runtime.v1alpha2.RemovePodSandboxResponse
	32,  // 193: runtime.v1alpha2.RuntimeService.PodSandboxStatus:output_type -> runtime.v1alpha2.PodSandboxStatusResponse
	37,  // 194: runtime.v1alpha2.RuntimeService.ListPodSandbox:output_type -> runtime.v1alpha2.ListPodSandboxResponse
	67,  // 195: runtime.v1alpha2.RuntimeService.CreateContainer:output_type -> runtime.v1alpha2.CreateContainerResponse
	69,  // 196: runtime.v1alpha2.RuntimeService.StartContainer:output_type -> runtime.v1alpha2.StartContainerResponse
	71,  // 197: runtime.v1alpha2.RuntimeService.StopContainer:output_type -> runtime.v1alpha2.StopContainerResponse
	73,  // 198: runtime.v1alpha2.RuntimeService.RemoveContainer:output_type -> runtime.v1alpha2.RemoveContainerResponse
	78,  // 199: runtime.v1alpha2.RuntimeService.ListContainers:output_type -> runtime.v1alpha2.ListContainersResponse
	81,  // 200: runtime.v1alpha2.RuntimeService.ContainerStatus:output_type -> runtime.v1alpha2.ContainerStatusResponse
	84,  // 201: runtime.v1alpha2.RuntimeService.UpdateContainerResources:output_type -> runtime.v1alpha2.UpdateContainerResourcesResponse
	127, // 202: runtime.v1alpha2.RuntimeService.ReopenContainerLog:output_type -> runtime.v1alpha2.ReopenContainerLogResponse
	86,  // 203: runtime.v1alpha2.RuntimeService.ExecSync:output_type -> runtime.v1alpha2.ExecSyncResponse
	88,  // 204: runtime.v1alpha2.RuntimeService.Exec:output_type -> runtime.v1alpha2.ExecResponse
	90,  // 205: runtime.v1alpha2.RuntimeService.Attach:output_type -> runtime.v1alpha2.AttachResponse
	92,  // 206: runtime.v1alpha2.RuntimeService.PortForward:output_type -> runtime.v1alpha2.PortForwardResponse
	118, // 207: runtime.v1alpha2.RuntimeService.ContainerStats:output_type -> runtime.v1alpha2.ContainerStatsResponse
	121, // 208: runtime.v1alpha2.RuntimeService.ListContainerStats:output_type -> runtime.v1alpha2.ListContainerStatsResponse
	39,  // 209: runtime.v1alpha2.RuntimeService.PodSandboxStats:output_type -> runtime.v1alpha2.PodSandboxStatsResponse
	42,  // 210: runtime.v1alpha2.RuntimeService.ListPodSandboxStats:output_type -> runtime.v1alpha2.ListPodSandboxStatsResponse
	107, // 211: runtime.v1alpha2.RuntimeService.UpdateRuntimeConfig:output_type -> runtime.v1alpha2.UpdateRuntimeConfigResponse
	111, // 212: runtime.v1alpha2.RuntimeService.Status:output_type -> runtime.v1alpha2.StatusResponse
	96,  // 213: runtime.v1alpha2.ImageService.ListImages:output_type -> runtime.v1alpha2.ListImagesResponse
	98,  // 214: runtime.v1alpha2.ImageService.ImageStatus:output_type -> runtime.v1alpha2.ImageStatusResponse
	101, // 215: runtime.v1alpha2.ImageService.PullImage:output_type -> runtime.v1alpha2.PullImageResponse
	103, // 216: runtime.v1alpha2.ImageService.RemoveImage:output_type -> runtime.v1alpha2.RemoveImageResponse
	116, // 217: runtime.v1alpha2.ImageService.ImageFsInfo:output_type -> runtime.v1alpha2.ImageFsInfoResponse
	189, // [189:218] is the sub-list for method output_type
	160, // [160:189] is the sub-list for method input_type
	160, // [160:160] is the sub-list for extension type_name
	160, // [160:160] is the sub-list for extension extendee
	0,   // [0:160] is the sub-list for field type_name
}

func init() {
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_init()
}
func file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_init() {
	if File_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DNSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IDMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserNamespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Int64Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxSandboxSecurityContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxPodSandboxConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPodSandboxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPodSandboxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopPodSandboxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopPodSandboxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemovePodSandboxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemovePodSandboxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodIP); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxNetworkStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Namespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxPodSandboxStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStateValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPodSandboxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandbox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPodSandboxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStatsFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPodSandboxStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPodSandboxStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSandboxStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxPodSandboxStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsPodSandboxStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkInterfaceUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxContainerResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HugepageLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SELinuxOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Capability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxContainerSecurityContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxContainerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsSandboxSecurityContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsPodSandboxConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsContainerSecurityContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsContainerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsContainerResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Device); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateContainerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateContainerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartContainerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartContainerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopContainerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopContainerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveContainerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveContainerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStateValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListContainersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListContainersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateContainerResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateContainerResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecSyncRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecSyncResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttachRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttachResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortForwardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortForwardResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullImageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveImageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRuntimeConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRuntimeConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageFsInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UInt64Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilesystemIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilesystemUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageFsInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListContainerStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStatsFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListContainerStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpuUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MemoryUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReopenContainerLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReopenContainerLogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   150,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_goTypes,
		DependencyIndexes: file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_depIdxs,
		EnumInfos:         file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_enumTypes,
		MessageInfos:      file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_msgTypes,
	}.Build()
	File_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto = out.File
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_rawDesc = nil
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_goTypes = nil
	file_github_com_containerd_containerd_third_party_k8s_io_cri_api_pkg_apis_runtime_v1alpha2_api_proto_depIdxs = nil
}
