// Source: https://github.com/atlassian/react-beautiful-dnd

import { horizontal, vertical } from '../constants';
import { apply, isEqual, origin } from '../position';
import getScrollOnAxis from './get-scroll-on-axis';

// will replace -0 and replace with +0
var clean = apply(function (value) {
  return value === 0 ? 0 : value;
});
export default (function (_ref) {
  var dragStartTime = _ref.dragStartTime,
    container = _ref.container,
    center = _ref.center,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  // get distance to each edge
  var distanceToEdges = {
    top: center.y - container.top,
    right: container.right - center.x,
    bottom: container.bottom - center.y,
    left: center.x - container.left
  };

  // 1. Figure out which x,y values are the best target
  // 2. Can the container scroll in that direction at all?
  // If no for both directions, then return null
  // 3. Is the center close enough to a edge to start a drag?
  // 4. Based on the distance, calculate the speed at which a scroll should occur
  // The lower distance value the faster the scroll should be.
  // Maximum speed value should be hit before the distance is 0
  // Negative values to not continue to increase the speed
  var y = getScrollOnAxis({
    container: container,
    distanceToEdges: distanceToEdges,
    dragStartTime: dragStartTime,
    axis: vertical,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  var x = getScrollOnAxis({
    container: container,
    distanceToEdges: distanceToEdges,
    dragStartTime: dragStartTime,
    axis: horizontal,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  var required = clean({
    x: x,
    y: y
  });

  // nothing required
  if (isEqual(required, origin)) {
    return null;
  }
  return required;
});