'use client';
import { jsx } from 'react/jsx-runtime';
import { useRef } from 'react';
import { useMergedRef } from '@mantine/hooks';
import { createEventHandler } from '../../../core/utils/create-event-handler/create-event-handler.mjs';
import 'clsx';
import '../../../core/MantineProvider/Mantine.context.mjs';
import '../../../core/MantineProvider/default-theme.mjs';
import '../../../core/MantineProvider/MantineProvider.mjs';
import '../../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import { useProps } from '../../../core/MantineProvider/use-props/use-props.mjs';
import '../../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import '../../../core/Box/Box.mjs';
import { factory } from '../../../core/factory/factory.mjs';
import '../../../core/DirectionProvider/DirectionProvider.mjs';
import { Popover } from '../../Popover/Popover.mjs';
import '../../Popover/PopoverDropdown/PopoverDropdown.mjs';
import '../../Popover/PopoverTarget/PopoverTarget.mjs';
import { useMenuContext } from '../Menu.context.mjs';
import { useSubMenuContext } from '../MenuSub/MenuSub.context.mjs';
import classes from '../Menu.module.css.mjs';

const defaultProps = {};
const MenuSubDropdown = factory((props, ref) => {
  const {
    classNames,
    className,
    style,
    styles,
    vars,
    onMouseEnter,
    onMouseLeave,
    onKeyDown,
    children,
    ...others
  } = useProps("MenuSubDropdown", defaultProps, props);
  const wrapperRef = useRef(null);
  const ctx = useMenuContext();
  const subCtx = useSubMenuContext();
  const handleMouseEnter = createEventHandler(onMouseEnter, subCtx?.open);
  const handleMouseLeave = createEventHandler(onMouseLeave, subCtx?.close);
  return /* @__PURE__ */ jsx(
    Popover.Dropdown,
    {
      ...others,
      onMouseEnter: handleMouseEnter,
      onMouseLeave: handleMouseLeave,
      role: "menu",
      "aria-orientation": "vertical",
      ref: useMergedRef(ref, wrapperRef),
      ...ctx.getStyles("dropdown", {
        className,
        style,
        styles,
        classNames,
        withStaticClass: false
      }),
      tabIndex: -1,
      "data-menu-dropdown": true,
      children
    }
  );
});
MenuSubDropdown.classes = classes;
MenuSubDropdown.displayName = "@mantine/core/MenuSubDropdown";

export { MenuSubDropdown };
//# sourceMappingURL=MenuSubDropdown.mjs.map
