//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file field/field05/include/F05SteppingVerbose.hh
/// \brief Definition of the F05SteppingVerbose class
//
//---------------------------------------------------------------
//
// F05SteppingVerbose.hh
//
// Description:
//   This class manages the vervose outputs in G4SteppingManager.
//
//
// Contact:
//   Questions and comments to this code should be sent to
//     Katsuya Amako  (e-mail: Katsuya.Amako@kek.jp)
//     Takashi Sasaki (e-mail: Takashi.Sasaki@kek.jp)
//
//---------------------------------------------------------------

#ifndef F05SteppingVerbose_h
#define F05SteppingVerbose_h 1

#include "G4SteppingVerbose.hh"

class F05SteppingVerbose : public G4SteppingVerbose
{
  public:
    F05SteppingVerbose() = default;
    ~F05SteppingVerbose() override = default;

    G4VSteppingVerbose* Clone() override { return new F05SteppingVerbose; }

    void StepInfo() override;
    void TrackingStarted() override;
};

#endif
