/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.KeepClassSpecification;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassVisitor;

public class LibraryKeepChecker
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private String keepName;

    public LibraryKeepChecker(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List keepSpecifications) {
        if (keepSpecifications != null) {
            for (int index = 0; index < keepSpecifications.size(); ++index) {
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepSpecifications.get(index);
                this.keepName = keepClassSpecification.className;
                if (this.keepName == null) continue;
                KeepClassSpecificationVisitorFactory visitorFactory = new KeepClassSpecificationVisitorFactory(true, true, true);
                ClassCounter programClassCounter = new ClassCounter();
                this.programClassPool.accept(visitorFactory.createClassPoolVisitor(keepClassSpecification, (ClassVisitor)programClassCounter, null, null, null));
                if (programClassCounter.getCount() != 0) continue;
                this.libraryClassPool.accept(visitorFactory.createClassPoolVisitor(keepClassSpecification, (ClassVisitor)this, null, null, null));
            }
        }
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        String className = libraryClass.getName();
        this.notePrinter.print(className, "Note: the configuration explicitly specifies '" + ClassUtil.externalClassName(this.keepName) + "' to keep library class '" + ClassUtil.externalClassName(className) + "'");
    }
}

