/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.defaults.BreadthFirstWaitlist;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.StopSepOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ProgramLocationDependentTransferRelation;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.interfaces.StopOperator;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.interfaces.Waitlist;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Signature;

public class BamTransferRelation<CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, SignatureT extends Signature>
implements TransferRelation {
    private static final Logger log = LogManager.getLogger(BamTransferRelation.class);
    private final CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa;
    private final Cfa<CfaNodeT, CfaEdgeT, SignatureT> cfa;
    private final Stack<StackEntry> stack = new Stack();
    private boolean fixedPointReached = false;
    private final CfaNodeT mainLocation;
    private final BamCache<SignatureT> cache;
    private int maxCallStackDepth = -1;
    private final StopOperator fixedPointStopOperator;
    private final AbortOperator abortOperator;

    public BamTransferRelation(CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa, Cfa<CfaNodeT, CfaEdgeT, SignatureT> cfa, SignatureT mainFunction, BamCache<SignatureT> cache) {
        this(wrappedCpa, cfa, mainFunction, cache, -1, NeverAbortOperator.INSTANCE);
    }

    public BamTransferRelation(CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> wrappedCpa, Cfa<CfaNodeT, CfaEdgeT, SignatureT> cfa, SignatureT mainFunction, BamCache<SignatureT> cache, int maxCallStackDepth, AbortOperator abortOperator) {
        this.wrappedCpa = wrappedCpa;
        this.cfa = cfa;
        this.mainLocation = cfa.getFunctionEntryNode(mainFunction);
        this.cache = cache;
        this.fixedPointStopOperator = new StopSepOperator(wrappedCpa.getAbstractDomain());
        this.maxCallStackDepth = maxCallStackDepth;
        this.abortOperator = abortOperator;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState abstractState, Precision precision) {
        if (!(abstractState instanceof ProgramLocationDependent)) {
            throw new IllegalArgumentException("The abstract state of type " + AbstractState.class + " is not location dependent");
        }
        Object currentLocation = ((ProgramLocationDependent)((Object)abstractState)).getProgramLocation();
        ArrayList<? extends AbstractState> abstractSuccessors = new ArrayList<AbstractState>();
        if (this.stack.isEmpty() && currentLocation.equals(this.mainLocation)) {
            abstractSuccessors.addAll(this.fixedPoint(abstractState, currentLocation, precision));
        } else if (currentLocation.getLeavingEdges().stream().anyMatch(e -> e instanceof CallEdge)) {
            for (CfaEdge callEdge : currentLocation.getLeavingEdges().stream().filter(e -> e instanceof CallEdge).collect(Collectors.toList())) {
                if (!(this.maxCallStackDepth >= 0 && this.stack.size() >= this.maxCallStackDepth || callEdge.getTarget().isUnknownNode())) {
                    abstractSuccessors.addAll(this.applyBlockAbstraction(abstractState, precision, (CfaEdge)((Object)((CallEdge)((Object)callEdge)))));
                    continue;
                }
                abstractSuccessors.add(((ProgramLocationDependentTransferRelation)this.wrappedCpa.getTransferRelation()).getEdgeAbstractSuccessor(abstractState, callEdge, precision));
            }
        } else {
            abstractSuccessors.addAll(this.wrappedCpa.getTransferRelation().getAbstractSuccessors(abstractState, precision));
        }
        return abstractSuccessors;
    }

    public int getMaxCallStackDepth() {
        return this.maxCallStackDepth;
    }

    public CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT> getWrappedCpa() {
        return this.wrappedCpa;
    }

    protected Waitlist getWaitlist() {
        return new BreadthFirstWaitlist();
    }

    protected ReachedSet getReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }

    public BamCache<SignatureT> getCache() {
        return this.cache;
    }

    private Collection<? extends AbstractState> fixedPoint(AbstractState entryState, CfaNodeT currentLocation, Precision precision) {
        Collection<Object> blockResult = Collections.emptyList();
        while (!this.fixedPointReached) {
            this.fixedPointReached = true;
            blockResult = this.applyBlockAbstraction(entryState, precision, null);
        }
        return blockResult;
    }

    private <CfaCallEdgeT extends CfaEdge<CfaNodeT> & CallEdge> Collection<? extends AbstractState> applyBlockAbstraction(AbstractState callState, Precision precision, CfaCallEdgeT callEdge) {
        BlockAbstraction cacheEntry;
        ReachedSet reached = this.getReachedSet();
        Waitlist waitlist = this.getWaitlist();
        Call call = callEdge == null ? null : ((CallEdge)callEdge).getCall();
        Object entryNode = call != null ? this.cfa.getFunctionEntryNode(callEdge.getTarget().getSignature()) : ((ProgramLocationDependent)((Object)callState)).getProgramLocation();
        Object currentFunction = entryNode.getSignature();
        AbstractState reducedEntryState = call != null ? this.wrappedCpa.getReduceOperator().reduce(callState, this.cfa.getFunctionEntryNode(currentFunction), call) : callState;
        Optional<AbstractState> previousCall = this.stack.stream().filter(x -> ((Signature)x.function).equals(currentFunction) && this.wrappedCpa.getAbstractDomain().isLessOrEqual(reducedEntryState, x.entryState)).map(x -> x.entryState).findFirst();
        if (previousCall.isPresent()) {
            cacheEntry = this.cache.get(previousCall.get(), precision, currentFunction);
            if (cacheEntry != null) {
                reached = cacheEntry.getReachedSet();
            } else {
                this.stack.peek().incompleteCallStates.add(callState);
                this.fixedPointReached = false;
            }
        } else {
            cacheEntry = this.cache.get(reducedEntryState, precision, currentFunction);
            if (cacheEntry != null) {
                reached = cacheEntry.getReachedSet();
                waitlist = cacheEntry.getWaitlist();
            } else {
                reached.add(reducedEntryState);
                waitlist.add(reducedEntryState);
            }
            this.stack.push(new StackEntry(this, currentFunction, reducedEntryState));
            new CpaAlgorithm(this, this.wrappedCpa.getMergeOperator(), this.wrappedCpa.getStopOperator(), this.wrappedCpa.getPrecisionAdjustment()).run(reached, waitlist, this.abortOperator);
            StackEntry stackEntry = this.stack.pop();
            if (!stackEntry.incompleteCallStates.isEmpty()) {
                if (!this.stack.isEmpty()) {
                    this.stack.peek().incompleteCallStates.add(callState);
                }
                for (AbstractState incompleteCallState : stackEntry.incompleteCallStates) {
                    waitlist.add(incompleteCallState);
                }
            }
            if ((cacheEntry = this.cache.get(reducedEntryState, precision, currentFunction)) != null) {
                ReachedSet reachedOld = cacheEntry.getReachedSet();
                for (AbstractState abstractState : reached.asCollection()) {
                    Object reachedLocation = ((ProgramLocationDependent)((Object)abstractState)).getProgramLocation();
                    if (!((Signature)reachedLocation.getSignature()).equals(currentFunction) || !reachedLocation.isExitNode() || this.fixedPointStopOperator.stop(abstractState, reachedOld.asCollection(), null)) continue;
                    if (!this.stack.isEmpty()) {
                        this.stack.peek().incompleteCallStates.add(callState);
                    }
                    this.fixedPointReached = false;
                    break;
                }
            }
            this.cache.put(reducedEntryState, precision, currentFunction, new BlockAbstraction(reached, waitlist));
        }
        Collection exitStates = reached.asCollection();
        if (call != null) {
            exitStates = exitStates.stream().filter(e -> ((ProgramLocationDependent)((Object)e)).getProgramLocation().isExitNode()).map(e -> this.wrappedCpa.getExpandOperator().expand(callState, (AbstractState)e, (CfaNode)entryNode, call)).map(e -> this.wrappedCpa.getRebuildOperator().rebuild(callState, (AbstractState)e)).collect(Collectors.toSet());
        }
        return exitStates;
    }

    private static class StackEntry {
        public final SignatureT function;
        public final AbstractState entryState;
        public final Set<AbstractState> incompleteCallStates = new HashSet<AbstractState>();
        final /* synthetic */ BamTransferRelation this$0;

        public StackEntry(SignatureT function, AbstractState entryState) {
            this.this$0 = var1_1;
            this.function = function;
            this.entryState = entryState;
        }
    }
}

