/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

public class KotlinStringUtil {
    private KotlinStringUtil() {
    }

    public static String capitializeFirstCharacterAsciiOnly(String s) {
        if (s.length() == 0) {
            return s;
        }
        char firstChar = s.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            return Character.toUpperCase(firstChar) + s.substring(1);
        }
        return s;
    }

    public static String decapitializeFirstCharacterAsciiOnly(String s) {
        if (s.length() == 0) {
            return s;
        }
        char firstChar = s.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            return Character.toLowerCase(firstChar) + s.substring(1);
        }
        return s;
    }

    public static String decapitializeForKotlinCompiler(String s) {
        if (s.length() == 0 || !KotlinStringUtil.isUpperCaseAsciiCharAt(s, 0)) {
            return s;
        }
        if (s.length() == 1 || !KotlinStringUtil.isUpperCaseAsciiCharAt(s, 1)) {
            return KotlinStringUtil.decapitializeFirstCharacterAsciiOnly(s);
        }
        int secondWordStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (KotlinStringUtil.isUpperCaseAsciiCharAt(s, i)) continue;
            secondWordStart = i;
            break;
        }
        return secondWordStart == -1 ? KotlinStringUtil.toLowerCaseAsciiOnly(s) : KotlinStringUtil.toLowerCaseAsciiOnly(s.substring(0, secondWordStart)) + s.substring(secondWordStart);
    }

    private static boolean isUpperCaseAsciiCharAt(String s, int index) {
        char charAtIndex = s.charAt(index);
        return charAtIndex >= 'A' && charAtIndex <= 'Z';
    }

    private static String toLowerCaseAsciiOnly(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

