/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ResourceFilePool {
    private final Map<String, ResourceFile> resourceFileMap = new TreeMap<String, ResourceFile>();

    public ResourceFilePool() {
    }

    public ResourceFilePool(ResourceFile ... resourceFiles) {
        for (ResourceFile resourceFile : resourceFiles) {
            this.addResourceFile(resourceFile);
        }
    }

    public ResourceFilePool(Iterable<? extends ResourceFile> resourceFiles) {
        for (ResourceFile resourceFile : resourceFiles) {
            this.addResourceFile(resourceFile);
        }
    }

    public void clear() {
        this.resourceFileMap.clear();
    }

    public void addResourceFile(ResourceFile resourceFile) {
        this.addResourceFile(resourceFile.getFileName(), resourceFile);
    }

    public void addResourceFile(String fileName, ResourceFile resourceFile) {
        this.resourceFileMap.put(fileName, resourceFile);
    }

    public void removeResourceFile(String fileName) {
        this.resourceFileMap.remove(fileName);
    }

    public ResourceFile getResourceFile(String fileName) {
        return this.resourceFileMap.get(fileName);
    }

    public int size() {
        return this.resourceFileMap.size();
    }

    public ResourceFilePool refreshedCopy() {
        return new ResourceFilePool(this.resourceFileMap.values());
    }

    public Set<String> resourceFileNames() {
        return this.resourceFileMap.keySet();
    }

    public void resourceFilesAccept(ResourceFileVisitor resourceFileVisitor) {
        for (Map.Entry<String, ResourceFile> entry : this.resourceFileMap.entrySet()) {
            entry.getValue().accept(resourceFileVisitor);
        }
    }

    public void resourceFilesAccept(String fileNameFilter, ResourceFileVisitor resourceFileVisitor) {
        this.resourceFilesAccept(new ListParser(new FileNameParser()).parse(fileNameFilter), resourceFileVisitor);
    }

    public void resourceFilesAccept(List<String> fileNameFilter, ResourceFileVisitor resourceFileVisitor) {
        this.resourceFilesAccept(new ListParser(new FileNameParser()).parse(fileNameFilter), resourceFileVisitor);
    }

    public void resourceFilesAccept(StringMatcher fileNameFilter, ResourceFileVisitor resourceFileVisitor) {
        for (Map.Entry<String, ResourceFile> entry : this.resourceFileMap.entrySet()) {
            String fileName = entry.getKey();
            if (!fileNameFilter.matches(fileName)) continue;
            ResourceFile resourceFile = entry.getValue();
            resourceFile.accept(resourceFileVisitor);
        }
    }

    public void resourceFileAccept(String fileName, ResourceFileVisitor resourceFileVisitor) {
        ResourceFile resourceFile = this.getResourceFile(fileName);
        if (resourceFile != null) {
            resourceFile.accept(resourceFileVisitor);
        }
    }

    public String toString() {
        return this.resourceFileMap.toString();
    }
}

