/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.kbs;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.svr2.Pin;
import org.signal.libsignal.svr2.PinHash;
import org.whispersystems.signalservice.api.crypto.HmacSIV;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.api.kbs.KbsData;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.kbs.PinString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/kbs/PinHashUtil;", "", "()V", "createNewKbsData", "Lorg/whispersystems/signalservice/api/kbs/KbsData;", "pinHash", "Lorg/signal/libsignal/svr2/PinHash;", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "decryptSvrDataIVCipherText", "ivc", "", "hashPin", "pin", "", "salt", "localPinHash", "normalize", "normalizeToString", "verifyLocalPinHash", "", "signal-service-java"})
public final class PinHashUtil {
    @NotNull
    public static final PinHashUtil INSTANCE = new PinHashUtil();

    private PinHashUtil() {
    }

    @JvmStatic
    @NotNull
    public static final PinHash hashPin(@NotNull String pin, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        PinHash pinHash = PinHash.svr1((byte[])PinHashUtil.normalize(pin), (byte[])salt);
        Intrinsics.checkNotNullExpressionValue((Object)pinHash, (String)"svr1(...)");
        return pinHash;
    }

    @JvmStatic
    @NotNull
    public static final String localPinHash(@NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        String string = Pin.localHash((byte[])PinHashUtil.normalize(pin));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localHash(...)");
        return string;
    }

    @JvmStatic
    public static final boolean verifyLocalPinHash(@NotNull String localPinHash, @NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)localPinHash, (String)"localPinHash");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        return Pin.verifyLocalHash((String)localPinHash, (byte[])PinHashUtil.normalize(pin));
    }

    @JvmStatic
    @NotNull
    public static final KbsData createNewKbsData(@NotNull PinHash pinHash, @NotNull MasterKey masterKey) {
        Intrinsics.checkNotNullParameter((Object)pinHash, (String)"pinHash");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        byte[] ivc = HmacSIV.encrypt(pinHash.encryptionKey(), masterKey.serialize());
        return new KbsData(masterKey, pinHash.accessKey(), ivc);
    }

    @JvmStatic
    @NotNull
    public static final KbsData decryptSvrDataIVCipherText(@NotNull PinHash pinHash, @Nullable byte[] ivc) throws InvalidCiphertextException {
        Intrinsics.checkNotNullParameter((Object)pinHash, (String)"pinHash");
        byte[] masterKey = HmacSIV.decrypt(pinHash.encryptionKey(), ivc);
        return new KbsData(new MasterKey(masterKey), pinHash.accessKey(), ivc);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeToString(@NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        String normalizedPin = ((Object)StringsKt.trim((CharSequence)pin)).toString();
        if (PinString.allNumeric(normalizedPin)) {
            String string = PinString.toArabic(normalizedPin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toArabic(...)");
            normalizedPin = string;
        }
        String string = Normalizer.normalize(normalizedPin, Normalizer.Form.NFKD);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] normalize(@NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        String string = PinHashUtil.normalizeToString(pin);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }
}

