/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.payments;

import java.math.BigDecimal;
import java.text.NumberFormat;
import org.whispersystems.signalservice.api.payments.Currency;
import org.whispersystems.signalservice.api.payments.FormatterOptions;

public abstract class Formatter {
    protected final FormatterOptions formatterOptions;

    private Formatter(FormatterOptions formatterOptions) {
        this.formatterOptions = formatterOptions;
    }

    public abstract String format(BigDecimal var1);

    static Formatter forMoney(Currency currency, FormatterOptions formatterOptions) {
        return new CryptoFormatter(currency, formatterOptions);
    }

    static Formatter forFiat(java.util.Currency currency, FormatterOptions formatterOptions) {
        return new FiatFormatter(currency, formatterOptions);
    }

    private static final class CryptoFormatter
    extends Formatter {
        private final Currency currency;

        private CryptoFormatter(Currency currency, FormatterOptions formatterOptions) {
            super(formatterOptions);
            this.currency = currency;
        }

        @Override
        public String format(BigDecimal amount) {
            NumberFormat format = NumberFormat.getNumberInstance(this.formatterOptions.locale);
            BigDecimal toFormat = this.formatterOptions.alwaysPositive ? amount.abs() : amount;
            StringBuilder builder = new StringBuilder();
            format.setMaximumFractionDigits(Math.min(this.currency.getDecimalPrecision(), this.formatterOptions.maximumFractionDigits));
            if (toFormat.signum() == 1 && this.formatterOptions.alwaysPrefixWithSign) {
                builder.append("+");
            }
            builder.append(format.format(toFormat));
            if (this.formatterOptions.withSpaceBeforeUnit && this.formatterOptions.withUnit) {
                builder.append(" ");
            }
            if (this.formatterOptions.withUnit) {
                builder.append(this.currency.getCurrencyCode());
            }
            return builder.toString();
        }
    }

    private static final class FiatFormatter
    extends Formatter {
        private final java.util.Currency javaCurrency;

        private FiatFormatter(java.util.Currency javaCurrency, FormatterOptions formatterOptions) {
            super(formatterOptions);
            this.javaCurrency = javaCurrency;
        }

        @Override
        public String format(BigDecimal amount) {
            NumberFormat numberFormat;
            BigDecimal toFormat = this.formatterOptions.alwaysPositive ? amount.abs() : amount;
            StringBuilder builder = new StringBuilder();
            if (this.formatterOptions.withUnit) {
                numberFormat = NumberFormat.getCurrencyInstance(this.formatterOptions.locale);
                numberFormat.setCurrency(this.javaCurrency);
            } else {
                numberFormat = NumberFormat.getNumberInstance(this.formatterOptions.locale);
                numberFormat.setMinimumFractionDigits(this.javaCurrency.getDefaultFractionDigits());
            }
            numberFormat.setMaximumFractionDigits(Math.min(this.javaCurrency.getDefaultFractionDigits(), this.formatterOptions.maximumFractionDigits));
            builder.append(numberFormat.format(toFormat));
            return builder.toString();
        }
    }
}

