/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import org.asamk.signal.manager.api.ServiceEnvironment;
import org.asamk.signal.manager.config.LiveConfig;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.config.StagingConfig;
import org.signal.libsignal.protocol.util.Medium;
import org.whispersystems.signalservice.api.account.AccountAttributes;

public class ServiceConfig {
    public static final int PREKEY_MINIMUM_COUNT = 10;
    public static final int PREKEY_BATCH_SIZE = 100;
    public static final int PREKEY_MAXIMUM_ID = Medium.MAX_VALUE;
    public static final long PREKEY_ARCHIVE_AGE = TimeUnit.DAYS.toMillis(30L);
    public static final long PREKEY_STALE_AGE = TimeUnit.DAYS.toMillis(90L);
    public static final long SIGNED_PREKEY_ROTATE_AGE = TimeUnit.DAYS.toMillis(2L);
    public static final int MAX_ATTACHMENT_SIZE = 0x9600000;
    public static final long MAX_ENVELOPE_SIZE = 0L;
    public static final int MAX_MESSAGE_BODY_SIZE = 2000;
    public static final long AVATAR_DOWNLOAD_FAILSAFE_MAX_SIZE = 0xA00000L;
    public static final boolean AUTOMATIC_NETWORK_RETRY = true;
    public static final int GROUP_MAX_SIZE = 1001;
    public static final int MAXIMUM_ONE_OFF_REQUEST_SIZE = 3;
    public static final long UNREGISTERED_LIFESPAN = TimeUnit.DAYS.toMillis(30L);

    public static AccountAttributes.Capabilities getCapabilities(boolean isPrimaryDevice) {
        boolean deleteSync = !isPrimaryDevice;
        return new AccountAttributes.Capabilities(true, deleteSync, true);
    }

    public static ServiceEnvironmentConfig getServiceEnvironmentConfig(ServiceEnvironment serviceEnvironment, String userAgent) {
        Interceptor userAgentInterceptor = chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build());
        List<Interceptor> interceptors = List.of(userAgentInterceptor);
        return switch (serviceEnvironment) {
            default -> throw new MatchException(null, null);
            case ServiceEnvironment.LIVE -> LiveConfig.getServiceEnvironmentConfig(interceptors);
            case ServiceEnvironment.STAGING -> StagingConfig.getServiceEnvironmentConfig(interceptors);
        };
    }
}

