/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.AccountRecordProcessor;
import org.asamk.signal.manager.syncStorage.ContactRecordProcessor;
import org.asamk.signal.manager.syncStorage.GroupV1RecordProcessor;
import org.asamk.signal.manager.syncStorage.GroupV2RecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.syncStorage.StorageSyncValidations;
import org.asamk.signal.manager.syncStorage.WriteOperationResult;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.core.util.SetUtil;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;

public class StorageHelper {
    private static final Logger logger = LoggerFactory.getLogger(StorageHelper.class);
    private static final List<Integer> KNOWN_TYPES = List.of(Integer.valueOf(ManifestRecord.Identifier.Type.CONTACT.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.GROUPV1.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.GROUPV2.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.ACCOUNT.getValue()));
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public StorageHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void syncDataWithStorage() throws IOException {
        SignalStorageManifest remoteManifest;
        StorageKey storageKey = this.account.getOrCreateStorageKey();
        if (storageKey == null) {
            if (!this.account.isPrimaryDevice()) {
                logger.debug("Storage key unknown, requesting from primary device.");
                this.context.getSyncHelper().requestSyncKeys();
            }
            return;
        }
        logger.trace("Reading manifest from remote storage");
        long localManifestVersion = this.account.getStorageManifestVersion();
        SignalStorageManifest localManifest = this.account.getStorageManifest().orElse(SignalStorageManifest.EMPTY);
        try {
            remoteManifest = this.dependencies.getAccountManager().getStorageManifestIfDifferentVersion(storageKey, localManifestVersion).orElse(localManifest);
        }
        catch (InvalidKeyException e) {
            logger.warn("Manifest couldn't be decrypted.");
            if (this.account.isPrimaryDevice()) {
                try {
                    this.forcePushToStorage(storageKey);
                }
                catch (RetryLaterException rle) {
                    return;
                }
            }
            return;
        }
        logger.trace("Manifest versions: local {}, remote {}", (Object)localManifestVersion, (Object)remoteManifest.getVersion());
        boolean needsForcePush = false;
        if (remoteManifest.getVersion() > localManifestVersion) {
            logger.trace("Remote version was newer, reading records.");
            needsForcePush = this.readDataFromStorage(storageKey, localManifest, remoteManifest);
        } else if (remoteManifest.getVersion() < localManifest.getVersion()) {
            logger.debug("Remote storage manifest version was older. User might have switched accounts.");
        }
        logger.trace("Done reading data from remote storage");
        if (localManifest != remoteManifest) {
            this.storeManifestLocally(remoteManifest);
        }
        this.readRecordsWithPreviouslyUnknownTypes(storageKey);
        logger.trace("Adding missing storageIds to local data");
        this.account.getRecipientStore().setMissingStorageIds();
        this.account.getGroupStore().setMissingStorageIds();
        boolean needsMultiDeviceSync = false;
        try {
            needsMultiDeviceSync = this.writeToStorage(storageKey, remoteManifest, needsForcePush);
        }
        catch (RetryLaterException e) {
            return;
        }
        if (needsForcePush) {
            logger.debug("Doing a force push.");
            try {
                this.forcePushToStorage(storageKey);
                needsMultiDeviceSync = true;
            }
            catch (RetryLaterException e) {
                return;
            }
        }
        if (needsMultiDeviceSync) {
            this.context.getSyncHelper().sendSyncFetchStorageMessage();
        }
        logger.debug("Done syncing data with remote storage");
    }

    private boolean readDataFromStorage(StorageKey storageKey, SignalStorageManifest localManifest, SignalStorageManifest remoteManifest) throws IOException {
        boolean needsForcePush = false;
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            int updated;
            connection.setAutoCommit(false);
            IdDifferenceResult idDifference = StorageHelper.findIdDifference(remoteManifest.getStorageIds(), localManifest.getStorageIds());
            if (idDifference.hasTypeMismatches() && this.account.isPrimaryDevice()) {
                logger.debug("Found type mismatches in the ID sets! Scheduling a force push after this sync completes.");
                needsForcePush = true;
            }
            logger.debug("Pre-Merge ID Difference :: " + String.valueOf(idDifference));
            if (!idDifference.localOnlyIds().isEmpty() && (updated = this.account.getRecipientStore().removeStorageIdsFromLocalOnlyUnregisteredRecipients(connection, idDifference.localOnlyIds())) > 0) {
                logger.warn("Found {} records that were deleted remotely but only marked unregistered locally. Removed those from local store.", (Object)updated);
            }
            if (!idDifference.isEmpty()) {
                List<SignalStorageRecord> remoteOnlyRecords = this.getSignalStorageRecords(storageKey, idDifference.remoteOnlyIds());
                if (remoteOnlyRecords.size() != idDifference.remoteOnlyIds().size()) {
                    logger.debug("Could not find all remote-only records! Requested: " + idDifference.remoteOnlyIds().size() + ", Found: " + remoteOnlyRecords.size() + ". These stragglers should naturally get deleted during the sync.");
                }
                List<StorageId> unknownInserts = this.processKnownRecords(connection, remoteOnlyRecords);
                List<StorageId> unknownDeletes = idDifference.localOnlyIds().stream().filter(id -> !KNOWN_TYPES.contains(id.getType())).toList();
                logger.debug("Storage ids with unknown type: {} inserts, {} deletes", (Object)unknownInserts.size(), (Object)unknownDeletes.size());
                this.account.getUnknownStorageIdStore().addUnknownStorageIds(connection, unknownInserts);
                this.account.getUnknownStorageIdStore().deleteUnknownStorageIds(connection, unknownDeletes);
            } else {
                logger.debug("Remote version was newer, but there were no remote-only IDs.");
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        return needsForcePush;
    }

    private void readRecordsWithPreviouslyUnknownTypes(StorageKey storageKey) throws IOException {
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            List<StorageId> knownUnknownIds = this.account.getUnknownStorageIdStore().getUnknownStorageIds(connection, KNOWN_TYPES);
            if (!knownUnknownIds.isEmpty()) {
                logger.debug("We have " + knownUnknownIds.size() + " unknown records that we can now process.");
                List<SignalStorageRecord> remote = this.getSignalStorageRecords(storageKey, knownUnknownIds);
                logger.debug("Found " + remote.size() + " of the known-unknowns remotely.");
                this.processKnownRecords(connection, remote);
                this.account.getUnknownStorageIdStore().deleteUnknownStorageIds(connection, remote.stream().map(SignalStorageRecord::getId).toList());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
    }

    private boolean writeToStorage(StorageKey storageKey, SignalStorageManifest remoteManifest, boolean needsForcePush) throws IOException, RetryLaterException {
        Optional conflict;
        WriteOperationResult remoteWriteOperation;
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            List<StorageId> localStorageIds = this.getAllLocalStorageIds(connection);
            IdDifferenceResult idDifference = StorageHelper.findIdDifference(remoteManifest.getStorageIds(), localStorageIds);
            logger.debug("ID Difference :: " + String.valueOf(idDifference));
            List<byte[]> remoteDeletes = idDifference.remoteOnlyIds().stream().map(StorageId::getRaw).toList();
            List<SignalStorageRecord> remoteInserts = this.buildLocalStorageRecords(connection, idDifference.localOnlyIds());
            remoteWriteOperation = new WriteOperationResult(new SignalStorageManifest(remoteManifest.getVersion() + 1L, this.account.getDeviceId(), localStorageIds), remoteInserts, remoteDeletes);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        if (remoteWriteOperation.isEmpty()) {
            logger.debug("No remote writes needed. Still at version: " + remoteManifest.getVersion());
            return false;
        }
        logger.debug("We have something to write remotely.");
        logger.debug("WriteOperationResult :: " + String.valueOf(remoteWriteOperation));
        StorageSyncValidations.validate(remoteWriteOperation, remoteManifest, needsForcePush, this.account.getSelfRecipientAddress());
        try {
            conflict = this.dependencies.getAccountManager().writeStorageRecords(storageKey, remoteWriteOperation.manifest(), remoteWriteOperation.inserts(), remoteWriteOperation.deletes());
        }
        catch (InvalidKeyException e) {
            logger.warn("Failed to decrypt conflicting storage manifest: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        if (conflict.isPresent()) {
            logger.debug("Hit a conflict when trying to resolve the conflict! Retrying.");
            throw new RetryLaterException();
        }
        logger.debug("Saved new manifest. Now at version: " + remoteWriteOperation.manifest().getVersion());
        this.storeManifestLocally(remoteWriteOperation.manifest());
        return true;
    }

    private void forcePushToStorage(StorageKey storageServiceKey) throws IOException, RetryLaterException {
        Optional conflict;
        Map<GroupIdV2, StorageId> newGroupV2StorageIds;
        Map<GroupIdV1, StorageId> newGroupV1StorageIds;
        Map<RecipientId, StorageId> newContactStorageIds;
        logger.debug("Force pushing local state to remote storage");
        long currentVersion = this.dependencies.getAccountManager().getStorageManifestVersion();
        long newVersion = currentVersion + 1L;
        ArrayList<SignalStorageRecord> newStorageRecords = new ArrayList<SignalStorageRecord>();
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            SignalStorageRecord record;
            connection.setAutoCommit(false);
            List<RecipientId> recipientIds = this.account.getRecipientStore().getRecipientIds(connection);
            newContactStorageIds = this.generateContactStorageIds(recipientIds);
            for (RecipientId recipientId : recipientIds) {
                Recipient recipient;
                StorageId storageId = newContactStorageIds.get(recipientId);
                if (storageId.getType() == ManifestRecord.Identifier.Type.ACCOUNT.getValue()) {
                    recipient = this.account.getRecipientStore().getRecipient(connection, recipientId);
                    SignalStorageRecord accountRecord = StorageSyncModels.localToRemoteRecord(this.account.getConfigurationStore(), recipient, this.account.getUsernameLink(), storageId.getRaw());
                    newStorageRecords.add(accountRecord);
                    continue;
                }
                recipient = this.account.getRecipientStore().getRecipient(connection, recipientId);
                String address = recipient.getAddress().getIdentifier();
                IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(connection, address);
                record = StorageSyncModels.localToRemoteRecord(recipient, identity, storageId.getRaw());
                newStorageRecords.add(record);
            }
            List<GroupIdV1> groupV1Ids = this.account.getGroupStore().getGroupV1Ids(connection);
            newGroupV1StorageIds = this.generateGroupV1StorageIds(groupV1Ids);
            for (GroupIdV1 groupId : groupV1Ids) {
                StorageId storageId = newGroupV1StorageIds.get(groupId);
                GroupInfoV1 group = this.account.getGroupStore().getGroup(connection, groupId);
                SignalStorageRecord record2 = StorageSyncModels.localToRemoteRecord(group, storageId.getRaw());
                newStorageRecords.add(record2);
            }
            List<GroupIdV2> list = this.account.getGroupStore().getGroupV2Ids(connection);
            newGroupV2StorageIds = this.generateGroupV2StorageIds(list);
            for (GroupIdV2 groupId : list) {
                StorageId storageId = newGroupV2StorageIds.get(groupId);
                GroupInfoV2 group = this.account.getGroupStore().getGroup(connection, groupId);
                record = StorageSyncModels.localToRemoteRecord(group, storageId.getRaw());
                newStorageRecords.add(record);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        List<StorageId> newStorageIds = newStorageRecords.stream().map(SignalStorageRecord::getId).toList();
        SignalStorageManifest manifest = new SignalStorageManifest(newVersion, this.account.getDeviceId(), newStorageIds);
        StorageSyncValidations.validateForcePush(manifest, newStorageRecords, this.account.getSelfRecipientAddress());
        try {
            if (newVersion > 1L) {
                logger.trace("Force-pushing data. Inserting {} IDs.", (Object)newStorageRecords.size());
                conflict = this.dependencies.getAccountManager().resetStorageRecords(storageServiceKey, manifest, newStorageRecords);
            } else {
                logger.trace("First version, normal push. Inserting {} IDs.", (Object)newStorageRecords.size());
                conflict = this.dependencies.getAccountManager().writeStorageRecords(storageServiceKey, manifest, newStorageRecords, Collections.emptyList());
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.debug("Hit an invalid key exception, which likely indicates a conflict.", (Throwable)invalidKeyException);
            throw new RetryLaterException();
        }
        if (conflict.isPresent()) {
            logger.debug("Hit a conflict. Trying again.");
            throw new RetryLaterException();
        }
        logger.debug("Force push succeeded. Updating local manifest version to: " + manifest.getVersion());
        this.storeManifestLocally(manifest);
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            this.account.getRecipientStore().updateStorageIds(connection, newContactStorageIds);
            this.account.getGroupStore().updateStorageIds(connection, newGroupV1StorageIds, newGroupV2StorageIds);
            this.account.getUnknownStorageIdStore().deleteAllUnknownStorageIds(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to sync remote storage", sQLException);
        }
    }

    private Map<RecipientId, StorageId> generateContactStorageIds(List<RecipientId> recipientIds) {
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        return recipientIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> {
            if (recipientId.equals(selfRecipientId)) {
                return StorageId.forAccount((byte[])KeyUtils.createRawStorageId());
            }
            return StorageId.forContact((byte[])KeyUtils.createRawStorageId());
        }));
    }

    private Map<GroupIdV1, StorageId> generateGroupV1StorageIds(List<GroupIdV1> groupIds) {
        return groupIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> StorageId.forGroupV1((byte[])KeyUtils.createRawStorageId())));
    }

    private Map<GroupIdV2, StorageId> generateGroupV2StorageIds(List<GroupIdV2> groupIds) {
        return groupIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> StorageId.forGroupV2((byte[])KeyUtils.createRawStorageId())));
    }

    private void storeManifestLocally(SignalStorageManifest remoteManifest) {
        this.account.setStorageManifestVersion(remoteManifest.getVersion());
        this.account.setStorageManifest(remoteManifest);
    }

    private List<SignalStorageRecord> getSignalStorageRecords(StorageKey storageKey, List<StorageId> storageIds) throws IOException {
        List records;
        try {
            records = this.dependencies.getAccountManager().readStorageRecords(storageKey, storageIds);
        }
        catch (InvalidKeyException e) {
            logger.warn("Failed to read storage records, ignoring.");
            return List.of();
        }
        return records;
    }

    private List<StorageId> getAllLocalStorageIds(Connection connection) throws SQLException {
        ArrayList<StorageId> storageIds = new ArrayList<StorageId>();
        storageIds.addAll(this.account.getUnknownStorageIdStore().getUnknownStorageIds(connection));
        storageIds.addAll(this.account.getGroupStore().getStorageIds(connection));
        storageIds.addAll(this.account.getRecipientStore().getStorageIds(connection));
        storageIds.add(this.account.getRecipientStore().getSelfStorageId(connection));
        return storageIds;
    }

    private List<SignalStorageRecord> buildLocalStorageRecords(Connection connection, List<StorageId> storageIds) throws SQLException {
        ArrayList<SignalStorageRecord> records = new ArrayList<SignalStorageRecord>();
        for (StorageId storageId : storageIds) {
            SignalStorageRecord record = this.buildLocalStorageRecord(connection, storageId);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private SignalStorageRecord buildLocalStorageRecord(Connection connection, StorageId storageId) throws SQLException {
        ManifestRecord.Identifier.Type type = ManifestRecord.Identifier.Type.fromValue((int)storageId.getType());
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CONTACT", "GROUPV1", "GROUPV2", "ACCOUNT"}, (ManifestRecord.Identifier.Type)type, n)) {
            case 0 -> {
                Recipient recipient = this.account.getRecipientStore().getRecipient(connection, storageId);
                String address = recipient.getAddress().getIdentifier();
                IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(connection, address);
                yield StorageSyncModels.localToRemoteRecord(recipient, identity, storageId.getRaw());
            }
            case 1 -> {
                GroupInfoV1 groupV1 = this.account.getGroupStore().getGroupV1(connection, storageId);
                yield StorageSyncModels.localToRemoteRecord(groupV1, storageId.getRaw());
            }
            case 2 -> {
                GroupInfoV2 groupV2 = this.account.getGroupStore().getGroupV2(connection, storageId);
                yield StorageSyncModels.localToRemoteRecord(groupV2, storageId.getRaw());
            }
            case 3 -> {
                Recipient selfRecipient = this.account.getRecipientStore().getRecipient(connection, this.account.getSelfRecipientId());
                yield StorageSyncModels.localToRemoteRecord(this.account.getConfigurationStore(), selfRecipient, this.account.getUsernameLink(), storageId.getRaw());
            }
            default -> throw new AssertionError((Object)("Got unknown local storage record type: " + String.valueOf(storageId)));
        };
    }

    private static IdDifferenceResult findIdDifference(Collection<StorageId> remoteIds, Collection<StorageId> localIds) {
        Base64.Encoder base64Encoder = Base64.getEncoder();
        Map<String, StorageId> remoteByRawId = remoteIds.stream().collect(Collectors.toMap(id -> base64Encoder.encodeToString(id.getRaw()), id -> id));
        Map<String, StorageId> localByRawId = localIds.stream().collect(Collectors.toMap(id -> base64Encoder.encodeToString(id.getRaw()), id -> id));
        boolean hasTypeMismatch = remoteByRawId.size() != remoteIds.size() || localByRawId.size() != localIds.size();
        Set remoteOnlyRawIds = SetUtil.difference(remoteByRawId.keySet(), localByRawId.keySet());
        Set localOnlyRawIds = SetUtil.difference(localByRawId.keySet(), remoteByRawId.keySet());
        Set sharedRawIds = SetUtil.intersection(localByRawId.keySet(), remoteByRawId.keySet());
        for (String rawId : sharedRawIds) {
            StorageId remote = remoteByRawId.get(rawId);
            StorageId local = localByRawId.get(rawId);
            if (remote.getType() == local.getType() || local.getType() == 0) continue;
            remoteOnlyRawIds.remove(rawId);
            localOnlyRawIds.remove(rawId);
            hasTypeMismatch = true;
            logger.debug("Remote type {} did not match local type {} for {}!", new Object[]{remote.getType(), local.getType(), rawId});
        }
        List<StorageId> remoteOnlyKeys = remoteOnlyRawIds.stream().map(remoteByRawId::get).toList();
        List<StorageId> localOnlyKeys = localOnlyRawIds.stream().map(localByRawId::get).toList();
        return new IdDifferenceResult(remoteOnlyKeys, localOnlyKeys, hasTypeMismatch);
    }

    private List<StorageId> processKnownRecords(Connection connection, List<SignalStorageRecord> records) throws SQLException {
        ArrayList<StorageId> unknownRecords = new ArrayList<StorageId>();
        AccountRecordProcessor accountRecordProcessor = new AccountRecordProcessor(this.account, connection, this.context.getJobExecutor());
        ContactRecordProcessor contactRecordProcessor = new ContactRecordProcessor(this.account, connection, this.context.getJobExecutor());
        GroupV1RecordProcessor groupV1RecordProcessor = new GroupV1RecordProcessor(this.account, connection);
        GroupV2RecordProcessor groupV2RecordProcessor = new GroupV2RecordProcessor(this.account, connection);
        block6: for (SignalStorageRecord record : records) {
            logger.debug("Reading record of type {}", (Object)record.getType());
            ManifestRecord.Identifier.Type type = ManifestRecord.Identifier.Type.fromValue((int)record.getType());
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ACCOUNT", "GROUPV1", "GROUPV2", "CONTACT"}, (ManifestRecord.Identifier.Type)type, n)) {
                case 0: {
                    accountRecordProcessor.process((SignalRecord)((SignalAccountRecord)record.getAccount().get()));
                    continue block6;
                }
                case 1: {
                    groupV1RecordProcessor.process((SignalRecord)((SignalGroupV1Record)record.getGroupV1().get()));
                    continue block6;
                }
                case 2: {
                    groupV2RecordProcessor.process((SignalRecord)((SignalGroupV2Record)record.getGroupV2().get()));
                    continue block6;
                }
                case 3: {
                    contactRecordProcessor.process((SignalRecord)((SignalContactRecord)record.getContact().get()));
                    continue block6;
                }
            }
            unknownRecords.add(record.getId());
        }
        return unknownRecords;
    }

    private static class RetryLaterException
    extends Throwable {
        private RetryLaterException() {
        }
    }

    private record IdDifferenceResult(List<StorageId> remoteOnlyIds, List<StorageId> localOnlyIds, boolean hasTypeMismatches) {
        public boolean isEmpty() {
            return this.remoteOnlyIds.isEmpty() && this.localOnlyIds.isEmpty();
        }
    }
}

