/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.IOException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Optional;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.util.PaymentUtils;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.api.crypto.ProfileCipher;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.internal.push.PaymentAddress;

public class ProfileUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProfileUtils.class);

    public static Profile decryptProfile(ProfileKey profileKey, SignalServiceProfile encryptedProfile) {
        ProfileCipher profileCipher = new ProfileCipher(profileKey);
        IdentityKey identityKey = null;
        try {
            identityKey = new IdentityKey(Base64.getDecoder().decode(encryptedProfile.getIdentityKey()), 0);
        }
        catch (InvalidKeyException e) {
            logger.debug("Failed to decode identity key in profile, can't verify payment address", (Throwable)e);
        }
        try {
            String name = ProfileUtils.decryptString(encryptedProfile.getName(), profileCipher);
            String about = ProfileUtils.decryptString(encryptedProfile.getAbout(), profileCipher);
            String aboutEmoji = ProfileUtils.decryptString(encryptedProfile.getAboutEmoji(), profileCipher);
            Pair<String, String> nameParts = ProfileUtils.splitName(name);
            PhoneNumberSharingMode remotePhoneNumberSharing = ProfileUtils.decryptBoolean(encryptedProfile.getPhoneNumberSharing(), profileCipher).map(v -> v != false ? PhoneNumberSharingMode.EVERYBODY : PhoneNumberSharingMode.NOBODY).orElse(null);
            return new Profile(System.currentTimeMillis(), nameParts.first(), nameParts.second(), about, aboutEmoji, encryptedProfile.getAvatar(), identityKey == null || encryptedProfile.getPaymentAddress() == null ? null : ProfileUtils.decryptAndVerifyMobileCoinAddress(encryptedProfile.getPaymentAddress(), profileCipher, identityKey.getPublicKey()), ProfileUtils.getUnidentifiedAccessMode(encryptedProfile, profileCipher), ProfileUtils.getCapabilities(encryptedProfile), remotePhoneNumberSharing);
        }
        catch (InvalidCiphertextException e) {
            logger.debug("Failed to decrypt profile for {}", (Object)encryptedProfile.getServiceId(), (Object)e);
            return null;
        }
    }

    public static Profile.UnidentifiedAccessMode getUnidentifiedAccessMode(SignalServiceProfile encryptedProfile, ProfileCipher profileCipher) {
        byte[] unidentifiedAccessVerifier;
        if (encryptedProfile.isUnrestrictedUnidentifiedAccess()) {
            return Profile.UnidentifiedAccessMode.UNRESTRICTED;
        }
        if (encryptedProfile.getUnidentifiedAccess() != null && profileCipher != null && profileCipher.verifyUnidentifiedAccess(unidentifiedAccessVerifier = Base64.getDecoder().decode(encryptedProfile.getUnidentifiedAccess()))) {
            return Profile.UnidentifiedAccessMode.ENABLED;
        }
        return Profile.UnidentifiedAccessMode.DISABLED;
    }

    public static HashSet<Profile.Capability> getCapabilities(SignalServiceProfile encryptedProfile) {
        HashSet<Profile.Capability> capabilities = new HashSet<Profile.Capability>();
        if (encryptedProfile.getCapabilities().isStorage()) {
            capabilities.add(Profile.Capability.storage);
        }
        return capabilities;
    }

    private static String decryptString(String encrypted, ProfileCipher profileCipher) throws InvalidCiphertextException {
        try {
            return encrypted == null ? null : profileCipher.decryptString(Base64.getDecoder().decode(encrypted));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Optional<Boolean> decryptBoolean(String encrypted, ProfileCipher profileCipher) throws InvalidCiphertextException {
        try {
            return encrypted == null ? Optional.empty() : profileCipher.decryptBoolean(Base64.getDecoder().decode(encrypted));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static byte[] decryptAndVerifyMobileCoinAddress(byte[] encryptedPaymentAddress, ProfileCipher profileCipher, ECPublicKey publicKey) throws InvalidCiphertextException {
        PaymentAddress paymentAddress;
        byte[] decrypted;
        try {
            decrypted = profileCipher.decryptWithLength(encryptedPaymentAddress);
        }
        catch (IOException e) {
            logger.debug("Failed to decrypt payment address", (Throwable)e);
            return null;
        }
        try {
            paymentAddress = (PaymentAddress)PaymentAddress.ADAPTER.decode(decrypted);
        }
        catch (IOException e) {
            logger.debug("Failed to parse payment address", (Throwable)e);
            return null;
        }
        return PaymentUtils.verifyPaymentsAddress(paymentAddress, publicKey);
    }

    private static Pair<String, String> splitName(String name) {
        if (name == null) {
            return new Pair<Object, Object>(null, null);
        }
        String[] parts = name.split("\u0000");
        return switch (parts.length) {
            case 0 -> new Pair<Object, Object>(null, null);
            case 1 -> new Pair<String, Object>(parts[0], null);
            default -> new Pair<String, String>(parts[0], parts[1]);
        };
    }
}

