// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetObservabilitySecretReader is a Reader for the GetObservabilitySecret structure.
type GetObservabilitySecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetObservabilitySecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetObservabilitySecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetObservabilitySecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetObservabilitySecretOK creates a GetObservabilitySecretOK with default headers values
func NewGetObservabilitySecretOK() *GetObservabilitySecretOK {
	return &GetObservabilitySecretOK{}
}

/*
GetObservabilitySecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetObservabilitySecretOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215GetObservabilitySecretResponse
}

// IsSuccess returns true when this get observability secret o k response has a 2xx status code
func (o *GetObservabilitySecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get observability secret o k response has a 3xx status code
func (o *GetObservabilitySecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get observability secret o k response has a 4xx status code
func (o *GetObservabilitySecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get observability secret o k response has a 5xx status code
func (o *GetObservabilitySecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get observability secret o k response a status code equal to that given
func (o *GetObservabilitySecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get observability secret o k response
func (o *GetObservabilitySecretOK) Code() int {
	return 200
}

func (o *GetObservabilitySecretOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/credentials/observability][%d] getObservabilitySecretOK  %+v", 200, o.Payload)
}

func (o *GetObservabilitySecretOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/credentials/observability][%d] getObservabilitySecretOK  %+v", 200, o.Payload)
}

func (o *GetObservabilitySecretOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215GetObservabilitySecretResponse {
	return o.Payload
}

func (o *GetObservabilitySecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215GetObservabilitySecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetObservabilitySecretDefault creates a GetObservabilitySecretDefault with default headers values
func NewGetObservabilitySecretDefault(code int) *GetObservabilitySecretDefault {
	return &GetObservabilitySecretDefault{
		_statusCode: code,
	}
}

/*
GetObservabilitySecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetObservabilitySecretDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get observability secret default response has a 2xx status code
func (o *GetObservabilitySecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get observability secret default response has a 3xx status code
func (o *GetObservabilitySecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get observability secret default response has a 4xx status code
func (o *GetObservabilitySecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get observability secret default response has a 5xx status code
func (o *GetObservabilitySecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get observability secret default response a status code equal to that given
func (o *GetObservabilitySecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get observability secret default response
func (o *GetObservabilitySecretDefault) Code() int {
	return o._statusCode
}

func (o *GetObservabilitySecretDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/credentials/observability][%d] GetObservabilitySecret default  %+v", o._statusCode, o.Payload)
}

func (o *GetObservabilitySecretDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/credentials/observability][%d] GetObservabilitySecret default  %+v", o._statusCode, o.Payload)
}

func (o *GetObservabilitySecretDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetObservabilitySecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
