/* Copyright (c) 2015-2025 The Khronos Group Inc.
 * Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 * Copyright (C) 2015-2025 Google Inc.
 * Copyright (c) 2025 Arm Limited.
 * Modifications Copyright (C) 2020-2024 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "drawdispatch_vuids.h"

namespace vvl {
// clang-format off
struct DispatchVuidsCmdDraw : DrawDispatchVuid {
    DispatchVuidsCmdDraw() : DrawDispatchVuid(Func::vkCmdDraw) {
        pipeline_bound_08606                     = "VUID-vkCmdDraw-None-08606";
        vertex_binding_04007                     = "VUID-vkCmdDraw-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDraw-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDraw-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDraw-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDraw-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDraw-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDraw-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDraw-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDraw-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDraw-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDraw-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDraw-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDraw-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDraw-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDraw-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDraw-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDraw-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDraw-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDraw-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDraw-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDraw-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDraw-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDraw-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDraw-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDraw-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDraw-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDraw-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDraw-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDraw-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDraw-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDraw-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDraw-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDraw-commandBuffer-02707";
        protected_command_buffer_02712           = "VUID-vkCmdDraw-commandBuffer-02712";
        ray_query_04617                          = "VUID-vkCmdDraw-commandBuffer-04617";
        max_multiview_instance_index_02688       = "VUID-vkCmdDraw-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDraw-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDraw-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDraw-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDraw-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDraw-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDraw-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDraw-None-04877";
        logic_op_04878                           = "VUID-vkCmdDraw-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDraw-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDraw-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDraw-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDraw-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDraw-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDraw-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDraw-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDraw-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDraw-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDraw-None-07880";
        dynamic_discard_rectangle_mode_07881     = "VUID-vkCmdDraw-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDraw-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDraw-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDraw-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDraw-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDraw-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDraw-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDraw-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDraw-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDraw-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDraw-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDraw-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDraw-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDraw-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDraw-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDraw-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDraw-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDraw-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDraw-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDraw-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDraw-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDraw-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDraw-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDraw-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDraw-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDraw-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDraw-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDraw-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDraw-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDraw-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDraw-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDraw-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDraw-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDraw-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDraw-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDraw-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDraw-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDraw-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDraw-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDraw-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDraw-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDraw-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDraw-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDraw-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDraw-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDraw-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDraw-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDraw-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDraw-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDraw-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDraw-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDraw-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDraw-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDraw-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDraw-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDraw-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDraw-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDraw-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDraw-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDraw-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDraw-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDraw-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDraw-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDraw-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDraw-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDraw-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDraw-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDraw-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDraw-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDraw-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDraw-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDraw-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDraw-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDraw-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDraw-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDraw-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDraw-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDraw-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDraw-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDraw-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDraw-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDraw-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDraw-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDraw-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDraw-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDraw-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDraw-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDraw-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDraw-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDraw-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDraw-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDraw-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDraw-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDraw-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDraw-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDraw-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDraw-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDraw-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDraw-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDraw-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDraw-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDraw-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDraw-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDraw-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDraw-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDraw-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDraw-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDraw-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDraw-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDraw-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDraw-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDraw-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDraw-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDraw-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDraw-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDraw-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDraw-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDraw-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDraw-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDraw-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDraw-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDraw-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDraw-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDraw-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDraw-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDraw-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDraw-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDraw-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDraw-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDraw-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDraw-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDraw-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDraw-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDraw-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDraw-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDraw-None-08669";
        next_stage_10745                         = "VUID-vkCmdDraw-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDraw-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDraw-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDraw-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDraw-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDraw-None-08688";
        task_shader_08689                        = "VUID-vkCmdDraw-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDraw-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDraw-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDraw-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDraw-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDraw-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDraw-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDraw-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDraw-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDraw-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDraw-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDraw-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDraw-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDraw-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDraw-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDraw-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDraw-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDraw-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDraw-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDraw-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDraw-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDraw-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDraw-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDraw-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDraw-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDraw-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDraw-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDraw-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDraw-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDraw-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDraw-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDraw-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDraw-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDraw-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDraw-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDraw-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDraw-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDraw-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDraw-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDraw-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDraw-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDraw-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDraw-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDraw-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDraw-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDraw-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDraw-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDraw-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDraw-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDraw-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDraw-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDraw-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDraw-primitivesGeneratedQueryWithNonZeroStreams-07481";
        vertex_input_09461                       = "VUID-vkCmdDraw-pNext-09461";
        vertex_input_09462                       = "VUID-vkCmdDraw-None-09462";
        color_blend_enable_07627                 = "VUID-vkCmdDraw-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDraw-None-07629";
        image_layout_00344                       = "VUID-vkCmdDraw-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDraw-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDraw-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDraw-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDraw-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDraw-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDraw-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMultiEXT : DrawDispatchVuid {
    DispatchVuidsCmdDrawMultiEXT() : DrawDispatchVuid(Func::vkCmdDrawMultiEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMultiEXT-None-08606";
        vertex_binding_04007                     = "VUID-vkCmdDrawMultiEXT-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawMultiEXT-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMultiEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMultiEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMultiEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMultiEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMultiEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMultiEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMultiEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMultiEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMultiEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMultiEXT-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDrawMultiEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMultiEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMultiEXT-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawMultiEXT-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawMultiEXT-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawMultiEXT-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawMultiEXT-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMultiEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMultiEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMultiEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMultiEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMultiEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMultiEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMultiEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMultiEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMultiEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMultiEXT-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawMultiEXT-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMultiEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMultiEXT-commandBuffer-02707";
        protected_command_buffer_02712           = "VUID-vkCmdDrawMultiEXT-commandBuffer-02712";
        ray_query_04617                          = "VUID-vkCmdDrawMultiEXT-commandBuffer-04617";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMultiEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMultiEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMultiEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMultiEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMultiEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawMultiEXT-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMultiEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMultiEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMultiEXT-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawMultiEXT-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawMultiEXT-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawMultiEXT-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawMultiEXT-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawMultiEXT-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawMultiEXT-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawMultiEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMultiEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMultiEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMultiEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     = "VUID-vkCmdDrawMultiEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMultiEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMultiEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMultiEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMultiEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMultiEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMultiEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMultiEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMultiEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMultiEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMultiEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMultiEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMultiEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMultiEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMultiEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMultiEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMultiEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMultiEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMultiEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMultiEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMultiEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMultiEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMultiEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMultiEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMultiEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMultiEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMultiEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMultiEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMultiEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMultiEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMultiEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMultiEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMultiEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMultiEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMultiEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMultiEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMultiEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMultiEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMultiEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMultiEXT-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawMultiEXT-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMultiEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMultiEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMultiEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMultiEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMultiEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMultiEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMultiEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMultiEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMultiEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMultiEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMultiEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMultiEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMultiEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMultiEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMultiEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMultiEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMultiEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMultiEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMultiEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMultiEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMultiEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMultiEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMultiEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMultiEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMultiEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMultiEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMultiEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMultiEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMultiEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMultiEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMultiEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMultiEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMultiEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMultiEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMultiEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMultiEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMultiEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMultiEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMultiEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMultiEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMultiEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMultiEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMultiEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMultiEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMultiEXT-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawMultiEXT-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMultiEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMultiEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMultiEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMultiEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMultiEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMultiEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMultiEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMultiEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawMultiEXT-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMultiEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMultiEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMultiEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMultiEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMultiEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMultiEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMultiEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMultiEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMultiEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMultiEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMultiEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMultiEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMultiEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMultiEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMultiEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMultiEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMultiEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMultiEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMultiEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMultiEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMultiEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMultiEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMultiEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMultiEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMultiEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMultiEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMultiEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMultiEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMultiEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMultiEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMultiEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMultiEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMultiEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMultiEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMultiEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMultiEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMultiEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMultiEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMultiEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMultiEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMultiEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMultiEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMultiEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMultiEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMultiEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMultiEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMultiEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMultiEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMultiEXT-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMultiEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMultiEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMultiEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMultiEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMultiEXT-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawMultiEXT-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawMultiEXT-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawMultiEXT-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawMultiEXT-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawMultiEXT-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawMultiEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMultiEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMultiEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMultiEXT-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawMultiEXT-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawMultiEXT-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawMultiEXT-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawMultiEXT-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMultiEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMultiEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMultiEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMultiEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMultiEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMultiEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMultiEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMultiEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMultiEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMultiEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMultiEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMultiEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMultiEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMultiEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMultiEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMultiEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMultiEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMultiEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMultiEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMultiEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMultiEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMultiEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMultiEXT-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawMultiEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMultiEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMultiEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        vertex_input_09461                       = "VUID-vkCmdDrawMultiEXT-pNext-09461";
        vertex_input_09462                       = "VUID-vkCmdDrawMultiEXT-None-09462";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMultiEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMultiEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMultiEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMultiEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMultiEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMultiEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMultiEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMultiEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMultiEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndexed : DrawDispatchVuid {
    DispatchVuidsCmdDrawIndexed() : DrawDispatchVuid(Func::vkCmdDrawIndexed) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndexed-None-08606";
        index_binding_07312                      = "VUID-vkCmdDrawIndexed-None-07312";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndexed-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndexed-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndexed-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndexed-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndexed-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndexed-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndexed-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndexed-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndexed-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndexed-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndexed-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndexed-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDrawIndexed-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndexed-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndexed-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndexed-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndexed-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndexed-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndexed-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndexed-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndexed-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndexed-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndexed-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndexed-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndexed-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndexed-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndexed-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndexed-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndexed-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndexed-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndexed-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndexed-commandBuffer-02707";
        protected_command_buffer_02712           = "VUID-vkCmdDrawIndexed-commandBuffer-02712";
        ray_query_04617                          = "VUID-vkCmdDrawIndexed-commandBuffer-04617";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndexed-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndexed-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndexed-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndexed-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndexed-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndexed-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndexed-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndexed-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndexed-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndexed-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndexed-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndexed-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndexed-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndexed-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndexed-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndexed-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndexed-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndexed-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndexed-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndexed-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndexed-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndexed-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndexed-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndexed-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndexed-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndexed-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndexed-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndexed-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndexed-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndexed-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndexed-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndexed-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndexed-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndexed-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndexed-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndexed-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndexed-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndexed-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndexed-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndexed-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndexed-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndexed-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndexed-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndexed-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndexed-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndexed-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndexed-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndexed-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndexed-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndexed-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndexed-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndexed-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndexed-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndexed-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndexed-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndexed-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndexed-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndexed-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndexed-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndexed-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndexed-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndexed-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndexed-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndexed-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndexed-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndexed-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndexed-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndexed-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndexed-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndexed-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndexed-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndexed-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndexed-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndexed-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndexed-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndexed-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndexed-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndexed-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndexed-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndexed-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndexed-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndexed-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndexed-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndexed-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndexed-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndexed-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndexed-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndexed-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndexed-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndexed-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndexed-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndexed-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndexed-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndexed-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndexed-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndexed-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndexed-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndexed-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndexed-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndexed-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndexed-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndexed-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndexed-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndexed-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndexed-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndexed-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndexed-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndexed-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndexed-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndexed-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndexed-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndexed-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndexed-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndexed-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndexed-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndexed-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndexed-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndexed-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndexed-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndexed-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndexed-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndexed-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndexed-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndexed-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndexed-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndexed-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndexed-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndexed-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndexed-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndexed-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndexed-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndexed-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndexed-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndexed-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndexed-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndexed-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndexed-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndexed-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndexed-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndexed-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndexed-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndexed-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndexed-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndexed-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndexed-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndexed-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndexed-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndexed-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndexed-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndexed-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndexed-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndexed-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndexed-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndexed-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndexed-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndexed-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndexed-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndexed-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndexed-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndexed-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndexed-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndexed-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndexed-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndexed-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndexed-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndexed-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndexed-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndexed-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndexed-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndexed-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndexed-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndexed-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndexed-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndexed-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndexed-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndexed-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndexed-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndexed-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndexed-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndexed-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndexed-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndexed-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndexed-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndexed-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndexed-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndexed-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndexed-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndexed-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndexed-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndexed-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndexed-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndexed-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndexed-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndexed-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndexed-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndexed-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndexed-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndexed-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndexed-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndexed-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndexed-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndexed-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndexed-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndexed-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndexed-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndexed-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndexed-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndexed-primitivesGeneratedQueryWithNonZeroStreams-07481";
        vertex_input_09461                       = "VUID-vkCmdDrawIndexed-pNext-09461";
        vertex_input_09462                       = "VUID-vkCmdDrawIndexed-None-09462";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndexed-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndexed-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndexed-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndexed-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndexed-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndexed-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndexed-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndexed-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndexed-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMultiIndexedEXT : DrawDispatchVuid {
    DispatchVuidsCmdDrawMultiIndexedEXT() : DrawDispatchVuid(Func::vkCmdDrawMultiIndexedEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMultiIndexedEXT-None-08606";
        index_binding_07312                      = "VUID-vkCmdDrawMultiIndexedEXT-None-07312";
        vertex_binding_04007                     = "VUID-vkCmdDrawMultiIndexedEXT-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawMultiIndexedEXT-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMultiIndexedEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMultiIndexedEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMultiIndexedEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMultiIndexedEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMultiIndexedEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMultiIndexedEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMultiIndexedEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMultiIndexedEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMultiIndexedEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMultiIndexedEXT-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMultiIndexedEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawMultiIndexedEXT-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawMultiIndexedEXT-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawMultiIndexedEXT-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawMultiIndexedEXT-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMultiIndexedEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMultiIndexedEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMultiIndexedEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMultiIndexedEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMultiIndexedEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMultiIndexedEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMultiIndexedEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMultiIndexedEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMultiIndexedEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMultiIndexedEXT-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawMultiIndexedEXT-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMultiIndexedEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-02707";
        protected_command_buffer_02712           = "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-02712";
        ray_query_04617                          = "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-04617";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMultiIndexedEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMultiIndexedEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMultiIndexedEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMultiIndexedEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMultiIndexedEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawMultiIndexedEXT-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMultiIndexedEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMultiIndexedEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMultiIndexedEXT-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawMultiIndexedEXT-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawMultiIndexedEXT-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawMultiIndexedEXT-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawMultiIndexedEXT-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawMultiIndexedEXT-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawMultiIndexedEXT-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawMultiIndexedEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMultiIndexedEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMultiIndexedEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMultiIndexedEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMultiIndexedEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMultiIndexedEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMultiIndexedEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMultiIndexedEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMultiIndexedEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMultiIndexedEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMultiIndexedEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMultiIndexedEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMultiIndexedEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMultiIndexedEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMultiIndexedEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMultiIndexedEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMultiIndexedEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMultiIndexedEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMultiIndexedEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMultiIndexedEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMultiIndexedEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMultiIndexedEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMultiIndexedEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMultiIndexedEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMultiIndexedEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMultiIndexedEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMultiIndexedEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMultiIndexedEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMultiIndexedEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMultiIndexedEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMultiIndexedEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMultiIndexedEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMultiIndexedEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMultiIndexedEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMultiIndexedEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMultiIndexedEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMultiIndexedEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMultiIndexedEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMultiIndexedEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMultiIndexedEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMultiIndexedEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMultiIndexedEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMultiIndexedEXT-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawMultiIndexedEXT-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMultiIndexedEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMultiIndexedEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMultiIndexedEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMultiIndexedEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMultiIndexedEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMultiIndexedEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMultiIndexedEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMultiIndexedEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMultiIndexedEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMultiIndexedEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMultiIndexedEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMultiIndexedEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMultiIndexedEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMultiIndexedEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMultiIndexedEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMultiIndexedEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMultiIndexedEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMultiIndexedEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMultiIndexedEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMultiIndexedEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMultiIndexedEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMultiIndexedEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMultiIndexedEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMultiIndexedEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMultiIndexedEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMultiIndexedEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMultiIndexedEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMultiIndexedEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMultiIndexedEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMultiIndexedEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMultiIndexedEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMultiIndexedEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMultiIndexedEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMultiIndexedEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMultiIndexedEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMultiIndexedEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMultiIndexedEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMultiIndexedEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMultiIndexedEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMultiIndexedEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMultiIndexedEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMultiIndexedEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMultiIndexedEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMultiIndexedEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMultiIndexedEXT-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawMultiIndexedEXT-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMultiIndexedEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMultiIndexedEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMultiIndexedEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMultiIndexedEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMultiIndexedEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMultiIndexedEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMultiIndexedEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMultiIndexedEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawMultiIndexedEXT-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMultiIndexedEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMultiIndexedEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMultiIndexedEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMultiIndexedEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMultiIndexedEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMultiIndexedEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMultiIndexedEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMultiIndexedEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMultiIndexedEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMultiIndexedEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMultiIndexedEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMultiIndexedEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMultiIndexedEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMultiIndexedEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMultiIndexedEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMultiIndexedEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMultiIndexedEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMultiIndexedEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMultiIndexedEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMultiIndexedEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMultiIndexedEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMultiIndexedEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMultiIndexedEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMultiIndexedEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMultiIndexedEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMultiIndexedEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMultiIndexedEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMultiIndexedEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMultiIndexedEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMultiIndexedEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMultiIndexedEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMultiIndexedEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMultiIndexedEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMultiIndexedEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMultiIndexedEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMultiIndexedEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMultiIndexedEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMultiIndexedEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMultiIndexedEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMultiIndexedEXT-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMultiIndexedEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMultiIndexedEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMultiIndexedEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMultiIndexedEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMultiIndexedEXT-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawMultiIndexedEXT-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawMultiIndexedEXT-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawMultiIndexedEXT-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawMultiIndexedEXT-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawMultiIndexedEXT-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawMultiIndexedEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMultiIndexedEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMultiIndexedEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMultiIndexedEXT-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawMultiIndexedEXT-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawMultiIndexedEXT-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawMultiIndexedEXT-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawMultiIndexedEXT-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMultiIndexedEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMultiIndexedEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMultiIndexedEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMultiIndexedEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMultiIndexedEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMultiIndexedEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMultiIndexedEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMultiIndexedEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMultiIndexedEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMultiIndexedEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMultiIndexedEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMultiIndexedEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMultiIndexedEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMultiIndexedEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMultiIndexedEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMultiIndexedEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMultiIndexedEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMultiIndexedEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMultiIndexedEXT-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawMultiIndexedEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMultiIndexedEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMultiIndexedEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        vertex_input_09461                       = "VUID-vkCmdDrawMultiIndexedEXT-pNext-09461";
        vertex_input_09462                       = "VUID-vkCmdDrawMultiIndexedEXT-None-09462";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMultiIndexedEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMultiIndexedEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMultiIndexedEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMultiIndexedEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMultiIndexedEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMultiIndexedEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMultiIndexedEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMultiIndexedEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMultiIndexedEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndirect : DrawDispatchVuid {
    DispatchVuidsCmdDrawIndirect() : DrawDispatchVuid(Func::vkCmdDrawIndirect) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndirect-None-08606";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndirect-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndirect-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndirect-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndirect-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndirect-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndirect-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndirect-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndirect-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndirect-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndirect-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndirect-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndirect-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawIndirect-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawIndirect-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawIndirect-buffer-02709";
        viewport_count_03417                     = "VUID-vkCmdDrawIndirect-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndirect-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndirect-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndirect-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndirect-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndirect-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndirect-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndirect-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndirect-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndirect-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndirect-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndirect-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndirect-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndirect-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndirect-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndirect-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndirect-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndirect-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndirect-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndirect-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndirect-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndirect-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndirect-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndirect-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndirect-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndirect-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndirect-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndirect-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndirect-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndirect-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndirect-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndirect-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndirect-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndirect-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndirect-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndirect-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndirect-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndirect-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndirect-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndirect-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndirect-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndirect-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndirect-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndirect-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndirect-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndirect-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndirect-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndirect-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndirect-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndirect-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndirect-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndirect-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndirect-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndirect-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndirect-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndirect-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndirect-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndirect-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndirect-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndirect-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndirect-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndirect-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndirect-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndirect-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndirect-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndirect-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndirect-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndirect-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndirect-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndirect-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndirect-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndirect-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndirect-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndirect-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndirect-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndirect-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndirect-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndirect-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndirect-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndirect-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndirect-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndirect-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndirect-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndirect-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndirect-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndirect-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndirect-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndirect-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndirect-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndirect-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndirect-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndirect-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndirect-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndirect-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndirect-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndirect-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndirect-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndirect-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndirect-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndirect-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndirect-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndirect-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndirect-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndirect-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndirect-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndirect-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndirect-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndirect-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndirect-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndirect-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndirect-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndirect-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndirect-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndirect-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndirect-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndirect-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndirect-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndirect-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndirect-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndirect-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndirect-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndirect-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndirect-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndirect-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndirect-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndirect-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndirect-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndirect-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndirect-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndirect-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndirect-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndirect-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndirect-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndirect-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndirect-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndirect-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndirect-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndirect-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndirect-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndirect-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndirect-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndirect-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndirect-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndirect-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndirect-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndirect-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndirect-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndirect-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndirect-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndirect-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndirect-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndirect-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndirect-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndirect-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndirect-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndirect-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndirect-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndirect-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndirect-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndirect-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndirect-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndirect-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndirect-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndirect-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndirect-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndirect-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndirect-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndirect-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndirect-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndirect-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndirect-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndirect-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndirect-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndirect-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndirect-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndirect-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndirect-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndirect-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndirect-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndirect-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndirect-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndirect-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndirect-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndirect-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndirect-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndirect-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndirect-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndirect-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndirect-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndirect-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndirect-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndirect-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndirect-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndirect-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndirect-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndirect-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndirect-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndirect-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndirect-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndirect-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndirect-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndirect-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndirect-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndirect-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndirect-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndirect-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndirect-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndirect-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndirect-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndirect-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndirect-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndirect-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndirect-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndirect-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndirect-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndirect-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndirect-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndirect-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndirect-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndirect-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndirect-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndirect-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndirect-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndirect-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndirect-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndirect-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndirect-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndirect-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndirect-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndirect-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndirect-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndirect-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndirect-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndirect-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndirect-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndirect-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndirect-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndexedIndirect : DrawDispatchVuid {
    DispatchVuidsCmdDrawIndexedIndirect() : DrawDispatchVuid(Func::vkCmdDrawIndexedIndirect) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndexedIndirect-None-08606";
        index_binding_07312                      = "VUID-vkCmdDrawIndexedIndirect-None-07312";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndexedIndirect-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndexedIndirect-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndexedIndirect-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndexedIndirect-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndexedIndirect-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndexedIndirect-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndexedIndirect-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndexedIndirect-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndexedIndirect-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndexedIndirect-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndexedIndirect-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndexedIndirect-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawIndexedIndirect-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawIndexedIndirect-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawIndexedIndirect-buffer-02709";
        viewport_count_03417                     = "VUID-vkCmdDrawIndexedIndirect-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndexedIndirect-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndexedIndirect-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndexedIndirect-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndexedIndirect-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndexedIndirect-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndexedIndirect-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndexedIndirect-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndexedIndirect-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndexedIndirect-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndexedIndirect-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndexedIndirect-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndexedIndirect-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndexedIndirect-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndexedIndirect-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndexedIndirect-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndexedIndirect-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndexedIndirect-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndexedIndirect-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndexedIndirect-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndexedIndirect-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndexedIndirect-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndexedIndirect-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndexedIndirect-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndexedIndirect-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndexedIndirect-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndexedIndirect-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndexedIndirect-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndexedIndirect-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndexedIndirect-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndexedIndirect-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndexedIndirect-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndexedIndirect-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndexedIndirect-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndexedIndirect-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndexedIndirect-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndexedIndirect-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndexedIndirect-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndexedIndirect-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndexedIndirect-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndexedIndirect-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndexedIndirect-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndexedIndirect-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndexedIndirect-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndexedIndirect-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndexedIndirect-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndexedIndirect-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndexedIndirect-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndexedIndirect-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndexedIndirect-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndexedIndirect-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndexedIndirect-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndexedIndirect-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndexedIndirect-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndexedIndirect-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndexedIndirect-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndexedIndirect-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndexedIndirect-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndexedIndirect-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndexedIndirect-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndexedIndirect-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndexedIndirect-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndexedIndirect-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndexedIndirect-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndexedIndirect-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndexedIndirect-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndexedIndirect-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndexedIndirect-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndexedIndirect-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndexedIndirect-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndexedIndirect-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndexedIndirect-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndexedIndirect-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndexedIndirect-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndexedIndirect-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndexedIndirect-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndexedIndirect-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndexedIndirect-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndexedIndirect-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndexedIndirect-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndexedIndirect-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndexedIndirect-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndexedIndirect-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndexedIndirect-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndexedIndirect-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndexedIndirect-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndexedIndirect-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndexedIndirect-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndexedIndirect-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndexedIndirect-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndexedIndirect-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndexedIndirect-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndexedIndirect-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndexedIndirect-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndexedIndirect-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndexedIndirect-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndexedIndirect-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndexedIndirect-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndexedIndirect-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndexedIndirect-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndexedIndirect-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndexedIndirect-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndexedIndirect-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndexedIndirect-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndexedIndirect-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndexedIndirect-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndexedIndirect-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndexedIndirect-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndexedIndirect-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndexedIndirect-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndexedIndirect-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndexedIndirect-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndexedIndirect-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndexedIndirect-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndexedIndirect-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndexedIndirect-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndexedIndirect-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndexedIndirect-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndexedIndirect-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndexedIndirect-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndexedIndirect-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndexedIndirect-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndexedIndirect-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndexedIndirect-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndexedIndirect-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndexedIndirect-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndexedIndirect-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndexedIndirect-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndexedIndirect-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndexedIndirect-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndexedIndirect-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndexedIndirect-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndexedIndirect-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndexedIndirect-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndexedIndirect-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndexedIndirect-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndexedIndirect-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndexedIndirect-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndexedIndirect-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndexedIndirect-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndexedIndirect-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndexedIndirect-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndexedIndirect-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndexedIndirect-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndexedIndirect-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndexedIndirect-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndexedIndirect-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndexedIndirect-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndexedIndirect-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndexedIndirect-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndexedIndirect-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndexedIndirect-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndexedIndirect-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndexedIndirect-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndexedIndirect-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndexedIndirect-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndexedIndirect-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndexedIndirect-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndexedIndirect-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndexedIndirect-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndexedIndirect-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndexedIndirect-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndexedIndirect-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndexedIndirect-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndexedIndirect-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndexedIndirect-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndexedIndirect-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndexedIndirect-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndexedIndirect-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndexedIndirect-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndexedIndirect-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndexedIndirect-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndexedIndirect-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndexedIndirect-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndexedIndirect-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndexedIndirect-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndexedIndirect-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndexedIndirect-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndexedIndirect-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndexedIndirect-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndexedIndirect-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndexedIndirect-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndexedIndirect-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndexedIndirect-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndexedIndirect-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndexedIndirect-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndexedIndirect-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndexedIndirect-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndexedIndirect-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndexedIndirect-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndexedIndirect-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndexedIndirect-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndexedIndirect-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndexedIndirect-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndexedIndirect-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndexedIndirect-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndexedIndirect-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndexedIndirect-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndexedIndirect-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndexedIndirect-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndexedIndirect-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndexedIndirect-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndexedIndirect-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndexedIndirect-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndexedIndirect-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndexedIndirect-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndexedIndirect-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndexedIndirect-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndexedIndirect-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndexedIndirect-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndexedIndirect-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndexedIndirect-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndexedIndirect-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndexedIndirect-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndexedIndirect-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndexedIndirect-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndexedIndirect-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndexedIndirect-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndexedIndirect-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndexedIndirect-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndexedIndirect-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndexedIndirect-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndexedIndirect-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndexedIndirect-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndexedIndirect-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndexedIndirect-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndexedIndirect-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndexedIndirect-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndexedIndirect-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndexedIndirect-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndexedIndirect-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndexedIndirect-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndexedIndirect-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndexedIndirect-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDispatch : DrawDispatchVuid {
    DispatchVuidsCmdDispatch() : DrawDispatchVuid(Func::vkCmdDispatch) {
        pipeline_bound_08606                     = "VUID-vkCmdDispatch-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDispatch-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdDispatch-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDispatch-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDispatch-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDispatch-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDispatch-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDispatch-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDispatch-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDispatch-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDispatch-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDispatch-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdDispatch-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDispatch-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDispatch-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDispatch-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDispatch-commandBuffer-02707";
        protected_command_buffer_02712           = "VUID-vkCmdDispatch-commandBuffer-02712";
        compute_not_bound_10743                  = "VUID-vkCmdDispatch-None-10743";
        compute_inside_rp_10672                  = "VUID-vkCmdDispatch-None-10672";
        ray_query_04617                          = "VUID-vkCmdDispatch-commandBuffer-04617";
        img_filter_cubic_02693                   = "VUID-vkCmdDispatch-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDispatch-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDispatch-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdDispatch-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDispatch-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDispatch-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDispatch-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDispatch-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDispatch-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDispatch-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDispatch-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDispatch-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDispatch-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDispatch-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDispatch-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDispatch-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDispatch-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDispatch-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDispatch-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDispatch-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDispatch-format-07753";
        image_layout_00344                       = "VUID-vkCmdDispatch-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDispatch-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdDispatch-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDispatch-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDispatch-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDispatchIndirect : DrawDispatchVuid {
    DispatchVuidsCmdDispatchIndirect() : DrawDispatchVuid(Func::vkCmdDispatchIndirect) {
        pipeline_bound_08606                     = "VUID-vkCmdDispatchIndirect-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDispatchIndirect-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdDispatchIndirect-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDispatchIndirect-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDispatchIndirect-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDispatchIndirect-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDispatchIndirect-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDispatchIndirect-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDispatchIndirect-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDispatchIndirect-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDispatchIndirect-buffer-02709";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDispatchIndirect-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDispatchIndirect-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDispatchIndirect-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDispatchIndirect-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdDispatchIndirect-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDispatchIndirect-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDispatchIndirect-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDispatchIndirect-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDispatchIndirect-commandBuffer-02707";
        compute_not_bound_10743                  = "VUID-vkCmdDispatchIndirect-None-10743";
        compute_inside_rp_10672                  = "VUID-vkCmdDispatchIndirect-None-10672";
        img_filter_cubic_02693                   = "VUID-vkCmdDispatchIndirect-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDispatchIndirect-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDispatchIndirect-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdDispatchIndirect-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDispatchIndirect-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDispatchIndirect-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDispatchIndirect-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDispatchIndirect-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDispatchIndirect-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDispatchIndirect-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDispatchIndirect-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDispatchIndirect-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDispatchIndirect-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDispatchIndirect-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDispatchIndirect-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDispatchIndirect-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDispatchIndirect-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDispatchIndirect-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDispatchIndirect-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDispatchIndirect-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDispatchIndirect-format-07753";
        image_layout_00344                       = "VUID-vkCmdDispatchIndirect-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDispatchIndirect-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdDispatchIndirect-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDispatchIndirect-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDispatchIndirect-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndirectCount : DrawDispatchVuid {
    DispatchVuidsCmdDrawIndirectCount() : DrawDispatchVuid(Func::vkCmdDrawIndirectCount) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndirectCount-None-08606";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndirectCount-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndirectCount-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndirectCount-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndirectCount-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndirectCount-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndirectCount-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndirectCount-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndirectCount-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndirectCount-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndirectCount-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndirectCount-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndirectCount-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawIndirectCount-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawIndirectCount-buffer-02708";
        indirect_count_contiguous_memory_02714   = "VUID-vkCmdDrawIndirectCount-countBuffer-02714";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawIndirectCount-buffer-02709";
        indirect_count_buffer_bit_02715          = "VUID-vkCmdDrawIndirectCount-countBuffer-02715";
        indirect_count_offset_04129              = "VUID-vkCmdDrawIndirectCount-countBufferOffset-04129";
        viewport_count_03417                     = "VUID-vkCmdDrawIndirectCount-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndirectCount-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndirectCount-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndirectCount-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndirectCount-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndirectCount-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndirectCount-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndirectCount-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndirectCount-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndirectCount-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndirectCount-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndirectCount-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndirectCount-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndirectCount-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndirectCount-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndirectCount-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndirectCount-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndirectCount-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndirectCount-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndirectCount-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndirectCount-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndirectCount-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndirectCount-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndirectCount-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndirectCount-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndirectCount-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndirectCount-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndirectCount-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndirectCount-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndirectCount-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndirectCount-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndirectCount-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndirectCount-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndirectCount-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndirectCount-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndirectCount-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndirectCount-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndirectCount-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndirectCount-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndirectCount-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndirectCount-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndirectCount-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndirectCount-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndirectCount-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndirectCount-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndirectCount-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndirectCount-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndirectCount-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndirectCount-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndirectCount-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndirectCount-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndirectCount-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndirectCount-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndirectCount-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndirectCount-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndirectCount-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndirectCount-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndirectCount-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndirectCount-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndirectCount-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndirectCount-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndirectCount-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndirectCount-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndirectCount-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndirectCount-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndirectCount-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndirectCount-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndirectCount-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndirectCount-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndirectCount-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndirectCount-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndirectCount-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndirectCount-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndirectCount-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndirectCount-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndirectCount-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndirectCount-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndirectCount-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndirectCount-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndirectCount-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndirectCount-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndirectCount-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndirectCount-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndirectCount-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndirectCount-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndirectCount-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndirectCount-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndirectCount-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndirectCount-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndirectCount-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndirectCount-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndirectCount-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndirectCount-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndirectCount-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndirectCount-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndirectCount-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndirectCount-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndirectCount-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndirectCount-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndirectCount-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndirectCount-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndirectCount-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndirectCount-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndirectCount-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndirectCount-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndirectCount-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndirectCount-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndirectCount-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndirectCount-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndirectCount-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndirectCount-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndirectCount-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndirectCount-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndirectCount-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndirectCount-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndirectCount-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndirectCount-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndirectCount-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndirectCount-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndirectCount-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndirectCount-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndirectCount-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndirectCount-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndirectCount-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndirectCount-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndirectCount-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndirectCount-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndirectCount-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndirectCount-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndirectCount-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndirectCount-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndirectCount-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndirectCount-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndirectCount-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndirectCount-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndirectCount-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndirectCount-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndirectCount-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndirectCount-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndirectCount-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndirectCount-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndirectCount-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndirectCount-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndirectCount-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndirectCount-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndirectCount-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndirectCount-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndirectCount-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndirectCount-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndirectCount-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndirectCount-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndirectCount-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndirectCount-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndirectCount-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndirectCount-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndirectCount-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndirectCount-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndirectCount-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndirectCount-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndirectCount-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndirectCount-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndirectCount-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndirectCount-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndirectCount-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndirectCount-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndirectCount-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndirectCount-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndirectCount-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndirectCount-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndirectCount-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndirectCount-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndirectCount-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndirectCount-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndirectCount-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndirectCount-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndirectCount-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndirectCount-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndirectCount-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndirectCount-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndirectCount-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndirectCount-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndirectCount-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndirectCount-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndirectCount-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndirectCount-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndirectCount-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndirectCount-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndirectCount-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndirectCount-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndirectCount-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndirectCount-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndirectCount-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndirectCount-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndirectCount-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndirectCount-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndirectCount-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndirectCount-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndirectCount-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndirectCount-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndirectCount-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndirectCount-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndirectCount-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndirectCount-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndirectCount-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndirectCount-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndirectCount-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndirectCount-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndirectCount-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndirectCount-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndirectCount-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndirectCount-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndirectCount-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndirectCount-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndirectCount-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndirectCount-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndirectCount-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndirectCount-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndirectCount-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndirectCount-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndirectCount-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndirectCount-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndirectCount-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndirectCount-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndirectCount-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndirectCount-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndirectCount-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndirectCount-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndirectCount-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndirectCount-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndirectCount-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndirectCount-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndirectCount-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndirectCount-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndirectCount-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndirectCount-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndirectCount-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndirectCount-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndexedIndirectCount : DrawDispatchVuid {
    DispatchVuidsCmdDrawIndexedIndirectCount() : DrawDispatchVuid(Func::vkCmdDrawIndexedIndirectCount) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndexedIndirectCount-None-08606";
        index_binding_07312                      = "VUID-vkCmdDrawIndexedIndirectCount-None-07312";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndexedIndirectCount-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndexedIndirectCount-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndexedIndirectCount-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndexedIndirectCount-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndexedIndirectCount-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndexedIndirectCount-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndexedIndirectCount-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndexedIndirectCount-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndexedIndirectCount-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndexedIndirectCount-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndexedIndirectCount-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndexedIndirectCount-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawIndexedIndirectCount-buffer-02708";
        indirect_count_contiguous_memory_02714   = "VUID-vkCmdDrawIndexedIndirectCount-countBuffer-02714";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawIndexedIndirectCount-buffer-02709";
        indirect_count_buffer_bit_02715          = "VUID-vkCmdDrawIndexedIndirectCount-countBuffer-02715";
        indirect_count_offset_04129              = "VUID-vkCmdDrawIndexedIndirectCount-countBufferOffset-04129";
        viewport_count_03417                     = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndexedIndirectCount-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndexedIndirectCount-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndexedIndirectCount-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndexedIndirectCount-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndexedIndirectCount-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndexedIndirectCount-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndexedIndirectCount-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndexedIndirectCount-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndexedIndirectCount-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndexedIndirectCount-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndexedIndirectCount-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndexedIndirectCount-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndexedIndirectCount-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndexedIndirectCount-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndexedIndirectCount-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndexedIndirectCount-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndexedIndirectCount-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndexedIndirectCount-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndexedIndirectCount-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndexedIndirectCount-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndexedIndirectCount-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndexedIndirectCount-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndexedIndirectCount-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndexedIndirectCount-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndexedIndirectCount-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndexedIndirectCount-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndexedIndirectCount-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndexedIndirectCount-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndexedIndirectCount-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndexedIndirectCount-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndexedIndirectCount-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndexedIndirectCount-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndexedIndirectCount-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndexedIndirectCount-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndexedIndirectCount-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndexedIndirectCount-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndexedIndirectCount-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndexedIndirectCount-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndexedIndirectCount-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndexedIndirectCount-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndexedIndirectCount-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndexedIndirectCount-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndexedIndirectCount-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndexedIndirectCount-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndexedIndirectCount-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndexedIndirectCount-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndexedIndirectCount-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndexedIndirectCount-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndexedIndirectCount-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndexedIndirectCount-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndexedIndirectCount-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndexedIndirectCount-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndexedIndirectCount-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndexedIndirectCount-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndexedIndirectCount-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndexedIndirectCount-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndexedIndirectCount-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndexedIndirectCount-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndexedIndirectCount-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndexedIndirectCount-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndexedIndirectCount-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndexedIndirectCount-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndexedIndirectCount-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndexedIndirectCount-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndexedIndirectCount-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndexedIndirectCount-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndexedIndirectCount-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndexedIndirectCount-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndexedIndirectCount-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndexedIndirectCount-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndexedIndirectCount-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndexedIndirectCount-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndexedIndirectCount-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndexedIndirectCount-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndexedIndirectCount-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndexedIndirectCount-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndexedIndirectCount-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndexedIndirectCount-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndexedIndirectCount-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndexedIndirectCount-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndexedIndirectCount-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndexedIndirectCount-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndexedIndirectCount-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndexedIndirectCount-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndexedIndirectCount-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndexedIndirectCount-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndexedIndirectCount-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndexedIndirectCount-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndexedIndirectCount-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndexedIndirectCount-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndexedIndirectCount-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndexedIndirectCount-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndexedIndirectCount-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndexedIndirectCount-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndexedIndirectCount-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndexedIndirectCount-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndexedIndirectCount-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndexedIndirectCount-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndexedIndirectCount-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndexedIndirectCount-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndexedIndirectCount-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndexedIndirectCount-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndexedIndirectCount-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndexedIndirectCount-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndexedIndirectCount-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndexedIndirectCount-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndexedIndirectCount-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndexedIndirectCount-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndexedIndirectCount-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndexedIndirectCount-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndexedIndirectCount-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndexedIndirectCount-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndexedIndirectCount-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndexedIndirectCount-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndexedIndirectCount-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndexedIndirectCount-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndexedIndirectCount-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndexedIndirectCount-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndexedIndirectCount-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndexedIndirectCount-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndexedIndirectCount-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndexedIndirectCount-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndexedIndirectCount-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndexedIndirectCount-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndexedIndirectCount-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndexedIndirectCount-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndexedIndirectCount-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndexedIndirectCount-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndexedIndirectCount-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndexedIndirectCount-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndexedIndirectCount-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndexedIndirectCount-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndexedIndirectCount-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndexedIndirectCount-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndexedIndirectCount-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndexedIndirectCount-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndexedIndirectCount-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndexedIndirectCount-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndexedIndirectCount-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndexedIndirectCount-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndexedIndirectCount-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndexedIndirectCount-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndexedIndirectCount-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndexedIndirectCount-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndexedIndirectCount-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndexedIndirectCount-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndexedIndirectCount-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndexedIndirectCount-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndexedIndirectCount-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndexedIndirectCount-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndexedIndirectCount-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndexedIndirectCount-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndexedIndirectCount-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndexedIndirectCount-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndexedIndirectCount-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndexedIndirectCount-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndexedIndirectCount-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndexedIndirectCount-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndexedIndirectCount-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndexedIndirectCount-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndexedIndirectCount-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndexedIndirectCount-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndexedIndirectCount-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndexedIndirectCount-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndexedIndirectCount-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndexedIndirectCount-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndexedIndirectCount-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndexedIndirectCount-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndexedIndirectCount-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndexedIndirectCount-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndexedIndirectCount-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndexedIndirectCount-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndexedIndirectCount-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndexedIndirectCount-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndexedIndirectCount-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndexedIndirectCount-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndexedIndirectCount-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndexedIndirectCount-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndexedIndirectCount-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndexedIndirectCount-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndexedIndirectCount-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndexedIndirectCount-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndexedIndirectCount-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndexedIndirectCount-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndexedIndirectCount-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndexedIndirectCount-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndexedIndirectCount-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndexedIndirectCount-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndexedIndirectCount-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndexedIndirectCount-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndexedIndirectCount-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndexedIndirectCount-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndexedIndirectCount-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndexedIndirectCount-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndexedIndirectCount-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndexedIndirectCount-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndexedIndirectCount-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndexedIndirectCount-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndexedIndirectCount-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndexedIndirectCount-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndexedIndirectCount-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndexedIndirectCount-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndexedIndirectCount-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndexedIndirectCount-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndexedIndirectCount-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndexedIndirectCount-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndexedIndirectCount-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndexedIndirectCount-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndexedIndirectCount-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndexedIndirectCount-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndexedIndirectCount-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndexedIndirectCount-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndexedIndirectCount-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndexedIndirectCount-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndexedIndirectCount-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndexedIndirectCount-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndexedIndirectCount-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndexedIndirectCount-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndexedIndirectCount-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndexedIndirectCount-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdTraceRaysNV: DrawDispatchVuid {
    DispatchVuidsCmdTraceRaysNV() : DrawDispatchVuid(Func::vkCmdTraceRaysNV) {
        pipeline_bound_08606                     = "VUID-vkCmdTraceRaysNV-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdTraceRaysNV-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdTraceRaysNV-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdTraceRaysNV-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdTraceRaysNV-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdTraceRaysNV-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdTraceRaysNV-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdTraceRaysNV-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdTraceRaysNV-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdTraceRaysNV-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdTraceRaysNV-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdTraceRaysNV-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdTraceRaysNV-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdTraceRaysNV-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdTraceRaysNV-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdTraceRaysNV-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdTraceRaysNV-commandBuffer-02707";
        ray_query_protected_cb_03635             = "VUID-vkCmdTraceRaysNV-commandBuffer-04624";
        img_filter_cubic_02693                   = "VUID-vkCmdTraceRaysNV-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdTraceRaysNV-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdTraceRaysNV-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdTraceRaysNV-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdTraceRaysNV-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdTraceRaysNV-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdTraceRaysNV-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdTraceRaysNV-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdTraceRaysNV-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdTraceRaysNV-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdTraceRaysNV-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdTraceRaysNV-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdTraceRaysNV-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdTraceRaysNV-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdTraceRaysNV-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdTraceRaysNV-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdTraceRaysNV-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdTraceRaysNV-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdTraceRaysNV-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdTraceRaysNV-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdTraceRaysNV-format-07753";
        ray_tracing_pipeline_stack_size_09458    = "VUID-vkCmdTraceRaysNV-None-09458";
        image_layout_00344                       = "VUID-vkCmdTraceRaysNV-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdTraceRaysNV-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdTraceRaysNV-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdTraceRaysNV-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdTraceRaysNV-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdTraceRaysKHR: DrawDispatchVuid {
    DispatchVuidsCmdTraceRaysKHR() : DrawDispatchVuid(Func::vkCmdTraceRaysKHR) {
        pipeline_bound_08606                     = "VUID-vkCmdTraceRaysKHR-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdTraceRaysKHR-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdTraceRaysKHR-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdTraceRaysKHR-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdTraceRaysKHR-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdTraceRaysKHR-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdTraceRaysKHR-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdTraceRaysKHR-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdTraceRaysKHR-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdTraceRaysKHR-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdTraceRaysKHR-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdTraceRaysKHR-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdTraceRaysKHR-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdTraceRaysKHR-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdTraceRaysKHR-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdTraceRaysKHR-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdTraceRaysKHR-commandBuffer-02707";
        ray_query_protected_cb_03635             = "VUID-vkCmdTraceRaysKHR-commandBuffer-03635";
        img_filter_cubic_02693                   = "VUID-vkCmdTraceRaysKHR-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdTraceRaysKHR-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdTraceRaysKHR-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdTraceRaysKHR-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdTraceRaysKHR-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdTraceRaysKHR-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdTraceRaysKHR-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdTraceRaysKHR-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdTraceRaysKHR-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdTraceRaysKHR-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdTraceRaysKHR-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdTraceRaysKHR-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdTraceRaysKHR-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdTraceRaysKHR-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdTraceRaysKHR-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdTraceRaysKHR-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdTraceRaysKHR-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdTraceRaysKHR-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdTraceRaysKHR-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdTraceRaysKHR-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdTraceRaysKHR-format-07753";
        ray_tracing_pipeline_stack_size_09458    = "VUID-vkCmdTraceRaysKHR-None-09458";
        image_layout_00344                       = "VUID-vkCmdTraceRaysKHR-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdTraceRaysKHR-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdTraceRaysKHR-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdTraceRaysKHR-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdTraceRaysKHR-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdTraceRaysIndirectKHR: DrawDispatchVuid {
    DispatchVuidsCmdTraceRaysIndirectKHR() : DrawDispatchVuid(Func::vkCmdTraceRaysIndirectKHR) {
        pipeline_bound_08606                     = "VUID-vkCmdTraceRaysIndirectKHR-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdTraceRaysIndirectKHR-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdTraceRaysIndirectKHR-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdTraceRaysIndirectKHR-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdTraceRaysIndirectKHR-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdTraceRaysIndirectKHR-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdTraceRaysIndirectKHR-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdTraceRaysIndirectKHR-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdTraceRaysIndirectKHR-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdTraceRaysIndirectKHR-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdTraceRaysIndirectKHR-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdTraceRaysIndirectKHR-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdTraceRaysIndirectKHR-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdTraceRaysIndirectKHR-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdTraceRaysIndirectKHR-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdTraceRaysIndirectKHR-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-02707";
        ray_query_protected_cb_03635             = "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-03635";
        img_filter_cubic_02693                   = "VUID-vkCmdTraceRaysIndirectKHR-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdTraceRaysIndirectKHR-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdTraceRaysIndirectKHR-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdTraceRaysIndirectKHR-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdTraceRaysIndirectKHR-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdTraceRaysIndirectKHR-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdTraceRaysIndirectKHR-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdTraceRaysIndirectKHR-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdTraceRaysIndirectKHR-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdTraceRaysIndirectKHR-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdTraceRaysIndirectKHR-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdTraceRaysIndirectKHR-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdTraceRaysIndirectKHR-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdTraceRaysIndirectKHR-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdTraceRaysIndirectKHR-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdTraceRaysIndirectKHR-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdTraceRaysIndirectKHR-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdTraceRaysIndirectKHR-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdTraceRaysIndirectKHR-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdTraceRaysIndirectKHR-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdTraceRaysIndirectKHR-format-07753";
        ray_tracing_pipeline_stack_size_09458    = "VUID-vkCmdTraceRaysIndirectKHR-None-09458";
        image_layout_00344                       = "VUID-vkCmdTraceRaysIndirectKHR-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdTraceRaysIndirectKHR-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdTraceRaysIndirectKHR-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdTraceRaysIndirectKHR-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdTraceRaysIndirectKHR-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdTraceRaysIndirect2KHR: DrawDispatchVuid {
    DispatchVuidsCmdTraceRaysIndirect2KHR() : DrawDispatchVuid(Func::vkCmdTraceRaysIndirect2KHR) {
        pipeline_bound_08606                     = "VUID-vkCmdTraceRaysIndirect2KHR-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdTraceRaysIndirect2KHR-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdTraceRaysIndirect2KHR-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdTraceRaysIndirect2KHR-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdTraceRaysIndirect2KHR-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdTraceRaysIndirect2KHR-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdTraceRaysIndirect2KHR-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdTraceRaysIndirect2KHR-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdTraceRaysIndirect2KHR-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdTraceRaysIndirect2KHR-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdTraceRaysIndirect2KHR-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdTraceRaysIndirect2KHR-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdTraceRaysIndirect2KHR-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdTraceRaysIndirect2KHR-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdTraceRaysIndirect2KHR-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdTraceRaysIndirect2KHR-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-02707";
        ray_query_protected_cb_03635             = "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-03635";
        img_filter_cubic_02693                   = "VUID-vkCmdTraceRaysIndirect2KHR-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdTraceRaysIndirect2KHR-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdTraceRaysIndirect2KHR-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdTraceRaysIndirect2KHR-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdTraceRaysIndirect2KHR-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdTraceRaysIndirect2KHR-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdTraceRaysIndirect2KHR-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdTraceRaysIndirect2KHR-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdTraceRaysIndirect2KHR-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdTraceRaysIndirect2KHR-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdTraceRaysIndirect2KHR-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdTraceRaysIndirect2KHR-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdTraceRaysIndirect2KHR-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdTraceRaysIndirect2KHR-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdTraceRaysIndirect2KHR-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdTraceRaysIndirect2KHR-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdTraceRaysIndirect2KHR-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdTraceRaysIndirect2KHR-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdTraceRaysIndirect2KHR-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdTraceRaysIndirect2KHR-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdTraceRaysIndirect2KHR-format-07753";
        ray_tracing_pipeline_stack_size_09458    = "VUID-vkCmdTraceRaysIndirect2KHR-None-09458";
        image_layout_00344                       = "VUID-vkCmdTraceRaysIndirect2KHR-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdTraceRaysIndirect2KHR-None-09600";
        tensorARM_pDescription_09900             = "VUID-vkCmdTraceRaysIndirect2KHR-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdTraceRaysIndirect2KHR-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdTraceRaysIndirect2KHR-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksNV: DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksNV() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksNV) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksNV-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksNV-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksNV-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksNV-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksNV-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksNV-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksNV-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksNV-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksNV-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksNV-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksNV-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksNV-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksNV-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksNV-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksNV-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksNV-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksNV-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksNV-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksNV-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksNV-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksNV-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksNV-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksNV-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksNV-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksNV-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksNV-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksNV-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksNV-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksNV-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksNV-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksNV-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksNV-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksNV-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksNV-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksNV-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksNV-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksNV-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksNV-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksNV-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksNV-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksNV-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksNV-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksNV-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksNV-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksNV-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksNV-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksNV-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksNV-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksNV-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksNV-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksNV-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksNV-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksNV-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksNV-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksNV-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksNV-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksNV-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksNV-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksNV-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksNV-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksNV-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksNV-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksNV-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksNV-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksNV-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksNV-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksNV-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksNV-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksNV-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksNV-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksNV-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksNV-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksNV-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksNV-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksNV-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksNV-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksNV-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksNV-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksNV-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksNV-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksNV-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksNV-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksNV-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksNV-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksNV-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksNV-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksNV-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksNV-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksNV-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksNV-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksNV-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksNV-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksNV-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksNV-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksNV-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksNV-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksNV-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksNV-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksNV-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksNV-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksNV-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksNV-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksNV-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksNV-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksNV-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksNV-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksNV-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksNV-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksNV-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksNV-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksNV-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksNV-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksNV-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksNV-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksNV-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksNV-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksNV-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksNV-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksNV-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksNV-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksNV-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksNV-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksNV-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksNV-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksNV-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksNV-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksNV-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksNV-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksNV-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksNV-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksNV-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksNV-MeshNV-07080";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksNV-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksNV-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksNV-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksNV-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksNV-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksNV-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksNV-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksNV-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksNV-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksNV-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksNV-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksNV-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksNV-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksNV-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksNV-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksNV-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksNV-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksNV-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksNV-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksNV-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksNV-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksNV-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksNV-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksNV-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksNV-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksNV-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksNV-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksNV-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksNV-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksNV-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksNV-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksNV-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksNV-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksNV-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksNV-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksNV-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksNV-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksNV-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksNV-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksNV-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksNV-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksNV-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksNV-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksNV-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksNV-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksNV-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksNV-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksNV-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksNV-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksNV-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksNV-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksNV-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksNV-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksNV-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksNV-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksNV-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksNV-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksNV-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksNV-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksNV-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksNV-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksNV-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksNV-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksNV-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksNV-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksNV-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksNV-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksNV-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksNV-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksNV-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksNV-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksNV-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksNV-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksNV-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksNV-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksNV-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksNV-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksNV-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksNV-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksNV-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksNV-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksNV-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksNV-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksNV-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksNV-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksNV-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksNV-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksNV-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksNV-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksNV-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksNV-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksNV-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksNV-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksNV-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksNV-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksNV-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksIndirectNV: DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksIndirectNV() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksIndirectNV) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksIndirectNV-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksIndirectNV-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksIndirectNV-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksIndirectNV-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksIndirectNV-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksIndirectNV-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksIndirectNV-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawMeshTasksIndirectNV-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawMeshTasksIndirectNV-buffer-02709";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksIndirectNV-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksIndirectNV-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksIndirectNV-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksIndirectNV-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksIndirectNV-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksIndirectNV-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksIndirectNV-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksIndirectNV-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksIndirectNV-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksIndirectNV-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksIndirectNV-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksIndirectNV-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksIndirectNV-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksIndirectNV-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksIndirectNV-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksIndirectNV-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksIndirectNV-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksIndirectNV-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksIndirectNV-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksIndirectNV-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksIndirectNV-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksIndirectNV-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksIndirectNV-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksIndirectNV-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksIndirectNV-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksIndirectNV-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksIndirectNV-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksIndirectNV-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksIndirectNV-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksIndirectNV-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksIndirectNV-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksIndirectNV-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksIndirectNV-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksIndirectNV-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksIndirectNV-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksIndirectNV-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksIndirectNV-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksIndirectNV-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksIndirectNV-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksIndirectNV-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksIndirectNV-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksIndirectNV-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksIndirectNV-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksIndirectNV-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksIndirectNV-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksIndirectNV-MeshNV-07081";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksIndirectNV-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksIndirectNV-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksIndirectNV-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksIndirectNV-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksIndirectNV-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksIndirectNV-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksIndirectNV-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksIndirectNV-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksIndirectNV-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksIndirectNV-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksIndirectNV-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksIndirectNV-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksIndirectNV-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksIndirectNV-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksIndirectNV-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksIndirectNV-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksIndirectNV-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksIndirectNV-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksIndirectNV-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksIndirectNV-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksIndirectNV-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksIndirectNV-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksIndirectNV-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksIndirectNV-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksIndirectNV-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksIndirectNV-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksIndirectNV-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksIndirectNV-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksIndirectNV-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksIndirectNV-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksIndirectNV-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksIndirectNV-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksIndirectNV-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksIndirectNV-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksIndirectNV-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksIndirectNV-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksIndirectNV-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksIndirectNV-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksIndirectNV-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksIndirectNV-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksIndirectNV-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksIndirectNV-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksIndirectNV-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksIndirectNV-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksIndirectNV-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksIndirectNV-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksIndirectNV-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksIndirectNV-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksIndirectNV-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksIndirectNV-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksIndirectCountNV : DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksIndirectCountNV() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksIndirectCountNV) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksIndirectCountNV-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawMeshTasksIndirectCountNV-buffer-02709";
        indirect_count_contiguous_memory_02714   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-countBuffer-02714";
        indirect_count_buffer_bit_02715          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-countBuffer-02715";
        indirect_count_offset_04129              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-countBufferOffset-04129";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-MeshNV-07082";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksIndirectCountNV-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksIndirectCountNV-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksIndirectCountNV-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksIndirectCountNV-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksIndirectCountNV-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksIndirectCountNV-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksIndirectCountNV-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksIndirectCountNV-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksIndirectCountNV-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksIndirectCountNV-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksEXT: DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksEXT() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksEXT-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksEXT-None-02692";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksEXT-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksEXT-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksEXT-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksEXT-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksEXT-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksEXT-MeshEXT-07087";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksEXT-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksEXT-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksEXT-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksEXT-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksEXT-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksEXT-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksEXT-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksEXT-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksEXT-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksIndirectEXT: DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksIndirectEXT() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksIndirectEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksIndirectEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksIndirectEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksIndirectEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksIndirectEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksIndirectEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksIndirectEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksIndirectEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawMeshTasksIndirectEXT-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawMeshTasksIndirectEXT-buffer-02709";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksIndirectEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksIndirectEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksIndirectEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksIndirectEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksIndirectEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksIndirectEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksIndirectEXT-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksIndirectEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksIndirectEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksIndirectEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksIndirectEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksIndirectEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksIndirectEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksIndirectEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksIndirectEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksIndirectEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksIndirectEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksIndirectEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksIndirectEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksIndirectEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksIndirectEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksIndirectEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksIndirectEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksIndirectEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksIndirectEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksIndirectEXT-MeshEXT-07091";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksIndirectEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksIndirectEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksIndirectEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksIndirectEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksIndirectEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksIndirectEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksIndirectEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksIndirectEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksIndirectEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksIndirectEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksIndirectEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksIndirectEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksIndirectEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksIndirectEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksIndirectEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksIndirectEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksIndirectEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksIndirectEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksIndirectEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksIndirectEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksIndirectEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksIndirectEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksIndirectEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksIndirectEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksIndirectEXT-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksIndirectEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksIndirectEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksIndirectEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksIndirectEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksIndirectEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksIndirectEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksIndirectEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawMeshTasksIndirectCountEXT : DrawDispatchVuid {
    DispatchVuidsCmdDrawMeshTasksIndirectCountEXT() : DrawDispatchVuid(Func::vkCmdDrawMeshTasksIndirectCountEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-02711";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-buffer-02708";
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-buffer-02709";
        indirect_count_contiguous_memory_02714   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-countBuffer-02714";
        indirect_count_buffer_bit_02715          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-countBuffer-02715";
        indirect_count_offset_04129              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-countBufferOffset-04129";
        viewport_count_03417                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        mesh_shader_stages_06480                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stage-06480";
        missing_mesh_shader_stages_07080         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-MeshEXT-07100";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08693";
        task_mesh_shader_08694                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08694";
        task_mesh_shader_08695                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08695";
        bound_non_mesh_10680                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pStages-10680";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08879";
        set_line_width_08617                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-sampleLocationsEnable-07487";
        xfb_queries_07074                        = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07074";
        pg_queries_07075                         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07075";
        rasterization_samples_09211              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawMeshTasksIndirectCountEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDrawIndirectByteCountEXT: DrawDispatchVuid {
    DispatchVuidsCmdDrawIndirectByteCountEXT() : DrawDispatchVuid(Func::vkCmdDrawIndirectByteCountEXT) {
        pipeline_bound_08606                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08606";
        vertex_binding_04007                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-04007";
        vertex_binding_null_04008                = "VUID-vkCmdDrawIndirectByteCountEXT-None-04008";
        compatible_pipeline_08600                = "VUID-vkCmdDrawIndirectByteCountEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdDrawIndirectByteCountEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdDrawIndirectByteCountEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdDrawIndirectByteCountEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdDrawIndirectByteCountEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDrawIndirectByteCountEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDrawIndirectByteCountEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDrawIndirectByteCountEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDrawIndirectByteCountEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDrawIndirectByteCountEXT-None-02692";
        indirect_protected_cb_02711              = "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-02646";
        indirect_contiguous_memory_02708         = "VUID-vkCmdDrawIndirectByteCountEXT-counterBuffer-04567",
        indirect_buffer_bit_02290                = "VUID-vkCmdDrawIndirectByteCountEXT-counterBuffer-02290";
        viewport_count_03417                     = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdDrawIndirectByteCountEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-03419";
        primitive_topology_class_07500           = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicPrimitiveTopologyUnrestricted-07500";
        primitive_topology_patch_list_10286      = "VUID-vkCmdDrawIndirectByteCountEXT-primitiveTopology-10286";
        primitive_topology_patch_list_10747      = "VUID-vkCmdDrawIndirectByteCountEXT-primitiveTopology-10747";
        primitive_topology_point_size_10748      = "VUID-vkCmdDrawIndirectByteCountEXT-primitiveTopology-10748";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDrawIndirectByteCountEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDrawIndirectByteCountEXT-maintenance4-08602";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdDrawIndirectByteCountEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdDrawIndirectByteCountEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdDrawIndirectByteCountEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdDrawIndirectByteCountEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDrawIndirectByteCountEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDrawIndirectByteCountEXT-None-08611";
        vertex_binding_attribute_02721           = "VUID-vkCmdDrawIndirectByteCountEXT-None-02721";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-02707";
        max_multiview_instance_index_02688       = "VUID-vkCmdDrawIndirectByteCountEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDrawIndirectByteCountEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDrawIndirectByteCountEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdDrawIndirectByteCountEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        patch_control_points_04875               = "VUID-vkCmdDrawIndirectByteCountEXT-None-04875";
        rasterizer_discard_enable_04876          = "VUID-vkCmdDrawIndirectByteCountEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdDrawIndirectByteCountEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdDrawIndirectByteCountEXT-logicOp-04878";
        primitive_restart_enable_04879           = "VUID-vkCmdDrawIndirectByteCountEXT-None-04879";
        primitive_restart_list_09637             = "VUID-vkCmdDrawIndirectByteCountEXT-None-09637";
        primitive_restart_patch_10909            = "VUID-vkCmdDrawIndirectByteCountEXT-None-10909";
        vertex_input_binding_stride_04913        = "VUID-vkCmdDrawIndirectByteCountEXT-pStrides-04913";
        vertex_input_04914                       = "VUID-vkCmdDrawIndirectByteCountEXT-None-04914";
        vertex_input_08734                       = "VUID-vkCmdDrawIndirectByteCountEXT-Input-08734";
        blend_enable_04727                       = "VUID-vkCmdDrawIndirectByteCountEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdDrawIndirectByteCountEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdDrawIndirectByteCountEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     =  "VUID-vkCmdDrawIndirectByteCountEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdDrawIndirectByteCountEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdDrawIndirectByteCountEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdDrawIndirectByteCountEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdDrawIndirectByteCountEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdDrawIndirectByteCountEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdDrawIndirectByteCountEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdDrawIndirectByteCountEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdDrawIndirectByteCountEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdDrawIndirectByteCountEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdDrawIndirectByteCountEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdDrawIndirectByteCountEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdDrawIndirectByteCountEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdDrawIndirectByteCountEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdDrawIndirectByteCountEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdDrawIndirectByteCountEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdDrawIndirectByteCountEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdDrawIndirectByteCountEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdDrawIndirectByteCountEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdDrawIndirectByteCountEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdDrawIndirectByteCountEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdDrawIndirectByteCountEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdDrawIndirectByteCountEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDrawIndirectByteCountEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDrawIndirectByteCountEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDrawIndirectByteCountEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDrawIndirectByteCountEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDrawIndirectByteCountEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDrawIndirectByteCountEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDrawIndirectByteCountEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDrawIndirectByteCountEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDrawIndirectByteCountEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDrawIndirectByteCountEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDrawIndirectByteCountEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDrawIndirectByteCountEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdDrawIndirectByteCountEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdDrawIndirectByteCountEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdDrawIndirectByteCountEXT-None-06666";
        dynamic_tessellation_domain_origin_07619 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07619";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdDrawIndirectByteCountEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdDrawIndirectByteCountEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdDrawIndirectByteCountEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdDrawIndirectByteCountEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdDrawIndirectByteCountEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdDrawIndirectByteCountEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdDrawIndirectByteCountEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdDrawIndirectByteCountEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdDrawIndirectByteCountEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdDrawIndirectByteCountEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdDrawIndirectByteCountEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdDrawIndirectByteCountEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdDrawIndirectByteCountEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdDrawIndirectByteCountEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdDrawIndirectByteCountEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdDrawIndirectByteCountEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdDrawIndirectByteCountEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdDrawIndirectByteCountEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdDrawIndirectByteCountEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdDrawIndirectByteCountEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdDrawIndirectByteCountEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdDrawIndirectByteCountEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdDrawIndirectByteCountEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdDrawIndirectByteCountEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdDrawIndirectByteCountEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdDrawIndirectByteCountEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdDrawIndirectByteCountEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdDrawIndirectByteCountEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdDrawIndirectByteCountEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdDrawIndirectByteCountEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07841";
        dynamic_primitive_topology_07842         = "VUID-vkCmdDrawIndirectByteCountEXT-None-07842";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdDrawIndirectByteCountEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdDrawIndirectByteCountEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdDrawIndirectByteCountEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdDrawIndirectByteCountEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdDrawIndirectByteCountEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdDrawIndirectByteCountEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdDrawIndirectByteCountEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        invalid_mesh_shader_stages_06481         = "VUID-vkCmdDrawIndirectByteCountEXT-stage-06481";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDrawIndirectByteCountEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDrawIndirectByteCountEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDrawIndirectByteCountEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDrawIndirectByteCountEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDrawIndirectByteCountEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdDrawIndirectByteCountEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdDrawIndirectByteCountEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdDrawIndirectByteCountEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdDrawIndirectByteCountEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdDrawIndirectByteCountEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdDrawIndirectByteCountEXT-None-10772";
        custom_resolve_11521                     = "VUID-vkCmdDrawIndirectByteCountEXT-flags-11521";
        custom_resolve_11522                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11522";
        custom_resolve_11523                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11523";
        custom_resolve_11524                     = "VUID-vkCmdDrawIndirectByteCountEXT-customResolve-11524";
        custom_resolve_11525                     = "VUID-vkCmdDrawIndirectByteCountEXT-customResolve-11525";
        custom_resolve_11529                     = "VUID-vkCmdDrawIndirectByteCountEXT-customResolve-11529";
        custom_resolve_11530                     = "VUID-vkCmdDrawIndirectByteCountEXT-customResolve-11530";
        custom_resolve_11539                     = "VUID-vkCmdDrawIndirectByteCountEXT-pColorAttachments-11539";
        custom_resolve_11540                     = "VUID-vkCmdDrawIndirectByteCountEXT-pDepthAttachment-11540";
        custom_resolve_11860                     = "VUID-vkCmdDrawIndirectByteCountEXT-pStencilAttachment-11860";
        custom_resolve_11861                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11861";
        custom_resolve_11862                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11862";
        custom_resolve_11863                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11863";
        custom_resolve_11864                     = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-11864";
        custom_resolve_11865                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11865";
        custom_resolve_11866                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11866";
        custom_resolve_11867                     = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-11867";
        custom_resolve_11868                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11868";
        custom_resolve_11869                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-11869";
        custom_resolve_11870                     = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-11870";
        external_format_resolve_09362            = "VUID-vkCmdDrawIndirectByteCountEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdDrawIndirectByteCountEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdDrawIndirectByteCountEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdDrawIndirectByteCountEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdDrawIndirectByteCountEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdDrawIndirectByteCountEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdDrawIndirectByteCountEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdDrawIndirectByteCountEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdDrawIndirectByteCountEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdDrawIndirectByteCountEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdDrawIndirectByteCountEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdDrawIndirectByteCountEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdDrawIndirectByteCountEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdDrawIndirectByteCountEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdDrawIndirectByteCountEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdDrawIndirectByteCountEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdDrawIndirectByteCountEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdDrawIndirectByteCountEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdDrawIndirectByteCountEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdDrawIndirectByteCountEXT-None-08879";
        draw_shaders_no_task_mesh_08885          = "VUID-vkCmdDrawIndirectByteCountEXT-None-08885";
        tessellation_subdivision_12239           = "VUID-vkCmdDrawIndirectByteCountEXT-OpExecutionMode-12239";
        tessellation_triangles_12240             = "VUID-vkCmdDrawIndirectByteCountEXT-OpExecutionMode-12240";
        tessellation_segment_12241               = "VUID-vkCmdDrawIndirectByteCountEXT-OpExecutionMode-12241";
        tessellation_patch_size_12242            = "VUID-vkCmdDrawIndirectByteCountEXT-OpExecutionMode-12242";
        set_line_width_08617                     = "VUID-vkCmdDrawIndirectByteCountEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdDrawIndirectByteCountEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdDrawIndirectByteCountEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-09116";
        vertex_input_format_08936                = "VUID-vkCmdDrawIndirectByteCountEXT-format-08936";
        vertex_input_format_08937                = "VUID-vkCmdDrawIndirectByteCountEXT-format-08937";
        vertex_input_format_09203                = "VUID-vkCmdDrawIndirectByteCountEXT-None-09203";
        vertex_input_format_07939                = "VUID-vkCmdDrawIndirectByteCountEXT-Input-07939";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdDrawIndirectByteCountEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdDrawIndirectByteCountEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdDrawIndirectByteCountEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdDrawIndirectByteCountEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdDrawIndirectByteCountEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdDrawIndirectByteCountEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdDrawIndirectByteCountEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdDrawIndirectByteCountEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdDrawIndirectByteCountEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdDrawIndirectByteCountEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdDrawIndirectByteCountEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdDrawIndirectByteCountEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdDrawIndirectByteCountEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdDrawIndirectByteCountEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdDrawIndirectByteCountEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdDrawIndirectByteCountEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdDrawIndirectByteCountEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdDrawIndirectByteCountEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdDrawIndirectByteCountEXT-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdDrawIndirectByteCountEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdDrawIndirectByteCountEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdDrawIndirectByteCountEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdDrawIndirectByteCountEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdDrawIndirectByteCountEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdDrawIndirectByteCountEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdDrawIndirectByteCountEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdDrawIndirectByteCountEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdDrawIndirectByteCountEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDrawIndirectByteCountEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDrawIndirectByteCountEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDispatchBase: DrawDispatchVuid {
    DispatchVuidsCmdDispatchBase() : DrawDispatchVuid(Func::vkCmdDispatchBase) {
        pipeline_bound_08606                     = "VUID-vkCmdDispatchBase-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdDispatchBase-None-08600";
        linear_filter_sampler_04553              = "VUID-vkCmdDispatchBase-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdDispatchBase-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdDispatchBase-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdDispatchBase-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdDispatchBase-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdDispatchBase-None-02692";
        corner_sampled_address_mode_02696        = "VUID-vkCmdDispatchBase-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdDispatchBase-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdDispatchBase-None-07888";
        push_constants_set_08602                 = "VUID-vkCmdDispatchBase-maintenance4-08602";
        sampler_imageview_type_08609             = "VUID-vkCmdDispatchBase-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdDispatchBase-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdDispatchBase-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdDispatchBase-None-08608";
        unprotected_command_buffer_02707         = "VUID-vkCmdDispatchBase-commandBuffer-02707";
        compute_not_bound_10743                  = "VUID-vkCmdDispatchBase-None-10743";
        compute_inside_rp_10672                  = "VUID-vkCmdDispatchBase-None-10672";
        protected_command_buffer_02712           = "VUID-vkCmdDispatchBase-commandBuffer-02712";
        ray_query_04617                          = "VUID-vkCmdDispatchBase-commandBuffer-04617";
        img_filter_cubic_02693                   = "VUID-vkCmdDispatchBase-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdDispatchBase-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdDispatchBase-filterCubicMinmax-02695";
        image_view_access_64_04470               = "VUID-vkCmdDispatchBase-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdDispatchBase-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdDispatchBase-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdDispatchBase-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdDispatchBase-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdDispatchBase-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdDispatchBase-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdDispatchBase-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdDispatchBase-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdDispatchBase-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdDispatchBase-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdDispatchBase-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdDispatchBase-None-06479";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdDispatchBase-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdDispatchBase-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdDispatchBase-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdDispatchBase-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdDispatchBase-format-07753";
        tensorARM_pDescription_09900             = "VUID-vkCmdDispatchBase-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdDispatchBase-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdDispatchBase-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdExecuteGeneratedCommandsEXT : DrawDispatchVuid {
    DispatchVuidsCmdExecuteGeneratedCommandsEXT() : DrawDispatchVuid(Func::vkCmdExecuteGeneratedCommandsEXT) {
        compute_inside_rp_10672                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-indirectCommandsLayout-12202";
        pipeline_bound_08606                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08606";
        compatible_pipeline_08600                = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08600";
        render_pass_compatible_02684             = "VUID-vkCmdExecuteGeneratedCommandsEXT-renderPass-02684";
        render_pass_began_08876                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08876";
        subpass_index_02685                      = "VUID-vkCmdExecuteGeneratedCommandsEXT-subpass-02685";
        sample_location_02689                    = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-02689";
        linear_filter_sampler_04553              = "VUID-vkCmdExecuteGeneratedCommandsEXT-magFilter-04553";
        linear_mipmap_sampler_04770              = "VUID-vkCmdExecuteGeneratedCommandsEXT-mipmapMode-04770";
        linear_filter_sampler_09598              = "VUID-vkCmdExecuteGeneratedCommandsEXT-magFilter-09598";
        linear_mipmap_sampler_09599              = "VUID-vkCmdExecuteGeneratedCommandsEXT-mipmapMode-09599";
        unnormalized_coordinates_09635           = "VUID-vkCmdExecuteGeneratedCommandsEXT-unnormalizedCoordinates-09635";
        cubic_sampler_02692                      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-02692";
        viewport_count_03417                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-03417";
        scissor_count_03418                      = "VUID-vkCmdExecuteGeneratedCommandsEXT-scissorCount-03418";
        viewport_scissor_count_03419             = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-03419";
        corner_sampled_address_mode_02696        = "VUID-vkCmdExecuteGeneratedCommandsEXT-flags-02696";
        imageview_atomic_02691                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-02691";
        bufferview_atomic_07888                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07888";
        image_subresources_render_pass_write_06537 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06537";
        image_subresources_subpass_read_09003    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09003";
        image_subresources_subpass_write_06539   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06539";
        sampler_imageview_type_08609             = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08609";
        sampler_implicitLod_dref_proj_08610      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08610";
        sampler_bias_offset_08611                = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08611";
        dynamic_state_setting_commands_08608     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08608";
        max_multiview_instance_index_02688       = "VUID-vkCmdExecuteGeneratedCommandsEXT-maxMultiviewInstanceIndex-02688";
        img_filter_cubic_02693                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-02693";
        filter_cubic_02694                       = "VUID-vkCmdExecuteGeneratedCommandsEXT-filterCubic-02694";
        filter_cubic_min_max_02695               = "VUID-vkCmdExecuteGeneratedCommandsEXT-filterCubicMinmax-02695";
        viewport_count_primitive_shading_rate_04552 = "VUID-vkCmdExecuteGeneratedCommandsEXT-primitiveFragmentShadingRateWithMultipleViewports-04552";
        rasterizer_discard_enable_04876          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-04876";
        depth_bias_enable_04877                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-04877";
        logic_op_04878                           = "VUID-vkCmdExecuteGeneratedCommandsEXT-logicOp-04878";
        blend_enable_04727                       = "VUID-vkCmdExecuteGeneratedCommandsEXT-blendEnable-04727";
        blend_dual_source_09239                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-maxFragmentDualSrcAttachments-09239";
        dynamic_discard_rectangle_07751          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07751";
        dynamic_discard_rectangle_enable_07880   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07880";
        dynamic_discard_rectangle_mode_07881     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07881";
        dynamic_exclusive_scissor_enable_07878   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07878";
        dynamic_exclusive_scissor_07879          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07879";
        dynamic_color_write_enable_07749         = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07749";
        dynamic_color_write_enable_count_07750   = "VUID-vkCmdExecuteGeneratedCommandsEXT-attachmentCount-07750";
        dynamic_attachment_feedback_loop_08877   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08877";
        dynamic_rendering_view_mask_06178        = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewMask-06178";
        dynamic_rendering_color_count_06179      = "VUID-vkCmdExecuteGeneratedCommandsEXT-colorAttachmentCount-06179";
        dynamic_rendering_color_formats_08910    = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08910";
        dynamic_rendering_unused_attachments_08911 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08911";
        dynamic_rendering_undefined_color_formats_08912 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08912";
        dynamic_rendering_undefined_stencil_format_08916 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08916";
        dynamic_rendering_depth_format_08914     = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08914";
        dynamic_rendering_unused_attachments_08915 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08915";
        dynamic_rendering_stencil_format_08917   = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08917";
        dynamic_rendering_unused_attachments_08918 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08918";
        dynamic_rendering_fsr_06183              = "VUID-vkCmdExecuteGeneratedCommandsEXT-imageView-06183";
        dynamic_rendering_fdm_06184              = "VUID-vkCmdExecuteGeneratedCommandsEXT-imageView-06184";
        dynamic_rendering_color_sample_06185     = "VUID-vkCmdExecuteGeneratedCommandsEXT-colorAttachmentCount-06185";
        dynamic_rendering_depth_sample_06186     = "VUID-vkCmdExecuteGeneratedCommandsEXT-pDepthAttachment-06186";
        dynamic_rendering_stencil_sample_06187   = "VUID-vkCmdExecuteGeneratedCommandsEXT-pStencilAttachment-06187";
        dynamic_rendering_06198                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-renderPass-06198";
        dynamic_rendering_07285                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-multisampledRenderToSingleSampled-07285";
        dynamic_rendering_07286                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-multisampledRenderToSingleSampled-07286";
        dynamic_rendering_07287                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-multisampledRenderToSingleSampled-07287";
        dynamic_rendering_local_location_09548   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09548";
        dynamic_rendering_local_index_09549      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09549";
        dynamic_rendering_local_index_10927      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10927";
        dynamic_rendering_local_index_10928      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10928";
        dynamic_rendering_dithering_09642        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09642";
        dynamic_rendering_dithering_09643        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09643";
        dynamic_rendering_local_read_11797       = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingLocalRead-11797";
        image_view_access_64_04470               = "VUID-vkCmdExecuteGeneratedCommandsEXT-SampledType-04470";
        image_view_access_32_04471               = "VUID-vkCmdExecuteGeneratedCommandsEXT-SampledType-04471";
        image_view_sparse_64_04474               = "VUID-vkCmdExecuteGeneratedCommandsEXT-sparseImageInt64Atomics-04474";
        buffer_view_access_64_04472              = "VUID-vkCmdExecuteGeneratedCommandsEXT-SampledType-04472";
        buffer_view_access_32_04473              = "VUID-vkCmdExecuteGeneratedCommandsEXT-SampledType-04473";
        storage_image_read_without_format_07028  = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpTypeImage-07028";
        storage_image_write_without_format_07027 = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpTypeImage-07027";
        storage_texel_buffer_read_without_format_07030  = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpTypeImage-07030";
        storage_texel_buffer_write_without_format_07029 = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpTypeImage-07029";
        storage_image_write_texel_count_08795           = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpImageWrite-08795";
        storage_image_write_texel_count_08796           = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpImageWrite-08796";
        storage_texel_buffer_write_texel_count_04469    = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpImageWrite-04469";
        depth_compare_sample_06479               = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06479";
        depth_read_only_06886                    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06886";
        stencil_read_only_06887                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06887";
        dynamic_sample_locations_06666           = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-06666";
        dynamic_depth_clamp_enable_07620         = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07620";
        dynamic_polygon_mode_07621               = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07621";
        dynamic_rasterization_samples_07622      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07622";
        dynamic_sample_mask_07623                = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07623";
        dynamic_alpha_to_coverage_enable_07624   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07624";
        dynamic_alpha_to_coverage_component_08919 = "VUID-vkCmdExecuteGeneratedCommandsEXT-alphaToCoverageEnable-08919";
        dynamic_alpha_to_one_enable_07625        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07625";
        dynamic_logic_op_enable_07626            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07626";
        dynamic_color_blend_enable_07476         = "VUID-vkCmdExecuteGeneratedCommandsEXT-firstAttachment-07476";
        dynamic_color_write_mask_07478           = "VUID-vkCmdExecuteGeneratedCommandsEXT-firstAttachment-07478";
        dynamic_color_blend_equation_10862       = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10862";
        dynamic_color_blend_equation_10863       = "VUID-vkCmdExecuteGeneratedCommandsEXT-rasterizerDiscardEnable-10863";
        dynamic_color_blend_equation_10864       = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10864";
        dynamic_rasterization_stream_07630       = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07630";
        dynamic_conservative_rasterization_mode_07631 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07631";
        dynamic_extra_primitive_overestimation_size_07632 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07632";
        dynamic_depth_clip_enable_07633          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07633";
        dynamic_sample_locations_enable_07634    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07634";
        dynamic_provoking_vertex_mode_07636      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07636";
        dynamic_depth_clip_negative_one_to_one_07639 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07639";
        dynamic_viewport_w_scaling_enable_07640  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07640";
        dynamic_viewport_swizzle_07641           = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07641";
        dynamic_coverage_to_color_enable_07642   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07642";
        dynamic_coverage_to_color_location_07643 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07643";
        dynamic_coverage_modulation_mode_07644   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07644";
        dynamic_coverage_modulation_table_enable_07645 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07645";
        dynamic_coverage_modulation_table_07646  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07646";
        dynamic_shading_rate_image_enable_07647  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07647";
        dynamic_representative_fragment_test_enable_07648  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07648";
        dynamic_coverage_reduction_mode_07649    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07649";
        dynamic_depth_clamp_control_09650        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09650";
        dynamic_viewport_07831                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07831";
        dynamic_scissor_07832                    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07832";
        dynamic_depth_bias_07834                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07834";
        dynamic_line_stipple_ext_07849           = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07849";
        dynamic_blend_constants_07835            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07835";
        dynamic_depth_bounds_07836               = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07836";
        dynamic_depth_enable_08715               = "VUID-vkCmdExecuteGeneratedCommandsEXT-pDynamicStates-08715";
        dynamic_stencil_compare_mask_07837       = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07837";
        dynamic_stencil_write_mask_07838         = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07838";
        dynamic_stencil_write_mask_08716         = "VUID-vkCmdExecuteGeneratedCommandsEXT-pDynamicStates-08716";
        dynamic_stencil_reference_07839          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07839";
        dynamic_state_inherited_07850            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07850";
        dynamic_cull_mode_07840                  = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07840";
        dynamic_front_face_07841                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07841";
        dynamic_depth_test_enable_07843          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07843";
        dynamic_depth_write_enable_07844         = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07844";
        dynamic_depth_compare_op_07845           = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07845";
        dynamic_depth_bound_test_enable_07846    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07846";
        dynamic_stencil_test_enable_07847        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07847";
        dynamic_stencil_op_07848                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07848";
        primitives_generated_06708               = "VUID-vkCmdExecuteGeneratedCommandsEXT-primitivesGeneratedQueryWithRasterizerDiscard-06708";
        primitives_generated_streams_06709       = "VUID-vkCmdExecuteGeneratedCommandsEXT-primitivesGeneratedQueryWithNonZeroStreams-06709";
        descriptor_buffer_bit_set_08114          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08114";
        descriptor_buffer_bit_not_set_08115      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08115";
        descriptor_buffer_set_offset_missing_08117 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08117";
        image_view_dim_07752                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewType-07752";
        image_view_numeric_format_07753          = "VUID-vkCmdExecuteGeneratedCommandsEXT-format-07753";
        stippled_rectangular_lines_07495         = "VUID-vkCmdExecuteGeneratedCommandsEXT-stippledLineEnable-07495";
        stippled_bresenham_lines_07496           = "VUID-vkCmdExecuteGeneratedCommandsEXT-stippledLineEnable-07496";
        stippled_smooth_lines_07497              = "VUID-vkCmdExecuteGeneratedCommandsEXT-stippledLineEnable-07497";
        stippled_default_strict_07498            = "VUID-vkCmdExecuteGeneratedCommandsEXT-stippledLineEnable-07498";
        viewport_and_scissor_with_count_03419    = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-03419";
        viewport_w_scaling_08636                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08636";
        shading_rate_palette_08637               = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08637";
        shader_object_multiview_10772            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10772";
        external_format_resolve_09362            = "VUID-vkCmdExecuteGeneratedCommandsEXT-colorAttachmentCount-09362";
        external_format_resolve_09363            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09363";
        external_format_resolve_09364            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09364";
        external_format_resolve_09365            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09365";
        external_format_resolve_09368            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09368";
        external_format_resolve_09369            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09369";
        external_format_resolve_09372            = "VUID-vkCmdExecuteGeneratedCommandsEXT-colorAttachmentCount-09372";
        set_rasterization_samples_08644          = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08644";
        set_line_rasterization_mode_08666        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08666";
        set_line_stipple_enable_08669            = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08669";
        next_stage_10745                         = "VUID-vkCmdExecuteGeneratedCommandsEXT-nextStage-10745";
        vertex_shader_08684                      = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08684";
        tessellation_control_shader_08685        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08685";
        tessellation_evaluation_shader_08686     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08686";
        geometry_shader_08687                    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08687";
        fragment_shader_08688                    = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08688";
        task_shader_08689                        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08689";
        mesh_shader_08690                        = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08690";
        vert_mesh_shader_08693                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08693";
        vert_task_mesh_shader_08696              = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08696";
        linked_shaders_08698                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08698";
        linked_shaders_08699                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08699";
        shaders_push_constants_08878             = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08878";
        shaders_descriptor_layouts_08879         = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08879";
        set_line_width_08617                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-08617";
        set_viewport_with_count_08642            = "VUID-vkCmdExecuteGeneratedCommandsEXT-primitiveFragmentShadingRateWithMultipleViewports-08642";
        alpha_component_word_08920               = "VUID-vkCmdExecuteGeneratedCommandsEXT-alphaToCoverageEnable-08920";
        color_write_mask_09116                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09116";
        set_clip_space_w_scaling_04138           = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-04138";
        set_discard_rectangle_09236              = "VUID-vkCmdExecuteGeneratedCommandsEXT-rasterizerDiscardEnable-09236";
        set_viewport_coarse_sample_order_09233   = "VUID-vkCmdExecuteGeneratedCommandsEXT-shadingRateImage-09233";
        set_viewport_shading_rate_palette_09234  = "VUID-vkCmdExecuteGeneratedCommandsEXT-shadingRateImage-09234";
        set_fragment_shading_rate_09238          = "VUID-vkCmdExecuteGeneratedCommandsEXT-pipelineFragmentShadingRate-09238";
        rasterization_samples_07935              = "VUID-vkCmdExecuteGeneratedCommandsEXT-pNext-07935";
        mesh_shader_queries_07073                = "VUID-vkCmdExecuteGeneratedCommandsEXT-stage-07073";
        fdm_layered_10831                        = "VUID-vkCmdExecuteGeneratedCommandsEXT-layers-10831";
        blend_advanced_07480                     = "VUID-vkCmdExecuteGeneratedCommandsEXT-advancedBlendMaxColorAttachments-07480";
        color_attachment_08963                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-pColorAttachments-08963";
        depth_attachment_08964                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-pDepthAttachment-08964";
        stencil_attachment_08965                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-pStencilAttachment-08965";
        sample_locations_07482                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsPerPixel-07482";
        sample_locations_07483                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsPerPixel-07483";
        sample_locations_07471                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-rasterizationSamples-07471";
        sample_locations_enable_07936            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07936";
        sample_locations_enable_07937            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07937";
        sample_locations_enable_07938            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07938";
        set_coverage_to_color_location_09420     = "VUID-vkCmdExecuteGeneratedCommandsEXT-rasterizerDiscardEnable-09420";
        set_coverage_to_color_location_07490     = "VUID-vkCmdExecuteGeneratedCommandsEXT-coverageToColorEnable-07490";
        set_viewport_swizzle_09421               = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-09421";
        set_viewport_swizzle_07493               = "VUID-vkCmdExecuteGeneratedCommandsEXT-viewportCount-07493";
        convervative_rasterization_07499         = "VUID-vkCmdExecuteGeneratedCommandsEXT-conservativePointAndLineRasterization-07499";
        sample_mask_07472                        = "VUID-vkCmdExecuteGeneratedCommandsEXT-samples-07472";
        sample_mask_07473                       = "VUID-vkCmdExecuteGeneratedCommandsEXT-samples-07473";
        sample_locations_enable_07484            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07484";
        sample_locations_enable_07485            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07485";
        sample_locations_enable_07486            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07486";
        sample_locations_enable_07487            = "VUID-vkCmdExecuteGeneratedCommandsEXT-sampleLocationsEnable-07487";
        rasterization_samples_09211              = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09211";
        dynamic_rendering_undefined_depth_format_08913 = "VUID-vkCmdExecuteGeneratedCommandsEXT-dynamicRenderingUnusedAttachments-08913";
        primitives_generated_query_07481         = "VUID-vkCmdExecuteGeneratedCommandsEXT-primitivesGeneratedQueryWithNonZeroStreams-07481";
        color_blend_enable_07627                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07627";
        color_write_mask_07629                   = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-07629";
        image_layout_00344                       = "VUID-vkCmdExecuteGeneratedCommandsEXT-imageLayout-00344";
        image_layout_09600                       = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-09600";
        rendering_contents_10582                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-flags-10582";
        line_rasterization_10608                 = "VUID-vkCmdExecuteGeneratedCommandsEXT-None-10608";
        tensorARM_pDescription_09900             = "VUID-vkCmdExecuteGeneratedCommandsEXT-pDescription-09900";
        tensorARM_dimensionCount_09905           = "VUID-vkCmdExecuteGeneratedCommandsEXT-dimensionCount-09905";
        spirv_OpTypeTensorARM_09906              = "VUID-vkCmdExecuteGeneratedCommandsEXT-OpTypeTensorARM-09906";
    }
};

struct DispatchVuidsCmdDispatchDataGraphARM : DrawDispatchVuid {
    DispatchVuidsCmdDispatchDataGraphARM() : DrawDispatchVuid(Func::vkCmdDispatchDataGraphARM) {
        pipeline_bound_08606                     = "VUID-vkCmdDispatchDataGraphARM-None-09799";
        compatible_pipeline_08600                = "VUID-vkCmdDispatchDataGraphARM-None-09797";
        unprotected_command_buffer_02707         = "VUID-vkCmdDispatchDataGraphARM-commandBuffer-09800";
        protected_command_buffer_02712           = "VUID-vkCmdDispatchDataGraphARM-commandBuffer-09801";
    }
};

using Func = vvl::Func;
// This LUT is created to allow a static listing of each VUID that is covered by drawdispatch commands
const auto &GetDrawDispatchVuid() {
static const std::pair<Func, DrawDispatchVuid> pairs[] = {
    {Func::vkCmdDraw, DispatchVuidsCmdDraw()},
    {Func::vkCmdDrawMultiEXT, DispatchVuidsCmdDrawMultiEXT()},
    {Func::vkCmdDrawIndexed, DispatchVuidsCmdDrawIndexed()},
    {Func::vkCmdDrawMultiIndexedEXT, DispatchVuidsCmdDrawMultiIndexedEXT()},
    {Func::vkCmdDrawIndirect, DispatchVuidsCmdDrawIndirect()},
    {Func::vkCmdDrawIndexedIndirect, DispatchVuidsCmdDrawIndexedIndirect()},
    {Func::vkCmdDispatch, DispatchVuidsCmdDispatch()},
    {Func::vkCmdDispatchIndirect, DispatchVuidsCmdDispatchIndirect()},
    {Func::vkCmdDrawIndirectCount, DispatchVuidsCmdDrawIndirectCount()},
    {Func::vkCmdDrawIndirectCountKHR , DispatchVuidsCmdDrawIndirectCount()},
    {Func::vkCmdDrawIndexedIndirectCount, DispatchVuidsCmdDrawIndexedIndirectCount()},
    {Func::vkCmdDrawIndexedIndirectCountKHR, DispatchVuidsCmdDrawIndexedIndirectCount()},
    {Func::vkCmdTraceRaysNV, DispatchVuidsCmdTraceRaysNV()},
    {Func::vkCmdTraceRaysKHR, DispatchVuidsCmdTraceRaysKHR()},
    {Func::vkCmdTraceRaysIndirectKHR, DispatchVuidsCmdTraceRaysIndirectKHR()},
    {Func::vkCmdTraceRaysIndirect2KHR, DispatchVuidsCmdTraceRaysIndirect2KHR()},
    {Func::vkCmdDrawMeshTasksNV, DispatchVuidsCmdDrawMeshTasksNV()},
    {Func::vkCmdDrawMeshTasksIndirectNV, DispatchVuidsCmdDrawMeshTasksIndirectNV()},
    {Func::vkCmdDrawMeshTasksIndirectCountNV, DispatchVuidsCmdDrawMeshTasksIndirectCountNV()},
    {Func::vkCmdDrawMeshTasksEXT, DispatchVuidsCmdDrawMeshTasksEXT()},
    {Func::vkCmdDrawMeshTasksIndirectEXT, DispatchVuidsCmdDrawMeshTasksIndirectEXT()},
    {Func::vkCmdDrawMeshTasksIndirectCountEXT, DispatchVuidsCmdDrawMeshTasksIndirectCountEXT()},
    {Func::vkCmdDrawIndirectByteCountEXT, DispatchVuidsCmdDrawIndirectByteCountEXT()},
    {Func::vkCmdDispatchBase, DispatchVuidsCmdDispatchBase()},
    {Func::vkCmdDispatchBaseKHR, DispatchVuidsCmdDispatchBase()},
    {Func::vkCmdExecuteGeneratedCommandsEXT, DispatchVuidsCmdExecuteGeneratedCommandsEXT()},
    {Func::vkCmdDispatchDataGraphARM, DispatchVuidsCmdDispatchDataGraphARM()},
    // Used if invalid function is used
    {Func::Empty, DrawDispatchVuid(Func::Empty)}
};
static const auto kDrawdispatchVuid = vvl::unordered_map<Func, DrawDispatchVuid>{std::begin(pairs), std::end(pairs)};

  return kDrawdispatchVuid;
}
// clang-format on

// Getter function to provide kVUIDUndefined in case an invalid function is passed in. Likely if new extension adds command and
// VUIDs are not added yet
const DrawDispatchVuid& GetDrawDispatchVuid(Func function) {
    const vvl::unordered_map<Func, DrawDispatchVuid>& vuids = GetDrawDispatchVuid();
    if (vuids.find(function) != vuids.cend()) {
        return vuids.at(function);
    } else {
        return vuids.at(Func::Empty);
    }
}
}  // namespace vvl
