// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_auth_decorator.h"
#include "google/cloud/internal/async_read_write_stream_auth.h"
#include "google/cloud/internal/async_streaming_read_rpc_auth.h"
#include "google/cloud/internal/async_streaming_write_rpc_auth.h"
#include "google/cloud/internal/streaming_write_rpc_impl.h"
#include <generator/integration_tests/test.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenKitchenSinkAuth::GoldenKitchenSinkAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<GoldenKitchenSinkStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::test::admin::database::v1::GenerateAccessTokenResponse> GoldenKitchenSinkAuth::GenerateAccessToken(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GenerateAccessToken(context, options, request);
}

StatusOr<google::test::admin::database::v1::GenerateIdTokenResponse> GoldenKitchenSinkAuth::GenerateIdToken(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateIdTokenRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GenerateIdToken(context, options, request);
}

StatusOr<google::test::admin::database::v1::WriteLogEntriesResponse> GoldenKitchenSinkAuth::WriteLogEntries(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::WriteLogEntriesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->WriteLogEntries(context, options, request);
}

StatusOr<google::test::admin::database::v1::ListLogsResponse> GoldenKitchenSinkAuth::ListLogs(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ListLogsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListLogs(context, options, request);
}

StatusOr<google::test::admin::database::v1::ListServiceAccountKeysResponse> GoldenKitchenSinkAuth::ListServiceAccountKeys(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ListServiceAccountKeysRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListServiceAccountKeys(context, options, request);
}

Status GoldenKitchenSinkAuth::DoNothing(
    grpc::ClientContext& context,
    Options const& options,
    google::protobuf::Empty const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DoNothing(context, options, request);
}

Status GoldenKitchenSinkAuth::Deprecated2(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Deprecated2(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<google::test::admin::database::v1::Response>>
GoldenKitchenSinkAuth::StreamingRead(
   std::shared_ptr<grpc::ClientContext> context,
   Options const& options,
   google::test::admin::database::v1::Request const& request) {
  using ErrorStream = ::google::cloud::internal::StreamingReadRpcError<
      google::test::admin::database::v1::Response>;
  auto status = auth_->ConfigureContext(*context);
  if (!status.ok()) return std::make_unique<ErrorStream>(std::move(status));
  return child_->StreamingRead(std::move(context), options, request);
}

std::unique_ptr<::google::cloud::internal::StreamingWriteRpc<
    google::test::admin::database::v1::Request,
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkAuth::StreamingWrite(
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options) {
  using ErrorStream = ::google::cloud::internal::StreamingWriteRpcError<
      google::test::admin::database::v1::Request, google::test::admin::database::v1::Response>;
  auto status = auth_->ConfigureContext(*context);
  if (!status.ok()) return std::make_unique<ErrorStream>(std::move(status));
  return child_->StreamingWrite(std::move(context), options);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::test::admin::database::v1::Request,
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkAuth::AsyncStreamingReadWrite(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using StreamAuth = google::cloud::internal::AsyncStreamingReadWriteRpcAuth<
    google::test::admin::database::v1::Request, google::test::admin::database::v1::Response>;

  auto call = [child = child_, cq, options = std::move(options)](
                  std::shared_ptr<grpc::ClientContext> ctx) {
    return child->AsyncStreamingReadWrite(cq, std::move(ctx), options);
  };
  return std::make_unique<StreamAuth>(
    std::move(context), auth_, StreamAuth::StreamFactory(std::move(call)));
}

Status GoldenKitchenSinkAuth::ExplicitRouting1(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ExplicitRoutingRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ExplicitRouting1(context, options, request);
}

Status GoldenKitchenSinkAuth::ExplicitRouting2(
    grpc::ClientContext& context,
    Options const& options,
    google::test::admin::database::v1::ExplicitRoutingRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ExplicitRouting2(context, options, request);
}

std::unique_ptr<::google::cloud::internal::AsyncStreamingReadRpc<
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkAuth::AsyncStreamingRead(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::Request const& request) {
  using StreamAuth = google::cloud::internal::AsyncStreamingReadRpcAuth<
    google::test::admin::database::v1::Response>;

  auto& child = child_;
  auto call = [child, cq, opts = std::move(options), request](std::shared_ptr<grpc::ClientContext> ctx) {
    return child->AsyncStreamingRead(cq, std::move(ctx), opts, request);
  };
  return std::make_unique<StreamAuth>(
    std::move(context), auth_, StreamAuth::StreamFactory(std::move(call)));
}

std::unique_ptr<::google::cloud::internal::AsyncStreamingWriteRpc<
    google::test::admin::database::v1::Request, google::test::admin::database::v1::Response>>
GoldenKitchenSinkAuth::AsyncStreamingWrite(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using StreamAuth = google::cloud::internal::AsyncStreamingWriteRpcAuth<
    google::test::admin::database::v1::Request, google::test::admin::database::v1::Response>;

  auto call = [child = child_, cq, options = std::move(options)](
                  std::shared_ptr<grpc::ClientContext> ctx) {
    return child->AsyncStreamingWrite(cq, std::move(ctx), options);
  };
  return std::make_unique<StreamAuth>(
    std::move(context), auth_, StreamAuth::StreamFactory(std::move(call)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
