// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

#include "google/cloud/assuredworkloads/v1/assured_workloads_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace assuredworkloads_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AssuredWorkloadsServiceConnectionIdempotencyPolicy::
    ~AssuredWorkloadsServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<AssuredWorkloadsServiceConnectionIdempotencyPolicy>
AssuredWorkloadsServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AssuredWorkloadsServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::CreateWorkload(
    google::cloud::assuredworkloads::v1::CreateWorkloadRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::UpdateWorkload(
    google::cloud::assuredworkloads::v1::UpdateWorkloadRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AssuredWorkloadsServiceConnectionIdempotencyPolicy::RestrictAllowedResources(
    google::cloud::assuredworkloads::v1::
        RestrictAllowedResourcesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::DeleteWorkload(
    google::cloud::assuredworkloads::v1::DeleteWorkloadRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::GetWorkload(
    google::cloud::assuredworkloads::v1::GetWorkloadRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::ListWorkloads(
    google::cloud::assuredworkloads::v1::ListWorkloadsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::ListViolations(
    google::cloud::assuredworkloads::v1::ListViolationsRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency AssuredWorkloadsServiceConnectionIdempotencyPolicy::GetViolation(
    google::cloud::assuredworkloads::v1::GetViolationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AssuredWorkloadsServiceConnectionIdempotencyPolicy::AcknowledgeViolation(
    google::cloud::assuredworkloads::v1::AcknowledgeViolationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AssuredWorkloadsServiceConnectionIdempotencyPolicy>
MakeDefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy() {
  return std::make_unique<AssuredWorkloadsServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads_v1
}  // namespace cloud
}  // namespace google
