// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#include "google/cloud/backupdr/v1/internal/backup_dr_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace backupdr_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BackupDRTracingConnection::BackupDRTracingConnection(
    std::shared_ptr<backupdr_v1::BackupDRConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::backupdr::v1::ManagementServer>
BackupDRTracingConnection::ListManagementServers(
    google::cloud::backupdr::v1::ListManagementServersRequest request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::ListManagementServers");
  internal::OTelScope scope(span);
  auto sr = child_->ListManagementServers(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::backupdr::v1::ManagementServer>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::backupdr::v1::ManagementServer>
BackupDRTracingConnection::GetManagementServer(
    google::cloud::backupdr::v1::GetManagementServerRequest const& request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::GetManagementServer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetManagementServer(request));
}

future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
BackupDRTracingConnection::CreateManagementServer(
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::CreateManagementServer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateManagementServer(request));
}

StatusOr<google::longrunning::Operation>
BackupDRTracingConnection::CreateManagementServer(
    NoAwaitTag,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::CreateManagementServer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateManagementServer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
BackupDRTracingConnection::CreateManagementServer(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::CreateManagementServer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateManagementServer(operation));
}

future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
BackupDRTracingConnection::DeleteManagementServer(
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::DeleteManagementServer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteManagementServer(request));
}

StatusOr<google::longrunning::Operation>
BackupDRTracingConnection::DeleteManagementServer(
    NoAwaitTag,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::DeleteManagementServer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteManagementServer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
BackupDRTracingConnection::DeleteManagementServer(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "backupdr_v1::BackupDRConnection::DeleteManagementServer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteManagementServer(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<backupdr_v1::BackupDRConnection> MakeBackupDRTracingConnection(
    std::shared_ptr<backupdr_v1::BackupDRConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<BackupDRTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1_internal
}  // namespace cloud
}  // namespace google
