// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_CATALOG_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_CATALOG_CONNECTION_H

#include "google/cloud/dataplex/v1/catalog_connection_idempotency_policy.h"
#include "google/cloud/dataplex/v1/internal/catalog_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/dataplex/v1/catalog.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `CatalogServiceConnection`.
class CatalogServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<CatalogServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `CatalogServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class CatalogServiceLimitedErrorCountRetryPolicy
    : public CatalogServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit CatalogServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  CatalogServiceLimitedErrorCountRetryPolicy(
      CatalogServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : CatalogServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  CatalogServiceLimitedErrorCountRetryPolicy(
      CatalogServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : CatalogServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<CatalogServiceRetryPolicy> clone() const override {
    return std::make_unique<CatalogServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = CatalogServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      dataplex_v1_internal::CatalogServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `CatalogServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class CatalogServiceLimitedTimeRetryPolicy : public CatalogServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit CatalogServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  CatalogServiceLimitedTimeRetryPolicy(
      CatalogServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : CatalogServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  CatalogServiceLimitedTimeRetryPolicy(
      CatalogServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : CatalogServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<CatalogServiceRetryPolicy> clone() const override {
    return std::make_unique<CatalogServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = CatalogServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      dataplex_v1_internal::CatalogServiceRetryTraits>
      impl_;
};

/**
 * The `CatalogServiceConnection` object for `CatalogServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `CatalogServiceClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `CatalogServiceClient`.
 *
 * To create a concrete instance, see `MakeCatalogServiceConnection()`.
 *
 * For mocking, see `dataplex_v1_mocks::MockCatalogServiceConnection`.
 */
class CatalogServiceConnection {
 public:
  virtual ~CatalogServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryType>>
  CreateEntryType(
      google::cloud::dataplex::v1::CreateEntryTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateEntryType(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateEntryTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryType>>
  CreateEntryType(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryType>>
  UpdateEntryType(
      google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateEntryType(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryType>>
  UpdateEntryType(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteEntryType(
      google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteEntryType(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteEntryType(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::EntryType> ListEntryTypes(
      google::cloud::dataplex::v1::ListEntryTypesRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::EntryType> GetEntryType(
      google::cloud::dataplex::v1::GetEntryTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::AspectType>>
  CreateAspectType(
      google::cloud::dataplex::v1::CreateAspectTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateAspectType(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateAspectTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::AspectType>>
  CreateAspectType(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::AspectType>>
  UpdateAspectType(
      google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateAspectType(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::AspectType>>
  UpdateAspectType(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteAspectType(
      google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteAspectType(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteAspectType(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::AspectType> ListAspectTypes(
      google::cloud::dataplex::v1::ListAspectTypesRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::AspectType> GetAspectType(
      google::cloud::dataplex::v1::GetAspectTypeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
  CreateEntryGroup(
      google::cloud::dataplex::v1::CreateEntryGroupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateEntryGroup(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateEntryGroupRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
  CreateEntryGroup(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
  UpdateEntryGroup(
      google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateEntryGroup(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
  UpdateEntryGroup(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteEntryGroup(
      google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteEntryGroup(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteEntryGroup(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::EntryGroup> ListEntryGroups(
      google::cloud::dataplex::v1::ListEntryGroupsRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::EntryGroup> GetEntryGroup(
      google::cloud::dataplex::v1::GetEntryGroupRequest const& request);

  virtual StatusOr<google::cloud::dataplex::v1::Entry> CreateEntry(
      google::cloud::dataplex::v1::CreateEntryRequest const& request);

  virtual StatusOr<google::cloud::dataplex::v1::Entry> UpdateEntry(
      google::cloud::dataplex::v1::UpdateEntryRequest const& request);

  virtual StatusOr<google::cloud::dataplex::v1::Entry> DeleteEntry(
      google::cloud::dataplex::v1::DeleteEntryRequest const& request);

  virtual StreamRange<google::cloud::dataplex::v1::Entry> ListEntries(
      google::cloud::dataplex::v1::ListEntriesRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::Entry> GetEntry(
      google::cloud::dataplex::v1::GetEntryRequest const& request);

  virtual StatusOr<google::cloud::dataplex::v1::Entry> LookupEntry(
      google::cloud::dataplex::v1::LookupEntryRequest const& request);

  virtual StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>
  SearchEntries(google::cloud::dataplex::v1::SearchEntriesRequest request);
};

/**
 * A factory function to construct an object of type `CatalogServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of CatalogServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `CatalogServiceConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::dataplex_v1::CatalogServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `CatalogServiceConnection` created by
 * this function.
 */
std::shared_ptr<CatalogServiceConnection> MakeCatalogServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_CATALOG_CONNECTION_H
