// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/session_entity_type.proto

#include "google/cloud/dialogflow_cx/internal/session_entity_types_auth_decorator.h"
#include <google/cloud/dialogflow/cx/v3/session_entity_type.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SessionEntityTypesAuth::SessionEntityTypesAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<SessionEntityTypesStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListSessionEntityTypesResponse>
SessionEntityTypesAuth::ListSessionEntityTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListSessionEntityTypesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListSessionEntityTypes(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesAuth::GetSessionEntityType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetSessionEntityTypeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSessionEntityType(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesAuth::CreateSessionEntityType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreateSessionEntityTypeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSessionEntityType(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesAuth::UpdateSessionEntityType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdateSessionEntityTypeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSessionEntityType(context, options, request);
}

Status SessionEntityTypesAuth::DeleteSessionEntityType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeleteSessionEntityTypeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSessionEntityType(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
