// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/internal/backup_for_gke_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkebackup_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BackupForGKETracingStub::BackupForGKETracingStub(
    std::shared_ptr<BackupForGKEStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncCreateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateBackupPlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateBackupPlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::CreateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateBackupPlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateBackupPlan(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListBackupPlansResponse>
BackupForGKETracingStub::ListBackupPlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListBackupPlans");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListBackupPlans(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKETracingStub::GetBackupPlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetBackupPlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetBackupPlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncUpdateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateBackupPlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateBackupPlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::UpdateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateBackupPlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateBackupPlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncDeleteBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteBackupPlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteBackupPlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::DeleteBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteBackupPlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteBackupPlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateBackup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateBackup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::CreateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateBackup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateBackup(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListBackupsResponse>
BackupForGKETracingStub::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListBackups");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListBackups(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::Backup>
BackupForGKETracingStub::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetBackup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetBackup(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateBackup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateBackup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::UpdateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateBackup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateBackup(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteBackup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteBackup(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::DeleteBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteBackup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteBackup(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeBackupsResponse>
BackupForGKETracingStub::ListVolumeBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeBackupsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListVolumeBackups");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListVolumeBackups(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKETracingStub::GetVolumeBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetVolumeBackup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetVolumeBackup(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncCreateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateRestorePlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateRestorePlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::CreateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateRestorePlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateRestorePlan(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListRestorePlansResponse>
BackupForGKETracingStub::ListRestorePlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestorePlansRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListRestorePlans");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRestorePlans(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKETracingStub::GetRestorePlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetRestorePlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRestorePlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncUpdateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateRestorePlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateRestorePlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::UpdateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateRestorePlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateRestorePlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncDeleteRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteRestorePlan");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteRestorePlan(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
BackupForGKETracingStub::DeleteRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteRestorePlan");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteRestorePlan(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncCreateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateRestore");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateRestore(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::CreateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "CreateRestore");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateRestore(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListRestoresResponse>
BackupForGKETracingStub::ListRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListRestores");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRestores(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::Restore>
BackupForGKETracingStub::GetRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetRestore");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRestore(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncUpdateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateRestore");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateRestore(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::UpdateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "UpdateRestore");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateRestore(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncDeleteRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteRestore");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteRestore(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> BackupForGKETracingStub::DeleteRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "DeleteRestore");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteRestore(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeRestoresResponse>
BackupForGKETracingStub::ListVolumeRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeRestoresRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "ListVolumeRestores");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListVolumeRestores(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKETracingStub::GetVolumeRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetVolumeRestore");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetVolumeRestore(context, options, request));
}

StatusOr<google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlResponse>
BackupForGKETracingStub::GetBackupIndexDownloadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.gkebackup.v1.BackupForGKE",
                                     "GetBackupIndexDownloadUrl");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetBackupIndexDownloadUrl(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKETracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> BackupForGKETracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<BackupForGKEStub> MakeBackupForGKETracingStub(
    std::shared_ptr<BackupForGKEStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<BackupForGKETracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_internal
}  // namespace cloud
}  // namespace google
