// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/v1/identity_aware_proxy_admin_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace iap_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyAdminServiceClient::IdentityAwareProxyAdminServiceClient(
    std::shared_ptr<IdentityAwareProxyAdminServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
IdentityAwareProxyAdminServiceClient::~IdentityAwareProxyAdminServiceClient() =
    default;

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IdentityAwareProxyAdminServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceClient::GetIapSettings(
    google::cloud::iap::v1::GetIapSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIapSettings(request);
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceClient::UpdateIapSettings(
    google::cloud::iap::v1::UpdateIapSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIapSettings(request);
}

StreamRange<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::ListTunnelDestGroups(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::iap::v1::ListTunnelDestGroupsRequest request;
  request.set_parent(parent);
  return connection_->ListTunnelDestGroups(request);
}

StreamRange<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::ListTunnelDestGroups(
    google::cloud::iap::v1::ListTunnelDestGroupsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTunnelDestGroups(std::move(request));
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::CreateTunnelDestGroup(
    std::string const& parent,
    google::cloud::iap::v1::TunnelDestGroup const& tunnel_dest_group,
    std::string const& tunnel_dest_group_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::iap::v1::CreateTunnelDestGroupRequest request;
  request.set_parent(parent);
  *request.mutable_tunnel_dest_group() = tunnel_dest_group;
  request.set_tunnel_dest_group_id(tunnel_dest_group_id);
  return connection_->CreateTunnelDestGroup(request);
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::CreateTunnelDestGroup(
    google::cloud::iap::v1::CreateTunnelDestGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTunnelDestGroup(request);
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::GetTunnelDestGroup(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::iap::v1::GetTunnelDestGroupRequest request;
  request.set_name(name);
  return connection_->GetTunnelDestGroup(request);
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::GetTunnelDestGroup(
    google::cloud::iap::v1::GetTunnelDestGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTunnelDestGroup(request);
}

Status IdentityAwareProxyAdminServiceClient::DeleteTunnelDestGroup(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::iap::v1::DeleteTunnelDestGroupRequest request;
  request.set_name(name);
  return connection_->DeleteTunnelDestGroup(request);
}

Status IdentityAwareProxyAdminServiceClient::DeleteTunnelDestGroup(
    google::cloud::iap::v1::DeleteTunnelDestGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTunnelDestGroup(request);
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::UpdateTunnelDestGroup(
    google::cloud::iap::v1::TunnelDestGroup const& tunnel_dest_group,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::iap::v1::UpdateTunnelDestGroupRequest request;
  *request.mutable_tunnel_dest_group() = tunnel_dest_group;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTunnelDestGroup(request);
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceClient::UpdateTunnelDestGroup(
    google::cloud::iap::v1::UpdateTunnelDestGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTunnelDestGroup(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_v1
}  // namespace cloud
}  // namespace google
