// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_CLOUD_MEMCACHE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_CLOUD_MEMCACHE_CLIENT_H

#include "google/cloud/memcache/v1/cloud_memcache_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace memcache_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Configures and manages Cloud Memorystore for Memcached instances.
///
///
/// The `memcache.googleapis.com` service implements the Google Cloud
/// Memorystore for Memcached API and defines the following resource model for
/// managing Memorystore Memcached (also called Memcached below) instances:
/// * The service works with a collection of cloud projects, named:
/// `/projects/*`
/// * Each project has a collection of available locations, named:
/// `/locations/*`
/// * Each location has a collection of Memcached instances, named:
/// `/instances/*`
/// * As such, Memcached instances are resources of the form:
///   `/projects/{project_id}/locations/{location_id}/instances/{instance_id}`
///
/// Note that location_id must be a GCP `region`; for example:
/// * `projects/my-memcached-project/locations/us-central1/instances/my-memcached`
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudMemcacheClient {
 public:
  explicit CloudMemcacheClient(
      std::shared_ptr<CloudMemcacheConnection> connection, Options opts = {});
  ~CloudMemcacheClient();

  ///@{
  /// @name Copy and move support
  CloudMemcacheClient(CloudMemcacheClient const&) = default;
  CloudMemcacheClient& operator=(CloudMemcacheClient const&) = default;
  CloudMemcacheClient(CloudMemcacheClient&&) = default;
  CloudMemcacheClient& operator=(CloudMemcacheClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CloudMemcacheClient const& a,
                         CloudMemcacheClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudMemcacheClient const& a,
                         CloudMemcacheClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Instances in a given location.
  ///
  /// @param parent  Required. The resource name of the instance location using the form:
  ///      `projects/{project_id}/locations/{location_id}`
  ///  where `location_id` refers to a GCP region
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.memcache.v1.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.ListInstancesRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L409}
  ///
  // clang-format on
  StreamRange<google::cloud::memcache::v1::Instance> ListInstances(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Instances in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.ListInstancesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.memcache.v1.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.ListInstancesRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L409}
  ///
  // clang-format on
  StreamRange<google::cloud::memcache::v1::Instance> ListInstances(
      google::cloud::memcache::v1::ListInstancesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Instance.
  ///
  /// @param name  Required. Memcached instance resource name in the format:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.memcache.v1.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.GetInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L458}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  StatusOr<google::cloud::memcache::v1::Instance> GetInstance(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.GetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.memcache.v1.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.GetInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L458}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  StatusOr<google::cloud::memcache::v1::Instance> GetInstance(
      google::cloud::memcache::v1::GetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Instance in a given location.
  ///
  /// @param parent  Required. The resource name of the instance location using the form:
  ///      `projects/{project_id}/locations/{location_id}`
  ///  where `location_id` refers to a GCP region
  /// @param instance  Required. A Memcached Instance
  /// @param instance_id  Required. The logical name of the Memcached instance in the user
  ///  project with the following restrictions:
  ///  @n
  ///  * Must contain only lowercase letters, numbers, and hyphens.
  ///  * Must start with a letter.
  ///  * Must be between 1-40 characters.
  ///  * Must end with a number or a letter.
  ///  * Must be unique within the user project / location.
  ///  @n
  ///  If any of the above are not met, the API raises an invalid argument error.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.CreateInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L471}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> CreateInstance(
      std::string const& parent,
      google::cloud::memcache::v1::Instance const& instance,
      std::string const& instance_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag, std::string const& parent,
      google::cloud::memcache::v1::Instance const& instance,
      std::string const& instance_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Instance in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.CreateInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.CreateInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L471}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> CreateInstance(
      google::cloud::memcache::v1::CreateInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::CreateInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> CreateInstance(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Instance in a given project and location.
  ///
  /// @param instance  Required. A Memcached Instance.
  ///  Only fields specified in update_mask are updated.
  /// @param update_mask  Required. Mask of fields to update.
  ///  @n
  ///   *   `displayName`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.UpdateInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L499}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateInstance(
      google::cloud::memcache::v1::Instance const& instance,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag, google::cloud::memcache::v1::Instance const& instance,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Instance in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.UpdateInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.UpdateInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L499}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateInstance(
      google::cloud::memcache::v1::UpdateInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::UpdateInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateInstance(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the defined Memcached parameters for an existing instance.
  /// This method only stages the parameters, it must be followed by
  /// `ApplyParameters` to apply the parameters to nodes of the Memcached
  /// instance.
  ///
  /// @param name  Required. Resource name of the Memcached instance for which the parameters should be
  ///  updated.
  /// @param update_mask  Required. Mask of fields to update.
  /// @param parameters  The parameters to apply to the instance.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.UpdateParametersRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L544}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateParameters(
      std::string const& name, google::protobuf::FieldMask const& update_mask,
      google::cloud::memcache::v1::MemcacheParameters const& parameters,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateParameters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateParameters(
      NoAwaitTag, std::string const& name,
      google::protobuf::FieldMask const& update_mask,
      google::cloud::memcache::v1::MemcacheParameters const& parameters,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the defined Memcached parameters for an existing instance.
  /// This method only stages the parameters, it must be followed by
  /// `ApplyParameters` to apply the parameters to nodes of the Memcached
  /// instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.UpdateParametersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.UpdateParametersRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L544}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateParameters(
      google::cloud::memcache::v1::UpdateParametersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateParameters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateParameters(
      NoAwaitTag,
      google::cloud::memcache::v1::UpdateParametersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateParameters
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateParameters(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Instance.
  ///
  /// @param name  Required. Memcached instance resource name in the format:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.DeleteInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L511}
  /// [google.cloud.memcache.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L582}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.DeleteInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.DeleteInstanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L511}
  /// [google.cloud.memcache.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L582}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::memcache::v1::DeleteInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::DeleteInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// `ApplyParameters` restarts the set of specified nodes in order to update
  /// them to the current set of parameters for the Memcached Instance.
  ///
  /// @param name  Required. Resource name of the Memcached instance for which parameter group updates
  ///  should be applied.
  /// @param node_ids  Nodes to which the instance-level parameter group is applied.
  /// @param apply_all  Whether to apply instance-level parameter group to all nodes. If set to
  ///  true, users are restricted from specifying individual nodes, and
  ///  `ApplyParameters` updates all nodes within the instance.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.ApplyParametersRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L524}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> ApplyParameters(
      std::string const& name, std::vector<std::string> const& node_ids,
      bool apply_all, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ApplyParameters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ApplyParameters(
      NoAwaitTag, std::string const& name,
      std::vector<std::string> const& node_ids, bool apply_all,
      Options opts = {});

  // clang-format off
  ///
  /// `ApplyParameters` restarts the set of specified nodes in order to update
  /// them to the current set of parameters for the Memcached Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.ApplyParametersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.ApplyParametersRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L524}
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> ApplyParameters(
      google::cloud::memcache::v1::ApplyParametersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ApplyParameters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ApplyParameters(
      NoAwaitTag,
      google::cloud::memcache::v1::ApplyParametersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ApplyParameters
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> ApplyParameters(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Reschedules upcoming maintenance event.
  ///
  /// @param instance  Required. Memcache instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param reschedule_type  Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
  /// @param schedule_time  Timestamp when the maintenance shall be rescheduled to if
  ///  reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
  ///  example `2012-11-15T16:19:00.094Z`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.RescheduleMaintenanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L372}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> RescheduleMaintenance(
      std::string const& instance,
      google::cloud::memcache::v1::RescheduleMaintenanceRequest::RescheduleType
          reschedule_type,
      google::protobuf::Timestamp const& schedule_time, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RescheduleMaintenance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RescheduleMaintenance(
      NoAwaitTag, std::string const& instance,
      google::cloud::memcache::v1::RescheduleMaintenanceRequest::RescheduleType
          reschedule_type,
      google::protobuf::Timestamp const& schedule_time, Options opts = {});

  // clang-format off
  ///
  /// Reschedules upcoming maintenance event.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.memcache.v1.RescheduleMaintenanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.memcache.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.memcache.v1.Instance]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L153}
  /// [google.cloud.memcache.v1.RescheduleMaintenanceRequest]: @googleapis_reference_link{google/cloud/memcache/v1/cloud_memcache.proto#L372}
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> RescheduleMaintenance(
      google::cloud::memcache::v1::RescheduleMaintenanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RescheduleMaintenance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RescheduleMaintenance(
      NoAwaitTag,
      google::cloud::memcache::v1::RescheduleMaintenanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RescheduleMaintenance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::memcache::v1::Instance>> RescheduleMaintenance(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<CloudMemcacheConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_CLOUD_MEMCACHE_CLIENT_H
