// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_INTERNAL_MIGRATION_CENTER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_INTERNAL_MIGRATION_CENTER_CONNECTION_IMPL_H

#include "google/cloud/migrationcenter/v1/internal/migration_center_retry_traits.h"
#include "google/cloud/migrationcenter/v1/internal/migration_center_stub.h"
#include "google/cloud/migrationcenter/v1/migration_center_connection.h"
#include "google/cloud/migrationcenter/v1/migration_center_connection_idempotency_policy.h"
#include "google/cloud/migrationcenter/v1/migration_center_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace migrationcenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MigrationCenterConnectionImpl
    : public migrationcenter_v1::MigrationCenterConnection {
 public:
  ~MigrationCenterConnectionImpl() override = default;

  MigrationCenterConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<migrationcenter_v1_internal::MigrationCenterStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::migrationcenter::v1::Asset> ListAssets(
      google::cloud::migrationcenter::v1::ListAssetsRequest request) override;

  StatusOr<google::cloud::migrationcenter::v1::Asset> GetAsset(
      google::cloud::migrationcenter::v1::GetAssetRequest const& request)
      override;

  StatusOr<google::cloud::migrationcenter::v1::Asset> UpdateAsset(
      google::cloud::migrationcenter::v1::UpdateAssetRequest const& request)
      override;

  StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
  BatchUpdateAssets(
      google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
          request) override;

  Status DeleteAsset(
      google::cloud::migrationcenter::v1::DeleteAssetRequest const& request)
      override;

  Status BatchDeleteAssets(
      google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
          request) override;

  StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
  ReportAssetFrames(
      google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
          request) override;

  StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
  AggregateAssetsValues(
      google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  CreateImportJob(
      google::cloud::migrationcenter::v1::CreateImportJobRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateImportJobRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  CreateImportJob(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::migrationcenter::v1::ImportJob> ListImportJobs(
      google::cloud::migrationcenter::v1::ListImportJobsRequest request)
      override;

  StatusOr<google::cloud::migrationcenter::v1::ImportJob> GetImportJob(
      google::cloud::migrationcenter::v1::GetImportJobRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportJob(
      google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportJob(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  UpdateImportJob(
      google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  UpdateImportJob(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  ValidateImportJob(
      google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ValidateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  ValidateImportJob(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  RunImportJob(google::cloud::migrationcenter::v1::RunImportJobRequest const&
                   request) override;

  StatusOr<google::longrunning::Operation> RunImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::RunImportJobRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  RunImportJob(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
  GetImportDataFile(
      google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
          request) override;

  StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
  ListImportDataFiles(
      google::cloud::migrationcenter::v1::ListImportDataFilesRequest request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
  CreateImportDataFile(
      google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateImportDataFile(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
  CreateImportDataFile(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportDataFile(
      google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteImportDataFile(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportDataFile(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::migrationcenter::v1::Group> ListGroups(
      google::cloud::migrationcenter::v1::ListGroupsRequest request) override;

  StatusOr<google::cloud::migrationcenter::v1::Group> GetGroup(
      google::cloud::migrationcenter::v1::GetGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> CreateGroup(
      google::cloud::migrationcenter::v1::CreateGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> CreateGroup(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> UpdateGroup(
      google::cloud::migrationcenter::v1::UpdateGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> UpdateGroup(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteGroup(google::cloud::migrationcenter::v1::DeleteGroupRequest const&
                  request) override;

  StatusOr<google::longrunning::Operation> DeleteGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteGroup(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> AddAssetsToGroup(
      google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> AddAssetsToGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>> AddAssetsToGroup(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>>
  RemoveAssetsFromGroup(
      google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> RemoveAssetsFromGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Group>>
  RemoveAssetsFromGroup(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::migrationcenter::v1::ErrorFrame> ListErrorFrames(
      google::cloud::migrationcenter::v1::ListErrorFramesRequest request)
      override;

  StatusOr<google::cloud::migrationcenter::v1::ErrorFrame> GetErrorFrame(
      google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request)
      override;

  StreamRange<google::cloud::migrationcenter::v1::Source> ListSources(
      google::cloud::migrationcenter::v1::ListSourcesRequest request) override;

  StatusOr<google::cloud::migrationcenter::v1::Source> GetSource(
      google::cloud::migrationcenter::v1::GetSourceRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Source>> CreateSource(
      google::cloud::migrationcenter::v1::CreateSourceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateSourceRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Source>> CreateSource(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Source>> UpdateSource(
      google::cloud::migrationcenter::v1::UpdateSourceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateSourceRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Source>> UpdateSource(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteSource(google::cloud::migrationcenter::v1::DeleteSourceRequest const&
                   request) override;

  StatusOr<google::longrunning::Operation> DeleteSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteSourceRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteSource(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
  ListPreferenceSets(
      google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request)
      override;

  StatusOr<google::cloud::migrationcenter::v1::PreferenceSet> GetPreferenceSet(
      google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  CreatePreferenceSet(
      google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreatePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  CreatePreferenceSet(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  UpdatePreferenceSet(
      google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdatePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  UpdatePreferenceSet(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeletePreferenceSet(
      google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeletePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeletePreferenceSet(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::migrationcenter::v1::Settings> GetSettings(
      google::cloud::migrationcenter::v1::GetSettingsRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Settings>> UpdateSettings(
      google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateSettings(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Settings>> UpdateSettings(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
  CreateReportConfig(
      google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateReportConfig(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
  CreateReportConfig(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::migrationcenter::v1::ReportConfig> GetReportConfig(
      google::cloud::migrationcenter::v1::GetReportConfigRequest const& request)
      override;

  StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
  ListReportConfigs(google::cloud::migrationcenter::v1::ListReportConfigsRequest
                        request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReportConfig(
      google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteReportConfig(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
          request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReportConfig(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::migrationcenter::v1::Report>> CreateReport(
      google::cloud::migrationcenter::v1::CreateReportRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateReport(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateReportRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::Report>> CreateReport(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::migrationcenter::v1::Report> GetReport(
      google::cloud::migrationcenter::v1::GetReportRequest const& request)
      override;

  StreamRange<google::cloud::migrationcenter::v1::Report> ListReports(
      google::cloud::migrationcenter::v1::ListReportsRequest request) override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReport(google::cloud::migrationcenter::v1::DeleteReportRequest const&
                   request) override;

  StatusOr<google::longrunning::Operation> DeleteReport(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteReportRequest const& request)
      override;

  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReport(google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<migrationcenter_v1_internal::MigrationCenterStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_INTERNAL_MIGRATION_CENTER_CONNECTION_IMPL_H
