// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/storage_insights_connection.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_connection_impl.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_option_defaults.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_stub_factory.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_tracing_connection.h"
#include "google/cloud/storageinsights/v1/storage_insights_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storageinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StorageInsightsConnection::~StorageInsightsConnection() = default;

StreamRange<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnection::ListReportConfigs(
    google::cloud::storageinsights::v1::
        ListReportConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::storageinsights::v1::ReportConfig>>();
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnection::GetReportConfig(
    google::cloud::storageinsights::v1::GetReportConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnection::CreateReportConfig(
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnection::UpdateReportConfig(
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status StorageInsightsConnection::DeleteReportConfig(
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsConnection::ListReportDetails(
    google::cloud::storageinsights::v1::
        ListReportDetailsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::storageinsights::v1::ReportDetail>>();
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsConnection::GetReportDetail(
    google::cloud::storageinsights::v1::GetReportDetailRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<StorageInsightsConnection> MakeStorageInsightsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 StorageInsightsPolicyOptionList>(options,
                                                                  __func__);
  options = storageinsights_v1_internal::StorageInsightsDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = storageinsights_v1_internal::CreateDefaultStorageInsightsStub(
      std::move(auth), options);
  return storageinsights_v1_internal::MakeStorageInsightsTracingConnection(
      std::make_shared<
          storageinsights_v1_internal::StorageInsightsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1
}  // namespace cloud
}  // namespace google
