/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Map;
import java.util.Optional;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointBucket;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointDetector;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;
import org.elasticsearch.xpack.ml.aggs.changepoint.InternalChangePointAggregation;

public class ChangePointAggregator
extends SiblingPipelineAggregator {
    public ChangePointAggregator(String name, String bucketsPath, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
    }

    public InternalAggregation doReduce(InternalAggregations aggregations, AggregationReduceContext context) {
        Optional<MlAggsHelper.DoubleBucketValues> maybeBucketValues = MlAggsHelper.extractDoubleBucketedValues(this.bucketsPaths()[0], aggregations, BucketHelpers.GapPolicy.SKIP, true);
        if (maybeBucketValues.isEmpty()) {
            return new InternalChangePointAggregation(this.name(), this.metadata(), null, new ChangeType.Indeterminable("unable to find valid bucket values in bucket path [" + this.bucketsPaths()[0] + "]"));
        }
        MlAggsHelper.DoubleBucketValues bucketValues = maybeBucketValues.get();
        ChangeType change = ChangePointDetector.getChangeType(bucketValues);
        ChangePointBucket changePointBucket = null;
        if (change.changePoint() != -1) {
            changePointBucket = MlAggsHelper.extractBucket(this.bucketsPaths()[0], aggregations, change.changePoint()).map(b -> new ChangePointBucket(b.getKey(), b.getDocCount(), b.getAggregations())).orElse(null);
        }
        return new InternalChangePointAggregation(this.name(), this.metadata(), changePointBucket, change);
    }
}

