/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorBase;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.AbstractItemSetMapReducer;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.DelegatingCircuitBreakerService;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.InternalItemSetMapReduceAggregation;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public abstract class ItemSetMapReduceAggregator<MapContext extends Closeable, MapFinalContext extends Writeable, ReduceContext extends Closeable, Result extends ToXContent & Writeable>
extends AggregatorBase {
    private final List<ItemSetMapReduceValueSource> valueSources;
    private final Weight weightDocumentFilter;
    private final List<ItemSetMapReduceValueSource.Field> fields;
    private final AbstractItemSetMapReducer<MapContext, MapFinalContext, ReduceContext, Result> mapReducer;
    private final BigArrays bigArraysForMapReduce;
    private final LongObjectPagedHashMap<Object> mapReduceContextByBucketOrdinal;
    private final boolean profiling;
    private final boolean rewriteBasedOnOrdinals;
    private final DelegatingCircuitBreakerService breakerService;

    protected ItemSetMapReduceAggregator(String name, ValuesSourceRegistry.RegistryKey<ItemSetMapReduceValueSource.ValueSourceSupplier> registryKey, AggregationContext context, Aggregator parent, Map<String, Object> metadata, AbstractItemSetMapReducer<MapContext, MapFinalContext, ReduceContext, Result> mapReducer, List<Tuple<ValuesSourceConfig, IncludeExclude>> configsAndValueFilters, QueryBuilder documentFilter, AbstractItemSetMapReducer.OrdinalOptimization ordinalOptimization) throws IOException {
        super(name, AggregatorFactories.EMPTY, context, parent, CardinalityUpperBound.NONE, metadata);
        ArrayList<ItemSetMapReduceValueSource> valueSources = new ArrayList<ItemSetMapReduceValueSource>();
        ArrayList<ItemSetMapReduceValueSource.Field> fields = new ArrayList<ItemSetMapReduceValueSource.Field>();
        IndexSearcher contextSearcher = context.searcher();
        Optional<LeafReaderContext> ctx = ItemSetMapReduceAggregator.getLeafReaderForOrdinals(context);
        int id = 0;
        this.weightDocumentFilter = documentFilter != null ? contextSearcher.createWeight(contextSearcher.rewrite(context.buildQuery(documentFilter)), ScoreMode.COMPLETE_NO_SCORES, 1.0f) : null;
        boolean rewriteBasedOnOrdinals = false;
        for (Tuple<ValuesSourceConfig, IncludeExclude> c : configsAndValueFilters) {
            ItemSetMapReduceValueSource e = ((ItemSetMapReduceValueSource.ValueSourceSupplier)context.getValuesSourceRegistry().getAggregator(registryKey, (ValuesSourceConfig)c.v1())).build((ValuesSourceConfig)c.v1(), id++, (IncludeExclude)c.v2(), ordinalOptimization, ctx);
            if (e.getField().getName() != null) {
                fields.add(e.getField());
                valueSources.add(e);
            }
            rewriteBasedOnOrdinals |= e.usesOrdinals();
        }
        this.rewriteBasedOnOrdinals = rewriteBasedOnOrdinals;
        this.valueSources = Collections.unmodifiableList(valueSources);
        this.fields = Collections.unmodifiableList(fields);
        this.mapReducer = mapReducer;
        this.profiling = context.profiling();
        this.breakerService = new DelegatingCircuitBreakerService(context.breaker(), x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        this.bigArraysForMapReduce = BigArrays.NON_RECYCLING_INSTANCE.withBreakerService((CircuitBreakerService)this.breakerService).withCircuitBreaking();
        this.mapReduceContextByBucketOrdinal = new LongObjectPagedHashMap(1L, context.bigArrays());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalItemSetMapReduceAggregation<MapContext, Object, ReduceContext, Object>(this.name, this.metadata(), this.mapReducer, null, null, this.fields, this.profiling);
    }

    public final InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        InternalAggregation[] results = new InternalAggregation[Math.toIntExact(owningBucketOrds.size())];
        for (int ordIdx = 0; ordIdx < results.length; ++ordIdx) {
            results[ordIdx] = this.buildAggregation(ordIdx);
        }
        return results;
    }

    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext ctx, LeafBucketCollector sub) throws IOException {
        final Bits bits = this.weightDocumentFilter != null ? Lucene.asSequentialAccessBits((int)ctx.getLeafReaderContext().reader().maxDoc(), (ScorerSupplier)this.weightDocumentFilter.scorerSupplier(ctx.getLeafReaderContext())) : null;
        final ArrayList<ItemSetMapReduceValueSource.ValueCollector> valueCollectors = new ArrayList<ItemSetMapReduceValueSource.ValueCollector>(this.valueSources.size());
        for (ItemSetMapReduceValueSource valueSource : this.valueSources) {
            valueCollectors.add(valueSource.getValueCollector(ctx.getLeafReaderContext()));
        }
        return new LeafBucketCollectorBase(sub, null){

            public void collect(int doc, long owningBucketOrd) throws IOException {
                SetOnce firstException = new SetOnce();
                if (bits == null || bits.get(doc)) {
                    ItemSetMapReduceAggregator.this.mapReducer.map(valueCollectors.stream().map(c -> {
                        try {
                            return c.collect(doc);
                        }
                        catch (IOException e) {
                            firstException.trySet((Object)e);
                            return null;
                        }
                    }), ItemSetMapReduceAggregator.this.getMapReduceContext(owningBucketOrd));
                } else {
                    ItemSetMapReduceAggregator.this.mapReducer.mapFiltered(ItemSetMapReduceAggregator.this.getMapReduceContext(owningBucketOrd));
                }
                if (firstException.get() != null) {
                    throw (IOException)firstException.get();
                }
            }
        };
    }

    public void doPostCollection() throws IOException {
        ArrayList<AbstractItemSetMapReducer.OrdinalLookupFunction> ordinalLookupFunctions = null;
        if (this.rewriteBasedOnOrdinals) {
            ordinalLookupFunctions = new ArrayList<AbstractItemSetMapReducer.OrdinalLookupFunction>(this.valueSources.size());
            for (ItemSetMapReduceValueSource valueSource : this.valueSources) {
                ordinalLookupFunctions.add(valueSource::mapOrdinal);
            }
        }
        for (long ordIdx = 0L; ordIdx < this.mapReduceContextByBucketOrdinal.size(); ++ordIdx) {
            MapContext context = this.getMapReduceContext(ordIdx);
            this.mapReduceContextByBucketOrdinal.put(ordIdx, this.mapReducer.mapFinalize(context, ordinalLookupFunctions));
        }
    }

    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("map_reducer", this.mapReducer.getWriteableName());
        this.mapReducer.collectDebugInfo(add);
    }

    protected void doClose() {
        if (this.breakerService != null) {
            this.breakerService.disconnect();
        }
        Releasables.close(this.mapReduceContextByBucketOrdinal);
    }

    private MapContext getMapReduceContext(long bucketOrd) {
        Closeable context = (Closeable)this.mapReduceContextByBucketOrdinal.get(bucketOrd);
        if (context == null) {
            context = this.mapReducer.mapInit(this.bigArraysForMapReduce);
            this.mapReduceContextByBucketOrdinal.put(bucketOrd, (Object)context);
        }
        return (MapContext)context;
    }

    private InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        Writeable context = (Writeable)this.mapReduceContextByBucketOrdinal.get(owningBucketOrdinal);
        if (context == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalItemSetMapReduceAggregation<MapContext, Writeable, ReduceContext, Object>(this.name, this.metadata(), this.mapReducer, context, null, this.fields, this.profiling);
    }

    private static Optional<LeafReaderContext> getLeafReaderForOrdinals(AggregationContext context) {
        IndexReader reader = context.searcher().getIndexReader();
        return reader.leaves().stream().findFirst();
    }
}

