/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public final class DatafeedManager {
    private static final Logger logger = LogManager.getLogger(DatafeedManager.class);
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobConfigProvider jobConfigProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final Settings settings;

    public DatafeedManager(DatafeedConfigProvider datafeedConfigProvider, JobConfigProvider jobConfigProvider, NamedXContentRegistry xContentRegistry, Settings settings, Client client) {
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobConfigProvider = jobConfigProvider;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.settings = settings;
    }

    public void putDatafeed(PutDatafeedAction.Request request, ClusterState state, SecurityContext securityContext, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
                String[] indices = (String[])request.getDatafeed().getIndices().stream().filter(Predicate.not(RemoteClusterLicenseChecker::isRemoteIndex)).toArray(String[]::new);
                String username = securityContext.getUser().principal();
                HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
                privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
                privRequest.username(username);
                privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
                RoleDescriptor.IndicesPrivileges.Builder indicesPrivilegesBuilder = RoleDescriptor.IndicesPrivileges.builder().indices(indices);
                ActionListener privResponseListener = listener.delegateFailureAndWrap((l, r) -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)r, state, threadPool, (ActionListener<PutDatafeedAction.Response>)l));
                ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
                    if (response.getJobs().isEmpty()) {
                        indicesPrivilegesBuilder.privileges(new String[]{TransportSearchAction.TYPE.name()});
                    } else {
                        indicesPrivilegesBuilder.privileges(new String[]{TransportSearchAction.TYPE.name(), "indices:data/read/xpack/rollup/search"});
                    }
                    if (indices.length == 0) {
                        privResponseListener.onResponse((Object)new HasPrivilegesResponse());
                    } else {
                        privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                        this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                    }
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                        indicesPrivilegesBuilder.privileges(new String[]{TransportSearchAction.TYPE.name()});
                        privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                        this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                    } else {
                        listener.onFailure(e);
                    }
                });
                if (RemoteClusterLicenseChecker.containsRemoteIndex((Collection)request.getDatafeed().getIndices())) {
                    getRollupIndexCapsActionHandler.onResponse((Object)new GetRollupIndexCapsAction.Response());
                } else {
                    ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(indices), (ActionListener)getRollupIndexCapsActionHandler);
                }
            });
        } else {
            this.putDatafeed(request, threadPool.getThreadContext().getHeaders(), state, listener);
        }
    }

    public void getDatafeeds(GetDatafeedsAction.Request request, @Nullable TaskId parentTaskId, ActionListener<QueryPage<DatafeedConfig>> listener) {
        this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), request.allowNoMatch(), parentTaskId, (ActionListener<List<DatafeedConfig.Builder>>)listener.delegateFailureAndWrap((l, datafeedBuilders) -> l.onResponse((Object)new QueryPage(datafeedBuilders.stream().map(DatafeedConfig.Builder::build).collect(Collectors.toList()), (long)datafeedBuilders.size(), DatafeedConfig.RESULTS_FIELD))));
    }

    public void getDatafeedsByJobIds(Set<String> jobIds, @Nullable TaskId parentTaskId, ActionListener<Map<String, DatafeedConfig.Builder>> listener) {
        this.datafeedConfigProvider.findDatafeedsByJobIds(jobIds, parentTaskId, listener);
    }

    public void updateDatafeed(UpdateDatafeedAction.Request request, ClusterState state, SecurityContext securityContext, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) {
        if (DatafeedManager.getDatafeedTask(state, request.getUpdate().getId()) != null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot update datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getUpdate().getId(), DatafeedState.STARTED}), (Object[])new Object[0])));
            return;
        }
        Runnable doUpdate = () -> SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
            Map headers = threadPool.getThreadContext().getHeaders();
            this.datafeedConfigProvider.updateDatefeedConfig(request.getUpdate().getId(), request.getUpdate(), headers, this.jobConfigProvider::validateDatafeedJob, (ActionListener<DatafeedConfig>)listener.delegateFailureAndWrap((l, updatedConfig) -> l.onResponse((Object)new PutDatafeedAction.Response(updatedConfig))));
        });
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap(bool -> doUpdate.run(), arg_0 -> listener.onFailure(arg_0)), (int)1);
    }

    public void deleteDatafeed(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (DatafeedManager.getDatafeedTask(state, request.getDatafeedId()) != null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getDatafeedId(), DatafeedState.STARTED}), (Object[])new Object[0])));
            return;
        }
        String datafeedId = request.getDatafeedId();
        this.datafeedConfigProvider.getDatafeedConfig(datafeedId, null, (ActionListener<DatafeedConfig.Builder>)listener.delegateFailureAndWrap((delegate, datafeedConfigBuilder) -> {
            String jobId = datafeedConfigBuilder.build().getJobId();
            JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
            jobDataDeleter.deleteDatafeedTimingStats((ActionListener<BulkByScrollResponse>)delegate.delegateFailureAndWrap((l, unused1) -> this.datafeedConfigProvider.deleteDatafeedConfig(datafeedId, (ActionListener<DeleteResponse>)l.delegateFailureAndWrap((ll, unused2) -> ll.onResponse((Object)AcknowledgedResponse.TRUE)))));
        }));
    }

    private static PersistentTasksCustomMetadata.PersistentTask<?> getDatafeedTask(ClusterState state, String datafeedId) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        return MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
    }

    private void handlePrivsResponse(String username, PutDatafeedAction.Request request, HasPrivilegesResponse response, ClusterState clusterState, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.putDatafeed(request, threadPool.getThreadContext().getHeaders(), clusterState, listener);
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create datafeed [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{request.getDatafeed().getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void putDatafeed(PutDatafeedAction.Request request, Map<String, String> headers, ClusterState clusterState, ActionListener<PutDatafeedAction.Response> listener) {
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)request.getDatafeed().getParsedAggregations(this.xContentRegistry));
        CheckedConsumer mappingsUpdated = ok -> this.datafeedConfigProvider.putDatafeedConfig(request.getDatafeed(), headers, (ActionListener<Tuple<DatafeedConfig, DocWriteResponse>>)listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)new PutDatafeedAction.Response((DatafeedConfig)response.v1()))));
        CheckedConsumer validationOk = ok -> {
            if (clusterState == null) {
                logger.warn("Cannot update doc mapping because clusterState == null");
                mappingsUpdated.accept((Object)false);
                return;
            }
            ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap((CheckedConsumer)mappingsUpdated, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (int)1);
        };
        CheckedConsumer jobOk = ok -> this.jobConfigProvider.validateDatafeedJob(request.getDatafeed(), (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)validationOk, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        this.checkJobDoesNotHaveADatafeed(request.getDatafeed().getJobId(), (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)jobOk, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkJobDoesNotHaveADatafeed(String jobId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedIdsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)listener.delegateFailureAndWrap((delegate, datafeedIds) -> {
            if (datafeedIds.isEmpty()) {
                delegate.onResponse((Object)Boolean.TRUE);
            } else {
                delegate.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0])));
            }
        }));
    }
}

