/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.persistence;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class DataFrameAnalyticsDeleter {
    private static final Logger logger = LogManager.getLogger(DataFrameAnalyticsDeleter.class);
    private final Client client;
    private final DataFrameAnalyticsAuditor auditor;

    public DataFrameAnalyticsDeleter(Client client, DataFrameAnalyticsAuditor auditor) {
        this.client = Objects.requireNonNull(client);
        this.auditor = Objects.requireNonNull(auditor);
    }

    public void deleteAllDocuments(DataFrameAnalyticsConfig config, TimeValue timeout, ActionListener<AcknowledgedResponse> listener) {
        String id = config.getId();
        ActionListener deleteStatsHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                logger.warn("[{}] DeleteByQuery for stats timed out", (Object)id);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery for stats", (Object)id, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts());
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    logger.warn("[{}] DBQ failure: {}", (Object)id, (Object)failure);
                }
            }
            this.deleteConfig(id, listener);
        }, failure -> {
            logger.warn(() -> "[" + id + "] failed to remove stats", ExceptionsHelper.unwrapCause((Throwable)failure));
            this.deleteConfig(id, listener);
        });
        ActionListener deleteStateHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                logger.warn("[{}] DeleteByQuery for state timed out", (Object)id);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery for state", (Object)id, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts());
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    logger.warn("[{}] DBQ failure: {}", (Object)id, (Object)failure);
                }
            }
            this.deleteStats(id, timeout, (ActionListener<BulkByScrollResponse>)deleteStatsHandler);
        }, arg_0 -> listener.onFailure(arg_0));
        this.deleteState(config, timeout, (ActionListener<BulkByScrollResponse>)deleteStateHandler);
    }

    private void deleteConfig(String id, ActionListener<AcknowledgedResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(MlConfigIndex.indexName());
        deleteRequest.id(DataFrameAnalyticsConfig.documentId((String)id));
        deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportDeleteAction.TYPE, (ActionRequest)deleteRequest, (ActionListener)ActionListener.wrap(deleteResponse -> {
            if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                listener.onFailure((Exception)ExceptionsHelper.missingDataFrameAnalytics((String)id));
                return;
            }
            assert (deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
            logger.info("[{}] Deleted", (Object)id);
            this.auditor.info(id, "Deleted analytics");
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                listener.onFailure((Exception)ExceptionsHelper.missingDataFrameAnalytics((String)id));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void deleteState(DataFrameAnalyticsConfig config, TimeValue timeout, ActionListener<BulkByScrollResponse> listener) {
        ActionListener deleteModelStateListener = listener.delegateFailureAndWrap((l, r) -> this.executeDeleteByQuery(AnomalyDetectorsIndex.jobStateIndexPattern(), (QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{StoredProgress.documentId(config.getId())}), timeout, (ActionListener<BulkByScrollResponse>)l));
        this.deleteModelState(config, timeout, 1, (ActionListener<Boolean>)deleteModelStateListener);
    }

    private void deleteModelState(DataFrameAnalyticsConfig config, TimeValue timeout, int docNum, ActionListener<Boolean> listener) {
        if (!config.getAnalysis().persistsState()) {
            listener.onResponse((Object)true);
            return;
        }
        IdsQueryBuilder query = QueryBuilders.idsQuery().addIds(new String[]{config.getAnalysis().getStateDocIdPrefix(config.getId()) + docNum});
        this.executeDeleteByQuery(AnomalyDetectorsIndex.jobStateIndexPattern(), (QueryBuilder)query, timeout, (ActionListener<BulkByScrollResponse>)listener.delegateFailureAndWrap((l, response) -> {
            if (response.getDeleted() > 0L) {
                this.deleteModelState(config, timeout, docNum + 1, (ActionListener<Boolean>)l);
                return;
            }
            l.onResponse((Object)true);
        }));
    }

    private void deleteStats(String jobId, TimeValue timeout, ActionListener<BulkByScrollResponse> listener) {
        this.executeDeleteByQuery(MlStatsIndex.indexPattern(), (QueryBuilder)QueryBuilders.termQuery((String)Fields.JOB_ID.getPreferredName(), (String)jobId), timeout, listener);
    }

    private void executeDeleteByQuery(String index, QueryBuilder query, TimeValue timeout, ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
        request.setQuery(query);
        request.setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setSlices(0);
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        request.setTimeout(timeout);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
    }
}

