/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.stats;

import java.util.Objects;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.DataCounts;

public class DataCountsTracker {
    private final String jobId;
    private volatile long trainingDocsCount;
    private volatile long testDocsCount;
    private volatile long skippedDocsCount;

    public DataCountsTracker(DataCounts dataCounts) {
        this.jobId = Objects.requireNonNull(dataCounts.getJobId());
        this.trainingDocsCount = dataCounts.getTrainingDocsCount();
        this.testDocsCount = dataCounts.getTestDocsCount();
        this.skippedDocsCount = dataCounts.getSkippedDocsCount();
    }

    public void incrementTrainingDocsCount() {
        ++this.trainingDocsCount;
    }

    public void incrementTestDocsCount() {
        ++this.testDocsCount;
    }

    public void incrementSkippedDocsCount() {
        ++this.skippedDocsCount;
    }

    public DataCounts report() {
        return new DataCounts(this.jobId, this.trainingDocsCount, this.testDocsCount, this.skippedDocsCount);
    }

    public void reset() {
        this.trainingDocsCount = 0L;
        this.testDocsCount = 0L;
        this.skippedDocsCount = 0L;
    }

    public void setTestDocsCount(long testDocsCount) {
        this.testDocsCount = testDocsCount;
    }
}

