/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.ltr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.xpack.ml.inference.ltr.FeatureExtractor;

public class QueryFeatureExtractor
implements FeatureExtractor {
    private final List<String> featureNames;
    private final List<Weight> weights;
    private final DisiPriorityQueue subScorers;
    private DisjunctionDISIApproximation approximation;

    public QueryFeatureExtractor(List<String> featureNames, List<Weight> weights) {
        if (featureNames.size() != weights.size()) {
            throw new IllegalArgumentException("[featureNames] and [weights] must be the same size.");
        }
        this.featureNames = featureNames;
        this.weights = weights;
        this.subScorers = new DisiPriorityQueue(weights.size());
    }

    @Override
    public void setNextReader(LeafReaderContext segmentContext) throws IOException {
        this.subScorers.clear();
        for (int i = 0; i < this.weights.size(); ++i) {
            Scorer scorer;
            Weight weight = this.weights.get(i);
            if (weight == null || (scorer = weight.scorer(segmentContext)) == null) continue;
            this.subScorers.add((DisiWrapper)new FeatureDisiWrapper(scorer, this.featureNames.get(i)));
        }
        this.approximation = this.subScorers.size() > 0 ? new DisjunctionDISIApproximation(this.subScorers) : null;
    }

    @Override
    public void addFeatures(Map<String, Object> featureMap, int docId) throws IOException {
        if (this.approximation == null || this.approximation.docID() > docId) {
            return;
        }
        if (this.approximation.docID() < docId) {
            this.approximation.advance(docId);
        }
        if (this.approximation.docID() != docId) {
            return;
        }
        FeatureDisiWrapper w = (FeatureDisiWrapper)this.subScorers.topList();
        while (w != null) {
            if (w.twoPhaseView == null || w.twoPhaseView.matches()) {
                featureMap.put(w.featureName, Float.valueOf(w.scorer.score()));
            }
            w = (FeatureDisiWrapper)w.next;
        }
    }

    @Override
    public List<String> featureNames() {
        return this.featureNames;
    }

    private static class FeatureDisiWrapper
    extends DisiWrapper {
        final String featureName;

        FeatureDisiWrapper(Scorer scorer, String featureName) {
            super(scorer);
            this.featureName = featureName;
        }
    }
}

