/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.analyze;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;

class GetBlobChecksumAction
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(GetBlobChecksumAction.class);
    static final String NAME = "cluster:admin/repository/analyze/blob/read";
    private static final int BUFFER_SIZE = ByteSizeUnit.KB.toIntBytes(8L);
    private final RepositoriesService repositoriesService;

    GetBlobChecksumAction(TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
        super(NAME, transportService, actionFilters, Request::new, (Executor)transportService.getThreadPool().executor("snapshot"));
        this.repositoriesService = repositoriesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        long startTimeNanos;
        InputStream rawInputStream;
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        Repository repository = this.repositoriesService.repository(request.getRepositoryName());
        if (!(repository instanceof BlobStoreRepository)) {
            throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is not a blob store repository");
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        BlobContainer blobContainer = blobStoreRepository.blobStore().blobContainer(blobStoreRepository.basePath().add(request.getBlobPath()));
        logger.trace("handling [{}]", (Object)request);
        try {
            rawInputStream = request.isWholeBlob() ? blobContainer.readBlob(OperationPurpose.REPOSITORY_ANALYSIS, request.getBlobName()) : blobContainer.readBlob(OperationPurpose.REPOSITORY_ANALYSIS, request.getBlobName(), request.getRangeStart(), request.getRangeLength());
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            logger.trace("blob not found for [{}]", (Object)request);
            listener.onResponse((Object)Response.BLOB_NOT_FOUND);
            return;
        }
        catch (IOException e) {
            logger.warn("failed to read blob for [{}]", (Object)request);
            listener.onFailure((Exception)e);
            return;
        }
        logger.trace("reading blob for [{}]", (Object)request);
        AtomicLong throttleNanos = new AtomicLong();
        InputStream throttledInputStream = blobStoreRepository.maybeRateLimitRestores(rawInputStream, throttleNanos::addAndGet);
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[BUFFER_SIZE];
        long bytesRead = 0L;
        long firstByteNanos = startTimeNanos = System.nanoTime();
        boolean success = false;
        try {
            block18: {
                do {
                    int readSize;
                    try {
                        readSize = throttledInputStream.read(buffer, 0, buffer.length);
                    }
                    catch (IOException e) {
                        logger.warn("exception while read blob for [{}]", (Object)request);
                        listener.onFailure((Exception)e);
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable)throttledInputStream);
                        }
                        return;
                    }
                    if (readSize == -1) break block18;
                    if (readSize <= 0) continue;
                    if (bytesRead == 0L) {
                        firstByteNanos = System.nanoTime();
                    }
                    crc32.update(buffer, 0, readSize);
                    bytesRead += (long)readSize;
                } while (!cancellableTask.isCancelled());
                throw new RepositoryVerificationException(request.repositoryName, "cancelled [" + request.getDescription() + "] after reading [" + bytesRead + "] bytes");
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)throttledInputStream);
            }
        }
        try {
            throttledInputStream.close();
        }
        catch (IOException e) {
            throw new RepositoryVerificationException(request.repositoryName, "failed to close input stream when handling [" + request.getDescription() + "]", (Throwable)e);
        }
        long endTimeNanos = System.nanoTime();
        if (!request.isWholeBlob() && bytesRead != request.getRangeLength()) {
            throw new RepositoryVerificationException(request.repositoryName, "unexpectedly read [" + bytesRead + "] bytes when handling [" + request.getDescription() + "]");
        }
        Response response = new Response(bytesRead, crc32.getValue(), firstByteNanos - startTimeNanos, endTimeNanos - startTimeNanos, throttleNanos.get());
        logger.trace("responding to [{}] with [{}]", (Object)request, (Object)response);
        listener.onResponse((Object)response);
    }

    static class Request
    extends ActionRequest {
        private final String repositoryName;
        private final String blobPath;
        private final String blobName;
        private final long rangeStart;
        private final long rangeEnd;

        Request(StreamInput in) throws IOException {
            super(in);
            this.repositoryName = in.readString();
            this.blobPath = in.readString();
            this.blobName = in.readString();
            this.rangeStart = in.readVLong();
            this.rangeEnd = in.readVLong();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        Request(String repositoryName, String blobPath, String blobName, long rangeStart, long rangeEnd) {
            assert (rangeStart == 0L && rangeEnd == 0L || 0L <= rangeStart && rangeStart < rangeEnd) : rangeStart + "-" + rangeEnd;
            this.repositoryName = repositoryName;
            this.blobPath = blobPath;
            this.blobName = blobName;
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        String getBlobPath() {
            return this.blobPath;
        }

        String getBlobName() {
            return this.blobName;
        }

        long getRangeStart() {
            assert (!this.isWholeBlob());
            return this.rangeStart;
        }

        long getRangeEnd() {
            assert (!this.isWholeBlob());
            return this.rangeEnd;
        }

        long getRangeLength() {
            assert (!this.isWholeBlob());
            return this.rangeEnd - this.rangeStart;
        }

        boolean isWholeBlob() {
            return this.rangeEnd == 0L;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repositoryName);
            out.writeString(this.blobPath);
            out.writeString(this.blobName);
            out.writeVLong(this.rangeStart);
            out.writeVLong(this.rangeEnd);
        }

        public String getDescription() {
            return "retrieve [" + (String)(this.isWholeBlob() ? "whole blob" : this.getRangeStart() + "-" + this.getRangeEnd()) + "] from [" + this.getRepositoryName() + ":" + this.getBlobPath() + "/" + this.getBlobName() + "]";
        }

        public String toString() {
            return "GetRepositoryBlobChecksumRequest{" + this.getDescription() + "}";
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers){

                public boolean shouldCancelChildrenOnCancellation() {
                    return false;
                }
            };
        }
    }

    static class Response
    extends ActionResponse {
        static Response BLOB_NOT_FOUND = new Response(0L, 0L, 0L, 0L, 0L);
        private final long bytesRead;
        private final long checksum;
        private final long firstByteNanos;
        private final long elapsedNanos;
        private final long throttleNanos;

        Response(long bytesRead, long checksum, long firstByteNanos, long elapsedNanos, long throttleNanos) {
            this.bytesRead = bytesRead;
            this.checksum = checksum;
            this.firstByteNanos = firstByteNanos;
            this.elapsedNanos = elapsedNanos;
            this.throttleNanos = throttleNanos;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.bytesRead = in.readVLong();
            this.checksum = in.readLong();
            this.firstByteNanos = in.readVLong();
            this.elapsedNanos = in.readVLong();
            this.throttleNanos = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.bytesRead);
            out.writeLong(this.checksum);
            out.writeVLong(this.firstByteNanos);
            out.writeVLong(this.elapsedNanos);
            out.writeVLong(this.throttleNanos);
        }

        public String toString() {
            return "GetRepositoryBlobChecksumResponse{bytesRead=" + this.bytesRead + ", checksum=" + this.checksum + ", firstByteNanos=" + this.firstByteNanos + ", elapsedNanos=" + this.elapsedNanos + ", throttleNanos=" + this.throttleNanos + "}";
        }

        long getBytesRead() {
            return this.bytesRead;
        }

        long getChecksum() {
            return this.checksum;
        }

        long getFirstByteNanos() {
            return this.firstByteNanos;
        }

        long getElapsedNanos() {
            return this.elapsedNanos;
        }

        long getThrottleNanos() {
            return this.throttleNanos;
        }

        boolean isNotFound() {
            return this.bytesRead == 0L && this.checksum == 0L && this.firstByteNanos == 0L && this.elapsedNanos == 0L && this.throttleNanos == 0L;
        }
    }
}

