/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

public final class AuthorizationStatePersistenceUtils {
    private static final Logger logger = LogManager.getLogger(AuthorizationStatePersistenceUtils.class);

    public static void fetchAuthState(TransformConfigManager transformConfigManager, String transformId, ActionListener<AuthorizationState> listener) {
        ActionListener getTransformStoredDocListener = ActionListener.wrap(stateAndStatsAndSeqNoPrimaryTermAndIndex -> {
            if (stateAndStatsAndSeqNoPrimaryTermAndIndex == null) {
                listener.onResponse(null);
                return;
            }
            TransformState transformState = ((TransformStoredDoc)stateAndStatsAndSeqNoPrimaryTermAndIndex.v1()).getTransformState();
            if (transformState == null) {
                listener.onResponse(null);
                return;
            }
            AuthorizationState authState = transformState.getAuthState();
            if (authState == null) {
                listener.onResponse(null);
                return;
            }
            listener.onResponse((Object)authState);
        }, arg_0 -> listener.onFailure(arg_0));
        transformConfigManager.getTransformStoredDoc(transformId, true, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)getTransformStoredDocListener);
    }

    public static void persistAuthState(Settings settings, TransformConfigManager transformConfigManager, String transformId, AuthorizationState authState, ActionListener<Void> listener) {
        assert (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue());
        logger.trace("Started persisting auth state: {}", (Object)authState);
        ActionListener persistListener = ActionListener.wrap(unusedResponse -> {
            logger.trace("Finished persisting auth state: {}", (Object)authState);
            listener.onResponse(null);
        }, e -> {
            logger.trace("Failed persisting auth state: {}, exception = {}", (Object)authState, e);
            listener.onFailure(e);
        });
        ActionListener transformStatsActionListener = ActionListener.wrap(stateAndStatsAndSeqNoPrimaryTermAndIndex -> {
            if (stateAndStatsAndSeqNoPrimaryTermAndIndex == null) {
                TransformState state = new TransformState(TransformTaskState.STOPPED, IndexerState.STOPPED, null, 0L, null, null, null, false, authState);
                TransformIndexerStats stats = new TransformIndexerStats();
                transformConfigManager.putOrUpdateTransformStoredDoc(new TransformStoredDoc(transformId, state, stats), null, (ActionListener<SeqNoPrimaryTermAndIndex>)persistListener);
                return;
            }
            TransformStoredDoc stateAndStats = (TransformStoredDoc)stateAndStatsAndSeqNoPrimaryTermAndIndex.v1();
            SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = (SeqNoPrimaryTermAndIndex)stateAndStatsAndSeqNoPrimaryTermAndIndex.v2();
            TransformState oldState = stateAndStats.getTransformState();
            TransformState newState = new TransformState(oldState.getTaskState(), oldState.getIndexerState(), oldState.getPosition(), oldState.getCheckpoint(), oldState.getReason(), oldState.getProgress(), oldState.getNode(), oldState.shouldStopAtNextCheckpoint(), authState);
            TransformIndexerStats stats = stateAndStats.getTransformStats();
            transformConfigManager.putOrUpdateTransformStoredDoc(new TransformStoredDoc(transformId, newState, stats), seqNoPrimaryTermAndIndex, (ActionListener<SeqNoPrimaryTermAndIndex>)persistListener);
        }, error -> {
            String msg = TransformMessages.getMessage((String)"Failed to load transform state for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            listener.onFailure(error);
        });
        transformConfigManager.getTransformStoredDoc(transformId, true, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)transformStatsActionListener);
    }
}

