/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TimeRetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;

public final class RetentionPolicyToDeleteByQueryRequestConverter {
    private static final String DATE_FORMAT = "strict_date_optional_time";
    private static final DateFormatter DATE_FORMATER = DateFormatter.forPattern((String)"strict_date_optional_time");

    private RetentionPolicyToDeleteByQueryRequestConverter() {
    }

    static DeleteByQueryRequest buildDeleteByQueryRequest(RetentionPolicyConfig retentionPolicyConfig, SettingsConfig settingsConfig, DestConfig destConfig, TransformCheckpoint nextCheckpoint) {
        if (nextCheckpoint == null || nextCheckpoint.isEmpty()) {
            return null;
        }
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        if (!(retentionPolicyConfig instanceof TimeRetentionPolicyConfig)) {
            throw new RetentionPolicyException("unsupported retention policy of type [{}]", retentionPolicyConfig.getWriteableName());
        }
        request.setQuery(RetentionPolicyToDeleteByQueryRequestConverter.getDeleteQueryFromTimeBasedRetentionPolicy((TimeRetentionPolicyConfig)retentionPolicyConfig, nextCheckpoint));
        ((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)request.setSlices(0)).setBatchSize(1000).setAbortOnVersionConflict(false)).setMaxRetries(0)).indices(new String[]{destConfig.getIndex()});
        if (settingsConfig.getDocsPerSecond() != null) {
            request.setRequestsPerSecond(settingsConfig.getDocsPerSecond().floatValue());
        }
        return request;
    }

    private static QueryBuilder getDeleteQueryFromTimeBasedRetentionPolicy(TimeRetentionPolicyConfig config, TransformCheckpoint checkpoint) {
        Instant cutOffDate = Instant.ofEpochMilli(checkpoint.getTimestamp()).minusMillis(config.getMaxAge().getMillis());
        return QueryBuilders.rangeQuery((String)config.getField()).lt((Object)DATE_FORMATER.format((TemporalAccessor)cutOffDate)).format(DATE_FORMAT);
    }

    public static class RetentionPolicyException
    extends ElasticsearchException {
        RetentionPolicyException(String msg, Object ... args) {
            super(msg, args);
        }
    }
}

