/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchServiceSettings;

public class AlibabaCloudSearchSparseServiceSettings
implements ServiceSettings {
    public static final String NAME = "alibabacloud_search_sparse_embeddings_service_settings";
    private final AlibabaCloudSearchServiceSettings commonSettings;

    public static AlibabaCloudSearchSparseServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AlibabaCloudSearchServiceSettings commonServiceSettings = AlibabaCloudSearchServiceSettings.fromMap(map, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AlibabaCloudSearchSparseServiceSettings(commonServiceSettings);
    }

    public AlibabaCloudSearchSparseServiceSettings(AlibabaCloudSearchServiceSettings commonSettings) {
        this.commonSettings = commonSettings;
    }

    public AlibabaCloudSearchSparseServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new AlibabaCloudSearchServiceSettings(in);
    }

    public AlibabaCloudSearchServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.commonSettings.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchSparseServiceSettings that = (AlibabaCloudSearchSparseServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings);
    }

    public int hashCode() {
        return Objects.hash(this.commonSettings);
    }
}

