/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioConstants;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionRequestTaskSettings;

public class AzureAiStudioChatCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "azure_ai_studio_chat_completion_task_settings";
    public static final Integer DEFAULT_MAX_NEW_TOKENS = 64;
    private final Double temperature;
    private final Double topP;
    private final Boolean doSample;
    private final Integer maxNewTokens;

    public static AzureAiStudioChatCompletionTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Double temperature = ServiceUtils.extractOptionalDoubleInRange(map, "temperature", AzureAiStudioConstants.MIN_TEMPERATURE_TOP_P, AzureAiStudioConstants.MAX_TEMPERATURE_TOP_P, "task_settings", validationException);
        Double topP = ServiceUtils.extractOptionalDoubleInRange(map, "top_p", AzureAiStudioConstants.MIN_TEMPERATURE_TOP_P, AzureAiStudioConstants.MAX_TEMPERATURE_TOP_P, "task_settings", validationException);
        Boolean doSample = ServiceUtils.extractOptionalBoolean(map, "do_sample", validationException);
        Integer maxNewTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_new_tokens", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioChatCompletionTaskSettings(temperature, topP, doSample, maxNewTokens);
    }

    public static AzureAiStudioChatCompletionTaskSettings of(AzureAiStudioChatCompletionTaskSettings originalSettings, AzureAiStudioChatCompletionRequestTaskSettings requestSettings) {
        Double temperature = requestSettings.temperature() == null ? originalSettings.temperature() : requestSettings.temperature();
        Double topP = requestSettings.topP() == null ? originalSettings.topP() : requestSettings.topP();
        Boolean doSample = requestSettings.doSample() == null ? originalSettings.doSample() : requestSettings.doSample();
        Integer maxNewTokens = requestSettings.maxNewTokens() == null ? originalSettings.maxNewTokens() : requestSettings.maxNewTokens();
        return new AzureAiStudioChatCompletionTaskSettings(temperature, topP, doSample, maxNewTokens);
    }

    public AzureAiStudioChatCompletionTaskSettings(@Nullable Double temperature, @Nullable Double topP, @Nullable Boolean doSample, @Nullable Integer maxNewTokens) {
        this.temperature = temperature;
        this.topP = topP;
        this.doSample = doSample;
        this.maxNewTokens = maxNewTokens;
    }

    public AzureAiStudioChatCompletionTaskSettings(StreamInput in) throws IOException {
        this.temperature = in.readOptionalDouble();
        this.topP = in.readOptionalDouble();
        this.doSample = in.readOptionalBoolean();
        this.maxNewTokens = in.readOptionalInt();
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Boolean doSample() {
        return this.doSample;
    }

    public Integer maxNewTokens() {
        return this.maxNewTokens;
    }

    public boolean areAnyParametersAvailable() {
        return this.temperature != null && this.topP != null && this.doSample != null && this.maxNewTokens != null;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public boolean isEmpty() {
        return this.temperature == null && this.topP == null && this.doSample == null && this.maxNewTokens == null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.temperature);
        out.writeOptionalDouble(this.topP);
        out.writeOptionalBoolean(this.doSample);
        out.writeOptionalInt(this.maxNewTokens);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.temperature != null) {
            builder.field("temperature", this.temperature);
        }
        if (this.topP != null) {
            builder.field("top_p", this.topP);
        }
        if (this.doSample != null) {
            builder.field("do_sample", this.doSample);
        }
        if (this.maxNewTokens != null) {
            builder.field("max_new_tokens", this.maxNewTokens);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "AzureAiStudioChatCompletionTaskSettings{temperature=" + this.temperature + ", topP=" + this.topP + ", doSample=" + this.doSample + ", maxNewTokens=" + this.maxNewTokens + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAiStudioChatCompletionTaskSettings that = (AzureAiStudioChatCompletionTaskSettings)o;
        return Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.doSample, that.doSample) && Objects.equals(this.maxNewTokens, that.maxNewTokens);
    }

    public int hashCode() {
        return Objects.hash(this.temperature, this.topP, this.doSample, this.maxNewTokens);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AzureAiStudioChatCompletionRequestTaskSettings requestSettings = AzureAiStudioChatCompletionRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AzureAiStudioChatCompletionTaskSettings.of(this, requestSettings);
    }
}

