/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Strings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.IpDataLookup;
import org.elasticsearch.ingest.geoip.IpDataLookupFactories;
import org.elasticsearch.ingest.geoip.IpDatabase;
import org.elasticsearch.ingest.geoip.IpDatabaseProvider;
import org.elasticsearch.ingest.geoip.MaxmindIpDataLookups;

public final class GeoIpProcessor
extends AbstractProcessor {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(GeoIpProcessor.class);
    static final String DEFAULT_DATABASES_DEPRECATION_MESSAGE = "the [fallback_to_default_databases] has been deprecated, because Elasticsearch no longer includes the default Maxmind geoip databases. This setting will be removed in Elasticsearch 9.0";
    static final String UNSUPPORTED_DATABASE_DEPRECATION_MESSAGE = "the geoip processor will no longer support database type [{}] in a future version of Elasticsearch";
    public static final String GEOIP_TYPE = "geoip";
    public static final String IP_LOCATION_TYPE = "ip_location";
    private final String type;
    private final String field;
    private final Supplier<Boolean> isValid;
    private final String targetField;
    private final CheckedSupplier<IpDatabase, IOException> supplier;
    private final IpDataLookup ipDataLookup;
    private final boolean ignoreMissing;
    private final boolean firstOnly;
    private final String databaseFile;

    GeoIpProcessor(String type, String tag, String description, String field, CheckedSupplier<IpDatabase, IOException> supplier, Supplier<Boolean> isValid, String targetField, IpDataLookup ipDataLookup, boolean ignoreMissing, boolean firstOnly, String databaseFile) {
        super(tag, description);
        this.type = type;
        this.field = field;
        this.isValid = isValid;
        this.targetField = targetField;
        this.supplier = supplier;
        this.ipDataLookup = ipDataLookup;
        this.ignoreMissing = ignoreMissing;
        this.firstOnly = firstOnly;
        this.databaseFile = databaseFile;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) throws IOException {
        block21: {
            Object ip = document.getFieldValue(this.field, Object.class, this.ignoreMissing);
            if (!this.isValid.get().booleanValue()) {
                document.appendFieldValue("tags", (Object)("_" + this.type + "_expired_database"), false);
                return document;
            }
            if (ip == null && this.ignoreMissing) {
                return document;
            }
            if (ip == null) {
                throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract geoip information.");
            }
            try (IpDatabase ipDatabase = (IpDatabase)this.supplier.get();){
                if (ipDatabase == null) {
                    if (!this.ignoreMissing) {
                        GeoIpProcessor.tag(document, this.type, this.databaseFile);
                    }
                    IngestDocument ingestDocument = document;
                    return ingestDocument;
                }
                if (ip instanceof String) {
                    String ipString = (String)ip;
                    Map<String, Object> data = this.ipDataLookup.getData(ipDatabase, ipString);
                    if (!data.isEmpty()) {
                        document.setFieldValue(this.targetField, data);
                    }
                    break block21;
                }
                if (ip instanceof List) {
                    List ipList = (List)ip;
                    boolean match = false;
                    ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(ipList.size());
                    for (Object ipAddr : ipList) {
                        if (!(ipAddr instanceof String)) {
                            throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
                        }
                        Map<String, Object> data = this.ipDataLookup.getData(ipDatabase, (String)ipAddr);
                        if (data.isEmpty()) {
                            dataList.add(null);
                            continue;
                        }
                        if (this.firstOnly) {
                            document.setFieldValue(this.targetField, data);
                            IngestDocument ingestDocument = document;
                            return ingestDocument;
                        }
                        match = true;
                        dataList.add(data);
                    }
                    if (match) {
                        document.setFieldValue(this.targetField, dataList);
                    }
                    break block21;
                }
                throw new IllegalArgumentException("field [" + this.field + "] should contain only string or array of strings");
            }
        }
        return document;
    }

    public String getType() {
        return this.type;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    String getDatabaseType() throws IOException {
        return ((IpDatabase)this.supplier.get()).getDatabaseType();
    }

    Set<Database.Property> getProperties() {
        return this.ipDataLookup.getProperties();
    }

    private static void tag(IngestDocument ingestDocument, String type, String databaseName) {
        ingestDocument.appendFieldValue("tags", (Object)("_" + type + "_database_unavailable_" + databaseName), true);
    }

    static class DatabaseUnavailableProcessor
    extends AbstractProcessor {
        private final String type;
        private final String databaseName;

        DatabaseUnavailableProcessor(String type, String tag, String description, String databaseName) {
            super(tag, description);
            this.type = type;
            this.databaseName = databaseName;
        }

        public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
            GeoIpProcessor.tag(ingestDocument, this.type, this.databaseName);
            return ingestDocument;
        }

        public String getType() {
            return this.type;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final String type;
        private final IpDatabaseProvider ipDatabaseProvider;

        public Factory(String type, IpDatabaseProvider ipDatabaseProvider) {
            this.type = type;
            this.ipDatabaseProvider = ipDatabaseProvider;
        }

        public Processor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            IpDataLookup ipDataLookup;
            IpDataLookupFactories.IpDataLookupFactory factory;
            String databaseType;
            String ipField = ConfigurationUtils.readStringProperty((String)this.type, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)this.type, (String)processorTag, config, (String)"target_field", (String)this.type);
            String databaseFile = ConfigurationUtils.readStringProperty((String)this.type, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb");
            List propertyNames = ConfigurationUtils.readOptionalList((String)this.type, (String)processorTag, config, (String)"properties");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)this.type, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean firstOnly = ConfigurationUtils.readBooleanProperty((String)this.type, (String)processorTag, config, (String)"first_only", (boolean)true);
            ConfigurationUtils.readBooleanProperty((String)this.type, (String)processorTag, config, (String)"download_database_on_pipeline_creation", (boolean)true);
            Object value = config.remove("fallback_to_default_databases");
            if (value != null) {
                deprecationLogger.warn(DeprecationCategory.OTHER, "default_databases_message", GeoIpProcessor.DEFAULT_DATABASES_DEPRECATION_MESSAGE, new Object[0]);
            }
            try (IpDatabase ipDatabase = this.ipDatabaseProvider.getDatabase(databaseFile);){
                if (ipDatabase == null) {
                    DatabaseUnavailableProcessor databaseUnavailableProcessor = new DatabaseUnavailableProcessor(this.type, processorTag, description, databaseFile);
                    return databaseUnavailableProcessor;
                }
                databaseType = ipDatabase.getDatabaseType();
            }
            try {
                factory = IpDataLookupFactories.get(databaseType, databaseFile);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)this.type, (String)processorTag, (String)"database_file", (String)e.getMessage());
            }
            if (GeoIpProcessor.GEOIP_TYPE.equals(this.type)) {
                String lowerCaseDatabaseType = databaseType.toLowerCase(Locale.ROOT);
                if (lowerCaseDatabaseType.startsWith("ipinfo")) {
                    throw ConfigurationUtils.newConfigurationException((String)this.type, (String)processorTag, (String)"database_file", (String)Strings.format((String)"Unsupported database type [%s] for file [%s]", (Object[])new Object[]{databaseType, databaseFile}));
                }
                if (!lowerCaseDatabaseType.startsWith(MaxmindIpDataLookups.GEOIP2_PREFIX) && !lowerCaseDatabaseType.startsWith(MaxmindIpDataLookups.GEOLITE2_PREFIX)) {
                    deprecationLogger.warn(DeprecationCategory.OTHER, "unsupported_database_type", GeoIpProcessor.UNSUPPORTED_DATABASE_DEPRECATION_MESSAGE, new Object[]{databaseType});
                }
            }
            try {
                ipDataLookup = factory.create(propertyNames);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)this.type, (String)processorTag, (String)"properties", (String)e.getMessage());
            }
            return new GeoIpProcessor(this.type, processorTag, description, ipField, new DatabaseVerifyingSupplier(this.ipDatabaseProvider, databaseFile, databaseType), () -> this.ipDatabaseProvider.isValid(databaseFile), targetField, ipDataLookup, ignoreMissing, firstOnly, databaseFile);
        }

        public static boolean downloadDatabaseOnPipelineCreation(Map<String, Object> config) {
            return (Boolean)config.getOrDefault("download_database_on_pipeline_creation", true);
        }
    }

    public static final class DatabaseVerifyingSupplier
    implements CheckedSupplier<IpDatabase, IOException> {
        private final IpDatabaseProvider ipDatabaseProvider;
        private final String databaseFile;
        private final String databaseType;

        public DatabaseVerifyingSupplier(IpDatabaseProvider ipDatabaseProvider, String databaseFile, String databaseType) {
            this.ipDatabaseProvider = ipDatabaseProvider;
            this.databaseFile = databaseFile;
            this.databaseType = databaseType;
        }

        public IpDatabase get() throws IOException {
            IpDatabase loader = this.ipDatabaseProvider.getDatabase(this.databaseFile);
            if (loader == null) {
                return null;
            }
            if (Assertions.ENABLED) {
                int last = this.databaseType.lastIndexOf(45);
                String expectedSuffix = last == -1 ? null : this.databaseType.substring(last);
                String loaderType = loader.getDatabaseType();
                assert (loaderType.equals(this.databaseType) || expectedSuffix == null || loaderType.endsWith(expectedSuffix)) : "database type [" + loaderType + "] doesn't match with expected suffix [" + expectedSuffix + "]";
            }
            return loader;
        }
    }
}

