/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.AbstractFallibleArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class BooleanFallibleArrayState
extends AbstractFallibleArrayState
implements GroupingAggregatorState {
    private final boolean init;
    private BitArray values;
    private int size;

    BooleanFallibleArrayState(BigArrays bigArrays, boolean init) {
        super(bigArrays);
        this.values = new BitArray(1L, bigArrays);
        this.size = 1;
        this.values.set(0L, init);
        this.init = init;
    }

    boolean get(int groupId) {
        return this.values.get((long)groupId);
    }

    boolean getOrDefault(int groupId) {
        return groupId < this.size ? this.values.get((long)groupId) : this.init;
    }

    void set(int groupId, boolean value) {
        this.ensureCapacity(groupId);
        this.values.set((long)groupId, value);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.trackingGroupIds() && !this.anyFailure()) {
            try (BooleanVector.FixedBuilder builder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    builder.appendBoolean(i, this.values.get((long)selected.getInt(i)));
                }
                BooleanBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (BooleanBlock.Builder builder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group) && !this.hasFailed(group)) {
                    builder.appendBoolean(this.values.get((long)group));
                    continue;
                }
                builder.appendNull();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        if (groupId >= this.size) {
            this.values.fill((long)this.size, (long)(groupId + 1), this.init);
            this.size = groupId + 1;
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        try (BooleanBlock.Builder valuesBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasValueBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasFailedBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (group < this.size) {
                    valuesBuilder.appendBoolean(this.values.get((long)group));
                } else {
                    valuesBuilder.appendBoolean(false);
                }
                hasValueBuilder.appendBoolean(i, this.hasValue(group));
                hasFailedBuilder.appendBoolean(i, this.hasFailed(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build().asBlock();
            blocks[offset + 2] = hasFailedBuilder.build().asBlock();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }
}

