/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleArrayVector;
import org.elasticsearch.compute.data.DoubleBigArrayVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DoubleVector
extends Vector {
    public double getDouble(int var1);

    @Override
    public DoubleBlock asBlock();

    @Override
    public DoubleVector filter(int ... var1);

    @Override
    public DoubleBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends DoubleBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(DoubleVector vector1, DoubleVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getDouble(pos) == vector2.getDouble(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(DoubleVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            long element = Double.doubleToLongBits(vector.getDouble(pos));
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    public static DoubleVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> DoubleVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantDoubleVector(in.readDouble(), positions);
            case 2 -> DoubleArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> DoubleBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        DoubleVector doubleVector;
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeDouble(this.getDouble(0));
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (doubleVector = this) instanceof DoubleArrayVector) {
            DoubleArrayVector v = (DoubleArrayVector)doubleVector;
            out.writeByte((byte)2);
            v.writeArrayVector(positions, out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (doubleVector = this) instanceof DoubleBigArrayVector) {
            DoubleBigArrayVector v = (DoubleBigArrayVector)doubleVector;
            out.writeByte((byte)3);
            v.writeArrayVector(positions, out);
        } else {
            out.writeByte((byte)0);
            DoubleVector.writeValues(this, positions, out);
        }
    }

    private static DoubleVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newDoubleVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendDouble(i, in.readDouble());
            }
            DoubleVector doubleVector = builder.build();
            return doubleVector;
        }
    }

    private static void writeValues(DoubleVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeDouble(v.getDouble(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Builder {
        @Override
        public FixedBuilder appendDouble(double var1);

        public FixedBuilder appendDouble(int var1, double var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendDouble(double var1);

        @Override
        public DoubleVector build();
    }
}

