/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.TimeSeriesBlockHash;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.Operator;

public final class TimeSeriesAggregationOperatorFactories {
    static List<GroupingAggregator.Factory> valuesAggregatorForGroupings(List<BlockHash.GroupSpec> groupings, int timeBucketChannel) {
        ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>();
        for (BlockHash.GroupSpec g : groupings) {
            if (g.channel() == timeBucketChannel) continue;
            List<Integer> channels = List.of(Integer.valueOf(g.channel()));
            AggregatorFunctionSupplier aggregatorSupplier = switch (g.elementType()) {
                default -> throw new IncompatibleClassChangeError();
                case ElementType.BYTES_REF -> new ValuesBytesRefAggregatorFunctionSupplier(channels);
                case ElementType.DOUBLE -> new ValuesDoubleAggregatorFunctionSupplier(channels);
                case ElementType.INT -> new ValuesIntAggregatorFunctionSupplier(channels);
                case ElementType.LONG -> new ValuesLongAggregatorFunctionSupplier(channels);
                case ElementType.BOOLEAN -> new ValuesBooleanAggregatorFunctionSupplier(channels);
                case ElementType.FLOAT, ElementType.NULL, ElementType.DOC, ElementType.COMPOSITE, ElementType.UNKNOWN -> throw new IllegalArgumentException("unsupported grouping type");
            };
            aggregators.add(aggregatorSupplier.groupingAggregatorFactory(AggregatorMode.SINGLE));
        }
        return aggregators;
    }

    public record Final(List<BlockHash.GroupSpec> groupings, List<AggregatorFunctionSupplier> outerRates, List<AggregatorFunctionSupplier> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.outerRates.size() + this.nonRates.size());
            for (AggregatorFunctionSupplier f : this.outerRates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.SINGLE));
            }
            for (AggregatorFunctionSupplier f : this.nonRates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.FINAL));
            }
            return new HashAggregationOperator(aggregators, () -> BlockHash.build(this.groupings, driverContext.blockFactory(), this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesFinalAggregationOperatorFactory";
        }
    }

    public record Intermediate(int tsHashChannel, int timeBucketChannel, List<BlockHash.GroupSpec> groupings, List<AggregatorFunctionSupplier> rates, List<AggregatorFunctionSupplier> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.groupings.size() + this.rates.size() + this.nonRates.size());
            for (AggregatorFunctionSupplier f : this.rates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.FINAL));
            }
            for (AggregatorFunctionSupplier f : this.nonRates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.INTERMEDIATE));
            }
            aggregators.addAll(TimeSeriesAggregationOperatorFactories.valuesAggregatorForGroupings(this.groupings, this.timeBucketChannel));
            List<BlockHash.GroupSpec> hashGroups = List.of(new BlockHash.GroupSpec(this.tsHashChannel, ElementType.BYTES_REF), new BlockHash.GroupSpec(this.timeBucketChannel, ElementType.LONG));
            return new HashAggregationOperator(aggregators, () -> BlockHash.build(hashGroups, driverContext.blockFactory(), this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesIntermediateAggregationOperatorFactory";
        }
    }

    public record Initial(int tsHashChannel, int timeBucketChannel, List<BlockHash.GroupSpec> groupings, List<AggregatorFunctionSupplier> rates, List<AggregatorFunctionSupplier> nonRates, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            ArrayList<GroupingAggregator.Factory> aggregators = new ArrayList<GroupingAggregator.Factory>(this.groupings.size() + this.rates.size() + this.nonRates.size());
            for (AggregatorFunctionSupplier f : this.rates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.INITIAL));
            }
            for (AggregatorFunctionSupplier f : this.nonRates) {
                aggregators.add(f.groupingAggregatorFactory(AggregatorMode.INITIAL));
            }
            aggregators.addAll(TimeSeriesAggregationOperatorFactories.valuesAggregatorForGroupings(this.groupings, this.timeBucketChannel));
            return new HashAggregationOperator(aggregators, () -> new TimeSeriesBlockHash(this.tsHashChannel, this.timeBucketChannel, driverContext), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesInitialAggregationOperatorFactory";
        }
    }
}

