/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.DeflateCompressor;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulkResponseListener;

class HttpExportBulk
extends ExportBulk {
    private static final Logger logger = LogManager.getLogger(HttpExportBulk.class);
    private final RestClient client;
    private final Map<String, String> params;
    private final DateFormatter formatter;
    private BytesReference payload = null;
    private long payloadLength = -1L;

    HttpExportBulk(String name, RestClient client, Map<String, String> parameters, DateFormatter dateTimeFormatter, ThreadContext threadContext) {
        super(name, threadContext);
        this.client = client;
        this.params = parameters;
        this.formatter = dateTimeFormatter;
    }

    @Override
    public void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
        block9: {
            try {
                CountingOutputStream countingStream;
                if (docs == null || docs.isEmpty()) break block9;
                BytesStreamOutput scratch = new BytesStreamOutput();
                try (OutputStream payload = CompressorFactory.COMPRESSOR.threadLocalOutputStream((OutputStream)scratch);){
                    countingStream = new CountingOutputStream(payload);
                    for (MonitoringDoc monitoringDoc : docs) {
                        this.writeDocument(monitoringDoc, countingStream);
                    }
                }
                this.payloadLength = countingStream.bytesWritten;
                this.payload = scratch.bytes();
            }
            catch (Exception e) {
                throw new ExportException("failed to add documents to export bulk [{}]", e, this.name);
            }
        }
    }

    @Override
    public void doFlush(final ActionListener<Void> listener) throws ExportException {
        if (this.payload == null) {
            listener.onFailure((Exception)((Object)new ExportException("unable to send documents because none were loaded for export bulk [{}]", this.name)));
        } else if (this.payload.length() != 0) {
            Request request = new Request("POST", "/_bulk");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                request.addParameter(param.getKey(), param.getValue());
            }
            try {
                request.setEntity((HttpEntity)new InputStreamEntity(DeflateCompressor.inputStream((InputStream)this.payload.streamInput(), (boolean)false), this.payloadLength, ContentType.APPLICATION_JSON));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            this.payload = null;
            this.client.performRequestAsync(request, new ResponseListener(){

                public void onSuccess(Response response) {
                    try {
                        HttpExportBulkResponseListener.INSTANCE.onSuccess(response);
                    }
                    finally {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception exception) {
                    try {
                        HttpExportBulkResponseListener.INSTANCE.onFailure(exception);
                    }
                    finally {
                        listener.onFailure(exception);
                    }
                }
            });
        }
    }

    private void writeDocument(MonitoringDoc doc, OutputStream out) throws IOException {
        XContentType xContentType = XContentType.JSON;
        XContent xContent = xContentType.xContent();
        String index = MonitoringTemplateUtils.indexName((DateFormatter)this.formatter, (MonitoredSystem)doc.getSystem(), (long)doc.getTimestamp());
        String id = doc.getId();
        try (XContentBuilder builder = new XContentBuilder(xContent, out);){
            builder.startObject();
            builder.startObject("index");
            builder.field("_index", index);
            if (id != null) {
                builder.field("_id", id);
            }
            builder.endObject();
            builder.endObject();
        }
        out.write(xContent.bulkSeparator());
        builder = new XContentBuilder(xContent, out);
        try {
            doc.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        finally {
            builder.close();
        }
        out.write(xContent.bulkSeparator());
        logger.trace("http exporter [{}] - added index request [index={}, id={}, monitoring data type={}]", (Object)this.name, (Object)index, (Object)id, (Object)doc.getType());
    }

    private static final class CountingOutputStream
    extends FilterOutputStream {
        private long bytesWritten = 0L;

        CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.count(1L);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.count(len);
        }

        @Override
        public void close() {
        }

        protected void count(long written) {
            if (written != -1L) {
                this.bytesWritten += written;
            }
        }
    }
}

